/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.init.Biomes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderHell
extends WorldProvider {
    @Override
    public void init() {
        this.biomeProvider = new BiomeProviderSingle(Biomes.HELL);
        this.doesWaterVaporize = true;
        this.hasNoSky = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(float p_getFogColor_1_, float p_getFogColor_2_) {
        return new Vec3d(0.2f, 0.03f, 0.03f);
    }

    @Override
    protected void generateLightBrightnessTable() {
        float lvt_1_1_ = 0.1f;
        for (int lvt_2_1_ = 0; lvt_2_1_ <= 15; ++lvt_2_1_) {
            float lvt_3_1_ = 1.0f - (float)lvt_2_1_ / 15.0f;
            this.lightBrightnessTable[lvt_2_1_] = (1.0f - lvt_3_1_) / (lvt_3_1_ * 3.0f + 1.0f) * 0.9f + 0.1f;
        }
    }

    @Override
    public IChunkGenerator createChunkGenerator() {
        return new ChunkProviderHell(this.world, this.world.getWorldInfo().isMapFeaturesEnabled(), this.world.getSeed());
    }

    @Override
    public boolean isSurfaceWorld() {
        return false;
    }

    @Override
    public boolean canCoordinateBeSpawn(int p_canCoordinateBeSpawn_1_, int p_canCoordinateBeSpawn_2_) {
        return false;
    }

    @Override
    public float calculateCelestialAngle(long p_calculateCelestialAngle_1_, float p_calculateCelestialAngle_3_) {
        return 0.5f;
    }

    @Override
    public boolean canRespawnHere() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean doesXZShowFog(int p_doesXZShowFog_1_, int p_doesXZShowFog_2_) {
        return true;
    }

    @Override
    public WorldBorder createWorldBorder() {
        return new WorldBorder(){

            @Override
            public double getCenterX() {
                return super.getCenterX() / 8.0;
            }

            @Override
            public double getCenterZ() {
                return super.getCenterZ() / 8.0;
            }
        };
    }

    @Override
    public DimensionType getDimensionType() {
        return DimensionType.NETHER;
    }
}

