/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.INpc;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockAction;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.network.play.server.SPacketSpawnGlobalEntity;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.ScoreboardSaveData;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ReportedException;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.VillageCollection;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldSavedDataCallableSave;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.feature.WorldGeneratorBonusChest;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.WorldSpecificSaveHandler;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldServer
extends World
implements IThreadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MinecraftServer mcServer;
    private final EntityTracker theEntityTracker;
    private final PlayerChunkMap playerChunkMap;
    private final Set<NextTickListEntry> pendingTickListEntriesHashSet = Sets.newHashSet();
    private final TreeSet<NextTickListEntry> pendingTickListEntriesTreeSet = new TreeSet();
    private final Map<UUID, Entity> entitiesByUuid = Maps.newHashMap();
    public boolean disableLevelSaving;
    private boolean allPlayersSleeping;
    private int updateEntityTick;
    private final Teleporter worldTeleporter;
    private final WorldEntitySpawner entitySpawner = new WorldEntitySpawner();
    protected final VillageSiege villageSiege = new VillageSiege(this);
    private final ServerBlockEventList[] blockEventQueue = new ServerBlockEventList[]{new ServerBlockEventList(), new ServerBlockEventList()};
    private int blockEventCacheIndex;
    private final List<NextTickListEntry> pendingTickListEntriesThisTick = Lists.newArrayList();
    protected Set<ChunkPos> doneChunks = new HashSet<ChunkPos>();
    public List<Teleporter> customTeleporters = new ArrayList<Teleporter>();

    public WorldServer(MinecraftServer p_i45921_1_, ISaveHandler p_i45921_2_, WorldInfo p_i45921_3_, int p_i45921_4_, Profiler p_i45921_5_) {
        super(p_i45921_2_, p_i45921_3_, DimensionManager.createProviderFor(p_i45921_4_), p_i45921_5_, false);
        this.mcServer = p_i45921_1_;
        this.theEntityTracker = new EntityTracker(this);
        this.playerChunkMap = new PlayerChunkMap(this);
        int providerDim = this.provider.getDimension();
        this.provider.setWorld(this);
        this.provider.setDimension(providerDim);
        this.chunkProvider = this.createChunkProvider();
        this.perWorldStorage = new MapStorage(new WorldSpecificSaveHandler(this, p_i45921_2_));
        this.worldTeleporter = new Teleporter(this);
        this.calculateInitialSkylight();
        this.calculateInitialWeather();
        this.getWorldBorder().setSize(p_i45921_1_.getMaxWorldSize());
        DimensionManager.setWorld(p_i45921_4_, this, this.mcServer);
    }

    @Override
    public World init() {
        this.mapStorage = new MapStorage(this.saveHandler);
        String s = VillageCollection.fileNameForProvider(this.provider);
        VillageCollection villagecollection = (VillageCollection)this.perWorldStorage.getOrLoadData(VillageCollection.class, s);
        if (villagecollection == null) {
            this.villageCollectionObj = new VillageCollection(this);
            this.perWorldStorage.setData(s, this.villageCollectionObj);
        } else {
            this.villageCollectionObj = villagecollection;
            this.villageCollectionObj.setWorldsForAll(this);
        }
        this.worldScoreboard = new ServerScoreboard(this.mcServer);
        ScoreboardSaveData scoreboardsavedata = (ScoreboardSaveData)this.mapStorage.getOrLoadData(ScoreboardSaveData.class, "scoreboard");
        if (scoreboardsavedata == null) {
            scoreboardsavedata = new ScoreboardSaveData();
            this.mapStorage.setData("scoreboard", scoreboardsavedata);
        }
        scoreboardsavedata.setScoreboard(this.worldScoreboard);
        ((ServerScoreboard)this.worldScoreboard).addDirtyRunnable(new WorldSavedDataCallableSave(scoreboardsavedata));
        this.lootTable = new LootTableManager(new File(new File(this.saveHandler.getWorldDirectory(), "data"), "loot_tables"));
        this.getWorldBorder().setCenter(this.worldInfo.getBorderCenterX(), this.worldInfo.getBorderCenterZ());
        this.getWorldBorder().setDamageAmount(this.worldInfo.getBorderDamagePerBlock());
        this.getWorldBorder().setDamageBuffer(this.worldInfo.getBorderSafeZone());
        this.getWorldBorder().setWarningDistance(this.worldInfo.getBorderWarningDistance());
        this.getWorldBorder().setWarningTime(this.worldInfo.getBorderWarningTime());
        if (this.worldInfo.getBorderLerpTime() > 0L) {
            this.getWorldBorder().setTransition(this.worldInfo.getBorderSize(), this.worldInfo.getBorderLerpTarget(), this.worldInfo.getBorderLerpTime());
        } else {
            this.getWorldBorder().setTransition(this.worldInfo.getBorderSize());
        }
        this.initCapabilities();
        return this;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getWorldInfo().isHardcoreModeEnabled() && this.getDifficulty() != EnumDifficulty.HARD) {
            this.getWorldInfo().setDifficulty(EnumDifficulty.HARD);
        }
        this.provider.getBiomeProvider().cleanupCache();
        if (this.areAllPlayersAsleep()) {
            if (this.getGameRules().getBoolean("doDaylightCycle")) {
                long i = this.getWorldTime() + 24000L;
                this.setWorldTime(i - i % 24000L);
            }
            this.wakeAllPlayers();
        }
        this.theProfiler.startSection("mobSpawner");
        if (this.getGameRules().getBoolean("doMobSpawning") && this.worldInfo.getTerrainType() != WorldType.DEBUG_WORLD) {
            this.entitySpawner.findChunksForSpawning(this, this.spawnHostileMobs, this.spawnPeacefulMobs, this.worldInfo.getWorldTotalTime() % 400L == 0L);
        }
        this.theProfiler.endStartSection("chunkSource");
        this.chunkProvider.tick();
        int j = this.calculateSkylightSubtracted(1.0f);
        if (j != this.getSkylightSubtracted()) {
            this.setSkylightSubtracted(j);
        }
        this.worldInfo.setWorldTotalTime(this.worldInfo.getWorldTotalTime() + 1L);
        if (this.getGameRules().getBoolean("doDaylightCycle")) {
            this.setWorldTime(this.getWorldTime() + 1L);
        }
        this.theProfiler.endStartSection("tickPending");
        this.tickUpdates(false);
        this.theProfiler.endStartSection("tickBlocks");
        this.updateBlocks();
        this.theProfiler.endStartSection("chunkMap");
        this.playerChunkMap.tick();
        this.theProfiler.endStartSection("village");
        this.villageCollectionObj.tick();
        this.villageSiege.tick();
        this.theProfiler.endStartSection("portalForcer");
        this.worldTeleporter.removeStalePortalLocations(this.getTotalWorldTime());
        for (Teleporter tele : this.customTeleporters) {
            tele.removeStalePortalLocations(this.getTotalWorldTime());
        }
        this.theProfiler.endSection();
        this.sendQueuedBlockEvents();
    }

    @Nullable
    public Biome.SpawnListEntry getSpawnListEntryForTypeAt(EnumCreatureType p_getSpawnListEntryForTypeAt_1_, BlockPos p_getSpawnListEntryForTypeAt_2_) {
        List<Biome.SpawnListEntry> list = this.getChunkProvider().getPossibleCreatures(p_getSpawnListEntryForTypeAt_1_, p_getSpawnListEntryForTypeAt_2_);
        return (list = ForgeEventFactory.getPotentialSpawns(this, p_getSpawnListEntryForTypeAt_1_, p_getSpawnListEntryForTypeAt_2_, list)) != null && !list.isEmpty() ? WeightedRandom.getRandomItem(this.rand, list) : null;
    }

    public boolean canCreatureTypeSpawnHere(EnumCreatureType p_canCreatureTypeSpawnHere_1_, Biome.SpawnListEntry p_canCreatureTypeSpawnHere_2_, BlockPos p_canCreatureTypeSpawnHere_3_) {
        List<Biome.SpawnListEntry> list = this.getChunkProvider().getPossibleCreatures(p_canCreatureTypeSpawnHere_1_, p_canCreatureTypeSpawnHere_3_);
        return (list = ForgeEventFactory.getPotentialSpawns(this, p_canCreatureTypeSpawnHere_1_, p_canCreatureTypeSpawnHere_3_, list)) != null && !list.isEmpty() ? list.contains(p_canCreatureTypeSpawnHere_2_) : false;
    }

    @Override
    public void updateAllPlayersSleepingFlag() {
        this.allPlayersSleeping = false;
        if (!this.playerEntities.isEmpty()) {
            int i = 0;
            int j = 0;
            for (EntityPlayer entityplayer : this.playerEntities) {
                if (entityplayer.isSpectator()) {
                    ++i;
                    continue;
                }
                if (!entityplayer.isPlayerSleeping()) continue;
                ++j;
            }
            this.allPlayersSleeping = j > 0 && j >= this.playerEntities.size() - i;
        }
    }

    protected void wakeAllPlayers() {
        this.allPlayersSleeping = false;
        for (EntityPlayer entityplayer : this.playerEntities) {
            if (!entityplayer.isPlayerSleeping()) continue;
            entityplayer.wakeUpPlayer(false, false, true);
        }
        if (this.getGameRules().getBoolean("doWeatherCycle")) {
            this.resetRainAndThunder();
        }
    }

    private void resetRainAndThunder() {
        this.provider.resetRainAndThunder();
    }

    public boolean areAllPlayersAsleep() {
        if (this.allPlayersSleeping && !this.isRemote) {
            for (EntityPlayer entityplayer : this.playerEntities) {
                if (entityplayer.isSpectator() || entityplayer.isPlayerFullyAsleep()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setInitialSpawnLocation() {
        if (this.worldInfo.getSpawnY() <= 0) {
            this.worldInfo.setSpawnY(this.getSeaLevel() + 1);
        }
        int i = this.worldInfo.getSpawnX();
        int j = this.worldInfo.getSpawnZ();
        int k = 0;
        while (this.getGroundAboveSeaLevel(new BlockPos(i, 0, j)).getMaterial() == Material.AIR) {
            i += this.rand.nextInt(8) - this.rand.nextInt(8);
            j += this.rand.nextInt(8) - this.rand.nextInt(8);
            if (++k != 10000) continue;
        }
        this.worldInfo.setSpawnX(i);
        this.worldInfo.setSpawnZ(j);
    }

    @Override
    protected boolean isChunkLoaded(int p_isChunkLoaded_1_, int p_isChunkLoaded_2_, boolean p_isChunkLoaded_3_) {
        return this.getChunkProvider().chunkExists(p_isChunkLoaded_1_, p_isChunkLoaded_2_);
    }

    protected void playerCheckLight() {
        this.theProfiler.startSection("playerCheckLight");
        if (!this.playerEntities.isEmpty()) {
            int i = this.rand.nextInt(this.playerEntities.size());
            EntityPlayer entityplayer = (EntityPlayer)this.playerEntities.get(i);
            int j = MathHelper.floor(entityplayer.posX) + this.rand.nextInt(11) - 5;
            int k = MathHelper.floor(entityplayer.posY) + this.rand.nextInt(11) - 5;
            int l = MathHelper.floor(entityplayer.posZ) + this.rand.nextInt(11) - 5;
            this.checkLight(new BlockPos(j, k, l));
        }
        this.theProfiler.endSection();
    }

    @Override
    protected void updateBlocks() {
        this.playerCheckLight();
        if (this.worldInfo.getTerrainType() == WorldType.DEBUG_WORLD) {
            Iterator<Chunk> iterator1 = this.playerChunkMap.getChunkIterator();
            while (iterator1.hasNext()) {
                iterator1.next().onTick(false);
            }
        } else {
            int i = this.getGameRules().getInt("randomTickSpeed");
            boolean flag = this.isRaining();
            boolean flag1 = this.isThundering();
            this.theProfiler.startSection("pollingChunks");
            Iterator<Chunk> iterator = this.getPersistentChunkIterable(this.playerChunkMap.getChunkIterator());
            while (iterator.hasNext()) {
                this.theProfiler.startSection("getChunk");
                Chunk chunk = iterator.next();
                int j = chunk.xPosition * 16;
                int k = chunk.zPosition * 16;
                this.theProfiler.endStartSection("checkNextLight");
                chunk.enqueueRelightChecks();
                this.theProfiler.endStartSection("tickChunk");
                chunk.onTick(false);
                this.theProfiler.endStartSection("thunder");
                if (this.provider.canDoLightning(chunk) && flag && flag1 && this.rand.nextInt(100000) == 0) {
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int l = this.updateLCG >> 2;
                    BlockPos blockpos = this.adjustPosToNearbyEntity(new BlockPos(j + (l & 0xF), 0, k + (l >> 8 & 0xF)));
                    if (this.isRainingAt(blockpos)) {
                        DifficultyInstance difficultyinstance = this.getDifficultyForLocation(blockpos);
                        if (this.getGameRules().getBoolean("doMobSpawning") && this.rand.nextDouble() < (double)difficultyinstance.getAdditionalDifficulty() * 0.01) {
                            EntitySkeletonHorse entityskeletonhorse = new EntitySkeletonHorse(this);
                            entityskeletonhorse.setTrap(true);
                            entityskeletonhorse.setGrowingAge(0);
                            entityskeletonhorse.setPosition(blockpos.getX(), blockpos.getY(), blockpos.getZ());
                            this.spawnEntity(entityskeletonhorse);
                            this.addWeatherEffect(new EntityLightningBolt(this, blockpos.getX(), blockpos.getY(), blockpos.getZ(), true));
                        } else {
                            this.addWeatherEffect(new EntityLightningBolt(this, blockpos.getX(), blockpos.getY(), blockpos.getZ(), false));
                        }
                    }
                }
                this.theProfiler.endStartSection("iceandsnow");
                if (this.provider.canDoRainSnowIce(chunk) && this.rand.nextInt(16) == 0) {
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int j2 = this.updateLCG >> 2;
                    BlockPos blockpos1 = this.getPrecipitationHeight(new BlockPos(j + (j2 & 0xF), 0, k + (j2 >> 8 & 0xF)));
                    BlockPos blockpos2 = blockpos1.down();
                    if (this.canBlockFreezeNoWater(blockpos2)) {
                        this.setBlockState(blockpos2, Blocks.ICE.getDefaultState());
                    }
                    if (flag && this.canSnowAt(blockpos1, true)) {
                        this.setBlockState(blockpos1, Blocks.SNOW_LAYER.getDefaultState());
                    }
                    if (flag && this.getBiome(blockpos2).canRain()) {
                        this.getBlockState(blockpos2).getBlock().fillWithRain(this, blockpos2);
                    }
                }
                this.theProfiler.endStartSection("tickBlocks");
                if (i > 0) {
                    for (ExtendedBlockStorage extendedblockstorage : chunk.getBlockStorageArray()) {
                        if (extendedblockstorage == Chunk.NULL_BLOCK_STORAGE || !extendedblockstorage.getNeedsRandomTick()) continue;
                        for (int i1 = 0; i1 < i; ++i1) {
                            this.updateLCG = this.updateLCG * 3 + 1013904223;
                            int j1 = this.updateLCG >> 2;
                            int k1 = j1 & 0xF;
                            int l1 = j1 >> 8 & 0xF;
                            int i2 = j1 >> 16 & 0xF;
                            IBlockState iblockstate = extendedblockstorage.get(k1, i2, l1);
                            Block block = iblockstate.getBlock();
                            this.theProfiler.startSection("randomTick");
                            if (block.getTickRandomly()) {
                                block.randomTick(this, new BlockPos(k1 + j, i2 + extendedblockstorage.getYLocation(), l1 + k), iblockstate, this.rand);
                            }
                            this.theProfiler.endSection();
                        }
                    }
                }
                this.theProfiler.endSection();
            }
            this.theProfiler.endSection();
        }
    }

    protected BlockPos adjustPosToNearbyEntity(BlockPos p_adjustPosToNearbyEntity_1_) {
        BlockPos blockpos = this.getPrecipitationHeight(p_adjustPosToNearbyEntity_1_);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos, new BlockPos(blockpos.getX(), this.getHeight(), blockpos.getZ())).expandXyz(3.0);
        List<EntityLivingBase> list = this.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb, new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.isEntityAlive() && WorldServer.this.canSeeSky(p_apply_1_.getPosition());
            }
        });
        if (!list.isEmpty()) {
            return list.get(this.rand.nextInt(list.size())).getPosition();
        }
        if (blockpos.getY() == -1) {
            blockpos = blockpos.up(2);
        }
        return blockpos;
    }

    @Override
    public boolean isBlockTickPending(BlockPos p_isBlockTickPending_1_, Block p_isBlockTickPending_2_) {
        NextTickListEntry nextticklistentry = new NextTickListEntry(p_isBlockTickPending_1_, p_isBlockTickPending_2_);
        return this.pendingTickListEntriesThisTick.contains(nextticklistentry);
    }

    @Override
    public boolean isUpdateScheduled(BlockPos p_isUpdateScheduled_1_, Block p_isUpdateScheduled_2_) {
        NextTickListEntry nextticklistentry = new NextTickListEntry(p_isUpdateScheduled_1_, p_isUpdateScheduled_2_);
        return this.pendingTickListEntriesHashSet.contains(nextticklistentry);
    }

    @Override
    public void scheduleUpdate(BlockPos p_scheduleUpdate_1_, Block p_scheduleUpdate_2_, int p_scheduleUpdate_3_) {
        this.updateBlockTick(p_scheduleUpdate_1_, p_scheduleUpdate_2_, p_scheduleUpdate_3_, 0);
    }

    @Override
    public void updateBlockTick(BlockPos p_updateBlockTick_1_, Block p_updateBlockTick_2_, int p_updateBlockTick_3_, int p_updateBlockTick_4_) {
        if (p_updateBlockTick_1_ instanceof BlockPos.MutableBlockPos || p_updateBlockTick_1_ instanceof BlockPos.PooledMutableBlockPos) {
            p_updateBlockTick_1_ = new BlockPos(p_updateBlockTick_1_);
            LogManager.getLogger().warn("Tried to assign a mutable BlockPos to tick data...", (Throwable)new Error(p_updateBlockTick_1_.getClass().toString()));
        }
        Material material = p_updateBlockTick_2_.getDefaultState().getMaterial();
        if (this.scheduledUpdatesAreImmediate && material != Material.AIR) {
            if (p_updateBlockTick_2_.requiresUpdates()) {
                IBlockState iblockstate;
                int range;
                boolean isForced = this.getPersistentChunks().containsKey((Object)new ChunkPos(p_updateBlockTick_1_));
                int n = range = isForced ? 0 : 8;
                if (this.isAreaLoaded(p_updateBlockTick_1_.add(-range, -range, -range), p_updateBlockTick_1_.add(range, range, range)) && (iblockstate = this.getBlockState(p_updateBlockTick_1_)).getMaterial() != Material.AIR && iblockstate.getBlock() == p_updateBlockTick_2_) {
                    iblockstate.getBlock().updateTick(this, p_updateBlockTick_1_, iblockstate, this.rand);
                }
                return;
            }
            p_updateBlockTick_3_ = 1;
        }
        NextTickListEntry nextticklistentry = new NextTickListEntry(p_updateBlockTick_1_, p_updateBlockTick_2_);
        if (this.isBlockLoaded(p_updateBlockTick_1_)) {
            if (material != Material.AIR) {
                nextticklistentry.setScheduledTime((long)p_updateBlockTick_3_ + this.worldInfo.getWorldTotalTime());
                nextticklistentry.setPriority(p_updateBlockTick_4_);
            }
            if (!this.pendingTickListEntriesHashSet.contains(nextticklistentry)) {
                this.pendingTickListEntriesHashSet.add(nextticklistentry);
                this.pendingTickListEntriesTreeSet.add(nextticklistentry);
            }
        }
    }

    @Override
    public void scheduleBlockUpdate(BlockPos p_scheduleBlockUpdate_1_, Block p_scheduleBlockUpdate_2_, int p_scheduleBlockUpdate_3_, int p_scheduleBlockUpdate_4_) {
        if (p_scheduleBlockUpdate_2_ == null) {
            return;
        }
        if (p_scheduleBlockUpdate_1_ instanceof BlockPos.MutableBlockPos || p_scheduleBlockUpdate_1_ instanceof BlockPos.PooledMutableBlockPos) {
            p_scheduleBlockUpdate_1_ = new BlockPos(p_scheduleBlockUpdate_1_);
            LogManager.getLogger().warn("Tried to assign a mutable BlockPos to tick data...", (Throwable)new Error(p_scheduleBlockUpdate_1_.getClass().toString()));
        }
        NextTickListEntry nextticklistentry = new NextTickListEntry(p_scheduleBlockUpdate_1_, p_scheduleBlockUpdate_2_);
        nextticklistentry.setPriority(p_scheduleBlockUpdate_4_);
        Material material = p_scheduleBlockUpdate_2_.getDefaultState().getMaterial();
        if (material != Material.AIR) {
            nextticklistentry.setScheduledTime((long)p_scheduleBlockUpdate_3_ + this.worldInfo.getWorldTotalTime());
        }
        if (!this.pendingTickListEntriesHashSet.contains(nextticklistentry)) {
            this.pendingTickListEntriesHashSet.add(nextticklistentry);
            this.pendingTickListEntriesTreeSet.add(nextticklistentry);
        }
    }

    @Override
    public void updateEntities() {
        if (this.playerEntities.isEmpty() && this.getPersistentChunks().isEmpty()) {
            if (this.updateEntityTick++ >= 300) {
                return;
            }
        } else {
            this.resetUpdateEntityTick();
        }
        this.provider.onWorldUpdateEntities();
        super.updateEntities();
    }

    @Override
    protected void tickPlayers() {
        super.tickPlayers();
        this.theProfiler.endStartSection("players");
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            Entity entity = (Entity)this.playerEntities.get(i);
            Entity entity1 = entity.getRidingEntity();
            if (entity1 != null) {
                if (!entity1.isDead && entity1.isPassenger(entity)) continue;
                entity.dismountRidingEntity();
            }
            this.theProfiler.startSection("tick");
            if (!entity.isDead) {
                try {
                    this.updateEntity(entity);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Ticking player");
                    CrashReportCategory crashreportcategory = crashreport.makeCategory("Player being ticked");
                    entity.addEntityCrashInfo(crashreportcategory);
                    throw new ReportedException(crashreport);
                }
            }
            this.theProfiler.endSection();
            this.theProfiler.startSection("remove");
            if (entity.isDead) {
                int j = entity.chunkCoordX;
                int k = entity.chunkCoordZ;
                if (entity.addedToChunk && this.isChunkLoaded(j, k, true)) {
                    this.getChunkFromChunkCoords(j, k).removeEntity(entity);
                }
                this.loadedEntityList.remove(entity);
                this.onEntityRemoved(entity);
            }
            this.theProfiler.endSection();
        }
    }

    public void resetUpdateEntityTick() {
        this.updateEntityTick = 0;
    }

    @Override
    public boolean tickUpdates(boolean p_tickUpdates_1_) {
        if (this.worldInfo.getTerrainType() == WorldType.DEBUG_WORLD) {
            return false;
        }
        int i = this.pendingTickListEntriesTreeSet.size();
        if (i != this.pendingTickListEntriesHashSet.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (i > 65536) {
            i = 65536;
        }
        this.theProfiler.startSection("cleaning");
        for (int j = 0; j < i; ++j) {
            NextTickListEntry nextticklistentry = this.pendingTickListEntriesTreeSet.first();
            if (!p_tickUpdates_1_ && nextticklistentry.scheduledTime > this.worldInfo.getWorldTotalTime()) break;
            this.pendingTickListEntriesTreeSet.remove(nextticklistentry);
            this.pendingTickListEntriesHashSet.remove(nextticklistentry);
            this.pendingTickListEntriesThisTick.add(nextticklistentry);
        }
        this.theProfiler.endSection();
        this.theProfiler.startSection("ticking");
        Iterator<NextTickListEntry> iterator = this.pendingTickListEntriesThisTick.iterator();
        while (iterator.hasNext()) {
            NextTickListEntry nextticklistentry1 = iterator.next();
            iterator.remove();
            boolean k = false;
            if (this.isAreaLoaded(nextticklistentry1.position.add(0, 0, 0), nextticklistentry1.position.add(0, 0, 0))) {
                IBlockState iblockstate = this.getBlockState(nextticklistentry1.position);
                if (iblockstate.getMaterial() == Material.AIR || !Block.isEqualTo(iblockstate.getBlock(), nextticklistentry1.getBlock())) continue;
                try {
                    iblockstate.getBlock().updateTick(this, nextticklistentry1.position, iblockstate, this.rand);
                    continue;
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Exception while ticking a block");
                    CrashReportCategory crashreportcategory = crashreport.makeCategory("Block being ticked");
                    CrashReportCategory.addBlockInfo(crashreportcategory, nextticklistentry1.position, iblockstate);
                    throw new ReportedException(crashreport);
                }
            }
            this.scheduleUpdate(nextticklistentry1.position, nextticklistentry1.getBlock(), 0);
        }
        this.theProfiler.endSection();
        this.pendingTickListEntriesThisTick.clear();
        return !this.pendingTickListEntriesTreeSet.isEmpty();
    }

    @Override
    @Nullable
    public List<NextTickListEntry> getPendingBlockUpdates(Chunk p_getPendingBlockUpdates_1_, boolean p_getPendingBlockUpdates_2_) {
        ChunkPos chunkpos = p_getPendingBlockUpdates_1_.getPos();
        int i = (chunkpos.chunkXPos << 4) - 2;
        int j = i + 16 + 2;
        int k = (chunkpos.chunkZPos << 4) - 2;
        int l = k + 16 + 2;
        return this.getPendingBlockUpdates(new StructureBoundingBox(i, 0, k, j, 256, l), p_getPendingBlockUpdates_2_);
    }

    @Override
    @Nullable
    public List<NextTickListEntry> getPendingBlockUpdates(StructureBoundingBox p_getPendingBlockUpdates_1_, boolean p_getPendingBlockUpdates_2_) {
        ArrayList list = null;
        for (int i = 0; i < 2; ++i) {
            Iterator<NextTickListEntry> iterator = i == 0 ? this.pendingTickListEntriesTreeSet.iterator() : this.pendingTickListEntriesThisTick.iterator();
            while (iterator.hasNext()) {
                NextTickListEntry nextticklistentry = iterator.next();
                BlockPos blockpos = nextticklistentry.position;
                if (blockpos.getX() < p_getPendingBlockUpdates_1_.minX || blockpos.getX() >= p_getPendingBlockUpdates_1_.maxX || blockpos.getZ() < p_getPendingBlockUpdates_1_.minZ || blockpos.getZ() >= p_getPendingBlockUpdates_1_.maxZ) continue;
                if (p_getPendingBlockUpdates_2_) {
                    if (i == 0) {
                        this.pendingTickListEntriesHashSet.remove(nextticklistentry);
                    }
                    iterator.remove();
                }
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(nextticklistentry);
            }
        }
        return list;
    }

    @Override
    public void updateEntityWithOptionalForce(Entity p_updateEntityWithOptionalForce_1_, boolean p_updateEntityWithOptionalForce_2_) {
        if (!this.canSpawnAnimals() && (p_updateEntityWithOptionalForce_1_ instanceof EntityAnimal || p_updateEntityWithOptionalForce_1_ instanceof EntityWaterMob)) {
            p_updateEntityWithOptionalForce_1_.setDead();
        }
        if (!this.canSpawnNPCs() && p_updateEntityWithOptionalForce_1_ instanceof INpc) {
            p_updateEntityWithOptionalForce_1_.setDead();
        }
        super.updateEntityWithOptionalForce(p_updateEntityWithOptionalForce_1_, p_updateEntityWithOptionalForce_2_);
    }

    private boolean canSpawnNPCs() {
        return this.mcServer.getCanSpawnNPCs();
    }

    private boolean canSpawnAnimals() {
        return this.mcServer.getCanSpawnAnimals();
    }

    @Override
    protected IChunkProvider createChunkProvider() {
        IChunkLoader ichunkloader = this.saveHandler.getChunkLoader(this.provider);
        return new ChunkProviderServer(this, ichunkloader, this.provider.createChunkGenerator());
    }

    @Override
    public boolean isBlockModifiable(EntityPlayer p_isBlockModifiable_1_, BlockPos p_isBlockModifiable_2_) {
        return super.isBlockModifiable(p_isBlockModifiable_1_, p_isBlockModifiable_2_);
    }

    @Override
    public boolean canMineBlockBody(EntityPlayer p_canMineBlockBody_1_, BlockPos p_canMineBlockBody_2_) {
        return !this.mcServer.isBlockProtected(this, p_canMineBlockBody_2_, p_canMineBlockBody_1_) && this.getWorldBorder().contains(p_canMineBlockBody_2_);
    }

    @Override
    public void initialize(WorldSettings p_initialize_1_) {
        if (!this.worldInfo.isInitialized()) {
            try {
                this.createSpawnPosition(p_initialize_1_);
                if (this.worldInfo.getTerrainType() == WorldType.DEBUG_WORLD) {
                    this.setDebugWorldSettings();
                }
                super.initialize(p_initialize_1_);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Exception initializing level");
                try {
                    this.addWorldInfoToCrashReport(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            this.worldInfo.setServerInitialized(true);
        }
    }

    private void setDebugWorldSettings() {
        this.worldInfo.setMapFeaturesEnabled(false);
        this.worldInfo.setAllowCommands(true);
        this.worldInfo.setRaining(false);
        this.worldInfo.setThundering(false);
        this.worldInfo.setCleanWeatherTime(1000000000);
        this.worldInfo.setWorldTime(6000L);
        this.worldInfo.setGameType(GameType.SPECTATOR);
        this.worldInfo.setHardcore(false);
        this.worldInfo.setDifficulty(EnumDifficulty.PEACEFUL);
        this.worldInfo.setDifficultyLocked(true);
        this.getGameRules().setOrCreateGameRule("doDaylightCycle", "false");
    }

    private void createSpawnPosition(WorldSettings p_createSpawnPosition_1_) {
        if (!this.provider.canRespawnHere()) {
            this.worldInfo.setSpawn(BlockPos.ORIGIN.up(this.provider.getAverageGroundLevel()));
        } else if (this.worldInfo.getTerrainType() == WorldType.DEBUG_WORLD) {
            this.worldInfo.setSpawn(BlockPos.ORIGIN.up());
        } else {
            if (ForgeEventFactory.onCreateWorldSpawn(this, p_createSpawnPosition_1_)) {
                return;
            }
            this.findingSpawnPoint = true;
            BiomeProvider biomeprovider = this.provider.getBiomeProvider();
            List<Biome> list = biomeprovider.getBiomesToSpawnIn();
            Random random = new Random(this.getSeed());
            BlockPos blockpos = biomeprovider.findBiomePosition(0, 0, 256, list, random);
            int i = 8;
            int j = this.provider.getAverageGroundLevel();
            int k = 8;
            if (blockpos != null) {
                i = blockpos.getX();
                k = blockpos.getZ();
            } else {
                LOGGER.warn("Unable to find spawn biome");
            }
            int l = 0;
            while (!this.provider.canCoordinateBeSpawn(i, k)) {
                i += random.nextInt(64) - random.nextInt(64);
                k += random.nextInt(64) - random.nextInt(64);
                if (++l != 1000) continue;
            }
            this.worldInfo.setSpawn(new BlockPos(i, j, k));
            this.findingSpawnPoint = false;
            if (p_createSpawnPosition_1_.isBonusChestEnabled()) {
                this.createBonusChest();
            }
        }
    }

    protected void createBonusChest() {
        int k;
        int j;
        BlockPos blockpos;
        WorldGeneratorBonusChest worldgeneratorbonuschest = new WorldGeneratorBonusChest();
        for (int i = 0; i < 10 && !worldgeneratorbonuschest.generate(this, this.rand, blockpos = this.getTopSolidOrLiquidBlock(new BlockPos(j = this.worldInfo.getSpawnX() + this.rand.nextInt(6) - this.rand.nextInt(6), 0, k = this.worldInfo.getSpawnZ() + this.rand.nextInt(6) - this.rand.nextInt(6))).up()); ++i) {
        }
    }

    @Nullable
    public BlockPos getSpawnCoordinate() {
        return this.provider.getSpawnCoordinate();
    }

    public void saveAllChunks(boolean p_saveAllChunks_1_, IProgressUpdate p_saveAllChunks_2_) throws MinecraftException {
        ChunkProviderServer chunkproviderserver = this.getChunkProvider();
        if (chunkproviderserver.canSave()) {
            if (p_saveAllChunks_2_ != null) {
                p_saveAllChunks_2_.displaySavingString("Saving level");
            }
            this.saveLevel();
            if (p_saveAllChunks_2_ != null) {
                p_saveAllChunks_2_.displayLoadingString("Saving chunks");
            }
            chunkproviderserver.saveChunks(p_saveAllChunks_1_);
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Save(this));
            for (Chunk chunk : Lists.newArrayList(chunkproviderserver.getLoadedChunks())) {
                if (chunk == null || this.playerChunkMap.contains(chunk.xPosition, chunk.zPosition)) continue;
                chunkproviderserver.unload(chunk);
            }
        }
    }

    public void saveChunkData() {
        ChunkProviderServer chunkproviderserver = this.getChunkProvider();
        if (chunkproviderserver.canSave()) {
            chunkproviderserver.saveExtraData();
        }
    }

    protected void saveLevel() throws MinecraftException {
        this.checkSessionLock();
        for (WorldServer worldserver : this.mcServer.worlds) {
            if (!(worldserver instanceof WorldServerMulti)) continue;
            ((WorldServerMulti)worldserver).saveAdditionalData();
        }
        this.worldInfo.setBorderSize(this.getWorldBorder().getDiameter());
        this.worldInfo.getBorderCenterX(this.getWorldBorder().getCenterX());
        this.worldInfo.getBorderCenterZ(this.getWorldBorder().getCenterZ());
        this.worldInfo.setBorderSafeZone(this.getWorldBorder().getDamageBuffer());
        this.worldInfo.setBorderDamagePerBlock(this.getWorldBorder().getDamageAmount());
        this.worldInfo.setBorderWarningDistance(this.getWorldBorder().getWarningDistance());
        this.worldInfo.setBorderWarningTime(this.getWorldBorder().getWarningTime());
        this.worldInfo.setBorderLerpTarget(this.getWorldBorder().getTargetSize());
        this.worldInfo.setBorderLerpTime(this.getWorldBorder().getTimeUntilTarget());
        this.saveHandler.saveWorldInfoWithPlayer(this.worldInfo, this.mcServer.getPlayerList().getHostPlayerData());
        this.mapStorage.saveAllData();
        this.perWorldStorage.saveAllData();
    }

    @Override
    public boolean spawnEntity(Entity p_spawnEntity_1_) {
        return this.canAddEntity(p_spawnEntity_1_) ? super.spawnEntity(p_spawnEntity_1_) : false;
    }

    @Override
    public void loadEntities(Collection<Entity> p_loadEntities_1_) {
        for (Entity entity : Lists.newArrayList(p_loadEntities_1_)) {
            if (!this.canAddEntity(entity) || MinecraftForge.EVENT_BUS.post(new EntityJoinWorldEvent(entity, this))) continue;
            this.loadedEntityList.add(entity);
            this.onEntityAdded(entity);
        }
    }

    private boolean canAddEntity(Entity p_canAddEntity_1_) {
        if (p_canAddEntity_1_.isDead) {
            LOGGER.warn("Tried to add entity {} but it was marked as removed already", new Object[]{EntityList.getKey(p_canAddEntity_1_)});
            return false;
        }
        UUID uuid = p_canAddEntity_1_.getUniqueID();
        if (this.entitiesByUuid.containsKey(uuid)) {
            Entity entity = this.entitiesByUuid.get(uuid);
            if (this.unloadedEntityList.contains(entity)) {
                this.unloadedEntityList.remove(entity);
            } else {
                if (!(p_canAddEntity_1_ instanceof EntityPlayer)) {
                    LOGGER.warn("Keeping entity {} that already exists with UUID {}", new Object[]{EntityList.getKey(entity), uuid.toString()});
                    return false;
                }
                LOGGER.warn("Force-added player with duplicate UUID {}", new Object[]{uuid.toString()});
            }
            this.removeEntityDangerously(entity);
        }
        return true;
    }

    @Override
    public void onEntityAdded(Entity p_onEntityAdded_1_) {
        super.onEntityAdded(p_onEntityAdded_1_);
        this.entitiesById.addKey(p_onEntityAdded_1_.getEntityId(), p_onEntityAdded_1_);
        this.entitiesByUuid.put(p_onEntityAdded_1_.getUniqueID(), p_onEntityAdded_1_);
        Entity[] aentity = p_onEntityAdded_1_.getParts();
        if (aentity != null) {
            for (Entity entity : aentity) {
                this.entitiesById.addKey(entity.getEntityId(), entity);
            }
        }
    }

    @Override
    public void onEntityRemoved(Entity p_onEntityRemoved_1_) {
        super.onEntityRemoved(p_onEntityRemoved_1_);
        this.entitiesById.removeObject(p_onEntityRemoved_1_.getEntityId());
        this.entitiesByUuid.remove(p_onEntityRemoved_1_.getUniqueID());
        Entity[] aentity = p_onEntityRemoved_1_.getParts();
        if (aentity != null) {
            for (Entity entity : aentity) {
                this.entitiesById.removeObject(entity.getEntityId());
            }
        }
    }

    @Override
    public boolean addWeatherEffect(Entity p_addWeatherEffect_1_) {
        if (super.addWeatherEffect(p_addWeatherEffect_1_)) {
            this.mcServer.getPlayerList().sendToAllNearExcept(null, p_addWeatherEffect_1_.posX, p_addWeatherEffect_1_.posY, p_addWeatherEffect_1_.posZ, 512.0, this.provider.getDimension(), new SPacketSpawnGlobalEntity(p_addWeatherEffect_1_));
            return true;
        }
        return false;
    }

    @Override
    public void setEntityState(Entity p_setEntityState_1_, byte p_setEntityState_2_) {
        this.getEntityTracker().sendToTrackingAndSelf(p_setEntityState_1_, new SPacketEntityStatus(p_setEntityState_1_, p_setEntityState_2_));
    }

    @Override
    public ChunkProviderServer getChunkProvider() {
        return (ChunkProviderServer)super.getChunkProvider();
    }

    @Override
    public Explosion newExplosion(Entity p_newExplosion_1_, double p_newExplosion_2_, double p_newExplosion_4_, double p_newExplosion_6_, float p_newExplosion_8_, boolean p_newExplosion_9_, boolean p_newExplosion_10_) {
        Explosion explosion = new Explosion(this, p_newExplosion_1_, p_newExplosion_2_, p_newExplosion_4_, p_newExplosion_6_, p_newExplosion_8_, p_newExplosion_9_, p_newExplosion_10_);
        if (ForgeEventFactory.onExplosionStart(this, explosion)) {
            return explosion;
        }
        explosion.doExplosionA();
        explosion.doExplosionB(false);
        if (!p_newExplosion_10_) {
            explosion.clearAffectedBlockPositions();
        }
        for (EntityPlayer entityplayer : this.playerEntities) {
            if (!(entityplayer.getDistanceSq(p_newExplosion_2_, p_newExplosion_4_, p_newExplosion_6_) < 4096.0)) continue;
            ((EntityPlayerMP)entityplayer).connection.sendPacket(new SPacketExplosion(p_newExplosion_2_, p_newExplosion_4_, p_newExplosion_6_, p_newExplosion_8_, explosion.getAffectedBlockPositions(), explosion.getPlayerKnockbackMap().get(entityplayer)));
        }
        return explosion;
    }

    @Override
    public void addBlockEvent(BlockPos p_addBlockEvent_1_, Block p_addBlockEvent_2_, int p_addBlockEvent_3_, int p_addBlockEvent_4_) {
        BlockEventData blockeventdata = new BlockEventData(p_addBlockEvent_1_, p_addBlockEvent_2_, p_addBlockEvent_3_, p_addBlockEvent_4_);
        for (BlockEventData blockeventdata1 : this.blockEventQueue[this.blockEventCacheIndex]) {
            if (!blockeventdata1.equals(blockeventdata)) continue;
            return;
        }
        this.blockEventQueue[this.blockEventCacheIndex].add(blockeventdata);
    }

    private void sendQueuedBlockEvents() {
        while (!this.blockEventQueue[this.blockEventCacheIndex].isEmpty()) {
            int i = this.blockEventCacheIndex;
            this.blockEventCacheIndex ^= 1;
            for (BlockEventData blockeventdata : this.blockEventQueue[i]) {
                if (!this.fireBlockEvent(blockeventdata)) continue;
                this.mcServer.getPlayerList().sendToAllNearExcept(null, blockeventdata.getPosition().getX(), blockeventdata.getPosition().getY(), blockeventdata.getPosition().getZ(), 64.0, this.provider.getDimension(), new SPacketBlockAction(blockeventdata.getPosition(), blockeventdata.getBlock(), blockeventdata.getEventID(), blockeventdata.getEventParameter()));
            }
            this.blockEventQueue[i].clear();
        }
    }

    private boolean fireBlockEvent(BlockEventData p_fireBlockEvent_1_) {
        IBlockState iblockstate = this.getBlockState(p_fireBlockEvent_1_.getPosition());
        return iblockstate.getBlock() == p_fireBlockEvent_1_.getBlock() ? iblockstate.onBlockEventReceived(this, p_fireBlockEvent_1_.getPosition(), p_fireBlockEvent_1_.getEventID(), p_fireBlockEvent_1_.getEventParameter()) : false;
    }

    public void flush() {
        this.saveHandler.flush();
    }

    @Override
    protected void updateWeather() {
        boolean flag = this.isRaining();
        super.updateWeather();
        if (this.prevRainingStrength != this.rainingStrength) {
            this.mcServer.getPlayerList().sendPacketToAllPlayersInDimension(new SPacketChangeGameState(7, this.rainingStrength), this.provider.getDimension());
        }
        if (this.prevThunderingStrength != this.thunderingStrength) {
            this.mcServer.getPlayerList().sendPacketToAllPlayersInDimension(new SPacketChangeGameState(8, this.thunderingStrength), this.provider.getDimension());
        }
        if (flag != this.isRaining()) {
            if (flag) {
                this.mcServer.getPlayerList().sendPacketToAllPlayersInDimension(new SPacketChangeGameState(2, 0.0f), this.provider.getDimension());
            } else {
                this.mcServer.getPlayerList().sendPacketToAllPlayersInDimension(new SPacketChangeGameState(1, 0.0f), this.provider.getDimension());
            }
            this.mcServer.getPlayerList().sendPacketToAllPlayersInDimension(new SPacketChangeGameState(7, this.rainingStrength), this.provider.getDimension());
            this.mcServer.getPlayerList().sendPacketToAllPlayersInDimension(new SPacketChangeGameState(8, this.thunderingStrength), this.provider.getDimension());
        }
    }

    @Override
    @Nullable
    public MinecraftServer getMinecraftServer() {
        return this.mcServer;
    }

    public EntityTracker getEntityTracker() {
        return this.theEntityTracker;
    }

    public PlayerChunkMap getPlayerChunkMap() {
        return this.playerChunkMap;
    }

    public Teleporter getDefaultTeleporter() {
        return this.worldTeleporter;
    }

    public TemplateManager getStructureTemplateManager() {
        return this.saveHandler.getStructureTemplateManager();
    }

    public void spawnParticle(EnumParticleTypes p_spawnParticle_1_, double p_spawnParticle_2_, double p_spawnParticle_4_, double p_spawnParticle_6_, int p_spawnParticle_8_, double p_spawnParticle_9_, double p_spawnParticle_11_, double p_spawnParticle_13_, double p_spawnParticle_15_, int ... p_spawnParticle_17_) {
        this.spawnParticle(p_spawnParticle_1_, false, p_spawnParticle_2_, p_spawnParticle_4_, p_spawnParticle_6_, p_spawnParticle_8_, p_spawnParticle_9_, p_spawnParticle_11_, p_spawnParticle_13_, p_spawnParticle_15_, p_spawnParticle_17_);
    }

    public void spawnParticle(EnumParticleTypes p_spawnParticle_1_, boolean p_spawnParticle_2_, double p_spawnParticle_3_, double p_spawnParticle_5_, double p_spawnParticle_7_, int p_spawnParticle_9_, double p_spawnParticle_10_, double p_spawnParticle_12_, double p_spawnParticle_14_, double p_spawnParticle_16_, int ... p_spawnParticle_18_) {
        SPacketParticles spacketparticles = new SPacketParticles(p_spawnParticle_1_, p_spawnParticle_2_, (float)p_spawnParticle_3_, (float)p_spawnParticle_5_, (float)p_spawnParticle_7_, (float)p_spawnParticle_10_, (float)p_spawnParticle_12_, (float)p_spawnParticle_14_, (float)p_spawnParticle_16_, p_spawnParticle_9_, p_spawnParticle_18_);
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.playerEntities.get(i);
            this.sendPacketWithinDistance(entityplayermp, p_spawnParticle_2_, p_spawnParticle_3_, p_spawnParticle_5_, p_spawnParticle_7_, spacketparticles);
        }
    }

    public void spawnParticle(EntityPlayerMP p_spawnParticle_1_, EnumParticleTypes p_spawnParticle_2_, boolean p_spawnParticle_3_, double p_spawnParticle_4_, double p_spawnParticle_6_, double p_spawnParticle_8_, int p_spawnParticle_10_, double p_spawnParticle_11_, double p_spawnParticle_13_, double p_spawnParticle_15_, double p_spawnParticle_17_, int ... p_spawnParticle_19_) {
        SPacketParticles packet = new SPacketParticles(p_spawnParticle_2_, p_spawnParticle_3_, (float)p_spawnParticle_4_, (float)p_spawnParticle_6_, (float)p_spawnParticle_8_, (float)p_spawnParticle_11_, (float)p_spawnParticle_13_, (float)p_spawnParticle_15_, (float)p_spawnParticle_17_, p_spawnParticle_10_, p_spawnParticle_19_);
        this.sendPacketWithinDistance(p_spawnParticle_1_, p_spawnParticle_3_, p_spawnParticle_4_, p_spawnParticle_6_, p_spawnParticle_8_, packet);
    }

    private void sendPacketWithinDistance(EntityPlayerMP p_sendPacketWithinDistance_1_, boolean p_sendPacketWithinDistance_2_, double p_sendPacketWithinDistance_3_, double p_sendPacketWithinDistance_5_, double p_sendPacketWithinDistance_7_, Packet<?> p_sendPacketWithinDistance_9_) {
        BlockPos blockpos = p_sendPacketWithinDistance_1_.getPosition();
        double d0 = blockpos.distanceSq(p_sendPacketWithinDistance_3_, p_sendPacketWithinDistance_5_, p_sendPacketWithinDistance_7_);
        if (d0 <= 1024.0 || p_sendPacketWithinDistance_2_ && d0 <= 262144.0) {
            p_sendPacketWithinDistance_1_.connection.sendPacket(p_sendPacketWithinDistance_9_);
        }
    }

    @Nullable
    public Entity getEntityFromUuid(UUID p_getEntityFromUuid_1_) {
        return this.entitiesByUuid.get(p_getEntityFromUuid_1_);
    }

    @Override
    public ListenableFuture<Object> addScheduledTask(Runnable p_addScheduledTask_1_) {
        return this.mcServer.addScheduledTask(p_addScheduledTask_1_);
    }

    @Override
    public boolean isCallingFromMinecraftThread() {
        return this.mcServer.isCallingFromMinecraftThread();
    }

    @Override
    @Nullable
    public BlockPos findNearestStructure(String p_findNearestStructure_1_, BlockPos p_findNearestStructure_2_, boolean p_findNearestStructure_3_) {
        return this.getChunkProvider().getStrongholdGen(this, p_findNearestStructure_1_, p_findNearestStructure_2_, p_findNearestStructure_3_);
    }

    public File getChunkSaveLocation() {
        return ((AnvilChunkLoader)this.getChunkProvider().chunkLoader).chunkSaveLocation;
    }

    static class ServerBlockEventList
    extends ArrayList<BlockEventData> {
        private ServerBlockEventList() {
        }
    }
}

