/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.ISaveHandler;

public class WorldServerMulti
extends WorldServer {
    private final WorldServer delegate;
    private IBorderListener borderListener;

    public WorldServerMulti(MinecraftServer p_i45923_1_, ISaveHandler p_i45923_2_, int p_i45923_3_, WorldServer p_i45923_4_, Profiler p_i45923_5_) {
        super(p_i45923_1_, p_i45923_2_, new DerivedWorldInfo(p_i45923_4_.getWorldInfo()), p_i45923_3_, p_i45923_5_);
        this.delegate = p_i45923_4_;
        this.borderListener = new IBorderListener(){

            @Override
            public void onSizeChanged(WorldBorder p_onSizeChanged_1_, double p_onSizeChanged_2_) {
                WorldServerMulti.this.getWorldBorder().setTransition(p_onSizeChanged_2_);
            }

            @Override
            public void onTransitionStarted(WorldBorder p_onTransitionStarted_1_, double p_onTransitionStarted_2_, double p_onTransitionStarted_4_, long p_onTransitionStarted_6_) {
                WorldServerMulti.this.getWorldBorder().setTransition(p_onTransitionStarted_2_, p_onTransitionStarted_4_, p_onTransitionStarted_6_);
            }

            @Override
            public void onCenterChanged(WorldBorder p_onCenterChanged_1_, double p_onCenterChanged_2_, double p_onCenterChanged_4_) {
                WorldServerMulti.this.getWorldBorder().setCenter(p_onCenterChanged_2_, p_onCenterChanged_4_);
            }

            @Override
            public void onWarningTimeChanged(WorldBorder p_onWarningTimeChanged_1_, int p_onWarningTimeChanged_2_) {
                WorldServerMulti.this.getWorldBorder().setWarningTime(p_onWarningTimeChanged_2_);
            }

            @Override
            public void onWarningDistanceChanged(WorldBorder p_onWarningDistanceChanged_1_, int p_onWarningDistanceChanged_2_) {
                WorldServerMulti.this.getWorldBorder().setWarningDistance(p_onWarningDistanceChanged_2_);
            }

            @Override
            public void onDamageAmountChanged(WorldBorder p_onDamageAmountChanged_1_, double p_onDamageAmountChanged_2_) {
                WorldServerMulti.this.getWorldBorder().setDamageAmount(p_onDamageAmountChanged_2_);
            }

            @Override
            public void onDamageBufferChanged(WorldBorder p_onDamageBufferChanged_1_, double p_onDamageBufferChanged_2_) {
                WorldServerMulti.this.getWorldBorder().setDamageBuffer(p_onDamageBufferChanged_2_);
            }
        };
        this.delegate.getWorldBorder().addListener(this.borderListener);
    }

    @Override
    protected void saveLevel() throws MinecraftException {
        this.perWorldStorage.saveAllData();
    }

    @Override
    public World init() {
        this.mapStorage = this.delegate.getMapStorage();
        this.worldScoreboard = this.delegate.getScoreboard();
        this.lootTable = this.delegate.getLootTableManager();
        String s = VillageCollection.fileNameForProvider(this.provider);
        VillageCollection villagecollection = (VillageCollection)this.perWorldStorage.getOrLoadData(VillageCollection.class, s);
        if (villagecollection == null) {
            this.villageCollectionObj = new VillageCollection(this);
            this.perWorldStorage.setData(s, this.villageCollectionObj);
        } else {
            this.villageCollectionObj = villagecollection;
            this.villageCollectionObj.setWorldsForAll(this);
        }
        this.initCapabilities();
        return this;
    }

    @Override
    public void flush() {
        super.flush();
        this.delegate.getWorldBorder().removeListener(this.borderListener);
    }

    public void saveAdditionalData() {
        this.provider.onWorldSave();
    }
}

