/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.world.GameType;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class WorldSettings {
    private final long seed;
    private final GameType theGameType;
    private final boolean mapFeaturesEnabled;
    private final boolean hardcoreEnabled;
    private final WorldType terrainType;
    private boolean commandsAllowed;
    private boolean bonusChestEnabled;
    private String generatorOptions = "";

    public WorldSettings(long p_i1957_1_, GameType p_i1957_3_, boolean p_i1957_4_, boolean p_i1957_5_, WorldType p_i1957_6_) {
        this.seed = p_i1957_1_;
        this.theGameType = p_i1957_3_;
        this.mapFeaturesEnabled = p_i1957_4_;
        this.hardcoreEnabled = p_i1957_5_;
        this.terrainType = p_i1957_6_;
    }

    public WorldSettings(WorldInfo p_i1958_1_) {
        this(p_i1958_1_.getSeed(), p_i1958_1_.getGameType(), p_i1958_1_.isMapFeaturesEnabled(), p_i1958_1_.isHardcoreModeEnabled(), p_i1958_1_.getTerrainType());
    }

    public WorldSettings enableBonusChest() {
        this.bonusChestEnabled = true;
        return this;
    }

    public WorldSettings setGeneratorOptions(String p_setGeneratorOptions_1_) {
        this.generatorOptions = p_setGeneratorOptions_1_;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public WorldSettings enableCommands() {
        this.commandsAllowed = true;
        return this;
    }

    public boolean isBonusChestEnabled() {
        return this.bonusChestEnabled;
    }

    public long getSeed() {
        return this.seed;
    }

    public GameType getGameType() {
        return this.theGameType;
    }

    public boolean getHardcoreEnabled() {
        return this.hardcoreEnabled;
    }

    public boolean isMapFeaturesEnabled() {
        return this.mapFeaturesEnabled;
    }

    public WorldType getTerrainType() {
        return this.terrainType;
    }

    public boolean areCommandsAllowed() {
        return this.commandsAllowed;
    }

    public static GameType getGameTypeById(int p_getGameTypeById_0_) {
        return GameType.getByID(p_getGameTypeById_0_);
    }

    public String getGeneratorOptions() {
        return this.generatorOptions;
    }
}

