/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateFlatWorld;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiCustomizeWorldScreen;
import net.minecraft.init.Biomes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderDebug;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.ChunkProviderOverworld;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiome;
import net.minecraft.world.gen.layer.GenLayerBiomeEdge;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldType {
    public static WorldType[] WORLD_TYPES = new WorldType[16];
    public static final WorldType DEFAULT = new WorldType(0, "default", 1).setVersioned();
    public static final WorldType FLAT = new WorldType(1, "flat");
    public static final WorldType LARGE_BIOMES = new WorldType(2, "largeBiomes");
    public static final WorldType AMPLIFIED = new WorldType(3, "amplified").setNotificationData();
    public static final WorldType CUSTOMIZED = new WorldType(4, "customized");
    public static final WorldType DEBUG_WORLD = new WorldType(5, "debug_all_block_states");
    public static final WorldType DEFAULT_1_1 = new WorldType(8, "default_1_1", 0).setCanBeCreated(false);
    private final int worldTypeId;
    private final String worldType;
    private final int generatorVersion;
    private boolean canBeCreated;
    private boolean isWorldTypeVersioned;
    private boolean hasNotificationData;

    private WorldType(int p_i1959_1_, String p_i1959_2_) {
        this(p_i1959_1_, p_i1959_2_, 0);
    }

    private WorldType(int p_i1960_1_, String p_i1960_2_, int p_i1960_3_) {
        if (p_i1960_2_.length() > 16 && DEBUG_WORLD != null) {
            throw new IllegalArgumentException("World type names must not be longer then 16: " + p_i1960_2_);
        }
        this.worldType = p_i1960_2_;
        this.generatorVersion = p_i1960_3_;
        this.canBeCreated = true;
        this.worldTypeId = p_i1960_1_;
        WorldType.WORLD_TYPES[p_i1960_1_] = this;
    }

    public String getName() {
        return this.worldType;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTranslateName() {
        return "generator." + this.worldType;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTranslatedInfo() {
        return this.getTranslateName() + ".info";
    }

    public int getGeneratorVersion() {
        return this.generatorVersion;
    }

    public WorldType getWorldTypeForGeneratorVersion(int p_getWorldTypeForGeneratorVersion_1_) {
        return this == DEFAULT && p_getWorldTypeForGeneratorVersion_1_ == 0 ? DEFAULT_1_1 : this;
    }

    private WorldType setCanBeCreated(boolean p_setCanBeCreated_1_) {
        this.canBeCreated = p_setCanBeCreated_1_;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canBeCreated() {
        return this.canBeCreated;
    }

    private WorldType setVersioned() {
        this.isWorldTypeVersioned = true;
        return this;
    }

    public boolean isVersioned() {
        return this.isWorldTypeVersioned;
    }

    public static WorldType parseWorldType(String p_parseWorldType_0_) {
        for (WorldType worldtype : WORLD_TYPES) {
            if (worldtype == null || !worldtype.worldType.equalsIgnoreCase(p_parseWorldType_0_)) continue;
            return worldtype;
        }
        return null;
    }

    public int getWorldTypeID() {
        return this.worldTypeId;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showWorldInfoNotice() {
        return this.hasNotificationData;
    }

    private WorldType setNotificationData() {
        this.hasNotificationData = true;
        return this;
    }

    public BiomeProvider getBiomeProvider(World p_getBiomeProvider_1_) {
        if (this == FLAT) {
            FlatGeneratorInfo flatgeneratorinfo = FlatGeneratorInfo.createFlatGeneratorFromString(p_getBiomeProvider_1_.getWorldInfo().getGeneratorOptions());
            return new BiomeProviderSingle(Biome.getBiome(flatgeneratorinfo.getBiome(), Biomes.DEFAULT));
        }
        if (this == DEBUG_WORLD) {
            return new BiomeProviderSingle(Biomes.PLAINS);
        }
        return new BiomeProvider(p_getBiomeProvider_1_.getWorldInfo());
    }

    public IChunkGenerator getChunkGenerator(World p_getChunkGenerator_1_, String p_getChunkGenerator_2_) {
        if (this == FLAT) {
            return new ChunkProviderFlat(p_getChunkGenerator_1_, p_getChunkGenerator_1_.getSeed(), p_getChunkGenerator_1_.getWorldInfo().isMapFeaturesEnabled(), p_getChunkGenerator_2_);
        }
        if (this == DEBUG_WORLD) {
            return new ChunkProviderDebug(p_getChunkGenerator_1_);
        }
        if (this == CUSTOMIZED) {
            return new ChunkProviderOverworld(p_getChunkGenerator_1_, p_getChunkGenerator_1_.getSeed(), p_getChunkGenerator_1_.getWorldInfo().isMapFeaturesEnabled(), p_getChunkGenerator_2_);
        }
        return new ChunkProviderOverworld(p_getChunkGenerator_1_, p_getChunkGenerator_1_.getSeed(), p_getChunkGenerator_1_.getWorldInfo().isMapFeaturesEnabled(), p_getChunkGenerator_2_);
    }

    public int getMinimumSpawnHeight(World p_getMinimumSpawnHeight_1_) {
        return this == FLAT ? 4 : p_getMinimumSpawnHeight_1_.getSeaLevel() + 1;
    }

    public double getHorizon(World p_getHorizon_1_) {
        return this == FLAT ? 0.0 : 63.0;
    }

    public double voidFadeMagnitude() {
        return this == FLAT ? 1.0 : 0.03125;
    }

    public boolean handleSlimeSpawnReduction(Random p_handleSlimeSpawnReduction_1_, World p_handleSlimeSpawnReduction_2_) {
        return this == FLAT ? p_handleSlimeSpawnReduction_1_.nextInt(4) != 1 : false;
    }

    private static int getNextID() {
        for (int x = 0; x < WORLD_TYPES.length; ++x) {
            if (WORLD_TYPES[x] != null) continue;
            return x;
        }
        int oldLen = WORLD_TYPES.length;
        WORLD_TYPES = Arrays.copyOf(WORLD_TYPES, oldLen + 16);
        return oldLen;
    }

    public WorldType(String p_i8_1_) {
        this(WorldType.getNextID(), p_i8_1_);
    }

    public void onGUICreateWorldPress() {
    }

    public int getSpawnFuzz(WorldServer p_getSpawnFuzz_1_, MinecraftServer p_getSpawnFuzz_2_) {
        return Math.max(0, p_getSpawnFuzz_2_.getSpawnRadius(p_getSpawnFuzz_1_));
    }

    @SideOnly(value=Side.CLIENT)
    public void onCustomizeButton(Minecraft p_onCustomizeButton_1_, GuiCreateWorld p_onCustomizeButton_2_) {
        if (this == FLAT) {
            p_onCustomizeButton_1_.displayGuiScreen(new GuiCreateFlatWorld(p_onCustomizeButton_2_, p_onCustomizeButton_2_.chunkProviderSettingsJson));
        } else if (this == CUSTOMIZED) {
            p_onCustomizeButton_1_.displayGuiScreen(new GuiCustomizeWorldScreen(p_onCustomizeButton_2_, p_onCustomizeButton_2_.chunkProviderSettingsJson));
        }
    }

    public boolean isCustomizable() {
        return this == FLAT || this == CUSTOMIZED;
    }

    public float getCloudHeight() {
        return 128.0f;
    }

    public GenLayer getBiomeLayer(long p_getBiomeLayer_1_, GenLayer p_getBiomeLayer_3_, ChunkProviderSettings p_getBiomeLayer_4_) {
        GenLayer ret = new GenLayerBiome(200L, p_getBiomeLayer_3_, this, p_getBiomeLayer_4_);
        ret = GenLayerZoom.magnify(1000L, ret, 2);
        ret = new GenLayerBiomeEdge(1000L, ret);
        return ret;
    }
}

