/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeBeach;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.biome.BiomeEnd;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.biome.BiomeForestMutated;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.biome.BiomeHills;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.biome.BiomeMesa;
import net.minecraft.world.biome.BiomeMushroomIsland;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.biome.BiomeRiver;
import net.minecraft.world.biome.BiomeSavanna;
import net.minecraft.world.biome.BiomeSavannaMutated;
import net.minecraft.world.biome.BiomeSnow;
import net.minecraft.world.biome.BiomeStoneBeach;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraft.world.biome.BiomeTaiga;
import net.minecraft.world.biome.BiomeVoid;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.DeferredBiomeDecorator;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Biome
extends IForgeRegistryEntry.Impl<Biome> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final IBlockState STONE = Blocks.STONE.getDefaultState();
    protected static final IBlockState AIR = Blocks.AIR.getDefaultState();
    protected static final IBlockState BEDROCK = Blocks.BEDROCK.getDefaultState();
    protected static final IBlockState GRAVEL = Blocks.GRAVEL.getDefaultState();
    protected static final IBlockState RED_SANDSTONE = Blocks.RED_SANDSTONE.getDefaultState();
    protected static final IBlockState SANDSTONE = Blocks.SANDSTONE.getDefaultState();
    protected static final IBlockState ICE = Blocks.ICE.getDefaultState();
    protected static final IBlockState WATER = Blocks.WATER.getDefaultState();
    public static final Set<Biome> EXPLORATION_BIOMES_LIST = Sets.newHashSet();
    public static final ObjectIntIdentityMap<Biome> MUTATION_TO_BASE_ID_MAP = new ObjectIntIdentityMap();
    protected static final NoiseGeneratorPerlin TEMPERATURE_NOISE = new NoiseGeneratorPerlin(new Random(1234L), 1);
    protected static final NoiseGeneratorPerlin GRASS_COLOR_NOISE = new NoiseGeneratorPerlin(new Random(2345L), 1);
    protected static final WorldGenDoublePlant DOUBLE_PLANT_GENERATOR = new WorldGenDoublePlant();
    protected static final WorldGenTrees TREE_FEATURE = new WorldGenTrees(false);
    protected static final WorldGenBigTree BIG_TREE_FEATURE = new WorldGenBigTree(false);
    protected static final WorldGenSwamp SWAMP_FEATURE = new WorldGenSwamp();
    public static final RegistryNamespaced<ResourceLocation, Biome> REGISTRY = GameData.getBiomeRegistry();
    private final String biomeName;
    private final float baseHeight;
    private final float heightVariation;
    private final float temperature;
    private final float rainfall;
    private final int waterColor;
    private final boolean enableSnow;
    private final boolean enableRain;
    @Nullable
    private final String baseBiomeRegName;
    public IBlockState topBlock = Blocks.GRASS.getDefaultState();
    public IBlockState fillerBlock = Blocks.DIRT.getDefaultState();
    public BiomeDecorator theBiomeDecorator;
    protected List<SpawnListEntry> spawnableMonsterList = Lists.newArrayList();
    protected List<SpawnListEntry> spawnableCreatureList = Lists.newArrayList();
    protected List<SpawnListEntry> spawnableWaterCreatureList = Lists.newArrayList();
    protected List<SpawnListEntry> spawnableCaveCreatureList = Lists.newArrayList();
    protected Map<EnumCreatureType, List<SpawnListEntry>> modSpawnableLists = Maps.newHashMap();
    protected List<FlowerEntry> flowers = new ArrayList<FlowerEntry>();

    public static int getIdForBiome(Biome p_getIdForBiome_0_) {
        return REGISTRY.getIDForObject(p_getIdForBiome_0_);
    }

    @Nullable
    public static Biome getBiomeForId(int p_getBiomeForId_0_) {
        return REGISTRY.getObjectById(p_getBiomeForId_0_);
    }

    @Nullable
    public static Biome getMutationForBiome(Biome p_getMutationForBiome_0_) {
        return MUTATION_TO_BASE_ID_MAP.getByValue(Biome.getIdForBiome(p_getMutationForBiome_0_));
    }

    public Biome(BiomeProperties p_i46713_1_) {
        this.biomeName = p_i46713_1_.biomeName;
        this.baseHeight = p_i46713_1_.baseHeight;
        this.heightVariation = p_i46713_1_.heightVariation;
        this.temperature = p_i46713_1_.temperature;
        this.rainfall = p_i46713_1_.rainfall;
        this.waterColor = p_i46713_1_.waterColor;
        this.enableSnow = p_i46713_1_.enableSnow;
        this.enableRain = p_i46713_1_.enableRain;
        this.baseBiomeRegName = p_i46713_1_.baseBiomeRegName;
        this.theBiomeDecorator = this.createBiomeDecorator();
        this.spawnableCreatureList.add(new SpawnListEntry(EntitySheep.class, 12, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityPig.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityCow.class, 8, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySpider.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityZombie.class, 95, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityZombieVillager.class, 5, 1, 1));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySkeleton.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityCreeper.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySlime.class, 100, 4, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityEnderman.class, 10, 1, 4));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityWitch.class, 5, 1, 1));
        this.spawnableWaterCreatureList.add(new SpawnListEntry(EntitySquid.class, 10, 4, 4));
        this.spawnableCaveCreatureList.add(new SpawnListEntry(EntityBat.class, 10, 8, 8));
        this.addDefaultFlowers();
    }

    public BiomeDecorator createBiomeDecorator() {
        return this.getModdedBiomeDecorator(new BiomeDecorator());
    }

    public boolean isMutation() {
        return this.baseBiomeRegName != null;
    }

    public WorldGenAbstractTree genBigTreeChance(Random p_genBigTreeChance_1_) {
        return p_genBigTreeChance_1_.nextInt(10) == 0 ? BIG_TREE_FEATURE : TREE_FEATURE;
    }

    public WorldGenerator getRandomWorldGenForGrass(Random p_getRandomWorldGenForGrass_1_) {
        return new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public BlockFlower.EnumFlowerType pickRandomFlower(Random p_pickRandomFlower_1_, BlockPos p_pickRandomFlower_2_) {
        return p_pickRandomFlower_1_.nextInt(3) > 0 ? BlockFlower.EnumFlowerType.DANDELION : BlockFlower.EnumFlowerType.POPPY;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSkyColorByTemp(float p_getSkyColorByTemp_1_) {
        p_getSkyColorByTemp_1_ /= 3.0f;
        p_getSkyColorByTemp_1_ = MathHelper.clamp(p_getSkyColorByTemp_1_, -1.0f, 1.0f);
        return MathHelper.hsvToRGB(0.62222224f - p_getSkyColorByTemp_1_ * 0.05f, 0.5f + p_getSkyColorByTemp_1_ * 0.1f, 1.0f);
    }

    public List<SpawnListEntry> getSpawnableList(EnumCreatureType p_getSpawnableList_1_) {
        switch (p_getSpawnableList_1_) {
            case MONSTER: {
                return this.spawnableMonsterList;
            }
            case CREATURE: {
                return this.spawnableCreatureList;
            }
            case WATER_CREATURE: {
                return this.spawnableWaterCreatureList;
            }
            case AMBIENT: {
                return this.spawnableCaveCreatureList;
            }
        }
        if (!this.modSpawnableLists.containsKey((Object)p_getSpawnableList_1_)) {
            this.modSpawnableLists.put(p_getSpawnableList_1_, Lists.newArrayList());
        }
        return this.modSpawnableLists.get((Object)p_getSpawnableList_1_);
    }

    public boolean getEnableSnow() {
        return this.isSnowyBiome();
    }

    public boolean canRain() {
        return this.isSnowyBiome() ? false : this.enableRain;
    }

    public boolean isHighHumidity() {
        return this.getRainfall() > 0.85f;
    }

    public float getSpawningChance() {
        return 0.1f;
    }

    public final float getFloatTemperature(BlockPos p_getFloatTemperature_1_) {
        if (p_getFloatTemperature_1_.getY() > 64) {
            float f = (float)(TEMPERATURE_NOISE.getValue((float)p_getFloatTemperature_1_.getX() / 8.0f, (float)p_getFloatTemperature_1_.getZ() / 8.0f) * 4.0);
            return this.getTemperature() - (f + (float)p_getFloatTemperature_1_.getY() - 64.0f) * 0.05f / 30.0f;
        }
        return this.getTemperature();
    }

    public void decorate(World p_decorate_1_, Random p_decorate_2_, BlockPos p_decorate_3_) {
        this.theBiomeDecorator.decorate(p_decorate_1_, p_decorate_2_, this, p_decorate_3_);
    }

    public void genTerrainBlocks(World p_genTerrainBlocks_1_, Random p_genTerrainBlocks_2_, ChunkPrimer p_genTerrainBlocks_3_, int p_genTerrainBlocks_4_, int p_genTerrainBlocks_5_, double p_genTerrainBlocks_6_) {
        this.generateBiomeTerrain(p_genTerrainBlocks_1_, p_genTerrainBlocks_2_, p_genTerrainBlocks_3_, p_genTerrainBlocks_4_, p_genTerrainBlocks_5_, p_genTerrainBlocks_6_);
    }

    @SideOnly(value=Side.CLIENT)
    public int getGrassColorAtPos(BlockPos p_getGrassColorAtPos_1_) {
        double d0 = MathHelper.clamp(this.getFloatTemperature(p_getGrassColorAtPos_1_), 0.0f, 1.0f);
        double d1 = MathHelper.clamp(this.getRainfall(), 0.0f, 1.0f);
        return this.getModdedBiomeGrassColor(ColorizerGrass.getGrassColor(d0, d1));
    }

    public final void generateBiomeTerrain(World p_generateBiomeTerrain_1_, Random p_generateBiomeTerrain_2_, ChunkPrimer p_generateBiomeTerrain_3_, int p_generateBiomeTerrain_4_, int p_generateBiomeTerrain_5_, double p_generateBiomeTerrain_6_) {
        int i = p_generateBiomeTerrain_1_.getSeaLevel();
        IBlockState iblockstate = this.topBlock;
        IBlockState iblockstate1 = this.fillerBlock;
        int j = -1;
        int k = (int)(p_generateBiomeTerrain_6_ / 3.0 + 3.0 + p_generateBiomeTerrain_2_.nextDouble() * 0.25);
        int l = p_generateBiomeTerrain_4_ & 0xF;
        int i1 = p_generateBiomeTerrain_5_ & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 <= p_generateBiomeTerrain_2_.nextInt(5)) {
                p_generateBiomeTerrain_3_.setBlockState(i1, j1, l, BEDROCK);
                continue;
            }
            IBlockState iblockstate2 = p_generateBiomeTerrain_3_.getBlockState(i1, j1, l);
            if (iblockstate2.getMaterial() == Material.AIR) {
                j = -1;
                continue;
            }
            if (iblockstate2.getBlock() != Blocks.STONE) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = AIR;
                    iblockstate1 = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = this.topBlock;
                    iblockstate1 = this.fillerBlock;
                }
                if (j1 < i && (iblockstate == null || iblockstate.getMaterial() == Material.AIR)) {
                    iblockstate = this.getFloatTemperature(blockpos$mutableblockpos.setPos(p_generateBiomeTerrain_4_, j1, p_generateBiomeTerrain_5_)) < 0.15f ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    p_generateBiomeTerrain_3_.setBlockState(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = AIR;
                    iblockstate1 = STONE;
                    p_generateBiomeTerrain_3_.setBlockState(i1, j1, l, GRAVEL);
                    continue;
                }
                p_generateBiomeTerrain_3_.setBlockState(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            p_generateBiomeTerrain_3_.setBlockState(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.getBlock() != Blocks.SAND || k <= 1) continue;
            j = p_generateBiomeTerrain_2_.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.getValue(BlockSand.VARIANT) == BlockSand.EnumType.RED_SAND ? RED_SANDSTONE : SANDSTONE;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFoliageColorAtPos(BlockPos p_getFoliageColorAtPos_1_) {
        double d0 = MathHelper.clamp(this.getFloatTemperature(p_getFoliageColorAtPos_1_), 0.0f, 1.0f);
        double d1 = MathHelper.clamp(this.getRainfall(), 0.0f, 1.0f);
        return this.getModdedBiomeFoliageColor(ColorizerFoliage.getFoliageColor(d0, d1));
    }

    public Class<? extends Biome> getBiomeClass() {
        return this.getClass();
    }

    public TempCategory getTempCategory() {
        return (double)this.getTemperature() < 0.2 ? TempCategory.COLD : ((double)this.getTemperature() < 1.0 ? TempCategory.MEDIUM : TempCategory.WARM);
    }

    @Nullable
    public static Biome getBiome(int p_getBiome_0_) {
        return Biome.getBiome(p_getBiome_0_, null);
    }

    public static Biome getBiome(int p_getBiome_0_, Biome p_getBiome_1_) {
        Biome biome = Biome.getBiomeForId(p_getBiome_0_);
        return biome == null ? p_getBiome_1_ : biome;
    }

    public boolean ignorePlayerSpawnSuitability() {
        return false;
    }

    public final float getBaseHeight() {
        return this.baseHeight;
    }

    public final float getRainfall() {
        return this.rainfall;
    }

    public final String getBiomeName() {
        return this.biomeName;
    }

    public final float getHeightVariation() {
        return this.heightVariation;
    }

    public final float getTemperature() {
        return this.temperature;
    }

    @SideOnly(value=Side.CLIENT)
    public final int getWaterColor() {
        return this.waterColor;
    }

    public final boolean isSnowyBiome() {
        return this.enableSnow;
    }

    public BiomeDecorator getModdedBiomeDecorator(BiomeDecorator p_getModdedBiomeDecorator_1_) {
        return new DeferredBiomeDecorator(p_getModdedBiomeDecorator_1_);
    }

    public int getWaterColorMultiplier() {
        BiomeEvent.GetWaterColor event = new BiomeEvent.GetWaterColor(this, this.waterColor);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getNewColor();
    }

    public int getModdedBiomeGrassColor(int p_getModdedBiomeGrassColor_1_) {
        BiomeEvent.GetGrassColor event = new BiomeEvent.GetGrassColor(this, p_getModdedBiomeGrassColor_1_);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getNewColor();
    }

    public int getModdedBiomeFoliageColor(int p_getModdedBiomeFoliageColor_1_) {
        BiomeEvent.GetFoliageColor event = new BiomeEvent.GetFoliageColor(this, p_getModdedBiomeFoliageColor_1_);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getNewColor();
    }

    public void addDefaultFlowers() {
        this.addFlower(Blocks.YELLOW_FLOWER.getDefaultState().withProperty(Blocks.YELLOW_FLOWER.getTypeProperty(), BlockFlower.EnumFlowerType.DANDELION), 20);
        this.addFlower(Blocks.RED_FLOWER.getDefaultState().withProperty(Blocks.RED_FLOWER.getTypeProperty(), BlockFlower.EnumFlowerType.POPPY), 20);
    }

    public void addFlower(IBlockState p_addFlower_1_, int p_addFlower_2_) {
        this.flowers.add(new FlowerEntry(p_addFlower_1_, p_addFlower_2_));
    }

    public void plantFlower(World p_plantFlower_1_, Random p_plantFlower_2_, BlockPos p_plantFlower_3_) {
        FlowerEntry flower = WeightedRandom.getRandomItem(p_plantFlower_2_, this.flowers);
        if (flower == null || flower.state == null || flower.state.getBlock() instanceof BlockBush && !((BlockBush)flower.state.getBlock()).canBlockStay(p_plantFlower_1_, p_plantFlower_3_, flower.state)) {
            return;
        }
        p_plantFlower_1_.setBlockState(p_plantFlower_3_, flower.state, 3);
    }

    public static void registerBiomes() {
        Biome.registerBiome(0, "ocean", new BiomeOcean(new BiomeProperties("Ocean").setBaseHeight(-1.0f).setHeightVariation(0.1f)));
        Biome.registerBiome(1, "plains", new BiomePlains(false, new BiomeProperties("Plains").setBaseHeight(0.125f).setHeightVariation(0.05f).setTemperature(0.8f).setRainfall(0.4f)));
        Biome.registerBiome(2, "desert", new BiomeDesert(new BiomeProperties("Desert").setBaseHeight(0.125f).setHeightVariation(0.05f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(3, "extreme_hills", new BiomeHills(BiomeHills.Type.NORMAL, new BiomeProperties("Extreme Hills").setBaseHeight(1.0f).setHeightVariation(0.5f).setTemperature(0.2f).setRainfall(0.3f)));
        Biome.registerBiome(4, "forest", new BiomeForest(BiomeForest.Type.NORMAL, new BiomeProperties("Forest").setTemperature(0.7f).setRainfall(0.8f)));
        Biome.registerBiome(5, "taiga", new BiomeTaiga(BiomeTaiga.Type.NORMAL, new BiomeProperties("Taiga").setBaseHeight(0.2f).setHeightVariation(0.2f).setTemperature(0.25f).setRainfall(0.8f)));
        Biome.registerBiome(6, "swampland", new BiomeSwamp(new BiomeProperties("Swampland").setBaseHeight(-0.2f).setHeightVariation(0.1f).setTemperature(0.8f).setRainfall(0.9f).setWaterColor(14745518)));
        Biome.registerBiome(7, "river", new BiomeRiver(new BiomeProperties("River").setBaseHeight(-0.5f).setHeightVariation(0.0f)));
        Biome.registerBiome(8, "hell", new BiomeHell(new BiomeProperties("Hell").setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(9, "sky", new BiomeEnd(new BiomeProperties("The End").setRainDisabled()));
        Biome.registerBiome(10, "frozen_ocean", new BiomeOcean(new BiomeProperties("FrozenOcean").setBaseHeight(-1.0f).setHeightVariation(0.1f).setTemperature(0.0f).setRainfall(0.5f).setSnowEnabled()));
        Biome.registerBiome(11, "frozen_river", new BiomeRiver(new BiomeProperties("FrozenRiver").setBaseHeight(-0.5f).setHeightVariation(0.0f).setTemperature(0.0f).setRainfall(0.5f).setSnowEnabled()));
        Biome.registerBiome(12, "ice_flats", new BiomeSnow(false, new BiomeProperties("Ice Plains").setBaseHeight(0.125f).setHeightVariation(0.05f).setTemperature(0.0f).setRainfall(0.5f).setSnowEnabled()));
        Biome.registerBiome(13, "ice_mountains", new BiomeSnow(false, new BiomeProperties("Ice Mountains").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(0.0f).setRainfall(0.5f).setSnowEnabled()));
        Biome.registerBiome(14, "mushroom_island", new BiomeMushroomIsland(new BiomeProperties("MushroomIsland").setBaseHeight(0.2f).setHeightVariation(0.3f).setTemperature(0.9f).setRainfall(1.0f)));
        Biome.registerBiome(15, "mushroom_island_shore", new BiomeMushroomIsland(new BiomeProperties("MushroomIslandShore").setBaseHeight(0.0f).setHeightVariation(0.025f).setTemperature(0.9f).setRainfall(1.0f)));
        Biome.registerBiome(16, "beaches", new BiomeBeach(new BiomeProperties("Beach").setBaseHeight(0.0f).setHeightVariation(0.025f).setTemperature(0.8f).setRainfall(0.4f)));
        Biome.registerBiome(17, "desert_hills", new BiomeDesert(new BiomeProperties("DesertHills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(18, "forest_hills", new BiomeForest(BiomeForest.Type.NORMAL, new BiomeProperties("ForestHills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(0.7f).setRainfall(0.8f)));
        Biome.registerBiome(19, "taiga_hills", new BiomeTaiga(BiomeTaiga.Type.NORMAL, new BiomeProperties("TaigaHills").setTemperature(0.25f).setRainfall(0.8f).setBaseHeight(0.45f).setHeightVariation(0.3f)));
        Biome.registerBiome(20, "smaller_extreme_hills", new BiomeHills(BiomeHills.Type.EXTRA_TREES, new BiomeProperties("Extreme Hills Edge").setBaseHeight(0.8f).setHeightVariation(0.3f).setTemperature(0.2f).setRainfall(0.3f)));
        Biome.registerBiome(21, "jungle", new BiomeJungle(false, new BiomeProperties("Jungle").setTemperature(0.95f).setRainfall(0.9f)));
        Biome.registerBiome(22, "jungle_hills", new BiomeJungle(false, new BiomeProperties("JungleHills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(0.95f).setRainfall(0.9f)));
        Biome.registerBiome(23, "jungle_edge", new BiomeJungle(true, new BiomeProperties("JungleEdge").setTemperature(0.95f).setRainfall(0.8f)));
        Biome.registerBiome(24, "deep_ocean", new BiomeOcean(new BiomeProperties("Deep Ocean").setBaseHeight(-1.8f).setHeightVariation(0.1f)));
        Biome.registerBiome(25, "stone_beach", new BiomeStoneBeach(new BiomeProperties("Stone Beach").setBaseHeight(0.1f).setHeightVariation(0.8f).setTemperature(0.2f).setRainfall(0.3f)));
        Biome.registerBiome(26, "cold_beach", new BiomeBeach(new BiomeProperties("Cold Beach").setBaseHeight(0.0f).setHeightVariation(0.025f).setTemperature(0.05f).setRainfall(0.3f).setSnowEnabled()));
        Biome.registerBiome(27, "birch_forest", new BiomeForest(BiomeForest.Type.BIRCH, new BiomeProperties("Birch Forest").setTemperature(0.6f).setRainfall(0.6f)));
        Biome.registerBiome(28, "birch_forest_hills", new BiomeForest(BiomeForest.Type.BIRCH, new BiomeProperties("Birch Forest Hills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(0.6f).setRainfall(0.6f)));
        Biome.registerBiome(29, "roofed_forest", new BiomeForest(BiomeForest.Type.ROOFED, new BiomeProperties("Roofed Forest").setTemperature(0.7f).setRainfall(0.8f)));
        Biome.registerBiome(30, "taiga_cold", new BiomeTaiga(BiomeTaiga.Type.NORMAL, new BiomeProperties("Cold Taiga").setBaseHeight(0.2f).setHeightVariation(0.2f).setTemperature(-0.5f).setRainfall(0.4f).setSnowEnabled()));
        Biome.registerBiome(31, "taiga_cold_hills", new BiomeTaiga(BiomeTaiga.Type.NORMAL, new BiomeProperties("Cold Taiga Hills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(-0.5f).setRainfall(0.4f).setSnowEnabled()));
        Biome.registerBiome(32, "redwood_taiga", new BiomeTaiga(BiomeTaiga.Type.MEGA, new BiomeProperties("Mega Taiga").setTemperature(0.3f).setRainfall(0.8f).setBaseHeight(0.2f).setHeightVariation(0.2f)));
        Biome.registerBiome(33, "redwood_taiga_hills", new BiomeTaiga(BiomeTaiga.Type.MEGA, new BiomeProperties("Mega Taiga Hills").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(0.3f).setRainfall(0.8f)));
        Biome.registerBiome(34, "extreme_hills_with_trees", new BiomeHills(BiomeHills.Type.EXTRA_TREES, new BiomeProperties("Extreme Hills+").setBaseHeight(1.0f).setHeightVariation(0.5f).setTemperature(0.2f).setRainfall(0.3f)));
        Biome.registerBiome(35, "savanna", new BiomeSavanna(new BiomeProperties("Savanna").setBaseHeight(0.125f).setHeightVariation(0.05f).setTemperature(1.2f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(36, "savanna_rock", new BiomeSavanna(new BiomeProperties("Savanna Plateau").setBaseHeight(1.5f).setHeightVariation(0.025f).setTemperature(1.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(37, "mesa", new BiomeMesa(false, false, new BiomeProperties("Mesa").setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(38, "mesa_rock", new BiomeMesa(false, true, new BiomeProperties("Mesa Plateau F").setBaseHeight(1.5f).setHeightVariation(0.025f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(39, "mesa_clear_rock", new BiomeMesa(false, false, new BiomeProperties("Mesa Plateau").setBaseHeight(1.5f).setHeightVariation(0.025f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(127, "void", new BiomeVoid(new BiomeProperties("The Void").setRainDisabled()));
        Biome.registerBiome(129, "mutated_plains", new BiomePlains(true, new BiomeProperties("Sunflower Plains").setBaseBiome("plains").setBaseHeight(0.125f).setHeightVariation(0.05f).setTemperature(0.8f).setRainfall(0.4f)));
        Biome.registerBiome(130, "mutated_desert", new BiomeDesert(new BiomeProperties("Desert M").setBaseBiome("desert").setBaseHeight(0.225f).setHeightVariation(0.25f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(131, "mutated_extreme_hills", new BiomeHills(BiomeHills.Type.MUTATED, new BiomeProperties("Extreme Hills M").setBaseBiome("extreme_hills").setBaseHeight(1.0f).setHeightVariation(0.5f).setTemperature(0.2f).setRainfall(0.3f)));
        Biome.registerBiome(132, "mutated_forest", new BiomeForest(BiomeForest.Type.FLOWER, new BiomeProperties("Flower Forest").setBaseBiome("forest").setHeightVariation(0.4f).setTemperature(0.7f).setRainfall(0.8f)));
        Biome.registerBiome(133, "mutated_taiga", new BiomeTaiga(BiomeTaiga.Type.NORMAL, new BiomeProperties("Taiga M").setBaseBiome("taiga").setBaseHeight(0.3f).setHeightVariation(0.4f).setTemperature(0.25f).setRainfall(0.8f)));
        Biome.registerBiome(134, "mutated_swampland", new BiomeSwamp(new BiomeProperties("Swampland M").setBaseBiome("swampland").setBaseHeight(-0.1f).setHeightVariation(0.3f).setTemperature(0.8f).setRainfall(0.9f).setWaterColor(14745518)));
        Biome.registerBiome(140, "mutated_ice_flats", new BiomeSnow(true, new BiomeProperties("Ice Plains Spikes").setBaseBiome("ice_flats").setBaseHeight(0.425f).setHeightVariation(0.45000002f).setTemperature(0.0f).setRainfall(0.5f).setSnowEnabled()));
        Biome.registerBiome(149, "mutated_jungle", new BiomeJungle(false, new BiomeProperties("Jungle M").setBaseBiome("jungle").setBaseHeight(0.2f).setHeightVariation(0.4f).setTemperature(0.95f).setRainfall(0.9f)));
        Biome.registerBiome(151, "mutated_jungle_edge", new BiomeJungle(true, new BiomeProperties("JungleEdge M").setBaseBiome("jungle_edge").setBaseHeight(0.2f).setHeightVariation(0.4f).setTemperature(0.95f).setRainfall(0.8f)));
        Biome.registerBiome(155, "mutated_birch_forest", new BiomeForestMutated(new BiomeProperties("Birch Forest M").setBaseBiome("birch_forest").setBaseHeight(0.2f).setHeightVariation(0.4f).setTemperature(0.6f).setRainfall(0.6f)));
        Biome.registerBiome(156, "mutated_birch_forest_hills", new BiomeForestMutated(new BiomeProperties("Birch Forest Hills M").setBaseBiome("birch_forest_hills").setBaseHeight(0.55f).setHeightVariation(0.5f).setTemperature(0.6f).setRainfall(0.6f)));
        Biome.registerBiome(157, "mutated_roofed_forest", new BiomeForest(BiomeForest.Type.ROOFED, new BiomeProperties("Roofed Forest M").setBaseBiome("roofed_forest").setBaseHeight(0.2f).setHeightVariation(0.4f).setTemperature(0.7f).setRainfall(0.8f)));
        Biome.registerBiome(158, "mutated_taiga_cold", new BiomeTaiga(BiomeTaiga.Type.NORMAL, new BiomeProperties("Cold Taiga M").setBaseBiome("taiga_cold").setBaseHeight(0.3f).setHeightVariation(0.4f).setTemperature(-0.5f).setRainfall(0.4f).setSnowEnabled()));
        Biome.registerBiome(160, "mutated_redwood_taiga", new BiomeTaiga(BiomeTaiga.Type.MEGA_SPRUCE, new BiomeProperties("Mega Spruce Taiga").setBaseBiome("redwood_taiga").setBaseHeight(0.2f).setHeightVariation(0.2f).setTemperature(0.25f).setRainfall(0.8f)));
        Biome.registerBiome(161, "mutated_redwood_taiga_hills", new BiomeTaiga(BiomeTaiga.Type.MEGA_SPRUCE, new BiomeProperties("Redwood Taiga Hills M").setBaseBiome("redwood_taiga_hills").setBaseHeight(0.2f).setHeightVariation(0.2f).setTemperature(0.25f).setRainfall(0.8f)));
        Biome.registerBiome(162, "mutated_extreme_hills_with_trees", new BiomeHills(BiomeHills.Type.MUTATED, new BiomeProperties("Extreme Hills+ M").setBaseBiome("extreme_hills_with_trees").setBaseHeight(1.0f).setHeightVariation(0.5f).setTemperature(0.2f).setRainfall(0.3f)));
        Biome.registerBiome(163, "mutated_savanna", new BiomeSavannaMutated(new BiomeProperties("Savanna M").setBaseBiome("savanna").setBaseHeight(0.3625f).setHeightVariation(1.225f).setTemperature(1.1f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(164, "mutated_savanna_rock", new BiomeSavannaMutated(new BiomeProperties("Savanna Plateau M").setBaseBiome("savanna_rock").setBaseHeight(1.05f).setHeightVariation(1.2125001f).setTemperature(1.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(165, "mutated_mesa", new BiomeMesa(true, false, new BiomeProperties("Mesa (Bryce)").setBaseBiome("mesa").setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(166, "mutated_mesa_rock", new BiomeMesa(false, true, new BiomeProperties("Mesa Plateau F M").setBaseBiome("mesa_rock").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Biome.registerBiome(167, "mutated_mesa_clear_rock", new BiomeMesa(false, false, new BiomeProperties("Mesa Plateau M").setBaseBiome("mesa_clear_rock").setBaseHeight(0.45f).setHeightVariation(0.3f).setTemperature(2.0f).setRainfall(0.0f).setRainDisabled()));
        Collections.addAll(EXPLORATION_BIOMES_LIST, Biomes.OCEAN, Biomes.PLAINS, Biomes.DESERT, Biomes.EXTREME_HILLS, Biomes.FOREST, Biomes.TAIGA, Biomes.SWAMPLAND, Biomes.RIVER, Biomes.FROZEN_RIVER, Biomes.ICE_PLAINS, Biomes.ICE_MOUNTAINS, Biomes.MUSHROOM_ISLAND, Biomes.MUSHROOM_ISLAND_SHORE, Biomes.BEACH, Biomes.DESERT_HILLS, Biomes.FOREST_HILLS, Biomes.TAIGA_HILLS, Biomes.JUNGLE, Biomes.JUNGLE_HILLS, Biomes.JUNGLE_EDGE, Biomes.DEEP_OCEAN, Biomes.STONE_BEACH, Biomes.COLD_BEACH, Biomes.BIRCH_FOREST, Biomes.BIRCH_FOREST_HILLS, Biomes.ROOFED_FOREST, Biomes.COLD_TAIGA, Biomes.COLD_TAIGA_HILLS, Biomes.REDWOOD_TAIGA, Biomes.REDWOOD_TAIGA_HILLS, Biomes.EXTREME_HILLS_WITH_TREES, Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.MESA, Biomes.MESA_ROCK, Biomes.MESA_CLEAR_ROCK);
    }

    public static void registerBiome(int p_registerBiome_0_, String p_registerBiome_1_, Biome p_registerBiome_2_) {
        REGISTRY.register(p_registerBiome_0_, new ResourceLocation(p_registerBiome_1_), p_registerBiome_2_);
        if (p_registerBiome_2_.isMutation()) {
            MUTATION_TO_BASE_ID_MAP.put(p_registerBiome_2_, Biome.getIdForBiome(REGISTRY.getObject(new ResourceLocation(p_registerBiome_2_.baseBiomeRegName))));
        }
    }

    public static enum TempCategory {
        OCEAN,
        COLD,
        MEDIUM,
        WARM;

    }

    public static class SpawnListEntry
    extends WeightedRandom.Item {
        public Class<? extends EntityLiving> entityClass;
        public int minGroupCount;
        public int maxGroupCount;
        private final Constructor<?> ctr;

        public SpawnListEntry(Class<? extends EntityLiving> p_i1970_1_, int p_i1970_2_, int p_i1970_3_, int p_i1970_4_) {
            super(p_i1970_2_);
            this.entityClass = p_i1970_1_;
            this.minGroupCount = p_i1970_3_;
            this.maxGroupCount = p_i1970_4_;
            Constructor<? extends EntityLiving> tmp = null;
            try {
                tmp = p_i1970_1_.getConstructor(World.class);
            }
            catch (NoSuchMethodException e) {
                Throwables.propagate((Throwable)e);
            }
            this.ctr = tmp;
        }

        public String toString() {
            return this.entityClass.getSimpleName() + "*(" + this.minGroupCount + "-" + this.maxGroupCount + "):" + this.itemWeight;
        }

        public EntityLiving newInstance(World p_newInstance_1_) throws Exception {
            return (EntityLiving)this.ctr.newInstance(p_newInstance_1_);
        }
    }

    public static class BiomeProperties {
        private final String biomeName;
        private float baseHeight = 0.1f;
        private float heightVariation = 0.2f;
        private float temperature = 0.5f;
        private float rainfall = 0.5f;
        private int waterColor = 0xFFFFFF;
        private boolean enableSnow;
        private boolean enableRain = true;
        @Nullable
        private String baseBiomeRegName;

        public BiomeProperties(String p_i47073_1_) {
            this.biomeName = p_i47073_1_;
        }

        public BiomeProperties setTemperature(float p_setTemperature_1_) {
            if (p_setTemperature_1_ > 0.1f && p_setTemperature_1_ < 0.2f) {
                throw new IllegalArgumentException("Please avoid temperatures in the range 0.1 - 0.2 because of snow");
            }
            this.temperature = p_setTemperature_1_;
            return this;
        }

        public BiomeProperties setRainfall(float p_setRainfall_1_) {
            this.rainfall = p_setRainfall_1_;
            return this;
        }

        public BiomeProperties setBaseHeight(float p_setBaseHeight_1_) {
            this.baseHeight = p_setBaseHeight_1_;
            return this;
        }

        public BiomeProperties setHeightVariation(float p_setHeightVariation_1_) {
            this.heightVariation = p_setHeightVariation_1_;
            return this;
        }

        public BiomeProperties setRainDisabled() {
            this.enableRain = false;
            return this;
        }

        public BiomeProperties setSnowEnabled() {
            this.enableSnow = true;
            return this;
        }

        public BiomeProperties setWaterColor(int p_setWaterColor_1_) {
            this.waterColor = p_setWaterColor_1_;
            return this;
        }

        public BiomeProperties setBaseBiome(String p_setBaseBiome_1_) {
            this.baseBiomeRegName = p_setBaseBiome_1_;
            return this;
        }
    }

    public static class FlowerEntry
    extends WeightedRandom.Item {
        public final IBlockState state;

        public FlowerEntry(IBlockState p_i25_1_, int p_i25_2_) {
            super(p_i25_2_);
            this.state = p_i25_1_;
        }
    }
}

