/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;

public class BiomeCache {
    private final BiomeProvider chunkManager;
    private long lastCleanupTime;
    private final Long2ObjectMap<Block> cacheMap = new Long2ObjectOpenHashMap(4096);
    private final List<Block> cache = Lists.newArrayList();

    public BiomeCache(BiomeProvider p_i1973_1_) {
        this.chunkManager = p_i1973_1_;
    }

    public Block getBiomeCacheBlock(int p_getBiomeCacheBlock_1_, int p_getBiomeCacheBlock_2_) {
        long lvt_3_1_ = (long)(p_getBiomeCacheBlock_1_ >>= 4) & 0xFFFFFFFFL | ((long)(p_getBiomeCacheBlock_2_ >>= 4) & 0xFFFFFFFFL) << 32;
        Block lvt_5_1_ = (Block)this.cacheMap.get(lvt_3_1_);
        if (lvt_5_1_ == null) {
            lvt_5_1_ = new Block(p_getBiomeCacheBlock_1_, p_getBiomeCacheBlock_2_);
            this.cacheMap.put(lvt_3_1_, (Object)lvt_5_1_);
            this.cache.add(lvt_5_1_);
        }
        lvt_5_1_.lastAccessTime = MinecraftServer.getCurrentTimeMillis();
        return lvt_5_1_;
    }

    public Biome getBiome(int p_getBiome_1_, int p_getBiome_2_, Biome p_getBiome_3_) {
        Biome lvt_4_1_ = this.getBiomeCacheBlock(p_getBiome_1_, p_getBiome_2_).getBiome(p_getBiome_1_, p_getBiome_2_);
        return lvt_4_1_ == null ? p_getBiome_3_ : lvt_4_1_;
    }

    public void cleanupCache() {
        long lvt_1_1_ = MinecraftServer.getCurrentTimeMillis();
        long lvt_3_1_ = lvt_1_1_ - this.lastCleanupTime;
        if (lvt_3_1_ > 7500L || lvt_3_1_ < 0L) {
            this.lastCleanupTime = lvt_1_1_;
            for (int lvt_5_1_ = 0; lvt_5_1_ < this.cache.size(); ++lvt_5_1_) {
                Block lvt_6_1_ = this.cache.get(lvt_5_1_);
                long lvt_7_1_ = lvt_1_1_ - lvt_6_1_.lastAccessTime;
                if (lvt_7_1_ <= 30000L && lvt_7_1_ >= 0L) continue;
                this.cache.remove(lvt_5_1_--);
                long lvt_9_1_ = (long)lvt_6_1_.xPosition & 0xFFFFFFFFL | ((long)lvt_6_1_.zPosition & 0xFFFFFFFFL) << 32;
                this.cacheMap.remove(lvt_9_1_);
            }
        }
    }

    public Biome[] getCachedBiomes(int p_getCachedBiomes_1_, int p_getCachedBiomes_2_) {
        return this.getBiomeCacheBlock((int)p_getCachedBiomes_1_, (int)p_getCachedBiomes_2_).biomes;
    }

    public class Block {
        public Biome[] biomes = new Biome[256];
        public int xPosition;
        public int zPosition;
        public long lastAccessTime;

        public Block(int p_i1972_2_, int p_i1972_3_) {
            this.xPosition = p_i1972_2_;
            this.zPosition = p_i1972_3_;
            BiomeCache.this.chunkManager.getBiomes(this.biomes, p_i1972_2_ << 4, p_i1972_3_ << 4, 16, 16, false);
        }

        public Biome getBiome(int p_getBiome_1_, int p_getBiome_2_) {
            return this.biomes[p_getBiome_1_ & 0xF | (p_getBiome_2_ & 0xF) << 4];
        }
    }
}

