/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BiomeColorHelper {
    private static final ColorResolver GRASS_COLOR = new ColorResolver(){

        @Override
        public int getColorAtPos(Biome p_getColorAtPos_1_, BlockPos p_getColorAtPos_2_) {
            return p_getColorAtPos_1_.getGrassColorAtPos(p_getColorAtPos_2_);
        }
    };
    private static final ColorResolver FOLIAGE_COLOR = new ColorResolver(){

        @Override
        public int getColorAtPos(Biome p_getColorAtPos_1_, BlockPos p_getColorAtPos_2_) {
            return p_getColorAtPos_1_.getFoliageColorAtPos(p_getColorAtPos_2_);
        }
    };
    private static final ColorResolver WATER_COLOR = new ColorResolver(){

        @Override
        public int getColorAtPos(Biome p_getColorAtPos_1_, BlockPos p_getColorAtPos_2_) {
            return p_getColorAtPos_1_.getWaterColor();
        }
    };

    private static int getColorAtPos(IBlockAccess p_getColorAtPos_0_, BlockPos p_getColorAtPos_1_, ColorResolver p_getColorAtPos_2_) {
        int lvt_3_1_ = 0;
        int lvt_4_1_ = 0;
        int lvt_5_1_ = 0;
        for (BlockPos.MutableBlockPos lvt_7_1_ : BlockPos.getAllInBoxMutable(p_getColorAtPos_1_.add(-1, 0, -1), p_getColorAtPos_1_.add(1, 0, 1))) {
            int lvt_8_1_ = p_getColorAtPos_2_.getColorAtPos(p_getColorAtPos_0_.getBiome(lvt_7_1_), lvt_7_1_);
            lvt_3_1_ += (lvt_8_1_ & 0xFF0000) >> 16;
            lvt_4_1_ += (lvt_8_1_ & 0xFF00) >> 8;
            lvt_5_1_ += lvt_8_1_ & 0xFF;
        }
        return (lvt_3_1_ / 9 & 0xFF) << 16 | (lvt_4_1_ / 9 & 0xFF) << 8 | lvt_5_1_ / 9 & 0xFF;
    }

    public static int getGrassColorAtPos(IBlockAccess p_getGrassColorAtPos_0_, BlockPos p_getGrassColorAtPos_1_) {
        return BiomeColorHelper.getColorAtPos(p_getGrassColorAtPos_0_, p_getGrassColorAtPos_1_, GRASS_COLOR);
    }

    public static int getFoliageColorAtPos(IBlockAccess p_getFoliageColorAtPos_0_, BlockPos p_getFoliageColorAtPos_1_) {
        return BiomeColorHelper.getColorAtPos(p_getFoliageColorAtPos_0_, p_getFoliageColorAtPos_1_, FOLIAGE_COLOR);
    }

    public static int getWaterColorAtPos(IBlockAccess p_getWaterColorAtPos_0_, BlockPos p_getWaterColorAtPos_1_) {
        return BiomeColorHelper.getColorAtPos(p_getWaterColorAtPos_0_, p_getWaterColorAtPos_1_, WATER_COLOR);
    }

    @SideOnly(value=Side.CLIENT)
    static interface ColorResolver {
        public int getColorAtPos(Biome var1, BlockPos var2);
    }
}

