/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import java.util.Random;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenCactus;
import net.minecraft.world.gen.feature.WorldGenClay;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenSand;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeDecorator {
    public boolean decorating;
    public BlockPos chunkPos;
    public ChunkProviderSettings chunkProviderSettings;
    public WorldGenerator clayGen = new WorldGenClay(4);
    public WorldGenerator sandGen = new WorldGenSand(Blocks.SAND, 7);
    public WorldGenerator gravelAsSandGen = new WorldGenSand(Blocks.GRAVEL, 6);
    public WorldGenerator dirtGen;
    public WorldGenerator gravelGen;
    public WorldGenerator graniteGen;
    public WorldGenerator dioriteGen;
    public WorldGenerator andesiteGen;
    public WorldGenerator coalGen;
    public WorldGenerator ironGen;
    public WorldGenerator goldGen;
    public WorldGenerator redstoneGen;
    public WorldGenerator diamondGen;
    public WorldGenerator lapisGen;
    public WorldGenFlowers yellowFlowerGen = new WorldGenFlowers(Blocks.YELLOW_FLOWER, BlockFlower.EnumFlowerType.DANDELION);
    public WorldGenerator mushroomBrownGen = new WorldGenBush(Blocks.BROWN_MUSHROOM);
    public WorldGenerator mushroomRedGen = new WorldGenBush(Blocks.RED_MUSHROOM);
    public WorldGenerator bigMushroomGen = new WorldGenBigMushroom();
    public WorldGenerator reedGen = new WorldGenReed();
    public WorldGenerator cactusGen = new WorldGenCactus();
    public WorldGenerator waterlilyGen = new WorldGenWaterlily();
    public int waterlilyPerChunk;
    public int treesPerChunk;
    public float extraTreeChance = 0.1f;
    public int flowersPerChunk = 2;
    public int grassPerChunk = 1;
    public int deadBushPerChunk;
    public int mushroomsPerChunk;
    public int reedsPerChunk;
    public int cactiPerChunk;
    public int sandPerChunk = 1;
    public int sandPerChunk2 = 3;
    public int clayPerChunk = 1;
    public int bigMushroomsPerChunk;
    public boolean generateLakes = true;

    public void decorate(World p_decorate_1_, Random p_decorate_2_, Biome p_decorate_3_, BlockPos p_decorate_4_) {
        if (this.decorating) {
            throw new RuntimeException("Already decorating");
        }
        this.chunkProviderSettings = ChunkProviderSettings.Factory.jsonToFactory(p_decorate_1_.getWorldInfo().getGeneratorOptions()).build();
        this.chunkPos = p_decorate_4_;
        this.dirtGen = new WorldGenMinable(Blocks.DIRT.getDefaultState(), this.chunkProviderSettings.dirtSize);
        this.gravelGen = new WorldGenMinable(Blocks.GRAVEL.getDefaultState(), this.chunkProviderSettings.gravelSize);
        this.graniteGen = new WorldGenMinable(Blocks.STONE.getDefaultState().withProperty(BlockStone.VARIANT, BlockStone.EnumType.GRANITE), this.chunkProviderSettings.graniteSize);
        this.dioriteGen = new WorldGenMinable(Blocks.STONE.getDefaultState().withProperty(BlockStone.VARIANT, BlockStone.EnumType.DIORITE), this.chunkProviderSettings.dioriteSize);
        this.andesiteGen = new WorldGenMinable(Blocks.STONE.getDefaultState().withProperty(BlockStone.VARIANT, BlockStone.EnumType.ANDESITE), this.chunkProviderSettings.andesiteSize);
        this.coalGen = new WorldGenMinable(Blocks.COAL_ORE.getDefaultState(), this.chunkProviderSettings.coalSize);
        this.ironGen = new WorldGenMinable(Blocks.IRON_ORE.getDefaultState(), this.chunkProviderSettings.ironSize);
        this.goldGen = new WorldGenMinable(Blocks.GOLD_ORE.getDefaultState(), this.chunkProviderSettings.goldSize);
        this.redstoneGen = new WorldGenMinable(Blocks.REDSTONE_ORE.getDefaultState(), this.chunkProviderSettings.redstoneSize);
        this.diamondGen = new WorldGenMinable(Blocks.DIAMOND_ORE.getDefaultState(), this.chunkProviderSettings.diamondSize);
        this.lapisGen = new WorldGenMinable(Blocks.LAPIS_ORE.getDefaultState(), this.chunkProviderSettings.lapisSize);
        this.genDecorations(p_decorate_3_, p_decorate_1_, p_decorate_2_);
        this.decorating = false;
    }

    protected void genDecorations(Biome p_genDecorations_1_, World p_genDecorations_2_, Random p_genDecorations_3_) {
        int k9;
        int i5;
        int j13;
        MinecraftForge.EVENT_BUS.post(new DecorateBiomeEvent.Pre(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos));
        this.generateOres(p_genDecorations_2_, p_genDecorations_3_);
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.SAND)) {
            for (int i = 0; i < this.sandPerChunk2; ++i) {
                int j = p_genDecorations_3_.nextInt(16) + 8;
                int k = p_genDecorations_3_.nextInt(16) + 8;
                this.sandGen.generate(p_genDecorations_2_, p_genDecorations_3_, p_genDecorations_2_.getTopSolidOrLiquidBlock(this.chunkPos.add(j, 0, k)));
            }
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.CLAY)) {
            for (int i1 = 0; i1 < this.clayPerChunk; ++i1) {
                int l1 = p_genDecorations_3_.nextInt(16) + 8;
                int i6 = p_genDecorations_3_.nextInt(16) + 8;
                this.clayGen.generate(p_genDecorations_2_, p_genDecorations_3_, p_genDecorations_2_.getTopSolidOrLiquidBlock(this.chunkPos.add(l1, 0, i6)));
            }
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.SAND_PASS2)) {
            for (int j1 = 0; j1 < this.sandPerChunk; ++j1) {
                int i2 = p_genDecorations_3_.nextInt(16) + 8;
                int j6 = p_genDecorations_3_.nextInt(16) + 8;
                this.gravelAsSandGen.generate(p_genDecorations_2_, p_genDecorations_3_, p_genDecorations_2_.getTopSolidOrLiquidBlock(this.chunkPos.add(i2, 0, j6)));
            }
        }
        int k1 = this.treesPerChunk;
        if (p_genDecorations_3_.nextFloat() < this.extraTreeChance) {
            ++k1;
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.TREE)) {
            for (int j2 = 0; j2 < k1; ++j2) {
                int k6 = p_genDecorations_3_.nextInt(16) + 8;
                int l = p_genDecorations_3_.nextInt(16) + 8;
                WorldGenAbstractTree worldgenabstracttree = p_genDecorations_1_.genBigTreeChance(p_genDecorations_3_);
                worldgenabstracttree.setDecorationDefaults();
                BlockPos blockpos = p_genDecorations_2_.getHeight(this.chunkPos.add(k6, 0, l));
                if (!worldgenabstracttree.generate(p_genDecorations_2_, p_genDecorations_3_, blockpos)) continue;
                worldgenabstracttree.generateSaplings(p_genDecorations_2_, p_genDecorations_3_, blockpos);
            }
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM)) {
            for (int k2 = 0; k2 < this.bigMushroomsPerChunk; ++k2) {
                int l6 = p_genDecorations_3_.nextInt(16) + 8;
                int k10 = p_genDecorations_3_.nextInt(16) + 8;
                this.bigMushroomGen.generate(p_genDecorations_2_, p_genDecorations_3_, p_genDecorations_2_.getHeight(this.chunkPos.add(l6, 0, k10)));
            }
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            for (int l2 = 0; l2 < this.flowersPerChunk; ++l2) {
                int k17;
                BlockPos blockpos1;
                BlockFlower.EnumFlowerType blockflower$enumflowertype;
                BlockFlower blockflower;
                int l10;
                int i7 = p_genDecorations_3_.nextInt(16) + 8;
                int j14 = p_genDecorations_2_.getHeight(this.chunkPos.add(i7, 0, l10 = p_genDecorations_3_.nextInt(16) + 8)).getY() + 32;
                if (j14 <= 0 || (blockflower = (blockflower$enumflowertype = p_genDecorations_1_.pickRandomFlower(p_genDecorations_3_, blockpos1 = this.chunkPos.add(i7, k17 = p_genDecorations_3_.nextInt(j14), l10))).getBlockType().getBlock()).getDefaultState().getMaterial() == Material.AIR) continue;
                this.yellowFlowerGen.setGeneratedBlock(blockflower, blockflower$enumflowertype);
                this.yellowFlowerGen.generate(p_genDecorations_2_, p_genDecorations_3_, blockpos1);
            }
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            for (int i3 = 0; i3 < this.grassPerChunk; ++i3) {
                int i11;
                int j7 = p_genDecorations_3_.nextInt(16) + 8;
                int k14 = p_genDecorations_2_.getHeight(this.chunkPos.add(j7, 0, i11 = p_genDecorations_3_.nextInt(16) + 8)).getY() * 2;
                if (k14 <= 0) continue;
                int l17 = p_genDecorations_3_.nextInt(k14);
                p_genDecorations_1_.getRandomWorldGenForGrass(p_genDecorations_3_).generate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos.add(j7, l17, i11));
            }
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH)) {
            for (int j3 = 0; j3 < this.deadBushPerChunk; ++j3) {
                int j11;
                int k7 = p_genDecorations_3_.nextInt(16) + 8;
                int l14 = p_genDecorations_2_.getHeight(this.chunkPos.add(k7, 0, j11 = p_genDecorations_3_.nextInt(16) + 8)).getY() * 2;
                if (l14 <= 0) continue;
                int i18 = p_genDecorations_3_.nextInt(l14);
                new WorldGenDeadBush().generate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos.add(k7, i18, j11));
            }
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.LILYPAD)) {
            for (int k3 = 0; k3 < this.waterlilyPerChunk; ++k3) {
                BlockPos blockpos7;
                int k11;
                int l7 = p_genDecorations_3_.nextInt(16) + 8;
                int i15 = p_genDecorations_2_.getHeight(this.chunkPos.add(l7, 0, k11 = p_genDecorations_3_.nextInt(16) + 8)).getY() * 2;
                if (i15 <= 0) continue;
                int j18 = p_genDecorations_3_.nextInt(i15);
                BlockPos blockpos4 = this.chunkPos.add(l7, j18, k11);
                while (blockpos4.getY() > 0 && p_genDecorations_2_.isAirBlock(blockpos7 = blockpos4.down())) {
                    blockpos4 = blockpos7;
                }
                this.waterlilyGen.generate(p_genDecorations_2_, p_genDecorations_3_, blockpos4);
            }
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            int l8;
            int j4;
            int k12;
            int k8;
            int i4;
            int j12;
            for (int l3 = 0; l3 < this.mushroomsPerChunk; ++l3) {
                int i12;
                int j8;
                int j15;
                if (p_genDecorations_3_.nextInt(4) == 0) {
                    int i8 = p_genDecorations_3_.nextInt(16) + 8;
                    int l11 = p_genDecorations_3_.nextInt(16) + 8;
                    BlockPos blockpos2 = p_genDecorations_2_.getHeight(this.chunkPos.add(i8, 0, l11));
                    this.mushroomBrownGen.generate(p_genDecorations_2_, p_genDecorations_3_, blockpos2);
                }
                if (p_genDecorations_3_.nextInt(8) != 0 || (j15 = p_genDecorations_2_.getHeight(this.chunkPos.add(j8 = p_genDecorations_3_.nextInt(16) + 8, 0, i12 = p_genDecorations_3_.nextInt(16) + 8)).getY() * 2) <= 0) continue;
                int k18 = p_genDecorations_3_.nextInt(j15);
                BlockPos blockpos5 = this.chunkPos.add(j8, k18, i12);
                this.mushroomRedGen.generate(p_genDecorations_2_, p_genDecorations_3_, blockpos5);
            }
            if (p_genDecorations_3_.nextInt(4) == 0 && (j12 = p_genDecorations_2_.getHeight(this.chunkPos.add(i4 = p_genDecorations_3_.nextInt(16) + 8, 0, k8 = p_genDecorations_3_.nextInt(16) + 8)).getY() * 2) > 0) {
                int k15 = p_genDecorations_3_.nextInt(j12);
                this.mushroomBrownGen.generate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos.add(i4, k15, k8));
            }
            if (p_genDecorations_3_.nextInt(8) == 0 && (k12 = p_genDecorations_2_.getHeight(this.chunkPos.add(j4 = p_genDecorations_3_.nextInt(16) + 8, 0, l8 = p_genDecorations_3_.nextInt(16) + 8)).getY() * 2) > 0) {
                int l15 = p_genDecorations_3_.nextInt(k12);
                this.mushroomRedGen.generate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos.add(j4, l15, l8));
            }
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.REED)) {
            for (int k4 = 0; k4 < this.reedsPerChunk; ++k4) {
                int l12;
                int i9 = p_genDecorations_3_.nextInt(16) + 8;
                int i16 = p_genDecorations_2_.getHeight(this.chunkPos.add(i9, 0, l12 = p_genDecorations_3_.nextInt(16) + 8)).getY() * 2;
                if (i16 <= 0) continue;
                int l18 = p_genDecorations_3_.nextInt(i16);
                this.reedGen.generate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos.add(i9, l18, l12));
            }
            for (int l4 = 0; l4 < 10; ++l4) {
                int i13;
                int j9 = p_genDecorations_3_.nextInt(16) + 8;
                int j16 = p_genDecorations_2_.getHeight(this.chunkPos.add(j9, 0, i13 = p_genDecorations_3_.nextInt(16) + 8)).getY() * 2;
                if (j16 <= 0) continue;
                int i19 = p_genDecorations_3_.nextInt(j16);
                this.reedGen.generate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos.add(j9, i19, i13));
            }
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.PUMPKIN) && p_genDecorations_3_.nextInt(32) == 0 && (j13 = p_genDecorations_2_.getHeight(this.chunkPos.add(i5 = p_genDecorations_3_.nextInt(16) + 8, 0, k9 = p_genDecorations_3_.nextInt(16) + 8)).getY() * 2) > 0) {
            int k16 = p_genDecorations_3_.nextInt(j13);
            new WorldGenPumpkin().generate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos.add(i5, k16, k9));
        }
        if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            for (int j5 = 0; j5 < this.cactiPerChunk; ++j5) {
                int k13;
                int l9 = p_genDecorations_3_.nextInt(16) + 8;
                int l16 = p_genDecorations_2_.getHeight(this.chunkPos.add(l9, 0, k13 = p_genDecorations_3_.nextInt(16) + 8)).getY() * 2;
                if (l16 <= 0) continue;
                int j19 = p_genDecorations_3_.nextInt(l16);
                this.cactusGen.generate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos.add(l9, j19, k13));
            }
        }
        if (this.generateLakes) {
            if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
                for (int k5 = 0; k5 < 50; ++k5) {
                    int i10 = p_genDecorations_3_.nextInt(16) + 8;
                    int l13 = p_genDecorations_3_.nextInt(16) + 8;
                    int i17 = p_genDecorations_3_.nextInt(248) + 8;
                    if (i17 <= 0) continue;
                    int k19 = p_genDecorations_3_.nextInt(i17);
                    BlockPos blockpos6 = this.chunkPos.add(i10, k19, l13);
                    new WorldGenLiquids(Blocks.FLOWING_WATER).generate(p_genDecorations_2_, p_genDecorations_3_, blockpos6);
                }
            }
            if (TerrainGen.decorate(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos, DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA)) {
                for (int l5 = 0; l5 < 20; ++l5) {
                    int j10 = p_genDecorations_3_.nextInt(16) + 8;
                    int i14 = p_genDecorations_3_.nextInt(16) + 8;
                    int j17 = p_genDecorations_3_.nextInt(p_genDecorations_3_.nextInt(p_genDecorations_3_.nextInt(240) + 8) + 8);
                    BlockPos blockpos3 = this.chunkPos.add(j10, j17, i14);
                    new WorldGenLiquids(Blocks.FLOWING_LAVA).generate(p_genDecorations_2_, p_genDecorations_3_, blockpos3);
                }
            }
        }
        MinecraftForge.EVENT_BUS.post(new DecorateBiomeEvent.Post(p_genDecorations_2_, p_genDecorations_3_, this.chunkPos));
    }

    protected void generateOres(World p_generateOres_1_, Random p_generateOres_2_) {
        MinecraftForge.ORE_GEN_BUS.post(new OreGenEvent.Pre(p_generateOres_1_, p_generateOres_2_, this.chunkPos));
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.dirtGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.DIRT)) {
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.dirtCount, this.dirtGen, this.chunkProviderSettings.dirtMinHeight, this.chunkProviderSettings.dirtMaxHeight);
        }
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.gravelGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.GRAVEL)) {
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.gravelCount, this.gravelGen, this.chunkProviderSettings.gravelMinHeight, this.chunkProviderSettings.gravelMaxHeight);
        }
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.dioriteGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.DIORITE)) {
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.dioriteCount, this.dioriteGen, this.chunkProviderSettings.dioriteMinHeight, this.chunkProviderSettings.dioriteMaxHeight);
        }
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.graniteGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.GRANITE)) {
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.graniteCount, this.graniteGen, this.chunkProviderSettings.graniteMinHeight, this.chunkProviderSettings.graniteMaxHeight);
        }
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.andesiteGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.ANDESITE)) {
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.andesiteCount, this.andesiteGen, this.chunkProviderSettings.andesiteMinHeight, this.chunkProviderSettings.andesiteMaxHeight);
        }
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.coalGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.COAL)) {
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.coalCount, this.coalGen, this.chunkProviderSettings.coalMinHeight, this.chunkProviderSettings.coalMaxHeight);
        }
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.ironGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.IRON)) {
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.ironCount, this.ironGen, this.chunkProviderSettings.ironMinHeight, this.chunkProviderSettings.ironMaxHeight);
        }
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.goldGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.GOLD)) {
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.goldCount, this.goldGen, this.chunkProviderSettings.goldMinHeight, this.chunkProviderSettings.goldMaxHeight);
        }
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.redstoneGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.REDSTONE)) {
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.redstoneCount, this.redstoneGen, this.chunkProviderSettings.redstoneMinHeight, this.chunkProviderSettings.redstoneMaxHeight);
        }
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.diamondGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.diamondCount, this.diamondGen, this.chunkProviderSettings.diamondMinHeight, this.chunkProviderSettings.diamondMaxHeight);
        }
        if (TerrainGen.generateOre(p_generateOres_1_, p_generateOres_2_, this.lapisGen, this.chunkPos, OreGenEvent.GenerateMinable.EventType.LAPIS)) {
            this.genStandardOre2(p_generateOres_1_, p_generateOres_2_, this.chunkProviderSettings.lapisCount, this.lapisGen, this.chunkProviderSettings.lapisCenterHeight, this.chunkProviderSettings.lapisSpread);
        }
        MinecraftForge.ORE_GEN_BUS.post(new OreGenEvent.Post(p_generateOres_1_, p_generateOres_2_, this.chunkPos));
    }

    protected void genStandardOre1(World p_genStandardOre1_1_, Random p_genStandardOre1_2_, int p_genStandardOre1_3_, WorldGenerator p_genStandardOre1_4_, int p_genStandardOre1_5_, int p_genStandardOre1_6_) {
        if (p_genStandardOre1_6_ < p_genStandardOre1_5_) {
            int i = p_genStandardOre1_5_;
            p_genStandardOre1_5_ = p_genStandardOre1_6_;
            p_genStandardOre1_6_ = i;
        } else if (p_genStandardOre1_6_ == p_genStandardOre1_5_) {
            if (p_genStandardOre1_5_ < 255) {
                ++p_genStandardOre1_6_;
            } else {
                --p_genStandardOre1_5_;
            }
        }
        for (int j = 0; j < p_genStandardOre1_3_; ++j) {
            BlockPos blockpos = this.chunkPos.add(p_genStandardOre1_2_.nextInt(16), p_genStandardOre1_2_.nextInt(p_genStandardOre1_6_ - p_genStandardOre1_5_) + p_genStandardOre1_5_, p_genStandardOre1_2_.nextInt(16));
            p_genStandardOre1_4_.generate(p_genStandardOre1_1_, p_genStandardOre1_2_, blockpos);
        }
    }

    protected void genStandardOre2(World p_genStandardOre2_1_, Random p_genStandardOre2_2_, int p_genStandardOre2_3_, WorldGenerator p_genStandardOre2_4_, int p_genStandardOre2_5_, int p_genStandardOre2_6_) {
        for (int i = 0; i < p_genStandardOre2_3_; ++i) {
            BlockPos blockpos = this.chunkPos.add(p_genStandardOre2_2_.nextInt(16), p_genStandardOre2_2_.nextInt(p_genStandardOre2_6_) + p_genStandardOre2_2_.nextInt(p_genStandardOre2_6_) + p_genStandardOre2_5_ - p_genStandardOre2_6_, p_genStandardOre2_2_.nextInt(16));
            p_genStandardOre2_4_.generate(p_genStandardOre2_1_, p_genStandardOre2_2_, blockpos);
        }
    }
}

