/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenDesertWells;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeDesert
extends Biome {
    public BiomeDesert(Biome.BiomeProperties p_i46711_1_) {
        super(p_i46711_1_);
        this.spawnableCreatureList.clear();
        this.topBlock = Blocks.SAND.getDefaultState();
        this.fillerBlock = Blocks.SAND.getDefaultState();
        this.theBiomeDecorator.treesPerChunk = -999;
        this.theBiomeDecorator.deadBushPerChunk = 2;
        this.theBiomeDecorator.reedsPerChunk = 50;
        this.theBiomeDecorator.cactiPerChunk = 10;
        this.spawnableCreatureList.clear();
        this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        Iterator iterator = this.spawnableMonsterList.iterator();
        while (iterator.hasNext()) {
            Biome.SpawnListEntry biome$spawnlistentry = (Biome.SpawnListEntry)iterator.next();
            if (biome$spawnlistentry.entityClass != EntityZombie.class && biome$spawnlistentry.entityClass != EntityZombieVillager.class) continue;
            iterator.remove();
        }
        this.spawnableMonsterList.add(new Biome.SpawnListEntry(EntityZombie.class, 19, 4, 4));
        this.spawnableMonsterList.add(new Biome.SpawnListEntry(EntityZombieVillager.class, 1, 1, 1));
        this.spawnableMonsterList.add(new Biome.SpawnListEntry(EntityHusk.class, 80, 4, 4));
    }

    @Override
    public void decorate(World p_decorate_1_, Random p_decorate_2_, BlockPos p_decorate_3_) {
        super.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
        if (TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.DESERT_WELL) && p_decorate_2_.nextInt(1000) == 0) {
            int i = p_decorate_2_.nextInt(16) + 8;
            int j = p_decorate_2_.nextInt(16) + 8;
            BlockPos blockpos = p_decorate_1_.getHeight(p_decorate_3_.add(i, 0, j)).up();
            new WorldGenDesertWells().generate(p_decorate_1_, p_decorate_2_, blockpos);
        }
        if (TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.FOSSIL) && p_decorate_2_.nextInt(64) == 0) {
            new WorldGenFossils().generate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
        }
    }
}

