/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenSpikes;

public class BiomeEndDecorator
extends BiomeDecorator {
    private static final LoadingCache<Long, WorldGenSpikes.EndSpike[]> SPIKE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new SpikeCacheLoader());
    private final WorldGenSpikes spikeGen = new WorldGenSpikes();

    @Override
    protected void genDecorations(Biome p_genDecorations_1_, World p_genDecorations_2_, Random p_genDecorations_3_) {
        WorldGenSpikes.EndSpike[] lvt_4_1_;
        this.generateOres(p_genDecorations_2_, p_genDecorations_3_);
        for (WorldGenSpikes.EndSpike lvt_8_1_ : lvt_4_1_ = BiomeEndDecorator.getSpikesForWorld(p_genDecorations_2_)) {
            if (!lvt_8_1_.doesStartInChunk(this.chunkPos)) continue;
            this.spikeGen.setSpike(lvt_8_1_);
            this.spikeGen.generate(p_genDecorations_2_, p_genDecorations_3_, new BlockPos(lvt_8_1_.getCenterX(), 45, lvt_8_1_.getCenterZ()));
        }
    }

    public static WorldGenSpikes.EndSpike[] getSpikesForWorld(World p_getSpikesForWorld_0_) {
        Random lvt_1_1_ = new Random(p_getSpikesForWorld_0_.getSeed());
        long lvt_2_1_ = lvt_1_1_.nextLong() & 0xFFFFL;
        return (WorldGenSpikes.EndSpike[])SPIKE_CACHE.getUnchecked((Object)lvt_2_1_);
    }

    static class SpikeCacheLoader
    extends CacheLoader<Long, WorldGenSpikes.EndSpike[]> {
        private SpikeCacheLoader() {
        }

        public WorldGenSpikes.EndSpike[] load(Long p_load_1_) throws Exception {
            ArrayList lvt_2_1_ = Lists.newArrayList((Iterable)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(10)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(lvt_2_1_, new Random(p_load_1_));
            WorldGenSpikes.EndSpike[] lvt_3_1_ = new WorldGenSpikes.EndSpike[10];
            for (int lvt_4_1_ = 0; lvt_4_1_ < 10; ++lvt_4_1_) {
                int lvt_5_1_ = (int)(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)lvt_4_1_)));
                int lvt_6_1_ = (int)(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)lvt_4_1_)));
                int lvt_7_1_ = (Integer)lvt_2_1_.get(lvt_4_1_);
                int lvt_8_1_ = 2 + lvt_7_1_ / 3;
                int lvt_9_1_ = 76 + lvt_7_1_ * 3;
                boolean lvt_10_1_ = lvt_7_1_ == 1 || lvt_7_1_ == 2;
                lvt_3_1_[lvt_4_1_] = new WorldGenSpikes.EndSpike(lvt_5_1_, lvt_6_1_, lvt_8_1_, lvt_9_1_, lvt_10_1_);
            }
            return lvt_3_1_;
        }

        public /* synthetic */ Object load(Object p_load_1_) throws Exception {
            return this.load((Long)p_load_1_);
        }
    }
}

