/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeForest
extends Biome {
    protected static final WorldGenBirchTree SUPER_BIRCH_TREE = new WorldGenBirchTree(false, true);
    protected static final WorldGenBirchTree BIRCH_TREE = new WorldGenBirchTree(false, false);
    protected static final WorldGenCanopyTree ROOF_TREE = new WorldGenCanopyTree(false);
    private final Type type;

    public BiomeForest(Type p_i46708_1_, Biome.BiomeProperties p_i46708_2_) {
        super(p_i46708_2_);
        this.type = p_i46708_1_;
        this.theBiomeDecorator.treesPerChunk = 10;
        this.theBiomeDecorator.grassPerChunk = 2;
        if (this.type == Type.FLOWER) {
            this.theBiomeDecorator.treesPerChunk = 6;
            this.theBiomeDecorator.flowersPerChunk = 100;
            this.theBiomeDecorator.grassPerChunk = 1;
            this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        }
        if (this.type == Type.NORMAL) {
            this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityWolf.class, 5, 4, 4));
        }
        if (this.type == Type.ROOFED) {
            this.theBiomeDecorator.treesPerChunk = -999;
        }
    }

    @Override
    public WorldGenAbstractTree genBigTreeChance(Random p_genBigTreeChance_1_) {
        return this.type == Type.ROOFED && p_genBigTreeChance_1_.nextInt(3) > 0 ? ROOF_TREE : (this.type != Type.BIRCH && p_genBigTreeChance_1_.nextInt(5) != 0 ? (p_genBigTreeChance_1_.nextInt(10) == 0 ? BIG_TREE_FEATURE : TREE_FEATURE) : BIRCH_TREE);
    }

    @Override
    public BlockFlower.EnumFlowerType pickRandomFlower(Random p_pickRandomFlower_1_, BlockPos p_pickRandomFlower_2_) {
        if (this.type == Type.FLOWER) {
            double d0 = MathHelper.clamp((1.0 + GRASS_COLOR_NOISE.getValue((double)p_pickRandomFlower_2_.getX() / 48.0, (double)p_pickRandomFlower_2_.getZ() / 48.0)) / 2.0, 0.0, 0.9999);
            BlockFlower.EnumFlowerType blockflower$enumflowertype = BlockFlower.EnumFlowerType.values()[(int)(d0 * (double)BlockFlower.EnumFlowerType.values().length)];
            return blockflower$enumflowertype == BlockFlower.EnumFlowerType.BLUE_ORCHID ? BlockFlower.EnumFlowerType.POPPY : blockflower$enumflowertype;
        }
        return super.pickRandomFlower(p_pickRandomFlower_1_, p_pickRandomFlower_2_);
    }

    @Override
    public void decorate(World p_decorate_1_, Random p_decorate_2_, BlockPos p_decorate_3_) {
        if (this.type == Type.ROOFED) {
            this.addMushrooms(p_decorate_1_, p_decorate_2_, p_decorate_3_);
        }
        if (TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            int i = p_decorate_2_.nextInt(5) - 3;
            if (this.type == Type.FLOWER) {
                i += 2;
            }
            this.addDoublePlants(p_decorate_1_, p_decorate_2_, p_decorate_3_, i);
        }
        super.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
    }

    public void addMushrooms(World p_addMushrooms_1_, Random p_addMushrooms_2_, BlockPos p_addMushrooms_3_) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4 + 1 + 8 + p_addMushrooms_2_.nextInt(3);
                int l = j * 4 + 1 + 8 + p_addMushrooms_2_.nextInt(3);
                BlockPos blockpos = p_addMushrooms_1_.getHeight(p_addMushrooms_3_.add(k, 0, l));
                if (p_addMushrooms_2_.nextInt(20) == 0 && TerrainGen.decorate(p_addMushrooms_1_, p_addMushrooms_2_, blockpos, DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM)) {
                    WorldGenBigMushroom worldgenbigmushroom = new WorldGenBigMushroom();
                    worldgenbigmushroom.generate(p_addMushrooms_1_, p_addMushrooms_2_, blockpos);
                    continue;
                }
                if (!TerrainGen.decorate(p_addMushrooms_1_, p_addMushrooms_2_, blockpos, DecorateBiomeEvent.Decorate.EventType.TREE)) continue;
                WorldGenAbstractTree worldgenabstracttree = this.genBigTreeChance(p_addMushrooms_2_);
                worldgenabstracttree.setDecorationDefaults();
                if (!worldgenabstracttree.generate(p_addMushrooms_1_, p_addMushrooms_2_, blockpos)) continue;
                worldgenabstracttree.generateSaplings(p_addMushrooms_1_, p_addMushrooms_2_, blockpos);
            }
        }
    }

    public void addDoublePlants(World p_addDoublePlants_1_, Random p_addDoublePlants_2_, BlockPos p_addDoublePlants_3_, int p_addDoublePlants_4_) {
        block0: for (int i = 0; i < p_addDoublePlants_4_; ++i) {
            int j = p_addDoublePlants_2_.nextInt(3);
            if (j == 0) {
                DOUBLE_PLANT_GENERATOR.setPlantType(BlockDoublePlant.EnumPlantType.SYRINGA);
            } else if (j == 1) {
                DOUBLE_PLANT_GENERATOR.setPlantType(BlockDoublePlant.EnumPlantType.ROSE);
            } else if (j == 2) {
                DOUBLE_PLANT_GENERATOR.setPlantType(BlockDoublePlant.EnumPlantType.PAEONIA);
            }
            for (int k = 0; k < 5; ++k) {
                int l = p_addDoublePlants_2_.nextInt(16) + 8;
                int i1 = p_addDoublePlants_2_.nextInt(16) + 8;
                int j1 = p_addDoublePlants_2_.nextInt(p_addDoublePlants_1_.getHeight(p_addDoublePlants_3_.add(l, 0, i1)).getY() + 32);
                if (DOUBLE_PLANT_GENERATOR.generate(p_addDoublePlants_1_, p_addDoublePlants_2_, new BlockPos(p_addDoublePlants_3_.getX() + l, j1, p_addDoublePlants_3_.getZ() + i1))) continue block0;
            }
        }
    }

    @Override
    public void addDefaultFlowers() {
        if (this.type != Type.FLOWER) {
            super.addDefaultFlowers();
            return;
        }
        for (BlockFlower.EnumFlowerType type : BlockFlower.EnumFlowerType.values()) {
            if (type.getBlockType() == BlockFlower.EnumFlowerColor.YELLOW) continue;
            if (type == BlockFlower.EnumFlowerType.BLUE_ORCHID) {
                type = BlockFlower.EnumFlowerType.POPPY;
            }
            this.addFlower(Blocks.RED_FLOWER.getDefaultState().withProperty(Blocks.RED_FLOWER.getTypeProperty(), type), 10);
        }
    }

    @Override
    public Class<? extends Biome> getBiomeClass() {
        return BiomeForest.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGrassColorAtPos(BlockPos p_getGrassColorAtPos_1_) {
        int i = super.getGrassColorAtPos(p_getGrassColorAtPos_1_);
        return this.type == Type.ROOFED ? (i & 0xFEFEFE) + 2634762 >> 1 : i;
    }

    public static enum Type {
        NORMAL,
        FLOWER,
        BIRCH,
        ROOFED;

    }
}

