/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import java.util.Random;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeHills
extends Biome {
    private final WorldGenerator theWorldGenerator = new WorldGenMinable(Blocks.MONSTER_EGG.getDefaultState().withProperty(BlockSilverfish.VARIANT, BlockSilverfish.EnumType.STONE), 9);
    private final WorldGenTaiga2 spruceGenerator = new WorldGenTaiga2(false);
    private final Type type;

    public BiomeHills(Type p_i46710_1_, Biome.BiomeProperties p_i46710_2_) {
        super(p_i46710_2_);
        if (p_i46710_1_ == Type.EXTRA_TREES) {
            this.theBiomeDecorator.treesPerChunk = 3;
        }
        this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityLlama.class, 5, 4, 6));
        this.type = p_i46710_1_;
    }

    @Override
    public WorldGenAbstractTree genBigTreeChance(Random p_genBigTreeChance_1_) {
        return p_genBigTreeChance_1_.nextInt(3) > 0 ? this.spruceGenerator : super.genBigTreeChance(p_genBigTreeChance_1_);
    }

    @Override
    public void decorate(World p_decorate_1_, Random p_decorate_2_, BlockPos p_decorate_3_) {
        super.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
        MinecraftForge.ORE_GEN_BUS.post(new OreGenEvent.Pre(p_decorate_1_, p_decorate_2_, p_decorate_3_));
        EmeraldGenerator emeralds = new EmeraldGenerator();
        if (TerrainGen.generateOre(p_decorate_1_, p_decorate_2_, emeralds, p_decorate_3_, OreGenEvent.GenerateMinable.EventType.EMERALD)) {
            ((WorldGenerator)emeralds).generate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
        }
        for (int i = 0; i < 7; ++i) {
            int l1;
            int k1;
            int j1 = p_decorate_2_.nextInt(16);
            if (!TerrainGen.generateOre(p_decorate_1_, p_decorate_2_, this.theWorldGenerator, p_decorate_3_.add(j1, k1 = p_decorate_2_.nextInt(64), l1 = p_decorate_2_.nextInt(16)), OreGenEvent.GenerateMinable.EventType.SILVERFISH)) continue;
            this.theWorldGenerator.generate(p_decorate_1_, p_decorate_2_, p_decorate_3_.add(j1, k1, l1));
        }
        MinecraftForge.ORE_GEN_BUS.post(new OreGenEvent.Post(p_decorate_1_, p_decorate_2_, p_decorate_3_));
    }

    @Override
    public void genTerrainBlocks(World p_genTerrainBlocks_1_, Random p_genTerrainBlocks_2_, ChunkPrimer p_genTerrainBlocks_3_, int p_genTerrainBlocks_4_, int p_genTerrainBlocks_5_, double p_genTerrainBlocks_6_) {
        this.topBlock = Blocks.GRASS.getDefaultState();
        this.fillerBlock = Blocks.DIRT.getDefaultState();
        if ((p_genTerrainBlocks_6_ < -1.0 || p_genTerrainBlocks_6_ > 2.0) && this.type == Type.MUTATED) {
            this.topBlock = Blocks.GRAVEL.getDefaultState();
            this.fillerBlock = Blocks.GRAVEL.getDefaultState();
        } else if (p_genTerrainBlocks_6_ > 1.0 && this.type != Type.EXTRA_TREES) {
            this.topBlock = Blocks.STONE.getDefaultState();
            this.fillerBlock = Blocks.STONE.getDefaultState();
        }
        this.generateBiomeTerrain(p_genTerrainBlocks_1_, p_genTerrainBlocks_2_, p_genTerrainBlocks_3_, p_genTerrainBlocks_4_, p_genTerrainBlocks_5_, p_genTerrainBlocks_6_);
    }

    private static class EmeraldGenerator
    extends WorldGenerator {
        private EmeraldGenerator() {
        }

        @Override
        public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
            int count = 3 + p_generate_2_.nextInt(6);
            for (int i = 0; i < count; ++i) {
                BlockPos blockpos = p_generate_3_.add(p_generate_2_.nextInt(16), p_generate_2_.nextInt(28) + 4, p_generate_2_.nextInt(16));
                IBlockState state = p_generate_1_.getBlockState(blockpos);
                if (!state.getBlock().isReplaceableOreGen(state, p_generate_1_, blockpos, BlockMatcher.forBlock(Blocks.STONE))) continue;
                p_generate_1_.setBlockState(blockpos, Blocks.EMERALD_ORE.getDefaultState(), 2);
            }
            return true;
        }
    }

    public static enum Type {
        NORMAL,
        EXTRA_TREES,
        MUTATED;

    }
}

