/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMelon;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeJungle
extends Biome {
    private final boolean isEdge;
    private static final IBlockState JUNGLE_LOG = Blocks.LOG.getDefaultState().withProperty(BlockOldLog.VARIANT, BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.LEAVES.getDefaultState().withProperty(BlockOldLeaf.VARIANT, BlockPlanks.EnumType.JUNGLE).withProperty(BlockLeaves.CHECK_DECAY, false);
    private static final IBlockState OAK_LEAF = Blocks.LEAVES.getDefaultState().withProperty(BlockOldLeaf.VARIANT, BlockPlanks.EnumType.OAK).withProperty(BlockLeaves.CHECK_DECAY, false);

    public BiomeJungle(boolean p_i46705_1_, Biome.BiomeProperties p_i46705_2_) {
        super(p_i46705_2_);
        this.isEdge = p_i46705_1_;
        this.theBiomeDecorator.treesPerChunk = p_i46705_1_ ? 2 : 50;
        this.theBiomeDecorator.grassPerChunk = 25;
        this.theBiomeDecorator.flowersPerChunk = 4;
        if (!p_i46705_1_) {
            this.spawnableMonsterList.add(new Biome.SpawnListEntry(EntityOcelot.class, 2, 1, 1));
        }
        this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityChicken.class, 10, 4, 4));
    }

    @Override
    public WorldGenAbstractTree genBigTreeChance(Random p_genBigTreeChance_1_) {
        return p_genBigTreeChance_1_.nextInt(10) == 0 ? BIG_TREE_FEATURE : (p_genBigTreeChance_1_.nextInt(2) == 0 ? new WorldGenShrub(JUNGLE_LOG, OAK_LEAF) : (!this.isEdge && p_genBigTreeChance_1_.nextInt(3) == 0 ? new WorldGenMegaJungle(false, 10, 20, JUNGLE_LOG, JUNGLE_LEAF) : new WorldGenTrees(false, 4 + p_genBigTreeChance_1_.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true)));
    }

    @Override
    public WorldGenerator getRandomWorldGenForGrass(Random p_getRandomWorldGenForGrass_1_) {
        return p_getRandomWorldGenForGrass_1_.nextInt(4) == 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    @Override
    public void decorate(World p_decorate_1_, Random p_decorate_2_, BlockPos p_decorate_3_) {
        super.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
        int i = p_decorate_2_.nextInt(16) + 8;
        int j = p_decorate_2_.nextInt(16) + 8;
        int height = p_decorate_1_.getHeight(p_decorate_3_.add(i, 0, j)).getY() * 2;
        if (height < 1) {
            height = 1;
        }
        int k = p_decorate_2_.nextInt(height);
        if (TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.PUMPKIN)) {
            new WorldGenMelon().generate(p_decorate_1_, p_decorate_2_, p_decorate_3_.add(i, k, j));
        }
        WorldGenVines worldgenvines = new WorldGenVines();
        if (TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            for (j = 0; j < 50; ++j) {
                k = p_decorate_2_.nextInt(16) + 8;
                int l = 128;
                int i1 = p_decorate_2_.nextInt(16) + 8;
                worldgenvines.generate(p_decorate_1_, p_decorate_2_, p_decorate_3_.add(k, 128, i1));
            }
        }
    }
}

