/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeMesa
extends Biome {
    protected static final IBlockState COARSE_DIRT = Blocks.DIRT.getDefaultState().withProperty(BlockDirt.VARIANT, BlockDirt.DirtType.COARSE_DIRT);
    protected static final IBlockState GRASS = Blocks.GRASS.getDefaultState();
    protected static final IBlockState HARDENED_CLAY = Blocks.HARDENED_CLAY.getDefaultState();
    protected static final IBlockState STAINED_HARDENED_CLAY = Blocks.STAINED_HARDENED_CLAY.getDefaultState();
    protected static final IBlockState ORANGE_STAINED_HARDENED_CLAY = STAINED_HARDENED_CLAY.withProperty(BlockColored.COLOR, EnumDyeColor.ORANGE);
    protected static final IBlockState RED_SAND = Blocks.SAND.getDefaultState().withProperty(BlockSand.VARIANT, BlockSand.EnumType.RED_SAND);
    private IBlockState[] clayBands;
    private long worldSeed;
    private NoiseGeneratorPerlin pillarNoise;
    private NoiseGeneratorPerlin pillarRoofNoise;
    private NoiseGeneratorPerlin clayBandsOffsetNoise;
    private final boolean brycePillars;
    private final boolean hasForest;

    public BiomeMesa(boolean p_i46704_1_, boolean p_i46704_2_, Biome.BiomeProperties p_i46704_3_) {
        super(p_i46704_3_);
        this.brycePillars = p_i46704_1_;
        this.hasForest = p_i46704_2_;
        this.spawnableCreatureList.clear();
        this.topBlock = RED_SAND;
        this.fillerBlock = STAINED_HARDENED_CLAY;
        this.theBiomeDecorator.treesPerChunk = -999;
        this.theBiomeDecorator.deadBushPerChunk = 20;
        this.theBiomeDecorator.reedsPerChunk = 3;
        this.theBiomeDecorator.cactiPerChunk = 5;
        this.theBiomeDecorator.flowersPerChunk = 0;
        this.spawnableCreatureList.clear();
        if (p_i46704_2_) {
            this.theBiomeDecorator.treesPerChunk = 5;
        }
    }

    @Override
    public BiomeDecorator createBiomeDecorator() {
        return new Decorator();
    }

    @Override
    public WorldGenAbstractTree genBigTreeChance(Random p_genBigTreeChance_1_) {
        return TREE_FEATURE;
    }

    @Override
    public void genTerrainBlocks(World p_genTerrainBlocks_1_, Random p_genTerrainBlocks_2_, ChunkPrimer p_genTerrainBlocks_3_, int p_genTerrainBlocks_4_, int p_genTerrainBlocks_5_, double p_genTerrainBlocks_6_) {
        if (this.clayBands == null || this.worldSeed != p_genTerrainBlocks_1_.getSeed()) {
            this.generateBands(p_genTerrainBlocks_1_.getSeed());
        }
        if (this.pillarNoise == null || this.pillarRoofNoise == null || this.worldSeed != p_genTerrainBlocks_1_.getSeed()) {
            Random lvt_8_1_ = new Random(this.worldSeed);
            this.pillarNoise = new NoiseGeneratorPerlin(lvt_8_1_, 4);
            this.pillarRoofNoise = new NoiseGeneratorPerlin(lvt_8_1_, 1);
        }
        this.worldSeed = p_genTerrainBlocks_1_.getSeed();
        double lvt_8_2_ = 0.0;
        if (this.brycePillars) {
            int lvt_10_1_ = (p_genTerrainBlocks_4_ & 0xFFFFFFF0) + (p_genTerrainBlocks_5_ & 0xF);
            int lvt_11_1_ = (p_genTerrainBlocks_5_ & 0xFFFFFFF0) + (p_genTerrainBlocks_4_ & 0xF);
            double lvt_12_1_ = Math.min(Math.abs(p_genTerrainBlocks_6_), this.pillarNoise.getValue((double)lvt_10_1_ * 0.25, (double)lvt_11_1_ * 0.25));
            if (lvt_12_1_ > 0.0) {
                double lvt_14_1_ = 0.001953125;
                lvt_8_2_ = lvt_12_1_ * lvt_12_1_ * 2.5;
                double lvt_16_1_ = Math.abs(this.pillarRoofNoise.getValue((double)lvt_10_1_ * 0.001953125, (double)lvt_11_1_ * 0.001953125));
                double lvt_18_1_ = Math.ceil(lvt_16_1_ * 50.0) + 14.0;
                if (lvt_8_2_ > lvt_18_1_) {
                    lvt_8_2_ = lvt_18_1_;
                }
                lvt_8_2_ += 64.0;
            }
        }
        int lvt_10_2_ = p_genTerrainBlocks_4_ & 0xF;
        int lvt_11_2_ = p_genTerrainBlocks_5_ & 0xF;
        int lvt_12_2_ = p_genTerrainBlocks_1_.getSeaLevel();
        IBlockState lvt_13_1_ = STAINED_HARDENED_CLAY;
        IBlockState lvt_14_2_ = this.fillerBlock;
        int lvt_15_1_ = (int)(p_genTerrainBlocks_6_ / 3.0 + 3.0 + p_genTerrainBlocks_2_.nextDouble() * 0.25);
        boolean lvt_16_2_ = Math.cos(p_genTerrainBlocks_6_ / 3.0 * Math.PI) > 0.0;
        int lvt_17_1_ = -1;
        boolean lvt_18_2_ = false;
        int lvt_19_1_ = 0;
        for (int lvt_20_1_ = 255; lvt_20_1_ >= 0; --lvt_20_1_) {
            if (p_genTerrainBlocks_3_.getBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_).getMaterial() == Material.AIR && lvt_20_1_ < (int)lvt_8_2_) {
                p_genTerrainBlocks_3_.setBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_, STONE);
            }
            if (lvt_20_1_ <= p_genTerrainBlocks_2_.nextInt(5)) {
                p_genTerrainBlocks_3_.setBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_, BEDROCK);
                continue;
            }
            if (lvt_19_1_ >= 15 && !this.brycePillars) continue;
            IBlockState lvt_21_1_ = p_genTerrainBlocks_3_.getBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_);
            if (lvt_21_1_.getMaterial() == Material.AIR) {
                lvt_17_1_ = -1;
                continue;
            }
            if (lvt_21_1_.getBlock() != Blocks.STONE) continue;
            if (lvt_17_1_ == -1) {
                lvt_18_2_ = false;
                if (lvt_15_1_ <= 0) {
                    lvt_13_1_ = AIR;
                    lvt_14_2_ = STONE;
                } else if (lvt_20_1_ >= lvt_12_2_ - 4 && lvt_20_1_ <= lvt_12_2_ + 1) {
                    lvt_13_1_ = STAINED_HARDENED_CLAY;
                    lvt_14_2_ = this.fillerBlock;
                }
                if (lvt_20_1_ < lvt_12_2_ && (lvt_13_1_ == null || lvt_13_1_.getMaterial() == Material.AIR)) {
                    lvt_13_1_ = WATER;
                }
                lvt_17_1_ = lvt_15_1_ + Math.max(0, lvt_20_1_ - lvt_12_2_);
                if (lvt_20_1_ >= lvt_12_2_ - 1) {
                    if (this.hasForest && lvt_20_1_ > 86 + lvt_15_1_ * 2) {
                        if (lvt_16_2_) {
                            p_genTerrainBlocks_3_.setBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_, COARSE_DIRT);
                        } else {
                            p_genTerrainBlocks_3_.setBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_, GRASS);
                        }
                    } else if (lvt_20_1_ > lvt_12_2_ + 3 + lvt_15_1_) {
                        IBlockState lvt_22_3_;
                        if (lvt_20_1_ < 64 || lvt_20_1_ > 127) {
                            IBlockState lvt_22_1_ = ORANGE_STAINED_HARDENED_CLAY;
                        } else if (lvt_16_2_) {
                            IBlockState lvt_22_2_ = HARDENED_CLAY;
                        } else {
                            lvt_22_3_ = this.getBand(p_genTerrainBlocks_4_, lvt_20_1_, p_genTerrainBlocks_5_);
                        }
                        p_genTerrainBlocks_3_.setBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_, lvt_22_3_);
                    } else {
                        p_genTerrainBlocks_3_.setBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_, this.topBlock);
                        lvt_18_2_ = true;
                    }
                } else {
                    p_genTerrainBlocks_3_.setBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_, lvt_14_2_);
                    if (lvt_14_2_.getBlock() == Blocks.STAINED_HARDENED_CLAY) {
                        p_genTerrainBlocks_3_.setBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_, ORANGE_STAINED_HARDENED_CLAY);
                    }
                }
            } else if (lvt_17_1_ > 0) {
                --lvt_17_1_;
                if (lvt_18_2_) {
                    p_genTerrainBlocks_3_.setBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_, ORANGE_STAINED_HARDENED_CLAY);
                } else {
                    p_genTerrainBlocks_3_.setBlockState(lvt_11_2_, lvt_20_1_, lvt_10_2_, this.getBand(p_genTerrainBlocks_4_, lvt_20_1_, p_genTerrainBlocks_5_));
                }
            }
            ++lvt_19_1_;
        }
    }

    public void generateBands(long p_generateBands_1_) {
        this.clayBands = new IBlockState[64];
        Arrays.fill(this.clayBands, HARDENED_CLAY);
        Random lvt_3_1_ = new Random(p_generateBands_1_);
        this.clayBandsOffsetNoise = new NoiseGeneratorPerlin(lvt_3_1_, 1);
        for (int lvt_4_1_ = 0; lvt_4_1_ < 64; ++lvt_4_1_) {
            if ((lvt_4_1_ += lvt_3_1_.nextInt(5) + 1) >= 64) continue;
            this.clayBands[lvt_4_1_] = ORANGE_STAINED_HARDENED_CLAY;
        }
        int lvt_4_2_ = lvt_3_1_.nextInt(4) + 2;
        for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_4_2_; ++lvt_5_1_) {
            int lvt_6_1_ = lvt_3_1_.nextInt(3) + 1;
            int lvt_7_1_ = lvt_3_1_.nextInt(64);
            for (int lvt_8_1_ = 0; lvt_7_1_ + lvt_8_1_ < 64 && lvt_8_1_ < lvt_6_1_; ++lvt_8_1_) {
                this.clayBands[lvt_7_1_ + lvt_8_1_] = STAINED_HARDENED_CLAY.withProperty(BlockColored.COLOR, EnumDyeColor.YELLOW);
            }
        }
        int lvt_5_2_ = lvt_3_1_.nextInt(4) + 2;
        for (int lvt_6_2_ = 0; lvt_6_2_ < lvt_5_2_; ++lvt_6_2_) {
            int lvt_7_2_ = lvt_3_1_.nextInt(3) + 2;
            int lvt_8_2_ = lvt_3_1_.nextInt(64);
            for (int lvt_9_1_ = 0; lvt_8_2_ + lvt_9_1_ < 64 && lvt_9_1_ < lvt_7_2_; ++lvt_9_1_) {
                this.clayBands[lvt_8_2_ + lvt_9_1_] = STAINED_HARDENED_CLAY.withProperty(BlockColored.COLOR, EnumDyeColor.BROWN);
            }
        }
        int lvt_6_3_ = lvt_3_1_.nextInt(4) + 2;
        for (int lvt_7_3_ = 0; lvt_7_3_ < lvt_6_3_; ++lvt_7_3_) {
            int lvt_8_3_ = lvt_3_1_.nextInt(3) + 1;
            int lvt_9_2_ = lvt_3_1_.nextInt(64);
            for (int lvt_10_1_ = 0; lvt_9_2_ + lvt_10_1_ < 64 && lvt_10_1_ < lvt_8_3_; ++lvt_10_1_) {
                this.clayBands[lvt_9_2_ + lvt_10_1_] = STAINED_HARDENED_CLAY.withProperty(BlockColored.COLOR, EnumDyeColor.RED);
            }
        }
        int lvt_7_4_ = lvt_3_1_.nextInt(3) + 3;
        int lvt_8_4_ = 0;
        for (int lvt_9_3_ = 0; lvt_9_3_ < lvt_7_4_; ++lvt_9_3_) {
            boolean lvt_10_2_ = true;
            lvt_8_4_ += lvt_3_1_.nextInt(16) + 4;
            for (int lvt_11_1_ = 0; lvt_8_4_ + lvt_11_1_ < 64 && lvt_11_1_ < 1; ++lvt_11_1_) {
                this.clayBands[lvt_8_4_ + lvt_11_1_] = STAINED_HARDENED_CLAY.withProperty(BlockColored.COLOR, EnumDyeColor.WHITE);
                if (lvt_8_4_ + lvt_11_1_ > 1 && lvt_3_1_.nextBoolean()) {
                    this.clayBands[lvt_8_4_ + lvt_11_1_ - 1] = STAINED_HARDENED_CLAY.withProperty(BlockColored.COLOR, EnumDyeColor.SILVER);
                }
                if (lvt_8_4_ + lvt_11_1_ >= 63 || !lvt_3_1_.nextBoolean()) continue;
                this.clayBands[lvt_8_4_ + lvt_11_1_ + 1] = STAINED_HARDENED_CLAY.withProperty(BlockColored.COLOR, EnumDyeColor.SILVER);
            }
        }
    }

    public IBlockState getBand(int p_getBand_1_, int p_getBand_2_, int p_getBand_3_) {
        int lvt_4_1_ = (int)Math.round(this.clayBandsOffsetNoise.getValue((double)p_getBand_1_ / 512.0, (double)p_getBand_1_ / 512.0) * 2.0);
        return this.clayBands[(p_getBand_2_ + lvt_4_1_ + 64) % 64];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getFoliageColorAtPos(BlockPos p_getFoliageColorAtPos_1_) {
        return 10387789;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGrassColorAtPos(BlockPos p_getGrassColorAtPos_1_) {
        return 9470285;
    }

    class Decorator
    extends BiomeDecorator {
        private Decorator() {
        }

        @Override
        protected void generateOres(World p_generateOres_1_, Random p_generateOres_2_) {
            super.generateOres(p_generateOres_1_, p_generateOres_2_);
            this.genStandardOre1(p_generateOres_1_, p_generateOres_2_, 20, this.goldGen, 32, 80);
        }
    }
}

