/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomePlains
extends Biome {
    protected boolean sunflowers;

    public BiomePlains(boolean p_i46699_1_, Biome.BiomeProperties p_i46699_2_) {
        super(p_i46699_2_);
        this.sunflowers = p_i46699_1_;
        this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityHorse.class, 5, 2, 6));
        this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityDonkey.class, 1, 1, 3));
        this.theBiomeDecorator.treesPerChunk = 0;
        this.theBiomeDecorator.extraTreeChance = 0.05f;
        this.theBiomeDecorator.flowersPerChunk = 4;
        this.theBiomeDecorator.grassPerChunk = 10;
    }

    @Override
    public BlockFlower.EnumFlowerType pickRandomFlower(Random p_pickRandomFlower_1_, BlockPos p_pickRandomFlower_2_) {
        double d0 = GRASS_COLOR_NOISE.getValue((double)p_pickRandomFlower_2_.getX() / 200.0, (double)p_pickRandomFlower_2_.getZ() / 200.0);
        if (d0 < -0.8) {
            int j = p_pickRandomFlower_1_.nextInt(4);
            switch (j) {
                case 0: {
                    return BlockFlower.EnumFlowerType.ORANGE_TULIP;
                }
                case 1: {
                    return BlockFlower.EnumFlowerType.RED_TULIP;
                }
                case 2: {
                    return BlockFlower.EnumFlowerType.PINK_TULIP;
                }
            }
            return BlockFlower.EnumFlowerType.WHITE_TULIP;
        }
        if (p_pickRandomFlower_1_.nextInt(3) > 0) {
            int i = p_pickRandomFlower_1_.nextInt(3);
            return i == 0 ? BlockFlower.EnumFlowerType.POPPY : (i == 1 ? BlockFlower.EnumFlowerType.HOUSTONIA : BlockFlower.EnumFlowerType.OXEYE_DAISY);
        }
        return BlockFlower.EnumFlowerType.DANDELION;
    }

    @Override
    public void decorate(World p_decorate_1_, Random p_decorate_2_, BlockPos p_decorate_3_) {
        double d0 = GRASS_COLOR_NOISE.getValue((double)(p_decorate_3_.getX() + 8) / 200.0, (double)(p_decorate_3_.getZ() + 8) / 200.0);
        if (d0 < -0.8) {
            this.theBiomeDecorator.flowersPerChunk = 15;
            this.theBiomeDecorator.grassPerChunk = 5;
        } else {
            this.theBiomeDecorator.flowersPerChunk = 4;
            this.theBiomeDecorator.grassPerChunk = 10;
            DOUBLE_PLANT_GENERATOR.setPlantType(BlockDoublePlant.EnumPlantType.GRASS);
            if (TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.GRASS)) {
                for (int i = 0; i < 7; ++i) {
                    int j = p_decorate_2_.nextInt(16) + 8;
                    int k = p_decorate_2_.nextInt(16) + 8;
                    int l = p_decorate_2_.nextInt(p_decorate_1_.getHeight(p_decorate_3_.add(j, 0, k)).getY() + 32);
                    DOUBLE_PLANT_GENERATOR.generate(p_decorate_1_, p_decorate_2_, p_decorate_3_.add(j, l, k));
                }
            }
        }
        if (this.sunflowers && TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            DOUBLE_PLANT_GENERATOR.setPlantType(BlockDoublePlant.EnumPlantType.SUNFLOWER);
            for (int i1 = 0; i1 < 10; ++i1) {
                int j1 = p_decorate_2_.nextInt(16) + 8;
                int k1 = p_decorate_2_.nextInt(16) + 8;
                int l1 = p_decorate_2_.nextInt(p_decorate_1_.getHeight(p_decorate_3_.add(j1, 0, k1)).getY() + 32);
                DOUBLE_PLANT_GENERATOR.generate(p_decorate_1_, p_decorate_2_, p_decorate_3_.add(j1, l1, k1));
            }
        }
        super.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
    }

    @Override
    public void addDefaultFlowers() {
        BlockFlower red = Blocks.RED_FLOWER;
        BlockFlower yel = Blocks.YELLOW_FLOWER;
        this.addFlower(red.getDefaultState().withProperty(red.getTypeProperty(), BlockFlower.EnumFlowerType.ORANGE_TULIP), 3);
        this.addFlower(red.getDefaultState().withProperty(red.getTypeProperty(), BlockFlower.EnumFlowerType.RED_TULIP), 3);
        this.addFlower(red.getDefaultState().withProperty(red.getTypeProperty(), BlockFlower.EnumFlowerType.PINK_TULIP), 3);
        this.addFlower(red.getDefaultState().withProperty(red.getTypeProperty(), BlockFlower.EnumFlowerType.WHITE_TULIP), 3);
        this.addFlower(red.getDefaultState().withProperty(red.getTypeProperty(), BlockFlower.EnumFlowerType.POPPY), 20);
        this.addFlower(red.getDefaultState().withProperty(red.getTypeProperty(), BlockFlower.EnumFlowerType.HOUSTONIA), 20);
        this.addFlower(red.getDefaultState().withProperty(red.getTypeProperty(), BlockFlower.EnumFlowerType.OXEYE_DAISY), 20);
        this.addFlower(yel.getDefaultState().withProperty(yel.getTypeProperty(), BlockFlower.EnumFlowerType.DANDELION), 30);
    }

    @Override
    public WorldGenAbstractTree genBigTreeChance(Random p_genBigTreeChance_1_) {
        return p_genBigTreeChance_1_.nextInt(3) == 0 ? BIG_TREE_FEATURE : TREE_FEATURE;
    }
}

