/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;

public class BiomeProvider {
    private ChunkProviderSettings settings;
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private final BiomeCache biomeCache = new BiomeCache(this);
    private final List<Biome> biomesToSpawnIn = Lists.newArrayList(allowedBiomes);
    public static List<Biome> allowedBiomes = Lists.newArrayList((Object[])new Biome[]{Biomes.FOREST, Biomes.PLAINS, Biomes.TAIGA, Biomes.TAIGA_HILLS, Biomes.FOREST_HILLS, Biomes.JUNGLE, Biomes.JUNGLE_HILLS});

    protected BiomeProvider() {
    }

    private BiomeProvider(long p_i45744_1_, WorldType p_i45744_3_, String p_i45744_4_) {
        this();
        if (p_i45744_3_ == WorldType.CUSTOMIZED && !p_i45744_4_.isEmpty()) {
            this.settings = ChunkProviderSettings.Factory.jsonToFactory(p_i45744_4_).build();
        }
        GenLayer[] agenlayer = GenLayer.initializeAllBiomeGenerators(p_i45744_1_, p_i45744_3_, this.settings);
        agenlayer = this.getModdedBiomeGenerators(p_i45744_3_, p_i45744_1_, agenlayer);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
    }

    public BiomeProvider(WorldInfo p_i46712_1_) {
        this(p_i46712_1_.getSeed(), p_i46712_1_.getTerrainType(), p_i46712_1_.getGeneratorOptions());
    }

    public List<Biome> getBiomesToSpawnIn() {
        return this.biomesToSpawnIn;
    }

    public Biome getBiome(BlockPos p_getBiome_1_) {
        return this.getBiome(p_getBiome_1_, null);
    }

    public Biome getBiome(BlockPos p_getBiome_1_, Biome p_getBiome_2_) {
        return this.biomeCache.getBiome(p_getBiome_1_.getX(), p_getBiome_1_.getZ(), p_getBiome_2_);
    }

    public float getTemperatureAtHeight(float p_getTemperatureAtHeight_1_, int p_getTemperatureAtHeight_2_) {
        return p_getTemperatureAtHeight_1_;
    }

    public Biome[] getBiomesForGeneration(Biome[] p_getBiomesForGeneration_1_, int p_getBiomesForGeneration_2_, int p_getBiomesForGeneration_3_, int p_getBiomesForGeneration_4_, int p_getBiomesForGeneration_5_) {
        IntCache.resetIntCache();
        if (p_getBiomesForGeneration_1_ == null || p_getBiomesForGeneration_1_.length < p_getBiomesForGeneration_4_ * p_getBiomesForGeneration_5_) {
            p_getBiomesForGeneration_1_ = new Biome[p_getBiomesForGeneration_4_ * p_getBiomesForGeneration_5_];
        }
        int[] aint = this.genBiomes.getInts(p_getBiomesForGeneration_2_, p_getBiomesForGeneration_3_, p_getBiomesForGeneration_4_, p_getBiomesForGeneration_5_);
        try {
            for (int i = 0; i < p_getBiomesForGeneration_4_ * p_getBiomesForGeneration_5_; ++i) {
                p_getBiomesForGeneration_1_[i] = Biome.getBiome(aint[i], Biomes.DEFAULT);
            }
            return p_getBiomesForGeneration_1_;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("RawBiomeBlock");
            crashreportcategory.addCrashSection("biomes[] size", p_getBiomesForGeneration_1_.length);
            crashreportcategory.addCrashSection("x", p_getBiomesForGeneration_2_);
            crashreportcategory.addCrashSection("z", p_getBiomesForGeneration_3_);
            crashreportcategory.addCrashSection("w", p_getBiomesForGeneration_4_);
            crashreportcategory.addCrashSection("h", p_getBiomesForGeneration_5_);
            throw new ReportedException(crashreport);
        }
    }

    public Biome[] getBiomes(Biome[] p_getBiomes_1_, int p_getBiomes_2_, int p_getBiomes_3_, int p_getBiomes_4_, int p_getBiomes_5_) {
        return this.getBiomes(p_getBiomes_1_, p_getBiomes_2_, p_getBiomes_3_, p_getBiomes_4_, p_getBiomes_5_, true);
    }

    public Biome[] getBiomes(Biome[] p_getBiomes_1_, int p_getBiomes_2_, int p_getBiomes_3_, int p_getBiomes_4_, int p_getBiomes_5_, boolean p_getBiomes_6_) {
        IntCache.resetIntCache();
        if (p_getBiomes_1_ == null || p_getBiomes_1_.length < p_getBiomes_4_ * p_getBiomes_5_) {
            p_getBiomes_1_ = new Biome[p_getBiomes_4_ * p_getBiomes_5_];
        }
        if (p_getBiomes_6_ && p_getBiomes_4_ == 16 && p_getBiomes_5_ == 16 && (p_getBiomes_2_ & 0xF) == 0 && (p_getBiomes_3_ & 0xF) == 0) {
            Biome[] abiome = this.biomeCache.getCachedBiomes(p_getBiomes_2_, p_getBiomes_3_);
            System.arraycopy(abiome, 0, p_getBiomes_1_, 0, p_getBiomes_4_ * p_getBiomes_5_);
            return p_getBiomes_1_;
        }
        int[] aint = this.biomeIndexLayer.getInts(p_getBiomes_2_, p_getBiomes_3_, p_getBiomes_4_, p_getBiomes_5_);
        for (int i = 0; i < p_getBiomes_4_ * p_getBiomes_5_; ++i) {
            p_getBiomes_1_[i] = Biome.getBiome(aint[i], Biomes.DEFAULT);
        }
        return p_getBiomes_1_;
    }

    public boolean areBiomesViable(int p_areBiomesViable_1_, int p_areBiomesViable_2_, int p_areBiomesViable_3_, List<Biome> p_areBiomesViable_4_) {
        IntCache.resetIntCache();
        int i = p_areBiomesViable_1_ - p_areBiomesViable_3_ >> 2;
        int j = p_areBiomesViable_2_ - p_areBiomesViable_3_ >> 2;
        int k = p_areBiomesViable_1_ + p_areBiomesViable_3_ >> 2;
        int l = p_areBiomesViable_2_ + p_areBiomesViable_3_ >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.getInts(i, j, i1, j1);
        try {
            for (int k1 = 0; k1 < i1 * j1; ++k1) {
                Biome biome = Biome.getBiome(aint[k1]);
                if (p_areBiomesViable_4_.contains(biome)) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Layer");
            crashreportcategory.addCrashSection("Layer", this.genBiomes.toString());
            crashreportcategory.addCrashSection("x", p_areBiomesViable_1_);
            crashreportcategory.addCrashSection("z", p_areBiomesViable_2_);
            crashreportcategory.addCrashSection("radius", p_areBiomesViable_3_);
            crashreportcategory.addCrashSection("allowed", p_areBiomesViable_4_);
            throw new ReportedException(crashreport);
        }
    }

    @Nullable
    public BlockPos findBiomePosition(int p_findBiomePosition_1_, int p_findBiomePosition_2_, int p_findBiomePosition_3_, List<Biome> p_findBiomePosition_4_, Random p_findBiomePosition_5_) {
        IntCache.resetIntCache();
        int i = p_findBiomePosition_1_ - p_findBiomePosition_3_ >> 2;
        int j = p_findBiomePosition_2_ - p_findBiomePosition_3_ >> 2;
        int k = p_findBiomePosition_1_ + p_findBiomePosition_3_ >> 2;
        int l = p_findBiomePosition_2_ + p_findBiomePosition_3_ >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.getInts(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            Biome biome = Biome.getBiome(aint[l1]);
            if (!p_findBiomePosition_4_.contains(biome) || blockpos != null && p_findBiomePosition_5_.nextInt(k1 + 1) != 0) continue;
            blockpos = new BlockPos(i2, 0, j2);
            ++k1;
        }
        return blockpos;
    }

    public void cleanupCache() {
        this.biomeCache.cleanupCache();
    }

    public GenLayer[] getModdedBiomeGenerators(WorldType p_getModdedBiomeGenerators_1_, long p_getModdedBiomeGenerators_2_, GenLayer[] p_getModdedBiomeGenerators_4_) {
        WorldTypeEvent.InitBiomeGens event = new WorldTypeEvent.InitBiomeGens(p_getModdedBiomeGenerators_1_, p_getModdedBiomeGenerators_2_, p_getModdedBiomeGenerators_4_);
        MinecraftForge.TERRAIN_GEN_BUS.post(event);
        return event.getNewBiomeGens();
    }

    public boolean isFixedBiome() {
        return this.settings != null && this.settings.fixedBiome >= 0;
    }

    public Biome getFixedBiome() {
        return this.settings != null && this.settings.fixedBiome >= 0 ? Biome.getBiomeForId(this.settings.fixedBiome) : null;
    }
}

