/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeSavanna
extends Biome {
    private static final WorldGenSavannaTree SAVANNA_TREE = new WorldGenSavannaTree(false);

    public BiomeSavanna(Biome.BiomeProperties p_i46697_1_) {
        super(p_i46697_1_);
        this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityHorse.class, 1, 2, 6));
        this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityDonkey.class, 1, 1, 1));
        if (this.getBaseHeight() > 1.1f) {
            this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityLlama.class, 8, 4, 4));
        }
        this.theBiomeDecorator.treesPerChunk = 1;
        this.theBiomeDecorator.flowersPerChunk = 4;
        this.theBiomeDecorator.grassPerChunk = 20;
    }

    @Override
    public WorldGenAbstractTree genBigTreeChance(Random p_genBigTreeChance_1_) {
        return p_genBigTreeChance_1_.nextInt(5) > 0 ? SAVANNA_TREE : TREE_FEATURE;
    }

    @Override
    public void decorate(World p_decorate_1_, Random p_decorate_2_, BlockPos p_decorate_3_) {
        DOUBLE_PLANT_GENERATOR.setPlantType(BlockDoublePlant.EnumPlantType.GRASS);
        if (TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            for (int i = 0; i < 7; ++i) {
                int j = p_decorate_2_.nextInt(16) + 8;
                int k = p_decorate_2_.nextInt(16) + 8;
                int l = p_decorate_2_.nextInt(p_decorate_1_.getHeight(p_decorate_3_.add(j, 0, k)).getY() + 32);
                DOUBLE_PLANT_GENERATOR.generate(p_decorate_1_, p_decorate_2_, p_decorate_3_.add(j, l, k));
            }
        }
        super.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
    }

    @Override
    public Class<? extends Biome> getBiomeClass() {
        return BiomeSavanna.class;
    }
}

