/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import java.util.Random;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeSwamp
extends Biome {
    protected static final IBlockState WATER_LILY = Blocks.WATERLILY.getDefaultState();

    protected BiomeSwamp(Biome.BiomeProperties p_i46695_1_) {
        super(p_i46695_1_);
        this.theBiomeDecorator.treesPerChunk = 2;
        this.theBiomeDecorator.flowersPerChunk = 1;
        this.theBiomeDecorator.deadBushPerChunk = 1;
        this.theBiomeDecorator.mushroomsPerChunk = 8;
        this.theBiomeDecorator.reedsPerChunk = 10;
        this.theBiomeDecorator.clayPerChunk = 1;
        this.theBiomeDecorator.waterlilyPerChunk = 4;
        this.theBiomeDecorator.sandPerChunk2 = 0;
        this.theBiomeDecorator.sandPerChunk = 0;
        this.theBiomeDecorator.grassPerChunk = 5;
        this.spawnableMonsterList.add(new Biome.SpawnListEntry(EntitySlime.class, 1, 1, 1));
    }

    @Override
    public WorldGenAbstractTree genBigTreeChance(Random p_genBigTreeChance_1_) {
        return SWAMP_FEATURE;
    }

    @Override
    public BlockFlower.EnumFlowerType pickRandomFlower(Random p_pickRandomFlower_1_, BlockPos p_pickRandomFlower_2_) {
        return BlockFlower.EnumFlowerType.BLUE_ORCHID;
    }

    @Override
    public void genTerrainBlocks(World p_genTerrainBlocks_1_, Random p_genTerrainBlocks_2_, ChunkPrimer p_genTerrainBlocks_3_, int p_genTerrainBlocks_4_, int p_genTerrainBlocks_5_, double p_genTerrainBlocks_6_) {
        double d0 = GRASS_COLOR_NOISE.getValue((double)p_genTerrainBlocks_4_ * 0.25, (double)p_genTerrainBlocks_5_ * 0.25);
        if (d0 > 0.0) {
            int i = p_genTerrainBlocks_4_ & 0xF;
            int j = p_genTerrainBlocks_5_ & 0xF;
            for (int k = 255; k >= 0; --k) {
                if (p_genTerrainBlocks_3_.getBlockState(j, k, i).getMaterial() == Material.AIR) continue;
                if (k != 62 || p_genTerrainBlocks_3_.getBlockState(j, k, i).getBlock() == Blocks.WATER) break;
                p_genTerrainBlocks_3_.setBlockState(j, k, i, WATER);
                if (!(d0 < 0.12)) break;
                p_genTerrainBlocks_3_.setBlockState(j, k + 1, i, WATER_LILY);
                break;
            }
        }
        this.generateBiomeTerrain(p_genTerrainBlocks_1_, p_genTerrainBlocks_2_, p_genTerrainBlocks_3_, p_genTerrainBlocks_4_, p_genTerrainBlocks_5_, p_genTerrainBlocks_6_);
    }

    @Override
    public void decorate(World p_decorate_1_, Random p_decorate_2_, BlockPos p_decorate_3_) {
        super.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
        if (TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.FOSSIL) && p_decorate_2_.nextInt(64) == 0) {
            new WorldGenFossils().generate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGrassColorAtPos(BlockPos p_getGrassColorAtPos_1_) {
        double d0 = GRASS_COLOR_NOISE.getValue((double)p_getGrassColorAtPos_1_.getX() * 0.0225, (double)p_getGrassColorAtPos_1_.getZ() * 0.0225);
        return d0 < -0.1 ? 5011004 : 6975545;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getFoliageColorAtPos(BlockPos p_getFoliageColorAtPos_1_) {
        return 6975545;
    }

    @Override
    public void addDefaultFlowers() {
        this.addFlower(Blocks.RED_FLOWER.getDefaultState().withProperty(Blocks.RED_FLOWER.getTypeProperty(), BlockFlower.EnumFlowerType.BLUE_ORCHID), 10);
    }
}

