/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeTaiga
extends Biome {
    private static final WorldGenTaiga1 PINE_GENERATOR = new WorldGenTaiga1();
    private static final WorldGenTaiga2 SPRUCE_GENERATOR = new WorldGenTaiga2(false);
    private static final WorldGenMegaPineTree MEGA_PINE_GENERATOR = new WorldGenMegaPineTree(false, false);
    private static final WorldGenMegaPineTree MEGA_SPRUCE_GENERATOR = new WorldGenMegaPineTree(false, true);
    private static final WorldGenBlockBlob FOREST_ROCK_GENERATOR = new WorldGenBlockBlob(Blocks.MOSSY_COBBLESTONE, 0);
    private final Type type;

    public BiomeTaiga(Type p_i46694_1_, Biome.BiomeProperties p_i46694_2_) {
        super(p_i46694_2_);
        this.type = p_i46694_1_;
        this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityWolf.class, 8, 4, 4));
        this.spawnableCreatureList.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        this.theBiomeDecorator.treesPerChunk = 10;
        if (p_i46694_1_ != Type.MEGA && p_i46694_1_ != Type.MEGA_SPRUCE) {
            this.theBiomeDecorator.grassPerChunk = 1;
            this.theBiomeDecorator.mushroomsPerChunk = 1;
        } else {
            this.theBiomeDecorator.grassPerChunk = 7;
            this.theBiomeDecorator.deadBushPerChunk = 1;
            this.theBiomeDecorator.mushroomsPerChunk = 3;
        }
    }

    @Override
    public WorldGenAbstractTree genBigTreeChance(Random p_genBigTreeChance_1_) {
        return (this.type == Type.MEGA || this.type == Type.MEGA_SPRUCE) && p_genBigTreeChance_1_.nextInt(3) == 0 ? (this.type != Type.MEGA_SPRUCE && p_genBigTreeChance_1_.nextInt(13) != 0 ? MEGA_PINE_GENERATOR : MEGA_SPRUCE_GENERATOR) : (p_genBigTreeChance_1_.nextInt(3) == 0 ? PINE_GENERATOR : SPRUCE_GENERATOR);
    }

    @Override
    public WorldGenerator getRandomWorldGenForGrass(Random p_getRandomWorldGenForGrass_1_) {
        return p_getRandomWorldGenForGrass_1_.nextInt(5) > 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    @Override
    public void decorate(World p_decorate_1_, Random p_decorate_2_, BlockPos p_decorate_3_) {
        if ((this.type == Type.MEGA || this.type == Type.MEGA_SPRUCE) && TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.ROCK)) {
            int i = p_decorate_2_.nextInt(3);
            for (int j = 0; j < i; ++j) {
                int k = p_decorate_2_.nextInt(16) + 8;
                int l = p_decorate_2_.nextInt(16) + 8;
                BlockPos blockpos = p_decorate_1_.getHeight(p_decorate_3_.add(k, 0, l));
                FOREST_ROCK_GENERATOR.generate(p_decorate_1_, p_decorate_2_, blockpos);
            }
        }
        DOUBLE_PLANT_GENERATOR.setPlantType(BlockDoublePlant.EnumPlantType.FERN);
        if (TerrainGen.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_, DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            for (int i1 = 0; i1 < 7; ++i1) {
                int j1 = p_decorate_2_.nextInt(16) + 8;
                int k1 = p_decorate_2_.nextInt(16) + 8;
                int l1 = p_decorate_2_.nextInt(p_decorate_1_.getHeight(p_decorate_3_.add(j1, 0, k1)).getY() + 32);
                DOUBLE_PLANT_GENERATOR.generate(p_decorate_1_, p_decorate_2_, p_decorate_3_.add(j1, l1, k1));
            }
        }
        super.decorate(p_decorate_1_, p_decorate_2_, p_decorate_3_);
    }

    @Override
    public void genTerrainBlocks(World p_genTerrainBlocks_1_, Random p_genTerrainBlocks_2_, ChunkPrimer p_genTerrainBlocks_3_, int p_genTerrainBlocks_4_, int p_genTerrainBlocks_5_, double p_genTerrainBlocks_6_) {
        if (this.type == Type.MEGA || this.type == Type.MEGA_SPRUCE) {
            this.topBlock = Blocks.GRASS.getDefaultState();
            this.fillerBlock = Blocks.DIRT.getDefaultState();
            if (p_genTerrainBlocks_6_ > 1.75) {
                this.topBlock = Blocks.DIRT.getDefaultState().withProperty(BlockDirt.VARIANT, BlockDirt.DirtType.COARSE_DIRT);
            } else if (p_genTerrainBlocks_6_ > -0.95) {
                this.topBlock = Blocks.DIRT.getDefaultState().withProperty(BlockDirt.VARIANT, BlockDirt.DirtType.PODZOL);
            }
        }
        this.generateBiomeTerrain(p_genTerrainBlocks_1_, p_genTerrainBlocks_2_, p_genTerrainBlocks_3_, p_genTerrainBlocks_4_, p_genTerrainBlocks_5_, p_genTerrainBlocks_6_);
    }

    public static enum Type {
        NORMAL,
        MEGA,
        MEGA_SPRUCE;

    }
}

