/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.border;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.border.EnumBorderStatus;
import net.minecraft.world.border.IBorderListener;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldBorder {
    private final List<IBorderListener> listeners = Lists.newArrayList();
    private double centerX;
    private double centerZ;
    private double startDiameter;
    private double endDiameter = this.startDiameter = 6.0E7;
    private long endTime;
    private long startTime;
    private int worldSize = 29999984;
    private double damageAmount = 0.2;
    private double damageBuffer = 5.0;
    private int warningTime = 15;
    private int warningDistance = 5;

    public boolean contains(BlockPos p_contains_1_) {
        return (double)(p_contains_1_.getX() + 1) > this.minX() && (double)p_contains_1_.getX() < this.maxX() && (double)(p_contains_1_.getZ() + 1) > this.minZ() && (double)p_contains_1_.getZ() < this.maxZ();
    }

    public boolean contains(ChunkPos p_contains_1_) {
        return (double)p_contains_1_.getXEnd() > this.minX() && (double)p_contains_1_.getXStart() < this.maxX() && (double)p_contains_1_.getZEnd() > this.minZ() && (double)p_contains_1_.getZStart() < this.maxZ();
    }

    public boolean contains(AxisAlignedBB p_contains_1_) {
        return p_contains_1_.maxX > this.minX() && p_contains_1_.minX < this.maxX() && p_contains_1_.maxZ > this.minZ() && p_contains_1_.minZ < this.maxZ();
    }

    public double getClosestDistance(Entity p_getClosestDistance_1_) {
        return this.getClosestDistance(p_getClosestDistance_1_.posX, p_getClosestDistance_1_.posZ);
    }

    public double getClosestDistance(double p_getClosestDistance_1_, double p_getClosestDistance_3_) {
        double d0 = p_getClosestDistance_3_ - this.minZ();
        double d1 = this.maxZ() - p_getClosestDistance_3_;
        double d2 = p_getClosestDistance_1_ - this.minX();
        double d3 = this.maxX() - p_getClosestDistance_1_;
        double d4 = Math.min(d2, d3);
        d4 = Math.min(d4, d0);
        return Math.min(d4, d1);
    }

    public EnumBorderStatus getStatus() {
        return this.endDiameter < this.startDiameter ? EnumBorderStatus.SHRINKING : (this.endDiameter > this.startDiameter ? EnumBorderStatus.GROWING : EnumBorderStatus.STATIONARY);
    }

    public double minX() {
        double d0 = this.getCenterX() - this.getDiameter() / 2.0;
        if (d0 < (double)(-this.worldSize)) {
            d0 = -this.worldSize;
        }
        return d0;
    }

    public double minZ() {
        double d0 = this.getCenterZ() - this.getDiameter() / 2.0;
        if (d0 < (double)(-this.worldSize)) {
            d0 = -this.worldSize;
        }
        return d0;
    }

    public double maxX() {
        double d0 = this.getCenterX() + this.getDiameter() / 2.0;
        if (d0 > (double)this.worldSize) {
            d0 = this.worldSize;
        }
        return d0;
    }

    public double maxZ() {
        double d0 = this.getCenterZ() + this.getDiameter() / 2.0;
        if (d0 > (double)this.worldSize) {
            d0 = this.worldSize;
        }
        return d0;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public void setCenter(double p_setCenter_1_, double p_setCenter_3_) {
        this.centerX = p_setCenter_1_;
        this.centerZ = p_setCenter_3_;
        for (IBorderListener iborderlistener : this.getListeners()) {
            iborderlistener.onCenterChanged(this, p_setCenter_1_, p_setCenter_3_);
        }
    }

    public double getDiameter() {
        if (this.getStatus() != EnumBorderStatus.STATIONARY) {
            double d0 = (float)(System.currentTimeMillis() - this.startTime) / (float)(this.endTime - this.startTime);
            if (d0 < 1.0) {
                return this.startDiameter + (this.endDiameter - this.startDiameter) * d0;
            }
            this.setTransition(this.endDiameter);
        }
        return this.startDiameter;
    }

    public long getTimeUntilTarget() {
        return this.getStatus() == EnumBorderStatus.STATIONARY ? 0L : this.endTime - System.currentTimeMillis();
    }

    public double getTargetSize() {
        return this.endDiameter;
    }

    public void setTransition(double p_setTransition_1_) {
        this.startDiameter = p_setTransition_1_;
        this.endDiameter = p_setTransition_1_;
        this.startTime = this.endTime = System.currentTimeMillis();
        for (IBorderListener iborderlistener : this.getListeners()) {
            iborderlistener.onSizeChanged(this, p_setTransition_1_);
        }
    }

    public void setTransition(double p_setTransition_1_, double p_setTransition_3_, long p_setTransition_5_) {
        this.startDiameter = p_setTransition_1_;
        this.endDiameter = p_setTransition_3_;
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + p_setTransition_5_;
        for (IBorderListener iborderlistener : this.getListeners()) {
            iborderlistener.onTransitionStarted(this, p_setTransition_1_, p_setTransition_3_, p_setTransition_5_);
        }
    }

    protected List<IBorderListener> getListeners() {
        return Lists.newArrayList(this.listeners);
    }

    public void addListener(IBorderListener p_addListener_1_) {
        this.listeners.add(p_addListener_1_);
    }

    public void setSize(int p_setSize_1_) {
        this.worldSize = p_setSize_1_;
    }

    public int getSize() {
        return this.worldSize;
    }

    public double getDamageBuffer() {
        return this.damageBuffer;
    }

    public void setDamageBuffer(double p_setDamageBuffer_1_) {
        this.damageBuffer = p_setDamageBuffer_1_;
        for (IBorderListener iborderlistener : this.getListeners()) {
            iborderlistener.onDamageBufferChanged(this, p_setDamageBuffer_1_);
        }
    }

    public double getDamageAmount() {
        return this.damageAmount;
    }

    public void setDamageAmount(double p_setDamageAmount_1_) {
        this.damageAmount = p_setDamageAmount_1_;
        for (IBorderListener iborderlistener : this.getListeners()) {
            iborderlistener.onDamageAmountChanged(this, p_setDamageAmount_1_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double getResizeSpeed() {
        return this.endTime == this.startTime ? 0.0 : Math.abs(this.startDiameter - this.endDiameter) / (double)(this.endTime - this.startTime);
    }

    public int getWarningTime() {
        return this.warningTime;
    }

    public void setWarningTime(int p_setWarningTime_1_) {
        this.warningTime = p_setWarningTime_1_;
        for (IBorderListener iborderlistener : this.getListeners()) {
            iborderlistener.onWarningTimeChanged(this, p_setWarningTime_1_);
        }
    }

    public int getWarningDistance() {
        return this.warningDistance;
    }

    public void setWarningDistance(int p_setWarningDistance_1_) {
        this.warningDistance = p_setWarningDistance_1_;
        for (IBorderListener iborderlistener : this.getListeners()) {
            iborderlistener.onWarningDistanceChanged(this, p_setWarningDistance_1_);
        }
    }

    public void removeListener(IBorderListener p_removeListener_1_) {
        this.listeners.remove(p_removeListener_1_);
    }
}

