/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BitArray;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.BlockStatePaletteHashMap;
import net.minecraft.world.chunk.BlockStatePaletteLinear;
import net.minecraft.world.chunk.BlockStatePaletteRegistry;
import net.minecraft.world.chunk.IBlockStatePalette;
import net.minecraft.world.chunk.IBlockStatePaletteResizer;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStateContainer
implements IBlockStatePaletteResizer {
    private static final IBlockStatePalette REGISTRY_BASED_PALETTE = new BlockStatePaletteRegistry();
    protected static final IBlockState AIR_BLOCK_STATE = Blocks.AIR.getDefaultState();
    protected BitArray storage;
    protected IBlockStatePalette palette;
    private int bits;

    public BlockStateContainer() {
        this.setBits(4);
    }

    private static int getIndex(int p_getIndex_0_, int p_getIndex_1_, int p_getIndex_2_) {
        return p_getIndex_1_ << 8 | p_getIndex_2_ << 4 | p_getIndex_0_;
    }

    private void setBits(int p_setBits_1_) {
        this.setBits(p_setBits_1_, false);
    }

    private void setBits(int p_setBits_1_, boolean p_setBits_2_) {
        if (p_setBits_1_ != this.bits) {
            this.bits = p_setBits_1_;
            if (this.bits <= 4) {
                this.bits = 4;
                this.palette = new BlockStatePaletteLinear(this.bits, this);
            } else if (this.bits <= 8) {
                this.palette = new BlockStatePaletteHashMap(this.bits, this);
            } else {
                this.palette = REGISTRY_BASED_PALETTE;
                this.bits = MathHelper.log2DeBruijn(Block.BLOCK_STATE_IDS.size());
                if (p_setBits_2_) {
                    this.bits = p_setBits_1_;
                }
            }
            this.palette.idFor(AIR_BLOCK_STATE);
            this.storage = new BitArray(this.bits, 4096);
        }
    }

    @Override
    public int onResize(int p_onResize_1_, IBlockState p_onResize_2_) {
        BitArray bitarray = this.storage;
        IBlockStatePalette iblockstatepalette = this.palette;
        this.setBits(p_onResize_1_);
        for (int i = 0; i < bitarray.size(); ++i) {
            IBlockState iblockstate = iblockstatepalette.getBlockState(bitarray.getAt(i));
            if (iblockstate == null) continue;
            this.set(i, iblockstate);
        }
        return this.palette.idFor(p_onResize_2_);
    }

    public void set(int p_set_1_, int p_set_2_, int p_set_3_, IBlockState p_set_4_) {
        this.set(BlockStateContainer.getIndex(p_set_1_, p_set_2_, p_set_3_), p_set_4_);
    }

    protected void set(int p_set_1_, IBlockState p_set_2_) {
        int i = this.palette.idFor(p_set_2_);
        this.storage.setAt(p_set_1_, i);
    }

    public IBlockState get(int p_get_1_, int p_get_2_, int p_get_3_) {
        return this.get(BlockStateContainer.getIndex(p_get_1_, p_get_2_, p_get_3_));
    }

    protected IBlockState get(int p_get_1_) {
        IBlockState iblockstate = this.palette.getBlockState(this.storage.getAt(p_get_1_));
        return iblockstate == null ? AIR_BLOCK_STATE : iblockstate;
    }

    @SideOnly(value=Side.CLIENT)
    public void read(PacketBuffer p_read_1_) {
        byte i = p_read_1_.readByte();
        if (this.bits != i) {
            this.setBits(i, true);
        }
        this.palette.read(p_read_1_);
        p_read_1_.readLongArray(this.storage.getBackingLongArray());
        int regSize = MathHelper.log2DeBruijn(Block.BLOCK_STATE_IDS.size());
        if (this.palette == REGISTRY_BASED_PALETTE && this.bits != regSize) {
            this.onResize(regSize, AIR_BLOCK_STATE);
        }
    }

    public void write(PacketBuffer p_write_1_) {
        p_write_1_.writeByte(this.bits);
        this.palette.write(p_write_1_);
        p_write_1_.writeLongArray(this.storage.getBackingLongArray());
    }

    @Nullable
    public NibbleArray getDataForNBT(byte[] p_getDataForNBT_1_, NibbleArray p_getDataForNBT_2_) {
        NibbleArray nibblearray = null;
        for (int i = 0; i < 4096; ++i) {
            int j = Block.BLOCK_STATE_IDS.get(this.get(i));
            int k = i & 0xF;
            int l = i >> 8 & 0xF;
            int i1 = i >> 4 & 0xF;
            if ((j >> 12 & 0xF) != 0) {
                if (nibblearray == null) {
                    nibblearray = new NibbleArray();
                }
                nibblearray.set(k, l, i1, j >> 12 & 0xF);
            }
            p_getDataForNBT_1_[i] = (byte)(j >> 4 & 0xFF);
            p_getDataForNBT_2_.set(k, l, i1, j & 0xF);
        }
        return nibblearray;
    }

    public void setDataFromNBT(byte[] p_setDataFromNBT_1_, NibbleArray p_setDataFromNBT_2_, NibbleArray p_setDataFromNBT_3_) {
        for (int i = 0; i < 4096; ++i) {
            int j = i & 0xF;
            int k = i >> 8 & 0xF;
            int l = i >> 4 & 0xF;
            int i1 = p_setDataFromNBT_3_ == null ? 0 : p_setDataFromNBT_3_.get(j, k, l);
            int j1 = i1 << 12 | (p_setDataFromNBT_1_[i] & 0xFF) << 4 | p_setDataFromNBT_2_.get(j, k, l);
            this.set(i, Block.BLOCK_STATE_IDS.getByValue(j1));
        }
    }

    public int getSerializedSize() {
        return 1 + this.palette.getSerializedState() + PacketBuffer.getVarIntSize(this.storage.size()) + this.storage.getBackingLongArray().length * 8;
    }
}

