/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderDebug;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Chunk {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ExtendedBlockStorage NULL_BLOCK_STORAGE = null;
    private final ExtendedBlockStorage[] storageArrays = new ExtendedBlockStorage[16];
    private final byte[] blockBiomeArray = new byte[256];
    private final int[] precipitationHeightMap = new int[256];
    private final boolean[] updateSkylightColumns = new boolean[256];
    private boolean isChunkLoaded;
    private final World world;
    private final int[] heightMap;
    public final int xPosition;
    public final int zPosition;
    private boolean isGapLightingUpdated;
    private final Map<BlockPos, TileEntity> chunkTileEntityMap = Maps.newHashMap();
    private final ClassInheritanceMultiMap<Entity>[] entityLists;
    private boolean isTerrainPopulated;
    private boolean isLightPopulated;
    private boolean chunkTicked;
    private boolean isModified;
    private boolean hasEntities;
    private long lastSaveTime;
    private int heightMapMinimum;
    private long inhabitedTime;
    private int queuedLightChecks = 4096;
    private final ConcurrentLinkedQueue<BlockPos> tileEntityPosQueue = Queues.newConcurrentLinkedQueue();
    public boolean unloaded;

    public Chunk(World p_i1995_1_, int p_i1995_2_, int p_i1995_3_) {
        this.entityLists = new ClassInheritanceMultiMap[16];
        this.world = p_i1995_1_;
        this.xPosition = p_i1995_2_;
        this.zPosition = p_i1995_3_;
        this.heightMap = new int[256];
        for (int i = 0; i < this.entityLists.length; ++i) {
            this.entityLists[i] = new ClassInheritanceMultiMap<Entity>(Entity.class);
        }
        Arrays.fill(this.precipitationHeightMap, -999);
        Arrays.fill(this.blockBiomeArray, (byte)-1);
    }

    public Chunk(World p_i45645_1_, ChunkPrimer p_i45645_2_, int p_i45645_3_, int p_i45645_4_) {
        this(p_i45645_1_, p_i45645_3_, p_i45645_4_);
        int i = 256;
        boolean flag = p_i45645_1_.provider.hasSkyLight();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 256; ++l) {
                    IBlockState iblockstate = p_i45645_2_.getBlockState(j, l, k);
                    if (iblockstate.getMaterial() == Material.AIR) continue;
                    int i1 = l >> 4;
                    if (this.storageArrays[i1] == NULL_BLOCK_STORAGE) {
                        this.storageArrays[i1] = new ExtendedBlockStorage(i1 << 4, flag);
                    }
                    this.storageArrays[i1].set(j, l & 0xF, k, iblockstate);
                }
            }
        }
    }

    public boolean isAtLocation(int p_isAtLocation_1_, int p_isAtLocation_2_) {
        return p_isAtLocation_1_ == this.xPosition && p_isAtLocation_2_ == this.zPosition;
    }

    public int getHeight(BlockPos p_getHeight_1_) {
        return this.getHeightValue(p_getHeight_1_.getX() & 0xF, p_getHeight_1_.getZ() & 0xF);
    }

    public int getHeightValue(int p_getHeightValue_1_, int p_getHeightValue_2_) {
        return this.heightMap[p_getHeightValue_2_ << 4 | p_getHeightValue_1_];
    }

    @Nullable
    private ExtendedBlockStorage getLastExtendedBlockStorage() {
        for (int i = this.storageArrays.length - 1; i >= 0; --i) {
            if (this.storageArrays[i] == NULL_BLOCK_STORAGE) continue;
            return this.storageArrays[i];
        }
        return null;
    }

    public int getTopFilledSegment() {
        ExtendedBlockStorage extendedblockstorage = this.getLastExtendedBlockStorage();
        return extendedblockstorage == null ? 0 : extendedblockstorage.getYLocation();
    }

    public ExtendedBlockStorage[] getBlockStorageArray() {
        return this.storageArrays;
    }

    @SideOnly(value=Side.CLIENT)
    protected void generateHeightMap() {
        int i = this.getTopFilledSegment();
        this.heightMapMinimum = Integer.MAX_VALUE;
        for (int j = 0; j < 16; ++j) {
            block1: for (int k = 0; k < 16; ++k) {
                this.precipitationHeightMap[j + (k << 4)] = -999;
                for (int l = i + 16; l > 0; --l) {
                    IBlockState iblockstate = this.getBlockState(j, l - 1, k);
                    if (this.getBlockLightOpacity(j, l - 1, k) == 0) continue;
                    this.heightMap[k << 4 | j] = l;
                    if (l >= this.heightMapMinimum) continue block1;
                    this.heightMapMinimum = l;
                    continue block1;
                }
            }
        }
        this.isModified = true;
    }

    public void generateSkylightMap() {
        int i = this.getTopFilledSegment();
        this.heightMapMinimum = Integer.MAX_VALUE;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                this.precipitationHeightMap[j + (k << 4)] = -999;
                for (int l = i + 16; l > 0; --l) {
                    if (this.getBlockLightOpacity(j, l - 1, k) == 0) continue;
                    this.heightMap[k << 4 | j] = l;
                    if (l >= this.heightMapMinimum) break;
                    this.heightMapMinimum = l;
                    break;
                }
                if (!this.world.provider.hasSkyLight()) continue;
                int k1 = 15;
                int i1 = i + 16 - 1;
                do {
                    ExtendedBlockStorage extendedblockstorage;
                    int j1;
                    if ((j1 = this.getBlockLightOpacity(j, i1, k)) == 0 && k1 != 15) {
                        j1 = 1;
                    }
                    if ((k1 -= j1) <= 0 || (extendedblockstorage = this.storageArrays[i1 >> 4]) == NULL_BLOCK_STORAGE) continue;
                    extendedblockstorage.setExtSkylightValue(j, i1 & 0xF, k, k1);
                    this.world.notifyLightSet(new BlockPos((this.xPosition << 4) + j, i1, (this.zPosition << 4) + k));
                } while (--i1 > 0 && k1 > 0);
            }
        }
        this.isModified = true;
    }

    private void propagateSkylightOcclusion(int p_propagateSkylightOcclusion_1_, int p_propagateSkylightOcclusion_2_) {
        this.updateSkylightColumns[p_propagateSkylightOcclusion_1_ + p_propagateSkylightOcclusion_2_ * 16] = true;
        this.isGapLightingUpdated = true;
    }

    private void recheckGaps(boolean p_recheckGaps_1_) {
        this.world.theProfiler.startSection("recheckGaps");
        if (this.world.isAreaLoaded(new BlockPos(this.xPosition * 16 + 8, 0, this.zPosition * 16 + 8), 16)) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (!this.updateSkylightColumns[i + j * 16]) continue;
                    this.updateSkylightColumns[i + j * 16] = false;
                    int k = this.getHeightValue(i, j);
                    int l = this.xPosition * 16 + i;
                    int i1 = this.zPosition * 16 + j;
                    int j1 = Integer.MAX_VALUE;
                    for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                        j1 = Math.min(j1, this.world.getChunksLowestHorizon(l + enumfacing.getFrontOffsetX(), i1 + enumfacing.getFrontOffsetZ()));
                    }
                    this.checkSkylightNeighborHeight(l, i1, j1);
                    for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                        this.checkSkylightNeighborHeight(l + enumfacing1.getFrontOffsetX(), i1 + enumfacing1.getFrontOffsetZ(), k);
                    }
                    if (!p_recheckGaps_1_) continue;
                    this.world.theProfiler.endSection();
                    return;
                }
            }
            this.isGapLightingUpdated = false;
        }
        this.world.theProfiler.endSection();
    }

    private void checkSkylightNeighborHeight(int p_checkSkylightNeighborHeight_1_, int p_checkSkylightNeighborHeight_2_, int p_checkSkylightNeighborHeight_3_) {
        int i = this.world.getHeight(new BlockPos(p_checkSkylightNeighborHeight_1_, 0, p_checkSkylightNeighborHeight_2_)).getY();
        if (i > p_checkSkylightNeighborHeight_3_) {
            this.updateSkylightNeighborHeight(p_checkSkylightNeighborHeight_1_, p_checkSkylightNeighborHeight_2_, p_checkSkylightNeighborHeight_3_, i + 1);
        } else if (i < p_checkSkylightNeighborHeight_3_) {
            this.updateSkylightNeighborHeight(p_checkSkylightNeighborHeight_1_, p_checkSkylightNeighborHeight_2_, i, p_checkSkylightNeighborHeight_3_ + 1);
        }
    }

    private void updateSkylightNeighborHeight(int p_updateSkylightNeighborHeight_1_, int p_updateSkylightNeighborHeight_2_, int p_updateSkylightNeighborHeight_3_, int p_updateSkylightNeighborHeight_4_) {
        if (p_updateSkylightNeighborHeight_4_ > p_updateSkylightNeighborHeight_3_ && this.world.isAreaLoaded(new BlockPos(p_updateSkylightNeighborHeight_1_, 0, p_updateSkylightNeighborHeight_2_), 16)) {
            for (int i = p_updateSkylightNeighborHeight_3_; i < p_updateSkylightNeighborHeight_4_; ++i) {
                this.world.checkLightFor(EnumSkyBlock.SKY, new BlockPos(p_updateSkylightNeighborHeight_1_, i, p_updateSkylightNeighborHeight_2_));
            }
            this.isModified = true;
        }
    }

    private void relightBlock(int p_relightBlock_1_, int p_relightBlock_2_, int p_relightBlock_3_) {
        int i;
        int j = i = this.heightMap[p_relightBlock_3_ << 4 | p_relightBlock_1_] & 0xFF;
        if (p_relightBlock_2_ > i) {
            j = p_relightBlock_2_;
        }
        while (j > 0 && this.getBlockLightOpacity(p_relightBlock_1_, j - 1, p_relightBlock_3_) == 0) {
            --j;
        }
        if (j != i) {
            this.world.markBlocksDirtyVertical(p_relightBlock_1_ + this.xPosition * 16, p_relightBlock_3_ + this.zPosition * 16, j, i);
            this.heightMap[p_relightBlock_3_ << 4 | p_relightBlock_1_] = j;
            int k = this.xPosition * 16 + p_relightBlock_1_;
            int l = this.zPosition * 16 + p_relightBlock_3_;
            if (this.world.provider.hasSkyLight()) {
                if (j < i) {
                    for (int j1 = j; j1 < i; ++j1) {
                        ExtendedBlockStorage extendedblockstorage2 = this.storageArrays[j1 >> 4];
                        if (extendedblockstorage2 == NULL_BLOCK_STORAGE) continue;
                        extendedblockstorage2.setExtSkylightValue(p_relightBlock_1_, j1 & 0xF, p_relightBlock_3_, 15);
                        this.world.notifyLightSet(new BlockPos((this.xPosition << 4) + p_relightBlock_1_, j1, (this.zPosition << 4) + p_relightBlock_3_));
                    }
                } else {
                    for (int i1 = i; i1 < j; ++i1) {
                        ExtendedBlockStorage extendedblockstorage = this.storageArrays[i1 >> 4];
                        if (extendedblockstorage == NULL_BLOCK_STORAGE) continue;
                        extendedblockstorage.setExtSkylightValue(p_relightBlock_1_, i1 & 0xF, p_relightBlock_3_, 0);
                        this.world.notifyLightSet(new BlockPos((this.xPosition << 4) + p_relightBlock_1_, i1, (this.zPosition << 4) + p_relightBlock_3_));
                    }
                }
                int k1 = 15;
                while (j > 0 && k1 > 0) {
                    ExtendedBlockStorage extendedblockstorage1;
                    int i2;
                    if ((i2 = this.getBlockLightOpacity(p_relightBlock_1_, --j, p_relightBlock_3_)) == 0) {
                        i2 = 1;
                    }
                    if ((k1 -= i2) < 0) {
                        k1 = 0;
                    }
                    if ((extendedblockstorage1 = this.storageArrays[j >> 4]) == NULL_BLOCK_STORAGE) continue;
                    extendedblockstorage1.setExtSkylightValue(p_relightBlock_1_, j & 0xF, p_relightBlock_3_, k1);
                }
            }
            int l1 = this.heightMap[p_relightBlock_3_ << 4 | p_relightBlock_1_];
            int j2 = i;
            int k2 = l1;
            if (l1 < i) {
                j2 = l1;
                k2 = i;
            }
            if (l1 < this.heightMapMinimum) {
                this.heightMapMinimum = l1;
            }
            if (this.world.provider.hasSkyLight()) {
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    this.updateSkylightNeighborHeight(k + enumfacing.getFrontOffsetX(), l + enumfacing.getFrontOffsetZ(), j2, k2);
                }
                this.updateSkylightNeighborHeight(k, l, j2, k2);
            }
            this.isModified = true;
        }
    }

    public int getBlockLightOpacity(BlockPos p_getBlockLightOpacity_1_) {
        return this.getBlockState(p_getBlockLightOpacity_1_).getLightOpacity(this.world, p_getBlockLightOpacity_1_);
    }

    private int getBlockLightOpacity(int p_getBlockLightOpacity_1_, int p_getBlockLightOpacity_2_, int p_getBlockLightOpacity_3_) {
        IBlockState state = this.getBlockState(p_getBlockLightOpacity_1_, p_getBlockLightOpacity_2_, p_getBlockLightOpacity_3_);
        return !this.isChunkLoaded ? state.getLightOpacity() : state.getLightOpacity(this.world, new BlockPos(this.xPosition << 4 | p_getBlockLightOpacity_1_ & 0xF, p_getBlockLightOpacity_2_, this.zPosition << 4 | p_getBlockLightOpacity_3_ & 0xF));
    }

    public IBlockState getBlockState(BlockPos p_getBlockState_1_) {
        return this.getBlockState(p_getBlockState_1_.getX(), p_getBlockState_1_.getY(), p_getBlockState_1_.getZ());
    }

    public IBlockState getBlockState(final int p_getBlockState_1_, final int p_getBlockState_2_, final int p_getBlockState_3_) {
        if (this.world.getWorldType() == WorldType.DEBUG_WORLD) {
            IBlockState iblockstate = null;
            if (p_getBlockState_2_ == 60) {
                iblockstate = Blocks.BARRIER.getDefaultState();
            }
            if (p_getBlockState_2_ == 70) {
                iblockstate = ChunkProviderDebug.getBlockStateFor(p_getBlockState_1_, p_getBlockState_3_);
            }
            return iblockstate == null ? Blocks.AIR.getDefaultState() : iblockstate;
        }
        try {
            ExtendedBlockStorage extendedblockstorage;
            if (p_getBlockState_2_ >= 0 && p_getBlockState_2_ >> 4 < this.storageArrays.length && (extendedblockstorage = this.storageArrays[p_getBlockState_2_ >> 4]) != NULL_BLOCK_STORAGE) {
                return extendedblockstorage.get(p_getBlockState_1_ & 0xF, p_getBlockState_2_ & 0xF, p_getBlockState_3_ & 0xF);
            }
            return Blocks.AIR.getDefaultState();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Getting block state");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Block being got");
            crashreportcategory.setDetail("Location", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return CrashReportCategory.getCoordinateInfo(p_getBlockState_1_, p_getBlockState_2_, p_getBlockState_3_);
                }
            });
            throw new ReportedException(crashreport);
        }
    }

    @Nullable
    public IBlockState setBlockState(BlockPos p_setBlockState_1_, IBlockState p_setBlockState_2_) {
        TileEntity te;
        int k;
        int l;
        int i = p_setBlockState_1_.getX() & 0xF;
        int j = p_setBlockState_1_.getY();
        if (j >= this.precipitationHeightMap[l = (k = p_setBlockState_1_.getZ() & 0xF) << 4 | i] - 1) {
            this.precipitationHeightMap[l] = -999;
        }
        int i1 = this.heightMap[l];
        IBlockState iblockstate = this.getBlockState(p_setBlockState_1_);
        if (iblockstate == p_setBlockState_2_) {
            return null;
        }
        Block block = p_setBlockState_2_.getBlock();
        Block block1 = iblockstate.getBlock();
        int k1 = iblockstate.getLightOpacity(this.world, p_setBlockState_1_);
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[j >> 4];
        boolean flag = false;
        if (extendedblockstorage == NULL_BLOCK_STORAGE) {
            if (block == Blocks.AIR) {
                return null;
            }
            this.storageArrays[j >> 4] = extendedblockstorage = new ExtendedBlockStorage(j >> 4 << 4, this.world.provider.hasSkyLight());
            flag = j >= i1;
        }
        extendedblockstorage.set(i, j & 0xF, k, p_setBlockState_2_);
        if (!this.world.isRemote) {
            if (block1 != block) {
                block1.breakBlock(this.world, p_setBlockState_1_, iblockstate);
            }
            if ((te = this.getTileEntity(p_setBlockState_1_, EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(this.world, p_setBlockState_1_, iblockstate, p_setBlockState_2_)) {
                this.world.removeTileEntity(p_setBlockState_1_);
            }
        } else if (block1.hasTileEntity(iblockstate) && (te = this.getTileEntity(p_setBlockState_1_, EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(this.world, p_setBlockState_1_, iblockstate, p_setBlockState_2_)) {
            this.world.removeTileEntity(p_setBlockState_1_);
        }
        if (extendedblockstorage.get(i, j & 0xF, k).getBlock() != block) {
            return null;
        }
        if (flag) {
            this.generateSkylightMap();
        } else {
            int j1 = p_setBlockState_2_.getLightOpacity(this.world, p_setBlockState_1_);
            if (j1 > 0) {
                if (j >= i1) {
                    this.relightBlock(i, j + 1, k);
                }
            } else if (j == i1 - 1) {
                this.relightBlock(i, j, k);
            }
            if (j1 != k1 && (j1 < k1 || this.getLightFor(EnumSkyBlock.SKY, p_setBlockState_1_) > 0 || this.getLightFor(EnumSkyBlock.BLOCK, p_setBlockState_1_) > 0)) {
                this.propagateSkylightOcclusion(i, k);
            }
        }
        if (!(this.world.isRemote || block1 == block || this.world.captureBlockSnapshots && !block.hasTileEntity(p_setBlockState_2_))) {
            block.onBlockAdded(this.world, p_setBlockState_1_, p_setBlockState_2_);
        }
        if (block.hasTileEntity(p_setBlockState_2_)) {
            TileEntity tileentity1 = this.getTileEntity(p_setBlockState_1_, EnumCreateEntityType.CHECK);
            if (tileentity1 == null) {
                tileentity1 = block.createTileEntity(this.world, p_setBlockState_2_);
                this.world.setTileEntity(p_setBlockState_1_, tileentity1);
            }
            if (tileentity1 != null) {
                tileentity1.updateContainingBlockInfo();
            }
        }
        this.isModified = true;
        return iblockstate;
    }

    public int getLightFor(EnumSkyBlock p_getLightFor_1_, BlockPos p_getLightFor_2_) {
        int i = p_getLightFor_2_.getX() & 0xF;
        int j = p_getLightFor_2_.getY();
        int k = p_getLightFor_2_.getZ() & 0xF;
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[j >> 4];
        return extendedblockstorage == NULL_BLOCK_STORAGE ? (this.canSeeSky(p_getLightFor_2_) ? p_getLightFor_1_.defaultLightValue : 0) : (p_getLightFor_1_ == EnumSkyBlock.SKY ? (!this.world.provider.hasSkyLight() ? 0 : extendedblockstorage.getExtSkylightValue(i, j & 0xF, k)) : (p_getLightFor_1_ == EnumSkyBlock.BLOCK ? extendedblockstorage.getExtBlocklightValue(i, j & 0xF, k) : p_getLightFor_1_.defaultLightValue));
    }

    public void setLightFor(EnumSkyBlock p_setLightFor_1_, BlockPos p_setLightFor_2_, int p_setLightFor_3_) {
        int i = p_setLightFor_2_.getX() & 0xF;
        int j = p_setLightFor_2_.getY();
        int k = p_setLightFor_2_.getZ() & 0xF;
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[j >> 4];
        if (extendedblockstorage == NULL_BLOCK_STORAGE) {
            this.storageArrays[j >> 4] = extendedblockstorage = new ExtendedBlockStorage(j >> 4 << 4, this.world.provider.hasSkyLight());
            this.generateSkylightMap();
        }
        this.isModified = true;
        if (p_setLightFor_1_ == EnumSkyBlock.SKY) {
            if (this.world.provider.hasSkyLight()) {
                extendedblockstorage.setExtSkylightValue(i, j & 0xF, k, p_setLightFor_3_);
            }
        } else if (p_setLightFor_1_ == EnumSkyBlock.BLOCK) {
            extendedblockstorage.setExtBlocklightValue(i, j & 0xF, k, p_setLightFor_3_);
        }
    }

    public int getLightSubtracted(BlockPos p_getLightSubtracted_1_, int p_getLightSubtracted_2_) {
        int i = p_getLightSubtracted_1_.getX() & 0xF;
        int j = p_getLightSubtracted_1_.getY();
        int k = p_getLightSubtracted_1_.getZ() & 0xF;
        ExtendedBlockStorage extendedblockstorage = this.storageArrays[j >> 4];
        if (extendedblockstorage == NULL_BLOCK_STORAGE) {
            return this.world.provider.hasSkyLight() && p_getLightSubtracted_2_ < EnumSkyBlock.SKY.defaultLightValue ? EnumSkyBlock.SKY.defaultLightValue - p_getLightSubtracted_2_ : 0;
        }
        int l = !this.world.provider.hasSkyLight() ? 0 : extendedblockstorage.getExtSkylightValue(i, j & 0xF, k);
        int i1 = extendedblockstorage.getExtBlocklightValue(i, j & 0xF, k);
        if (i1 > (l -= p_getLightSubtracted_2_)) {
            l = i1;
        }
        return l;
    }

    public void addEntity(Entity p_addEntity_1_) {
        int k;
        this.hasEntities = true;
        int i = MathHelper.floor(p_addEntity_1_.posX / 16.0);
        int j = MathHelper.floor(p_addEntity_1_.posZ / 16.0);
        if (i != this.xPosition || j != this.zPosition) {
            LOGGER.warn("Wrong location! ({}, {}) should be ({}, {}), {}", new Object[]{i, j, this.xPosition, this.zPosition, p_addEntity_1_});
            p_addEntity_1_.setDead();
        }
        if ((k = MathHelper.floor(p_addEntity_1_.posY / 16.0)) < 0) {
            k = 0;
        }
        if (k >= this.entityLists.length) {
            k = this.entityLists.length - 1;
        }
        MinecraftForge.EVENT_BUS.post(new EntityEvent.EnteringChunk(p_addEntity_1_, this.xPosition, this.zPosition, p_addEntity_1_.chunkCoordX, p_addEntity_1_.chunkCoordZ));
        p_addEntity_1_.addedToChunk = true;
        p_addEntity_1_.chunkCoordX = this.xPosition;
        p_addEntity_1_.chunkCoordY = k;
        p_addEntity_1_.chunkCoordZ = this.zPosition;
        this.entityLists[k].add(p_addEntity_1_);
    }

    public void removeEntity(Entity p_removeEntity_1_) {
        this.removeEntityAtIndex(p_removeEntity_1_, p_removeEntity_1_.chunkCoordY);
    }

    public void removeEntityAtIndex(Entity p_removeEntityAtIndex_1_, int p_removeEntityAtIndex_2_) {
        if (p_removeEntityAtIndex_2_ < 0) {
            p_removeEntityAtIndex_2_ = 0;
        }
        if (p_removeEntityAtIndex_2_ >= this.entityLists.length) {
            p_removeEntityAtIndex_2_ = this.entityLists.length - 1;
        }
        this.entityLists[p_removeEntityAtIndex_2_].remove(p_removeEntityAtIndex_1_);
    }

    public boolean canSeeSky(BlockPos p_canSeeSky_1_) {
        int k;
        int i = p_canSeeSky_1_.getX() & 0xF;
        int j = p_canSeeSky_1_.getY();
        return j >= this.heightMap[(k = p_canSeeSky_1_.getZ() & 0xF) << 4 | i];
    }

    @Nullable
    private TileEntity createNewTileEntity(BlockPos p_createNewTileEntity_1_) {
        IBlockState iblockstate = this.getBlockState(p_createNewTileEntity_1_);
        Block block = iblockstate.getBlock();
        return !block.hasTileEntity(iblockstate) ? null : block.createTileEntity(this.world, iblockstate);
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos p_getTileEntity_1_, EnumCreateEntityType p_getTileEntity_2_) {
        TileEntity tileentity = this.chunkTileEntityMap.get(p_getTileEntity_1_);
        if (tileentity != null && tileentity.isInvalid()) {
            this.chunkTileEntityMap.remove(p_getTileEntity_1_);
            tileentity = null;
        }
        if (tileentity == null) {
            if (p_getTileEntity_2_ == EnumCreateEntityType.IMMEDIATE) {
                tileentity = this.createNewTileEntity(p_getTileEntity_1_);
                this.world.setTileEntity(p_getTileEntity_1_, tileentity);
            } else if (p_getTileEntity_2_ == EnumCreateEntityType.QUEUED) {
                this.tileEntityPosQueue.add(p_getTileEntity_1_.toImmutable());
            }
        }
        return tileentity;
    }

    public void addTileEntity(TileEntity p_addTileEntity_1_) {
        this.addTileEntity(p_addTileEntity_1_.getPos(), p_addTileEntity_1_);
        if (this.isChunkLoaded) {
            this.world.addTileEntity(p_addTileEntity_1_);
        }
    }

    public void addTileEntity(BlockPos p_addTileEntity_1_, TileEntity p_addTileEntity_2_) {
        if (p_addTileEntity_2_.getWorld() != this.world) {
            p_addTileEntity_2_.setWorld(this.world);
        }
        p_addTileEntity_2_.setPos(p_addTileEntity_1_);
        if (this.getBlockState(p_addTileEntity_1_).getBlock().hasTileEntity(this.getBlockState(p_addTileEntity_1_))) {
            if (this.chunkTileEntityMap.containsKey(p_addTileEntity_1_)) {
                this.chunkTileEntityMap.get(p_addTileEntity_1_).invalidate();
            }
            p_addTileEntity_2_.validate();
            this.chunkTileEntityMap.put(p_addTileEntity_1_, p_addTileEntity_2_);
            p_addTileEntity_2_.onLoad();
        }
    }

    public void removeTileEntity(BlockPos p_removeTileEntity_1_) {
        TileEntity tileentity;
        if (this.isChunkLoaded && (tileentity = this.chunkTileEntityMap.remove(p_removeTileEntity_1_)) != null) {
            tileentity.invalidate();
        }
    }

    public void onChunkLoad() {
        this.isChunkLoaded = true;
        this.world.addTileEntities(this.chunkTileEntityMap.values());
        for (ClassInheritanceMultiMap<Entity> classinheritancemultimap : this.entityLists) {
            this.world.loadEntities((Collection<Entity>)ImmutableList.copyOf(classinheritancemultimap));
        }
        MinecraftForge.EVENT_BUS.post(new ChunkEvent.Load(this));
    }

    public void onChunkUnload() {
        this.isChunkLoaded = false;
        for (TileEntity tileentity : this.chunkTileEntityMap.values()) {
            this.world.markTileEntityForRemoval(tileentity);
        }
        for (ClassInheritanceMultiMap<Entity> classinheritancemultimap : this.entityLists) {
            this.world.unloadEntities(classinheritancemultimap);
        }
        MinecraftForge.EVENT_BUS.post(new ChunkEvent.Unload(this));
    }

    public void setChunkModified() {
        this.isModified = true;
    }

    public void getEntitiesWithinAABBForEntity(Entity p_getEntitiesWithinAABBForEntity_1_, AxisAlignedBB p_getEntitiesWithinAABBForEntity_2_, List<Entity> p_getEntitiesWithinAABBForEntity_3_, Predicate<? super Entity> p_getEntitiesWithinAABBForEntity_4_) {
        int i = MathHelper.floor((p_getEntitiesWithinAABBForEntity_2_.minY - World.MAX_ENTITY_RADIUS) / 16.0);
        int j = MathHelper.floor((p_getEntitiesWithinAABBForEntity_2_.maxY + World.MAX_ENTITY_RADIUS) / 16.0);
        i = MathHelper.clamp(i, 0, this.entityLists.length - 1);
        j = MathHelper.clamp(j, 0, this.entityLists.length - 1);
        for (int k = i; k <= j; ++k) {
            if (this.entityLists[k].isEmpty()) continue;
            for (Entity entity : this.entityLists[k]) {
                Entity[] aentity;
                if (!entity.getEntityBoundingBox().intersectsWith(p_getEntitiesWithinAABBForEntity_2_) || entity == p_getEntitiesWithinAABBForEntity_1_) continue;
                if (p_getEntitiesWithinAABBForEntity_4_ == null || p_getEntitiesWithinAABBForEntity_4_.apply((Object)entity)) {
                    p_getEntitiesWithinAABBForEntity_3_.add(entity);
                }
                if ((aentity = entity.getParts()) == null) continue;
                for (Entity entity1 : aentity) {
                    if (entity1 == p_getEntitiesWithinAABBForEntity_1_ || !entity1.getEntityBoundingBox().intersectsWith(p_getEntitiesWithinAABBForEntity_2_) || p_getEntitiesWithinAABBForEntity_4_ != null && !p_getEntitiesWithinAABBForEntity_4_.apply((Object)entity1)) continue;
                    p_getEntitiesWithinAABBForEntity_3_.add(entity1);
                }
            }
        }
    }

    public <T extends Entity> void getEntitiesOfTypeWithinAAAB(Class<? extends T> p_getEntitiesOfTypeWithinAAAB_1_, AxisAlignedBB p_getEntitiesOfTypeWithinAAAB_2_, List<T> p_getEntitiesOfTypeWithinAAAB_3_, Predicate<? super T> p_getEntitiesOfTypeWithinAAAB_4_) {
        int i = MathHelper.floor((p_getEntitiesOfTypeWithinAAAB_2_.minY - World.MAX_ENTITY_RADIUS) / 16.0);
        int j = MathHelper.floor((p_getEntitiesOfTypeWithinAAAB_2_.maxY + World.MAX_ENTITY_RADIUS) / 16.0);
        i = MathHelper.clamp(i, 0, this.entityLists.length - 1);
        j = MathHelper.clamp(j, 0, this.entityLists.length - 1);
        for (int k = i; k <= j; ++k) {
            for (Entity t : this.entityLists[k].getByClass(p_getEntitiesOfTypeWithinAAAB_1_)) {
                if (!t.getEntityBoundingBox().intersectsWith(p_getEntitiesOfTypeWithinAAAB_2_) || p_getEntitiesOfTypeWithinAAAB_4_ != null && !p_getEntitiesOfTypeWithinAAAB_4_.apply((Object)t)) continue;
                p_getEntitiesOfTypeWithinAAAB_3_.add(t);
            }
        }
    }

    public boolean needsSaving(boolean p_needsSaving_1_) {
        if (p_needsSaving_1_ ? this.hasEntities && this.world.getTotalWorldTime() != this.lastSaveTime || this.isModified : this.hasEntities && this.world.getTotalWorldTime() >= this.lastSaveTime + 600L) {
            return true;
        }
        return this.isModified;
    }

    public Random getRandomWithSeed(long p_getRandomWithSeed_1_) {
        return new Random(this.world.getSeed() + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ p_getRandomWithSeed_1_);
    }

    public boolean isEmpty() {
        return false;
    }

    public void populateChunk(IChunkProvider p_populateChunk_1_, IChunkGenerator p_populateChunk_2_) {
        Chunk chunk4;
        Chunk chunk = p_populateChunk_1_.getLoadedChunk(this.xPosition, this.zPosition - 1);
        Chunk chunk1 = p_populateChunk_1_.getLoadedChunk(this.xPosition + 1, this.zPosition);
        Chunk chunk2 = p_populateChunk_1_.getLoadedChunk(this.xPosition, this.zPosition + 1);
        Chunk chunk3 = p_populateChunk_1_.getLoadedChunk(this.xPosition - 1, this.zPosition);
        if (chunk1 != null && chunk2 != null && p_populateChunk_1_.getLoadedChunk(this.xPosition + 1, this.zPosition + 1) != null) {
            this.populateChunk(p_populateChunk_2_);
        }
        if (chunk3 != null && chunk2 != null && p_populateChunk_1_.getLoadedChunk(this.xPosition - 1, this.zPosition + 1) != null) {
            chunk3.populateChunk(p_populateChunk_2_);
        }
        if (chunk != null && chunk1 != null && p_populateChunk_1_.getLoadedChunk(this.xPosition + 1, this.zPosition - 1) != null) {
            chunk.populateChunk(p_populateChunk_2_);
        }
        if (chunk != null && chunk3 != null && (chunk4 = p_populateChunk_1_.getLoadedChunk(this.xPosition - 1, this.zPosition - 1)) != null) {
            chunk4.populateChunk(p_populateChunk_2_);
        }
    }

    protected void populateChunk(IChunkGenerator p_populateChunk_1_) {
        if (this.isTerrainPopulated()) {
            if (p_populateChunk_1_.generateStructures(this, this.xPosition, this.zPosition)) {
                this.setChunkModified();
            }
        } else {
            this.checkLight();
            p_populateChunk_1_.populate(this.xPosition, this.zPosition);
            GameRegistry.generateWorld(this.xPosition, this.zPosition, this.world, p_populateChunk_1_, this.world.getChunkProvider());
            this.setChunkModified();
        }
    }

    public BlockPos getPrecipitationHeight(BlockPos p_getPrecipitationHeight_1_) {
        int i = p_getPrecipitationHeight_1_.getX() & 0xF;
        int j = p_getPrecipitationHeight_1_.getZ() & 0xF;
        int k = i | j << 4;
        BlockPos blockpos = new BlockPos(p_getPrecipitationHeight_1_.getX(), this.precipitationHeightMap[k], p_getPrecipitationHeight_1_.getZ());
        if (blockpos.getY() == -999) {
            int l = this.getTopFilledSegment() + 15;
            blockpos = new BlockPos(p_getPrecipitationHeight_1_.getX(), l, p_getPrecipitationHeight_1_.getZ());
            int i1 = -1;
            while (blockpos.getY() > 0 && i1 == -1) {
                IBlockState iblockstate = this.getBlockState(blockpos);
                Material material = iblockstate.getMaterial();
                if (!material.blocksMovement() && !material.isLiquid()) {
                    blockpos = blockpos.down();
                    continue;
                }
                i1 = blockpos.getY() + 1;
            }
            this.precipitationHeightMap[k] = i1;
        }
        return new BlockPos(p_getPrecipitationHeight_1_.getX(), this.precipitationHeightMap[k], p_getPrecipitationHeight_1_.getZ());
    }

    public void onTick(boolean p_onTick_1_) {
        if (this.isGapLightingUpdated && this.world.provider.hasSkyLight() && !p_onTick_1_) {
            this.recheckGaps(this.world.isRemote);
        }
        this.chunkTicked = true;
        if (!this.isLightPopulated && this.isTerrainPopulated) {
            this.checkLight();
        }
        while (!this.tileEntityPosQueue.isEmpty()) {
            BlockPos blockpos = this.tileEntityPosQueue.poll();
            if (this.getTileEntity(blockpos, EnumCreateEntityType.CHECK) != null || !this.getBlockState(blockpos).getBlock().hasTileEntity(this.getBlockState(blockpos))) continue;
            TileEntity tileentity = this.createNewTileEntity(blockpos);
            this.world.setTileEntity(blockpos, tileentity);
            this.world.markBlockRangeForRenderUpdate(blockpos, blockpos);
        }
    }

    public boolean isPopulated() {
        return this.chunkTicked && this.isTerrainPopulated && this.isLightPopulated;
    }

    public boolean isChunkTicked() {
        return this.chunkTicked;
    }

    public ChunkPos getPos() {
        return new ChunkPos(this.xPosition, this.zPosition);
    }

    public boolean getAreLevelsEmpty(int p_getAreLevelsEmpty_1_, int p_getAreLevelsEmpty_2_) {
        if (p_getAreLevelsEmpty_1_ < 0) {
            p_getAreLevelsEmpty_1_ = 0;
        }
        if (p_getAreLevelsEmpty_2_ >= 256) {
            p_getAreLevelsEmpty_2_ = 255;
        }
        for (int i = p_getAreLevelsEmpty_1_; i <= p_getAreLevelsEmpty_2_; i += 16) {
            ExtendedBlockStorage extendedblockstorage = this.storageArrays[i >> 4];
            if (extendedblockstorage == NULL_BLOCK_STORAGE || extendedblockstorage.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setStorageArrays(ExtendedBlockStorage[] p_setStorageArrays_1_) {
        if (this.storageArrays.length != p_setStorageArrays_1_.length) {
            LOGGER.warn("Could not set level chunk sections, array length is {} instead of {}", new Object[]{p_setStorageArrays_1_.length, this.storageArrays.length});
        } else {
            System.arraycopy(p_setStorageArrays_1_, 0, this.storageArrays, 0, this.storageArrays.length);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void fillChunk(PacketBuffer p_fillChunk_1_, int p_fillChunk_2_, boolean p_fillChunk_3_) {
        for (TileEntity tileEntity : this.chunkTileEntityMap.values()) {
            tileEntity.updateContainingBlockInfo();
            tileEntity.getBlockMetadata();
            tileEntity.getBlockType();
        }
        boolean flag = this.world.provider.hasSkyLight();
        for (int i = 0; i < this.storageArrays.length; ++i) {
            ExtendedBlockStorage extendedblockstorage = this.storageArrays[i];
            if ((p_fillChunk_2_ & 1 << i) == 0) {
                if (!p_fillChunk_3_ || extendedblockstorage == NULL_BLOCK_STORAGE) continue;
                this.storageArrays[i] = NULL_BLOCK_STORAGE;
                continue;
            }
            if (extendedblockstorage == NULL_BLOCK_STORAGE) {
                this.storageArrays[i] = extendedblockstorage = new ExtendedBlockStorage(i << 4, flag);
            }
            extendedblockstorage.getData().read(p_fillChunk_1_);
            p_fillChunk_1_.readBytes(extendedblockstorage.getBlocklightArray().getData());
            if (!flag) continue;
            p_fillChunk_1_.readBytes(extendedblockstorage.getSkylightArray().getData());
        }
        if (p_fillChunk_3_) {
            p_fillChunk_1_.readBytes(this.blockBiomeArray);
        }
        for (int j = 0; j < this.storageArrays.length; ++j) {
            if (this.storageArrays[j] == NULL_BLOCK_STORAGE || (p_fillChunk_2_ & 1 << j) == 0) continue;
            this.storageArrays[j].removeInvalidBlocks();
        }
        this.isLightPopulated = true;
        this.isTerrainPopulated = true;
        this.generateHeightMap();
        ArrayList<TileEntity> invalidList = new ArrayList<TileEntity>();
        for (TileEntity tileentity : this.chunkTileEntityMap.values()) {
            if (tileentity.shouldRefresh(this.world, tileentity.getPos(), tileentity.getBlockType().getStateFromMeta(tileentity.getBlockMetadata()), this.getBlockState(tileentity.getPos()))) {
                invalidList.add(tileentity);
            }
            tileentity.updateContainingBlockInfo();
        }
        for (TileEntity te : invalidList) {
            te.invalidate();
        }
    }

    public Biome getBiome(BlockPos p_getBiome_1_, BiomeProvider p_getBiome_2_) {
        Biome biome1;
        int i = p_getBiome_1_.getX() & 0xF;
        int j = p_getBiome_1_.getZ() & 0xF;
        int k = this.blockBiomeArray[j << 4 | i] & 0xFF;
        if (k == 255) {
            Biome biome = p_getBiome_2_.getBiome(p_getBiome_1_, Biomes.PLAINS);
            k = Biome.getIdForBiome(biome);
            this.blockBiomeArray[j << 4 | i] = (byte)(k & 0xFF);
        }
        return (biome1 = Biome.getBiome(k)) == null ? Biomes.PLAINS : biome1;
    }

    public byte[] getBiomeArray() {
        return this.blockBiomeArray;
    }

    public void setBiomeArray(byte[] p_setBiomeArray_1_) {
        if (this.blockBiomeArray.length != p_setBiomeArray_1_.length) {
            LOGGER.warn("Could not set level chunk biomes, array length is {} instead of {}", new Object[]{p_setBiomeArray_1_.length, this.blockBiomeArray.length});
        } else {
            System.arraycopy(p_setBiomeArray_1_, 0, this.blockBiomeArray, 0, this.blockBiomeArray.length);
        }
    }

    public void resetRelightChecks() {
        this.queuedLightChecks = 0;
    }

    public void enqueueRelightChecks() {
        if (this.queuedLightChecks < 4096) {
            BlockPos blockpos = new BlockPos(this.xPosition << 4, 0, this.zPosition << 4);
            for (int i = 0; i < 8; ++i) {
                if (this.queuedLightChecks >= 4096) {
                    return;
                }
                int j = this.queuedLightChecks % 16;
                int k = this.queuedLightChecks / 16 % 16;
                int l = this.queuedLightChecks / 256;
                ++this.queuedLightChecks;
                for (int i1 = 0; i1 < 16; ++i1) {
                    boolean flag;
                    BlockPos blockpos1 = blockpos.add(k, (j << 4) + i1, l);
                    boolean bl = flag = i1 == 0 || i1 == 15 || k == 0 || k == 15 || l == 0 || l == 15;
                    if ((this.storageArrays[j] != NULL_BLOCK_STORAGE || !flag) && (this.storageArrays[j] == NULL_BLOCK_STORAGE || !this.storageArrays[j].get(k, i1, l).getBlock().isAir(this.storageArrays[j].get(k, i1, l), this.world, blockpos1))) continue;
                    for (EnumFacing enumfacing : EnumFacing.values()) {
                        BlockPos blockpos2 = blockpos1.offset(enumfacing);
                        if (this.world.getBlockState(blockpos2).getLightValue(this.world, blockpos2) <= 0) continue;
                        this.world.checkLight(blockpos2);
                    }
                    this.world.checkLight(blockpos1);
                }
            }
        }
    }

    public void checkLight() {
        this.isTerrainPopulated = true;
        this.isLightPopulated = true;
        BlockPos blockpos = new BlockPos(this.xPosition << 4, 0, this.zPosition << 4);
        if (this.world.provider.hasSkyLight()) {
            if (this.world.isAreaLoaded(blockpos.add(-1, 0, -1), blockpos.add(16, this.world.getSeaLevel(), 16))) {
                block0: for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        if (this.checkLight(i, j)) continue;
                        this.isLightPopulated = false;
                        break block0;
                    }
                }
                if (this.isLightPopulated) {
                    for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                        int k = enumfacing.getAxisDirection() == EnumFacing.AxisDirection.POSITIVE ? 16 : 1;
                        this.world.getChunkFromBlockCoords(blockpos.offset(enumfacing, k)).checkLightSide(enumfacing.getOpposite());
                    }
                    this.setSkylightUpdated();
                }
            } else {
                this.isLightPopulated = false;
            }
        }
    }

    private void setSkylightUpdated() {
        for (int i = 0; i < this.updateSkylightColumns.length; ++i) {
            this.updateSkylightColumns[i] = true;
        }
        this.recheckGaps(false);
    }

    private void checkLightSide(EnumFacing p_checkLightSide_1_) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        if (!this.isTerrainPopulated) break block4;
                        if (p_checkLightSide_1_ != EnumFacing.EAST) break block5;
                        for (int i = 0; i < 16; ++i) {
                            this.checkLight(15, i);
                        }
                        break block4;
                    }
                    if (p_checkLightSide_1_ != EnumFacing.WEST) break block6;
                    for (int j = 0; j < 16; ++j) {
                        this.checkLight(0, j);
                    }
                    break block4;
                }
                if (p_checkLightSide_1_ != EnumFacing.SOUTH) break block7;
                for (int k = 0; k < 16; ++k) {
                    this.checkLight(k, 15);
                }
                break block4;
            }
            if (p_checkLightSide_1_ != EnumFacing.NORTH) break block4;
            for (int l = 0; l < 16; ++l) {
                this.checkLight(l, 0);
            }
        }
    }

    private boolean checkLight(int p_checkLight_1_, int p_checkLight_2_) {
        int i = this.getTopFilledSegment();
        boolean flag = false;
        boolean flag1 = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos((this.xPosition << 4) + p_checkLight_1_, 0, (this.zPosition << 4) + p_checkLight_2_);
        for (int j = i + 16 - 1; j > this.world.getSeaLevel() || j > 0 && !flag1; --j) {
            blockpos$mutableblockpos.setPos(blockpos$mutableblockpos.getX(), j, blockpos$mutableblockpos.getZ());
            int k = this.getBlockLightOpacity(blockpos$mutableblockpos);
            if (k == 255 && blockpos$mutableblockpos.getY() < this.world.getSeaLevel()) {
                flag1 = true;
            }
            if (!flag && k > 0) {
                flag = true;
                continue;
            }
            if (!flag || k != 0 || this.world.checkLight(blockpos$mutableblockpos)) continue;
            return false;
        }
        for (int l = blockpos$mutableblockpos.getY(); l > 0; --l) {
            blockpos$mutableblockpos.setPos(blockpos$mutableblockpos.getX(), l, blockpos$mutableblockpos.getZ());
            if (this.getBlockState(blockpos$mutableblockpos).getLightValue(this.world, blockpos$mutableblockpos) <= 0) continue;
            this.world.checkLight(blockpos$mutableblockpos);
        }
        return true;
    }

    public boolean isLoaded() {
        return this.isChunkLoaded;
    }

    @SideOnly(value=Side.CLIENT)
    public void setChunkLoaded(boolean p_setChunkLoaded_1_) {
        this.isChunkLoaded = p_setChunkLoaded_1_;
    }

    public World getWorld() {
        return this.world;
    }

    public int[] getHeightMap() {
        return this.heightMap;
    }

    public void setHeightMap(int[] p_setHeightMap_1_) {
        if (this.heightMap.length != p_setHeightMap_1_.length) {
            LOGGER.warn("Could not set level chunk heightmap, array length is {} instead of {}", new Object[]{p_setHeightMap_1_.length, this.heightMap.length});
        } else {
            System.arraycopy(p_setHeightMap_1_, 0, this.heightMap, 0, this.heightMap.length);
        }
    }

    public Map<BlockPos, TileEntity> getTileEntityMap() {
        return this.chunkTileEntityMap;
    }

    public ClassInheritanceMultiMap<Entity>[] getEntityLists() {
        return this.entityLists;
    }

    public boolean isTerrainPopulated() {
        return this.isTerrainPopulated;
    }

    public void setTerrainPopulated(boolean p_setTerrainPopulated_1_) {
        this.isTerrainPopulated = p_setTerrainPopulated_1_;
    }

    public boolean isLightPopulated() {
        return this.isLightPopulated;
    }

    public void setLightPopulated(boolean p_setLightPopulated_1_) {
        this.isLightPopulated = p_setLightPopulated_1_;
    }

    public void setModified(boolean p_setModified_1_) {
        this.isModified = p_setModified_1_;
    }

    public void setHasEntities(boolean p_setHasEntities_1_) {
        this.hasEntities = p_setHasEntities_1_;
    }

    public void setLastSaveTime(long p_setLastSaveTime_1_) {
        this.lastSaveTime = p_setLastSaveTime_1_;
    }

    public int getLowestHeight() {
        return this.heightMapMinimum;
    }

    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    public void setInhabitedTime(long p_setInhabitedTime_1_) {
        this.inhabitedTime = p_setInhabitedTime_1_;
    }

    public void removeInvalidTileEntity(BlockPos p_removeInvalidTileEntity_1_) {
        TileEntity entity;
        if (this.isChunkLoaded && (entity = this.chunkTileEntityMap.get(p_removeInvalidTileEntity_1_)) != null && entity.isInvalid()) {
            this.chunkTileEntityMap.remove(p_removeInvalidTileEntity_1_);
        }
    }

    public static enum EnumCreateEntityType {
        IMMEDIATE,
        QUEUED,
        CHECK;

    }
}

