/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EmptyChunk
extends Chunk {
    public EmptyChunk(World p_i1994_1_, int p_i1994_2_, int p_i1994_3_) {
        super(p_i1994_1_, p_i1994_2_, p_i1994_3_);
    }

    @Override
    public boolean isAtLocation(int p_isAtLocation_1_, int p_isAtLocation_2_) {
        return p_isAtLocation_1_ == this.xPosition && p_isAtLocation_2_ == this.zPosition;
    }

    @Override
    public int getHeightValue(int p_getHeightValue_1_, int p_getHeightValue_2_) {
        return 0;
    }

    @Override
    public void generateHeightMap() {
    }

    @Override
    public void generateSkylightMap() {
    }

    @Override
    public IBlockState getBlockState(BlockPos p_getBlockState_1_) {
        return Blocks.AIR.getDefaultState();
    }

    @Override
    public int getBlockLightOpacity(BlockPos p_getBlockLightOpacity_1_) {
        return 255;
    }

    @Override
    public int getLightFor(EnumSkyBlock p_getLightFor_1_, BlockPos p_getLightFor_2_) {
        return p_getLightFor_1_.defaultLightValue;
    }

    @Override
    public void setLightFor(EnumSkyBlock p_setLightFor_1_, BlockPos p_setLightFor_2_, int p_setLightFor_3_) {
    }

    @Override
    public int getLightSubtracted(BlockPos p_getLightSubtracted_1_, int p_getLightSubtracted_2_) {
        return 0;
    }

    @Override
    public void addEntity(Entity p_addEntity_1_) {
    }

    @Override
    public void removeEntity(Entity p_removeEntity_1_) {
    }

    @Override
    public void removeEntityAtIndex(Entity p_removeEntityAtIndex_1_, int p_removeEntityAtIndex_2_) {
    }

    @Override
    public boolean canSeeSky(BlockPos p_canSeeSky_1_) {
        return false;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(BlockPos p_getTileEntity_1_, Chunk.EnumCreateEntityType p_getTileEntity_2_) {
        return null;
    }

    @Override
    public void addTileEntity(TileEntity p_addTileEntity_1_) {
    }

    @Override
    public void addTileEntity(BlockPos p_addTileEntity_1_, TileEntity p_addTileEntity_2_) {
    }

    @Override
    public void removeTileEntity(BlockPos p_removeTileEntity_1_) {
    }

    @Override
    public void onChunkLoad() {
    }

    @Override
    public void onChunkUnload() {
    }

    @Override
    public void setChunkModified() {
    }

    @Override
    public void getEntitiesWithinAABBForEntity(Entity p_getEntitiesWithinAABBForEntity_1_, AxisAlignedBB p_getEntitiesWithinAABBForEntity_2_, List<Entity> p_getEntitiesWithinAABBForEntity_3_, Predicate<? super Entity> p_getEntitiesWithinAABBForEntity_4_) {
    }

    @Override
    public <T extends Entity> void getEntitiesOfTypeWithinAAAB(Class<? extends T> p_getEntitiesOfTypeWithinAAAB_1_, AxisAlignedBB p_getEntitiesOfTypeWithinAAAB_2_, List<T> p_getEntitiesOfTypeWithinAAAB_3_, Predicate<? super T> p_getEntitiesOfTypeWithinAAAB_4_) {
    }

    @Override
    public boolean needsSaving(boolean p_needsSaving_1_) {
        return false;
    }

    @Override
    public Random getRandomWithSeed(long p_getRandomWithSeed_1_) {
        return new Random(this.getWorld().getSeed() + (long)(this.xPosition * this.xPosition * 4987142) + (long)(this.xPosition * 5947611) + (long)(this.zPosition * this.zPosition) * 4392871L + (long)(this.zPosition * 389711) ^ p_getRandomWithSeed_1_);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean getAreLevelsEmpty(int p_getAreLevelsEmpty_1_, int p_getAreLevelsEmpty_2_) {
        return true;
    }
}

