/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

public class NibbleArray {
    private final byte[] data;

    public NibbleArray() {
        this.data = new byte[2048];
    }

    public NibbleArray(byte[] p_i45646_1_) {
        this.data = p_i45646_1_;
        if (p_i45646_1_.length != 2048) {
            throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + p_i45646_1_.length);
        }
    }

    public int get(int p_get_1_, int p_get_2_, int p_get_3_) {
        return this.getFromIndex(this.getCoordinateIndex(p_get_1_, p_get_2_, p_get_3_));
    }

    public void set(int p_set_1_, int p_set_2_, int p_set_3_, int p_set_4_) {
        this.setIndex(this.getCoordinateIndex(p_set_1_, p_set_2_, p_set_3_), p_set_4_);
    }

    private int getCoordinateIndex(int p_getCoordinateIndex_1_, int p_getCoordinateIndex_2_, int p_getCoordinateIndex_3_) {
        return p_getCoordinateIndex_2_ << 8 | p_getCoordinateIndex_3_ << 4 | p_getCoordinateIndex_1_;
    }

    public int getFromIndex(int p_getFromIndex_1_) {
        int lvt_2_1_ = this.getNibbleIndex(p_getFromIndex_1_);
        if (this.isLowerNibble(p_getFromIndex_1_)) {
            return this.data[lvt_2_1_] & 0xF;
        }
        return this.data[lvt_2_1_] >> 4 & 0xF;
    }

    public void setIndex(int p_setIndex_1_, int p_setIndex_2_) {
        int lvt_3_1_ = this.getNibbleIndex(p_setIndex_1_);
        this.data[lvt_3_1_] = this.isLowerNibble(p_setIndex_1_) ? (byte)(this.data[lvt_3_1_] & 0xF0 | p_setIndex_2_ & 0xF) : (byte)(this.data[lvt_3_1_] & 0xF | (p_setIndex_2_ & 0xF) << 4);
    }

    private boolean isLowerNibble(int p_isLowerNibble_1_) {
        return (p_isLowerNibble_1_ & 1) == 0;
    }

    private int getNibbleIndex(int p_getNibbleIndex_1_) {
        return p_getNibbleIndex_1_ >> 1;
    }

    public byte[] getData() {
        return this.data;
    }
}

