/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilChunkLoader
implements IChunkLoader,
IThreadedFileIO {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ChunkPos, NBTTagCompound> chunksToRemove = new ConcurrentHashMap<ChunkPos, NBTTagCompound>();
    private final Set<ChunkPos> pendingAnvilChunksCoordinates = Collections.newSetFromMap(new ConcurrentHashMap());
    public final File chunkSaveLocation;
    private final DataFixer dataFixer;
    private boolean savingExtraData;

    public AnvilChunkLoader(File p_i46673_1_, DataFixer p_i46673_2_) {
        this.chunkSaveLocation = p_i46673_1_;
        this.dataFixer = p_i46673_2_;
    }

    public boolean chunkExists(World p_chunkExists_1_, int p_chunkExists_2_, int p_chunkExists_3_) {
        ChunkPos chunkcoordintpair = new ChunkPos(p_chunkExists_2_, p_chunkExists_3_);
        if (this.pendingAnvilChunksCoordinates.contains(chunkcoordintpair)) {
            for (ChunkPos pendingChunkCoord : this.chunksToRemove.keySet()) {
                if (!pendingChunkCoord.equals(chunkcoordintpair)) continue;
                return true;
            }
        }
        return RegionFileCache.createOrLoadRegionFile(this.chunkSaveLocation, p_chunkExists_2_, p_chunkExists_3_).chunkExists(p_chunkExists_2_ & 0x1F, p_chunkExists_3_ & 0x1F);
    }

    @Override
    @Nullable
    public Chunk loadChunk(World p_loadChunk_1_, int p_loadChunk_2_, int p_loadChunk_3_) throws IOException {
        Object[] data = this.loadChunk__Async(p_loadChunk_1_, p_loadChunk_2_, p_loadChunk_3_);
        if (data != null) {
            Chunk chunk = (Chunk)data[0];
            NBTTagCompound nbttagcompound = (NBTTagCompound)data[1];
            this.loadEntities(p_loadChunk_1_, nbttagcompound.getCompoundTag("Level"), chunk);
            return chunk;
        }
        return null;
    }

    public Object[] loadChunk__Async(World p_loadChunk__Async_1_, int p_loadChunk__Async_2_, int p_loadChunk__Async_3_) throws IOException {
        ChunkPos chunkpos = new ChunkPos(p_loadChunk__Async_2_, p_loadChunk__Async_3_);
        NBTTagCompound nbttagcompound = this.chunksToRemove.get(chunkpos);
        if (nbttagcompound == null) {
            DataInputStream datainputstream = RegionFileCache.getChunkInputStream(this.chunkSaveLocation, p_loadChunk__Async_2_, p_loadChunk__Async_3_);
            if (datainputstream == null) {
                return null;
            }
            nbttagcompound = this.dataFixer.process(FixTypes.CHUNK, CompressedStreamTools.read(datainputstream));
        }
        return this.checkedReadChunkFromNBT__Async(p_loadChunk__Async_1_, p_loadChunk__Async_2_, p_loadChunk__Async_3_, nbttagcompound);
    }

    @Override
    public boolean isChunkGeneratedAt(int p_isChunkGeneratedAt_1_, int p_isChunkGeneratedAt_2_) {
        ChunkPos chunkpos = new ChunkPos(p_isChunkGeneratedAt_1_, p_isChunkGeneratedAt_2_);
        NBTTagCompound nbttagcompound = this.chunksToRemove.get(chunkpos);
        return nbttagcompound != null ? true : RegionFileCache.chunkExists(this.chunkSaveLocation, p_isChunkGeneratedAt_1_, p_isChunkGeneratedAt_2_);
    }

    @Nullable
    protected Chunk checkedReadChunkFromNBT(World p_checkedReadChunkFromNBT_1_, int p_checkedReadChunkFromNBT_2_, int p_checkedReadChunkFromNBT_3_, NBTTagCompound p_checkedReadChunkFromNBT_4_) {
        Object[] data = this.checkedReadChunkFromNBT__Async(p_checkedReadChunkFromNBT_1_, p_checkedReadChunkFromNBT_2_, p_checkedReadChunkFromNBT_3_, p_checkedReadChunkFromNBT_4_);
        return data != null ? (Chunk)data[0] : null;
    }

    protected Object[] checkedReadChunkFromNBT__Async(World p_checkedReadChunkFromNBT__Async_1_, int p_checkedReadChunkFromNBT__Async_2_, int p_checkedReadChunkFromNBT__Async_3_, NBTTagCompound p_checkedReadChunkFromNBT__Async_4_) {
        if (!p_checkedReadChunkFromNBT__Async_4_.hasKey("Level", 10)) {
            LOGGER.error("Chunk file at {},{} is missing level data, skipping", new Object[]{p_checkedReadChunkFromNBT__Async_2_, p_checkedReadChunkFromNBT__Async_3_});
            return null;
        }
        NBTTagCompound nbttagcompound = p_checkedReadChunkFromNBT__Async_4_.getCompoundTag("Level");
        if (!nbttagcompound.hasKey("Sections", 9)) {
            LOGGER.error("Chunk file at {},{} is missing block data, skipping", new Object[]{p_checkedReadChunkFromNBT__Async_2_, p_checkedReadChunkFromNBT__Async_3_});
            return null;
        }
        Chunk chunk = this.readChunkFromNBT(p_checkedReadChunkFromNBT__Async_1_, nbttagcompound);
        if (!chunk.isAtLocation(p_checkedReadChunkFromNBT__Async_2_, p_checkedReadChunkFromNBT__Async_3_)) {
            LOGGER.error("Chunk file at {},{} is in the wrong location; relocating. (Expected {}, {}, got {}, {})", new Object[]{p_checkedReadChunkFromNBT__Async_2_, p_checkedReadChunkFromNBT__Async_3_, p_checkedReadChunkFromNBT__Async_2_, p_checkedReadChunkFromNBT__Async_3_, chunk.xPosition, chunk.zPosition});
            nbttagcompound.setInteger("xPos", p_checkedReadChunkFromNBT__Async_2_);
            nbttagcompound.setInteger("zPos", p_checkedReadChunkFromNBT__Async_3_);
            NBTTagList _tileEntities = nbttagcompound.getTagList("TileEntities", 10);
            if (_tileEntities != null) {
                for (int te = 0; te < _tileEntities.tagCount(); ++te) {
                    NBTTagCompound _nbt = _tileEntities.getCompoundTagAt(te);
                    _nbt.setInteger("x", p_checkedReadChunkFromNBT__Async_2_ * 16 + (_nbt.getInteger("x") - chunk.xPosition * 16));
                    _nbt.setInteger("z", p_checkedReadChunkFromNBT__Async_3_ * 16 + (_nbt.getInteger("z") - chunk.zPosition * 16));
                }
            }
            chunk = this.readChunkFromNBT(p_checkedReadChunkFromNBT__Async_1_, nbttagcompound);
        }
        Object[] data = new Object[]{chunk, p_checkedReadChunkFromNBT__Async_4_};
        return data;
    }

    @Override
    public void saveChunk(World p_saveChunk_1_, Chunk p_saveChunk_2_) throws MinecraftException, IOException {
        p_saveChunk_1_.checkSessionLock();
        try {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound.setTag("Level", nbttagcompound1);
            nbttagcompound.setInteger("DataVersion", 922);
            FMLCommonHandler.instance().getDataFixer().writeVersionData(nbttagcompound);
            this.writeChunkToNBT(p_saveChunk_2_, p_saveChunk_1_, nbttagcompound1);
            MinecraftForge.EVENT_BUS.post(new ChunkDataEvent.Save(p_saveChunk_2_, nbttagcompound));
            this.addChunkToPending(p_saveChunk_2_.getPos(), nbttagcompound);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save chunk", (Throwable)exception);
        }
    }

    protected void addChunkToPending(ChunkPos p_addChunkToPending_1_, NBTTagCompound p_addChunkToPending_2_) {
        if (!this.pendingAnvilChunksCoordinates.contains(p_addChunkToPending_1_)) {
            this.chunksToRemove.put(p_addChunkToPending_1_, p_addChunkToPending_2_);
        }
        ThreadedFileIOBase.getThreadedIOInstance().queueIO(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeNextIO() {
        boolean lvt_3_1_;
        if (this.chunksToRemove.isEmpty()) {
            if (this.savingExtraData) {
                LOGGER.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", new Object[]{this.chunkSaveLocation.getName()});
            }
            return false;
        }
        ChunkPos chunkpos = this.chunksToRemove.keySet().iterator().next();
        try {
            this.pendingAnvilChunksCoordinates.add(chunkpos);
            NBTTagCompound nbttagcompound = this.chunksToRemove.remove(chunkpos);
            if (nbttagcompound != null) {
                try {
                    this.writeChunkData(chunkpos, nbttagcompound);
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to save chunk", (Throwable)exception);
                }
            }
            lvt_3_1_ = true;
        }
        finally {
            this.pendingAnvilChunksCoordinates.remove(chunkpos);
        }
        return lvt_3_1_;
    }

    private void writeChunkData(ChunkPos p_writeChunkData_1_, NBTTagCompound p_writeChunkData_2_) throws IOException {
        DataOutputStream dataoutputstream = RegionFileCache.getChunkOutputStream(this.chunkSaveLocation, p_writeChunkData_1_.chunkXPos, p_writeChunkData_1_.chunkZPos);
        CompressedStreamTools.write(p_writeChunkData_2_, dataoutputstream);
        dataoutputstream.close();
    }

    @Override
    public void saveExtraChunkData(World p_saveExtraChunkData_1_, Chunk p_saveExtraChunkData_2_) throws IOException {
    }

    @Override
    public void chunkTick() {
    }

    @Override
    public void saveExtraData() {
        try {
            this.savingExtraData = true;
            while (this.writeNextIO()) {
            }
        }
        finally {
            this.savingExtraData = false;
        }
    }

    public static void registerFixes(DataFixer p_registerFixes_0_) {
        p_registerFixes_0_.registerWalker(FixTypes.CHUNK, new IDataWalker(){

            @Override
            public NBTTagCompound process(IDataFixer p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
                if (p_process_2_.hasKey("Level", 10)) {
                    NBTTagCompound nbttagcompound = p_process_2_.getCompoundTag("Level");
                    if (nbttagcompound.hasKey("Entities", 9)) {
                        NBTTagList nbttaglist = nbttagcompound.getTagList("Entities", 10);
                        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                            nbttaglist.set(i, p_process_1_.process(FixTypes.ENTITY, (NBTTagCompound)nbttaglist.get(i), p_process_3_));
                        }
                    }
                    if (nbttagcompound.hasKey("TileEntities", 9)) {
                        NBTTagList nbttaglist1 = nbttagcompound.getTagList("TileEntities", 10);
                        for (int j = 0; j < nbttaglist1.tagCount(); ++j) {
                            nbttaglist1.set(j, p_process_1_.process(FixTypes.BLOCK_ENTITY, (NBTTagCompound)nbttaglist1.get(j), p_process_3_));
                        }
                    }
                }
                return p_process_2_;
            }
        });
    }

    private void writeChunkToNBT(Chunk p_writeChunkToNBT_1_, World p_writeChunkToNBT_2_, NBTTagCompound p_writeChunkToNBT_3_) {
        p_writeChunkToNBT_3_.setInteger("xPos", p_writeChunkToNBT_1_.xPosition);
        p_writeChunkToNBT_3_.setInteger("zPos", p_writeChunkToNBT_1_.zPosition);
        p_writeChunkToNBT_3_.setLong("LastUpdate", p_writeChunkToNBT_2_.getTotalWorldTime());
        p_writeChunkToNBT_3_.setIntArray("HeightMap", p_writeChunkToNBT_1_.getHeightMap());
        p_writeChunkToNBT_3_.setBoolean("TerrainPopulated", p_writeChunkToNBT_1_.isTerrainPopulated());
        p_writeChunkToNBT_3_.setBoolean("LightPopulated", p_writeChunkToNBT_1_.isLightPopulated());
        p_writeChunkToNBT_3_.setLong("InhabitedTime", p_writeChunkToNBT_1_.getInhabitedTime());
        ExtendedBlockStorage[] aextendedblockstorage = p_writeChunkToNBT_1_.getBlockStorageArray();
        NBTTagList nbttaglist = new NBTTagList();
        boolean flag = p_writeChunkToNBT_2_.provider.hasSkyLight();
        for (ExtendedBlockStorage extendedblockstorage : aextendedblockstorage) {
            if (extendedblockstorage == Chunk.NULL_BLOCK_STORAGE) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.setByte("Y", (byte)(extendedblockstorage.getYLocation() >> 4 & 0xFF));
            byte[] abyte = new byte[4096];
            NibbleArray nibblearray = new NibbleArray();
            NibbleArray nibblearray1 = extendedblockstorage.getData().getDataForNBT(abyte, nibblearray);
            nbttagcompound.setByteArray("Blocks", abyte);
            nbttagcompound.setByteArray("Data", nibblearray.getData());
            if (nibblearray1 != null) {
                nbttagcompound.setByteArray("Add", nibblearray1.getData());
            }
            nbttagcompound.setByteArray("BlockLight", extendedblockstorage.getBlocklightArray().getData());
            if (flag) {
                nbttagcompound.setByteArray("SkyLight", extendedblockstorage.getSkylightArray().getData());
            } else {
                nbttagcompound.setByteArray("SkyLight", new byte[extendedblockstorage.getBlocklightArray().getData().length]);
            }
            nbttaglist.appendTag(nbttagcompound);
        }
        p_writeChunkToNBT_3_.setTag("Sections", nbttaglist);
        p_writeChunkToNBT_3_.setByteArray("Biomes", p_writeChunkToNBT_1_.getBiomeArray());
        p_writeChunkToNBT_1_.setHasEntities(false);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (int i = 0; i < p_writeChunkToNBT_1_.getEntityLists().length; ++i) {
            for (Entity entity : p_writeChunkToNBT_1_.getEntityLists()[i]) {
                NBTTagCompound nbttagcompound2;
                if (!entity.writeToNBTOptional(nbttagcompound2 = new NBTTagCompound())) continue;
                try {
                    p_writeChunkToNBT_1_.setHasEntities(true);
                    nbttaglist1.appendTag(nbttagcompound2);
                }
                catch (Exception e) {
                    FMLLog.log(Level.ERROR, e, "An Entity type %s has thrown an exception trying to write state. It will not persist. Report this to the mod author", entity.getClass().getName());
                }
            }
        }
        p_writeChunkToNBT_3_.setTag("Entities", nbttaglist1);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (TileEntity tileentity : p_writeChunkToNBT_1_.getTileEntityMap().values()) {
            try {
                NBTTagCompound nbttagcompound3 = tileentity.writeToNBT(new NBTTagCompound());
                nbttaglist2.appendTag(nbttagcompound3);
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "A TileEntity type %s has throw an exception trying to write state. It will not persist. Report this to the mod author", tileentity.getClass().getName());
            }
        }
        p_writeChunkToNBT_3_.setTag("TileEntities", nbttaglist2);
        List<NextTickListEntry> list = p_writeChunkToNBT_2_.getPendingBlockUpdates(p_writeChunkToNBT_1_, false);
        if (list != null) {
            long j = p_writeChunkToNBT_2_.getTotalWorldTime();
            NBTTagList nbttaglist3 = new NBTTagList();
            for (NextTickListEntry nextticklistentry : list) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                ResourceLocation resourcelocation = Block.REGISTRY.getNameForObject(nextticklistentry.getBlock());
                nbttagcompound1.setString("i", resourcelocation == null ? "" : resourcelocation.toString());
                nbttagcompound1.setInteger("x", nextticklistentry.position.getX());
                nbttagcompound1.setInteger("y", nextticklistentry.position.getY());
                nbttagcompound1.setInteger("z", nextticklistentry.position.getZ());
                nbttagcompound1.setInteger("t", (int)(nextticklistentry.scheduledTime - j));
                nbttagcompound1.setInteger("p", nextticklistentry.priority);
                nbttaglist3.appendTag(nbttagcompound1);
            }
            p_writeChunkToNBT_3_.setTag("TileTicks", nbttaglist3);
        }
    }

    private Chunk readChunkFromNBT(World p_readChunkFromNBT_1_, NBTTagCompound p_readChunkFromNBT_2_) {
        int i = p_readChunkFromNBT_2_.getInteger("xPos");
        int j = p_readChunkFromNBT_2_.getInteger("zPos");
        Chunk chunk = new Chunk(p_readChunkFromNBT_1_, i, j);
        chunk.setHeightMap(p_readChunkFromNBT_2_.getIntArray("HeightMap"));
        chunk.setTerrainPopulated(p_readChunkFromNBT_2_.getBoolean("TerrainPopulated"));
        chunk.setLightPopulated(p_readChunkFromNBT_2_.getBoolean("LightPopulated"));
        chunk.setInhabitedTime(p_readChunkFromNBT_2_.getLong("InhabitedTime"));
        NBTTagList nbttaglist = p_readChunkFromNBT_2_.getTagList("Sections", 10);
        int k = 16;
        ExtendedBlockStorage[] aextendedblockstorage = new ExtendedBlockStorage[16];
        boolean flag = p_readChunkFromNBT_1_.provider.hasSkyLight();
        for (int l = 0; l < nbttaglist.tagCount(); ++l) {
            NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(l);
            byte i1 = nbttagcompound.getByte("Y");
            ExtendedBlockStorage extendedblockstorage = new ExtendedBlockStorage(i1 << 4, flag);
            byte[] abyte = nbttagcompound.getByteArray("Blocks");
            NibbleArray nibblearray = new NibbleArray(nbttagcompound.getByteArray("Data"));
            NibbleArray nibblearray1 = nbttagcompound.hasKey("Add", 7) ? new NibbleArray(nbttagcompound.getByteArray("Add")) : null;
            extendedblockstorage.getData().setDataFromNBT(abyte, nibblearray, nibblearray1);
            extendedblockstorage.setBlocklightArray(new NibbleArray(nbttagcompound.getByteArray("BlockLight")));
            if (flag) {
                extendedblockstorage.setSkylightArray(new NibbleArray(nbttagcompound.getByteArray("SkyLight")));
            }
            extendedblockstorage.removeInvalidBlocks();
            aextendedblockstorage[i1] = extendedblockstorage;
        }
        chunk.setStorageArrays(aextendedblockstorage);
        if (p_readChunkFromNBT_2_.hasKey("Biomes", 7)) {
            chunk.setBiomeArray(p_readChunkFromNBT_2_.getByteArray("Biomes"));
        }
        return chunk;
    }

    public void loadEntities(World p_loadEntities_1_, NBTTagCompound p_loadEntities_2_, Chunk p_loadEntities_3_) {
        NBTTagList nbttaglist1 = p_loadEntities_2_.getTagList("Entities", 10);
        for (int j1 = 0; j1 < nbttaglist1.tagCount(); ++j1) {
            NBTTagCompound nbttagcompound1 = nbttaglist1.getCompoundTagAt(j1);
            AnvilChunkLoader.readChunkEntity(nbttagcompound1, p_loadEntities_1_, p_loadEntities_3_);
            p_loadEntities_3_.setHasEntities(true);
        }
        NBTTagList nbttaglist2 = p_loadEntities_2_.getTagList("TileEntities", 10);
        for (int k1 = 0; k1 < nbttaglist2.tagCount(); ++k1) {
            NBTTagCompound nbttagcompound2 = nbttaglist2.getCompoundTagAt(k1);
            TileEntity tileentity = TileEntity.create(p_loadEntities_1_, nbttagcompound2);
            if (tileentity == null) continue;
            p_loadEntities_3_.addTileEntity(tileentity);
        }
        if (p_loadEntities_2_.hasKey("TileTicks", 9)) {
            NBTTagList nbttaglist3 = p_loadEntities_2_.getTagList("TileTicks", 10);
            for (int l1 = 0; l1 < nbttaglist3.tagCount(); ++l1) {
                NBTTagCompound nbttagcompound3 = nbttaglist3.getCompoundTagAt(l1);
                Block block = nbttagcompound3.hasKey("i", 8) ? Block.getBlockFromName(nbttagcompound3.getString("i")) : Block.getBlockById(nbttagcompound3.getInteger("i"));
                p_loadEntities_1_.scheduleBlockUpdate(new BlockPos(nbttagcompound3.getInteger("x"), nbttagcompound3.getInteger("y"), nbttagcompound3.getInteger("z")), block, nbttagcompound3.getInteger("t"), nbttagcompound3.getInteger("p"));
            }
        }
    }

    @Nullable
    public static Entity readChunkEntity(NBTTagCompound p_readChunkEntity_0_, World p_readChunkEntity_1_, Chunk p_readChunkEntity_2_) {
        Entity entity = AnvilChunkLoader.createEntityFromNBT(p_readChunkEntity_0_, p_readChunkEntity_1_);
        if (entity == null) {
            return null;
        }
        p_readChunkEntity_2_.addEntity(entity);
        if (p_readChunkEntity_0_.hasKey("Passengers", 9)) {
            NBTTagList nbttaglist = p_readChunkEntity_0_.getTagList("Passengers", 10);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                Entity entity1 = AnvilChunkLoader.readChunkEntity(nbttaglist.getCompoundTagAt(i), p_readChunkEntity_1_, p_readChunkEntity_2_);
                if (entity1 == null) continue;
                entity1.startRiding(entity, true);
            }
        }
        return entity;
    }

    @Nullable
    public static Entity readWorldEntityPos(NBTTagCompound p_readWorldEntityPos_0_, World p_readWorldEntityPos_1_, double p_readWorldEntityPos_2_, double p_readWorldEntityPos_4_, double p_readWorldEntityPos_6_, boolean p_readWorldEntityPos_8_) {
        Entity entity = AnvilChunkLoader.createEntityFromNBT(p_readWorldEntityPos_0_, p_readWorldEntityPos_1_);
        if (entity == null) {
            return null;
        }
        entity.setLocationAndAngles(p_readWorldEntityPos_2_, p_readWorldEntityPos_4_, p_readWorldEntityPos_6_, entity.rotationYaw, entity.rotationPitch);
        if (p_readWorldEntityPos_8_ && !p_readWorldEntityPos_1_.spawnEntity(entity)) {
            return null;
        }
        if (p_readWorldEntityPos_0_.hasKey("Passengers", 9)) {
            NBTTagList nbttaglist = p_readWorldEntityPos_0_.getTagList("Passengers", 10);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                Entity entity1 = AnvilChunkLoader.readWorldEntityPos(nbttaglist.getCompoundTagAt(i), p_readWorldEntityPos_1_, p_readWorldEntityPos_2_, p_readWorldEntityPos_4_, p_readWorldEntityPos_6_, p_readWorldEntityPos_8_);
                if (entity1 == null) continue;
                entity1.startRiding(entity, true);
            }
        }
        return entity;
    }

    @Nullable
    protected static Entity createEntityFromNBT(NBTTagCompound p_createEntityFromNBT_0_, World p_createEntityFromNBT_1_) {
        try {
            return EntityList.createEntityFromNBT(p_createEntityFromNBT_0_, p_createEntityFromNBT_1_);
        }
        catch (RuntimeException var3) {
            return null;
        }
    }

    public static void spawnEntity(Entity p_spawnEntity_0_, World p_spawnEntity_1_) {
        if (p_spawnEntity_1_.spawnEntity(p_spawnEntity_0_) && p_spawnEntity_0_.isBeingRidden()) {
            for (Entity entity : p_spawnEntity_0_.getPassengers()) {
                AnvilChunkLoader.spawnEntity(entity, p_spawnEntity_1_);
            }
        }
    }

    @Nullable
    public static Entity readWorldEntity(NBTTagCompound p_readWorldEntity_0_, World p_readWorldEntity_1_, boolean p_readWorldEntity_2_) {
        Entity entity = AnvilChunkLoader.createEntityFromNBT(p_readWorldEntity_0_, p_readWorldEntity_1_);
        if (entity == null) {
            return null;
        }
        if (p_readWorldEntity_2_ && !p_readWorldEntity_1_.spawnEntity(entity)) {
            return null;
        }
        if (p_readWorldEntity_0_.hasKey("Passengers", 9)) {
            NBTTagList nbttaglist = p_readWorldEntity_0_.getTagList("Passengers", 10);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                Entity entity1 = AnvilChunkLoader.readWorldEntity(nbttaglist.getCompoundTagAt(i), p_readWorldEntity_1_, p_readWorldEntity_2_);
                if (entity1 == null) continue;
                entity1.startRiding(entity, true);
            }
        }
        return entity;
    }
}

