/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.chunk.storage.AnvilSaveHandler;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveFormatOld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilSaveConverter
extends SaveFormatOld {
    private static final Logger LOGGER = LogManager.getLogger();

    public AnvilSaveConverter(File p_i46649_1_, DataFixer p_i46649_2_) {
        super(p_i46649_1_, p_i46649_2_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return "Anvil";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<WorldSummary> getSaveList() throws AnvilConverterException {
        File[] lvt_2_1_;
        if (this.savesDirectory == null || !this.savesDirectory.exists() || !this.savesDirectory.isDirectory()) {
            throw new AnvilConverterException(I18n.translateToLocal("selectWorld.load_folder_access"));
        }
        ArrayList lvt_1_1_ = Lists.newArrayList();
        for (File lvt_6_1_ : lvt_2_1_ = this.savesDirectory.listFiles()) {
            String lvt_7_1_;
            WorldInfo lvt_8_1_;
            if (!lvt_6_1_.isDirectory() || (lvt_8_1_ = this.getWorldInfo(lvt_7_1_ = lvt_6_1_.getName())) == null || lvt_8_1_.getSaveVersion() != 19132 && lvt_8_1_.getSaveVersion() != 19133) continue;
            boolean lvt_9_1_ = lvt_8_1_.getSaveVersion() != this.getSaveVersion();
            String lvt_10_1_ = lvt_8_1_.getWorldName();
            if (StringUtils.isEmpty((CharSequence)lvt_10_1_)) {
                lvt_10_1_ = lvt_7_1_;
            }
            long lvt_11_1_ = 0L;
            lvt_1_1_.add(new WorldSummary(lvt_8_1_, lvt_7_1_, lvt_10_1_, 0L, lvt_9_1_));
        }
        return lvt_1_1_;
    }

    protected int getSaveVersion() {
        return 19133;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void flushCache() {
        RegionFileCache.clearRegionFileReferences();
    }

    @Override
    public ISaveHandler getSaveLoader(String p_getSaveLoader_1_, boolean p_getSaveLoader_2_) {
        return new AnvilSaveHandler(this.savesDirectory, p_getSaveLoader_1_, p_getSaveLoader_2_, this.dataFixer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isConvertible(String p_isConvertible_1_) {
        WorldInfo lvt_2_1_ = this.getWorldInfo(p_isConvertible_1_);
        return lvt_2_1_ != null && lvt_2_1_.getSaveVersion() == 19132;
    }

    @Override
    public boolean isOldMapFormat(String p_isOldMapFormat_1_) {
        WorldInfo lvt_2_1_ = this.getWorldInfo(p_isOldMapFormat_1_);
        return lvt_2_1_ != null && lvt_2_1_.getSaveVersion() != this.getSaveVersion();
    }

    @Override
    public boolean convertMapFormat(String p_convertMapFormat_1_, IProgressUpdate p_convertMapFormat_2_) {
        BiomeProvider lvt_11_2_;
        p_convertMapFormat_2_.setLoadingProgress(0);
        ArrayList lvt_3_1_ = Lists.newArrayList();
        ArrayList lvt_4_1_ = Lists.newArrayList();
        ArrayList lvt_5_1_ = Lists.newArrayList();
        File lvt_6_1_ = new File(this.savesDirectory, p_convertMapFormat_1_);
        File lvt_7_1_ = new File(lvt_6_1_, "DIM-1");
        File lvt_8_1_ = new File(lvt_6_1_, "DIM1");
        LOGGER.info("Scanning folders...");
        this.addRegionFilesToCollection(lvt_6_1_, lvt_3_1_);
        if (lvt_7_1_.exists()) {
            this.addRegionFilesToCollection(lvt_7_1_, lvt_4_1_);
        }
        if (lvt_8_1_.exists()) {
            this.addRegionFilesToCollection(lvt_8_1_, lvt_5_1_);
        }
        int lvt_9_1_ = lvt_3_1_.size() + lvt_4_1_.size() + lvt_5_1_.size();
        LOGGER.info("Total conversion count is {}", new Object[]{lvt_9_1_});
        WorldInfo lvt_10_1_ = this.getWorldInfo(p_convertMapFormat_1_);
        if (lvt_10_1_ != null && lvt_10_1_.getTerrainType() == WorldType.FLAT) {
            BiomeProviderSingle lvt_11_1_ = new BiomeProviderSingle(Biomes.PLAINS);
        } else {
            lvt_11_2_ = new BiomeProvider(lvt_10_1_);
        }
        this.convertFile(new File(lvt_6_1_, "region"), lvt_3_1_, lvt_11_2_, 0, lvt_9_1_, p_convertMapFormat_2_);
        this.convertFile(new File(lvt_7_1_, "region"), lvt_4_1_, new BiomeProviderSingle(Biomes.HELL), lvt_3_1_.size(), lvt_9_1_, p_convertMapFormat_2_);
        this.convertFile(new File(lvt_8_1_, "region"), lvt_5_1_, new BiomeProviderSingle(Biomes.SKY), lvt_3_1_.size() + lvt_4_1_.size(), lvt_9_1_, p_convertMapFormat_2_);
        lvt_10_1_.setSaveVersion(19133);
        if (lvt_10_1_.getTerrainType() == WorldType.DEFAULT_1_1) {
            lvt_10_1_.setTerrainType(WorldType.DEFAULT);
        }
        this.createFile(p_convertMapFormat_1_);
        ISaveHandler lvt_12_1_ = this.getSaveLoader(p_convertMapFormat_1_, false);
        lvt_12_1_.saveWorldInfo(lvt_10_1_);
        return true;
    }

    private void createFile(String p_createFile_1_) {
        File lvt_2_1_ = new File(this.savesDirectory, p_createFile_1_);
        if (!lvt_2_1_.exists()) {
            LOGGER.warn("Unable to create level.dat_mcr backup");
            return;
        }
        File lvt_3_1_ = new File(lvt_2_1_, "level.dat");
        if (!lvt_3_1_.exists()) {
            LOGGER.warn("Unable to create level.dat_mcr backup");
            return;
        }
        File lvt_4_1_ = new File(lvt_2_1_, "level.dat_mcr");
        if (!lvt_3_1_.renameTo(lvt_4_1_)) {
            LOGGER.warn("Unable to create level.dat_mcr backup");
        }
    }

    private void convertFile(File p_convertFile_1_, Iterable<File> p_convertFile_2_, BiomeProvider p_convertFile_3_, int p_convertFile_4_, int p_convertFile_5_, IProgressUpdate p_convertFile_6_) {
        for (File lvt_8_1_ : p_convertFile_2_) {
            this.convertChunks(p_convertFile_1_, lvt_8_1_, p_convertFile_3_, p_convertFile_4_, p_convertFile_5_, p_convertFile_6_);
            int lvt_9_1_ = (int)Math.round(100.0 * (double)(++p_convertFile_4_) / (double)p_convertFile_5_);
            p_convertFile_6_.setLoadingProgress(lvt_9_1_);
        }
    }

    private void convertChunks(File p_convertChunks_1_, File p_convertChunks_2_, BiomeProvider p_convertChunks_3_, int p_convertChunks_4_, int p_convertChunks_5_, IProgressUpdate p_convertChunks_6_) {
        try {
            String lvt_7_1_ = p_convertChunks_2_.getName();
            RegionFile lvt_8_1_ = new RegionFile(p_convertChunks_2_);
            RegionFile lvt_9_1_ = new RegionFile(new File(p_convertChunks_1_, lvt_7_1_.substring(0, lvt_7_1_.length() - ".mcr".length()) + ".mca"));
            for (int lvt_10_1_ = 0; lvt_10_1_ < 32; ++lvt_10_1_) {
                for (int lvt_11_1_ = 0; lvt_11_1_ < 32; ++lvt_11_1_) {
                    if (!lvt_8_1_.isChunkSaved(lvt_10_1_, lvt_11_1_) || lvt_9_1_.isChunkSaved(lvt_10_1_, lvt_11_1_)) continue;
                    DataInputStream lvt_12_1_ = lvt_8_1_.getChunkDataInputStream(lvt_10_1_, lvt_11_1_);
                    if (lvt_12_1_ == null) {
                        LOGGER.warn("Failed to fetch input stream");
                        continue;
                    }
                    NBTTagCompound lvt_13_1_ = CompressedStreamTools.read(lvt_12_1_);
                    lvt_12_1_.close();
                    NBTTagCompound lvt_14_1_ = lvt_13_1_.getCompoundTag("Level");
                    ChunkLoader.AnvilConverterData lvt_15_1_ = ChunkLoader.load(lvt_14_1_);
                    NBTTagCompound lvt_16_1_ = new NBTTagCompound();
                    NBTTagCompound lvt_17_1_ = new NBTTagCompound();
                    lvt_16_1_.setTag("Level", lvt_17_1_);
                    ChunkLoader.convertToAnvilFormat(lvt_15_1_, lvt_17_1_, p_convertChunks_3_);
                    DataOutputStream lvt_18_1_ = lvt_9_1_.getChunkDataOutputStream(lvt_10_1_, lvt_11_1_);
                    CompressedStreamTools.write(lvt_16_1_, lvt_18_1_);
                    lvt_18_1_.close();
                }
                int lvt_11_2_ = (int)Math.round(100.0 * (double)(p_convertChunks_4_ * 1024) / (double)(p_convertChunks_5_ * 1024));
                int lvt_12_2_ = (int)Math.round(100.0 * (double)((lvt_10_1_ + 1) * 32 + p_convertChunks_4_ * 1024) / (double)(p_convertChunks_5_ * 1024));
                if (lvt_12_2_ <= lvt_11_2_) continue;
                p_convertChunks_6_.setLoadingProgress(lvt_12_2_);
            }
            lvt_8_1_.close();
            lvt_9_1_.close();
        }
        catch (IOException lvt_7_2_) {
            lvt_7_2_.printStackTrace();
        }
    }

    private void addRegionFilesToCollection(File p_addRegionFilesToCollection_1_, Collection<File> p_addRegionFilesToCollection_2_) {
        File lvt_3_1_ = new File(p_addRegionFilesToCollection_1_, "region");
        File[] lvt_4_1_ = lvt_3_1_.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File p_accept_1_, String p_accept_2_) {
                return p_accept_2_.endsWith(".mcr");
            }
        });
        if (lvt_4_1_ != null) {
            Collections.addAll(p_addRegionFilesToCollection_2_, lvt_4_1_);
        }
    }
}

