/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.NibbleArrayReader;

public class ChunkLoader {
    public static AnvilConverterData load(NBTTagCompound p_load_0_) {
        int lvt_1_1_ = p_load_0_.getInteger("xPos");
        int lvt_2_1_ = p_load_0_.getInteger("zPos");
        AnvilConverterData lvt_3_1_ = new AnvilConverterData(lvt_1_1_, lvt_2_1_);
        lvt_3_1_.blocks = p_load_0_.getByteArray("Blocks");
        lvt_3_1_.data = new NibbleArrayReader(p_load_0_.getByteArray("Data"), 7);
        lvt_3_1_.skyLight = new NibbleArrayReader(p_load_0_.getByteArray("SkyLight"), 7);
        lvt_3_1_.blockLight = new NibbleArrayReader(p_load_0_.getByteArray("BlockLight"), 7);
        lvt_3_1_.heightmap = p_load_0_.getByteArray("HeightMap");
        lvt_3_1_.terrainPopulated = p_load_0_.getBoolean("TerrainPopulated");
        lvt_3_1_.entities = p_load_0_.getTagList("Entities", 10);
        lvt_3_1_.tileEntities = p_load_0_.getTagList("TileEntities", 10);
        lvt_3_1_.tileTicks = p_load_0_.getTagList("TileTicks", 10);
        try {
            lvt_3_1_.lastUpdated = p_load_0_.getLong("LastUpdate");
        }
        catch (ClassCastException lvt_4_1_) {
            lvt_3_1_.lastUpdated = p_load_0_.getInteger("LastUpdate");
        }
        return lvt_3_1_;
    }

    public static void convertToAnvilFormat(AnvilConverterData p_convertToAnvilFormat_0_, NBTTagCompound p_convertToAnvilFormat_1_, BiomeProvider p_convertToAnvilFormat_2_) {
        p_convertToAnvilFormat_1_.setInteger("xPos", p_convertToAnvilFormat_0_.x);
        p_convertToAnvilFormat_1_.setInteger("zPos", p_convertToAnvilFormat_0_.z);
        p_convertToAnvilFormat_1_.setLong("LastUpdate", p_convertToAnvilFormat_0_.lastUpdated);
        int[] lvt_3_1_ = new int[p_convertToAnvilFormat_0_.heightmap.length];
        for (int lvt_4_1_ = 0; lvt_4_1_ < p_convertToAnvilFormat_0_.heightmap.length; ++lvt_4_1_) {
            lvt_3_1_[lvt_4_1_] = p_convertToAnvilFormat_0_.heightmap[lvt_4_1_];
        }
        p_convertToAnvilFormat_1_.setIntArray("HeightMap", lvt_3_1_);
        p_convertToAnvilFormat_1_.setBoolean("TerrainPopulated", p_convertToAnvilFormat_0_.terrainPopulated);
        NBTTagList lvt_4_2_ = new NBTTagList();
        for (int lvt_5_1_ = 0; lvt_5_1_ < 8; ++lvt_5_1_) {
            boolean lvt_6_1_ = true;
            for (int lvt_7_1_ = 0; lvt_7_1_ < 16 && lvt_6_1_; ++lvt_7_1_) {
                block3: for (int lvt_8_1_ = 0; lvt_8_1_ < 16 && lvt_6_1_; ++lvt_8_1_) {
                    for (int lvt_9_1_ = 0; lvt_9_1_ < 16; ++lvt_9_1_) {
                        int lvt_10_1_ = lvt_7_1_ << 11 | lvt_9_1_ << 7 | lvt_8_1_ + (lvt_5_1_ << 4);
                        byte lvt_11_1_ = p_convertToAnvilFormat_0_.blocks[lvt_10_1_];
                        if (lvt_11_1_ == 0) continue;
                        lvt_6_1_ = false;
                        continue block3;
                    }
                }
            }
            if (lvt_6_1_) continue;
            byte[] lvt_7_2_ = new byte[4096];
            NibbleArray lvt_8_2_ = new NibbleArray();
            NibbleArray lvt_9_2_ = new NibbleArray();
            NibbleArray lvt_10_2_ = new NibbleArray();
            for (int lvt_11_2_ = 0; lvt_11_2_ < 16; ++lvt_11_2_) {
                for (int lvt_12_1_ = 0; lvt_12_1_ < 16; ++lvt_12_1_) {
                    for (int lvt_13_1_ = 0; lvt_13_1_ < 16; ++lvt_13_1_) {
                        int lvt_14_1_ = lvt_11_2_ << 11 | lvt_13_1_ << 7 | lvt_12_1_ + (lvt_5_1_ << 4);
                        byte lvt_15_1_ = p_convertToAnvilFormat_0_.blocks[lvt_14_1_];
                        lvt_7_2_[lvt_12_1_ << 8 | lvt_13_1_ << 4 | lvt_11_2_] = (byte)(lvt_15_1_ & 0xFF);
                        lvt_8_2_.set(lvt_11_2_, lvt_12_1_, lvt_13_1_, p_convertToAnvilFormat_0_.data.get(lvt_11_2_, lvt_12_1_ + (lvt_5_1_ << 4), lvt_13_1_));
                        lvt_9_2_.set(lvt_11_2_, lvt_12_1_, lvt_13_1_, p_convertToAnvilFormat_0_.skyLight.get(lvt_11_2_, lvt_12_1_ + (lvt_5_1_ << 4), lvt_13_1_));
                        lvt_10_2_.set(lvt_11_2_, lvt_12_1_, lvt_13_1_, p_convertToAnvilFormat_0_.blockLight.get(lvt_11_2_, lvt_12_1_ + (lvt_5_1_ << 4), lvt_13_1_));
                    }
                }
            }
            NBTTagCompound lvt_11_3_ = new NBTTagCompound();
            lvt_11_3_.setByte("Y", (byte)(lvt_5_1_ & 0xFF));
            lvt_11_3_.setByteArray("Blocks", lvt_7_2_);
            lvt_11_3_.setByteArray("Data", lvt_8_2_.getData());
            lvt_11_3_.setByteArray("SkyLight", lvt_9_2_.getData());
            lvt_11_3_.setByteArray("BlockLight", lvt_10_2_.getData());
            lvt_4_2_.appendTag(lvt_11_3_);
        }
        p_convertToAnvilFormat_1_.setTag("Sections", lvt_4_2_);
        byte[] lvt_5_2_ = new byte[256];
        BlockPos.MutableBlockPos lvt_6_2_ = new BlockPos.MutableBlockPos();
        for (int lvt_7_3_ = 0; lvt_7_3_ < 16; ++lvt_7_3_) {
            for (int lvt_8_3_ = 0; lvt_8_3_ < 16; ++lvt_8_3_) {
                lvt_6_2_.setPos(p_convertToAnvilFormat_0_.x << 4 | lvt_7_3_, 0, p_convertToAnvilFormat_0_.z << 4 | lvt_8_3_);
                lvt_5_2_[lvt_8_3_ << 4 | lvt_7_3_] = (byte)(Biome.getIdForBiome(p_convertToAnvilFormat_2_.getBiome(lvt_6_2_, Biomes.DEFAULT)) & 0xFF);
            }
        }
        p_convertToAnvilFormat_1_.setByteArray("Biomes", lvt_5_2_);
        p_convertToAnvilFormat_1_.setTag("Entities", p_convertToAnvilFormat_0_.entities);
        p_convertToAnvilFormat_1_.setTag("TileEntities", p_convertToAnvilFormat_0_.tileEntities);
        if (p_convertToAnvilFormat_0_.tileTicks != null) {
            p_convertToAnvilFormat_1_.setTag("TileTicks", p_convertToAnvilFormat_0_.tileTicks);
        }
    }

    public static class AnvilConverterData {
        public long lastUpdated;
        public boolean terrainPopulated;
        public byte[] heightmap;
        public NibbleArrayReader blockLight;
        public NibbleArrayReader skyLight;
        public NibbleArrayReader data;
        public byte[] blocks;
        public NBTTagList entities;
        public NBTTagList tileEntities;
        public NBTTagList tileTicks;
        public final int x;
        public final int z;

        public AnvilConverterData(int p_i1999_1_, int p_i1999_2_) {
            this.x = p_i1999_1_;
            this.z = p_i1999_2_;
        }
    }
}

