/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ExtendedBlockStorage {
    private final int yBase;
    private int blockRefCount;
    private int tickRefCount;
    private final BlockStateContainer data;
    private NibbleArray blocklightArray;
    private NibbleArray skylightArray;

    public ExtendedBlockStorage(int p_i1997_1_, boolean p_i1997_2_) {
        this.yBase = p_i1997_1_;
        this.data = new BlockStateContainer();
        this.blocklightArray = new NibbleArray();
        if (p_i1997_2_) {
            this.skylightArray = new NibbleArray();
        }
    }

    public IBlockState get(int p_get_1_, int p_get_2_, int p_get_3_) {
        return this.data.get(p_get_1_, p_get_2_, p_get_3_);
    }

    public void set(int p_set_1_, int p_set_2_, int p_set_3_, IBlockState p_set_4_) {
        if (p_set_4_ instanceof IExtendedBlockState) {
            p_set_4_ = ((IExtendedBlockState)p_set_4_).getClean();
        }
        IBlockState iblockstate = this.get(p_set_1_, p_set_2_, p_set_3_);
        Block block = iblockstate.getBlock();
        Block block1 = p_set_4_.getBlock();
        if (block != Blocks.AIR) {
            --this.blockRefCount;
            if (block.getTickRandomly()) {
                --this.tickRefCount;
            }
        }
        if (block1 != Blocks.AIR) {
            ++this.blockRefCount;
            if (block1.getTickRandomly()) {
                ++this.tickRefCount;
            }
        }
        this.data.set(p_set_1_, p_set_2_, p_set_3_, p_set_4_);
    }

    public boolean isEmpty() {
        return this.blockRefCount == 0;
    }

    public boolean getNeedsRandomTick() {
        return this.tickRefCount > 0;
    }

    public int getYLocation() {
        return this.yBase;
    }

    public void setExtSkylightValue(int p_setExtSkylightValue_1_, int p_setExtSkylightValue_2_, int p_setExtSkylightValue_3_, int p_setExtSkylightValue_4_) {
        this.skylightArray.set(p_setExtSkylightValue_1_, p_setExtSkylightValue_2_, p_setExtSkylightValue_3_, p_setExtSkylightValue_4_);
    }

    public int getExtSkylightValue(int p_getExtSkylightValue_1_, int p_getExtSkylightValue_2_, int p_getExtSkylightValue_3_) {
        return this.skylightArray.get(p_getExtSkylightValue_1_, p_getExtSkylightValue_2_, p_getExtSkylightValue_3_);
    }

    public void setExtBlocklightValue(int p_setExtBlocklightValue_1_, int p_setExtBlocklightValue_2_, int p_setExtBlocklightValue_3_, int p_setExtBlocklightValue_4_) {
        this.blocklightArray.set(p_setExtBlocklightValue_1_, p_setExtBlocklightValue_2_, p_setExtBlocklightValue_3_, p_setExtBlocklightValue_4_);
    }

    public int getExtBlocklightValue(int p_getExtBlocklightValue_1_, int p_getExtBlocklightValue_2_, int p_getExtBlocklightValue_3_) {
        return this.blocklightArray.get(p_getExtBlocklightValue_1_, p_getExtBlocklightValue_2_, p_getExtBlocklightValue_3_);
    }

    public void removeInvalidBlocks() {
        this.blockRefCount = 0;
        this.tickRefCount = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    Block block = this.get(i, j, k).getBlock();
                    if (block == Blocks.AIR) continue;
                    ++this.blockRefCount;
                    if (!block.getTickRandomly()) continue;
                    ++this.tickRefCount;
                }
            }
        }
    }

    public BlockStateContainer getData() {
        return this.data;
    }

    public NibbleArray getBlocklightArray() {
        return this.blocklightArray;
    }

    public NibbleArray getSkylightArray() {
        return this.skylightArray;
    }

    public void setBlocklightArray(NibbleArray p_setBlocklightArray_1_) {
        this.blocklightArray = p_setBlocklightArray_1_;
    }

    public void setSkylightArray(NibbleArray p_setSkylightArray_1_) {
        this.skylightArray = p_setSkylightArray_1_;
    }
}

