/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;

public class RegionFile {
    private static final byte[] EMPTY_SECTOR = new byte[4096];
    private final File fileName;
    private RandomAccessFile dataFile;
    private final int[] offsets = new int[1024];
    private final int[] chunkTimestamps = new int[1024];
    private List<Boolean> sectorFree;
    private int sizeDelta;
    private long lastModified;

    public RegionFile(File p_i2001_1_) {
        this.fileName = p_i2001_1_;
        this.sizeDelta = 0;
        try {
            if (p_i2001_1_.exists()) {
                this.lastModified = p_i2001_1_.lastModified();
            }
            this.dataFile = new RandomAccessFile(p_i2001_1_, "rw");
            if (this.dataFile.length() < 4096L) {
                this.dataFile.write(EMPTY_SECTOR);
                this.dataFile.write(EMPTY_SECTOR);
                this.sizeDelta += 8192;
            }
            if ((this.dataFile.length() & 0xFFFL) != 0L) {
                int i = 0;
                while ((long)i < (this.dataFile.length() & 0xFFFL)) {
                    this.dataFile.write(0);
                    ++i;
                }
            }
            int i1 = (int)this.dataFile.length() / 4096;
            this.sectorFree = Lists.newArrayListWithCapacity((int)i1);
            for (int j = 0; j < i1; ++j) {
                this.sectorFree.add(true);
            }
            this.sectorFree.set(0, false);
            this.sectorFree.set(1, false);
            this.dataFile.seek(0L);
            for (int j1 = 0; j1 < 1024; ++j1) {
                int k;
                this.offsets[j1] = k = this.dataFile.readInt();
                if (k == 0 || (k >> 8) + (k & 0xFF) > this.sectorFree.size()) continue;
                for (int l = 0; l < (k & 0xFF); ++l) {
                    this.sectorFree.set((k >> 8) + l, false);
                }
            }
            for (int k1 = 0; k1 < 1024; ++k1) {
                int l1;
                this.chunkTimestamps[k1] = l1 = this.dataFile.readInt();
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public synchronized boolean chunkExists(int p_chunkExists_1_, int p_chunkExists_2_) {
        if (this.outOfBounds(p_chunkExists_1_, p_chunkExists_2_)) {
            return false;
        }
        try {
            int offset = this.getOffset(p_chunkExists_1_, p_chunkExists_2_);
            if (offset == 0) {
                return false;
            }
            int sectorNumber = offset >> 8;
            int numSectors = offset & 0xFF;
            if (sectorNumber + numSectors > this.sectorFree.size()) {
                return false;
            }
            this.dataFile.seek(sectorNumber * 4096);
            int length = this.dataFile.readInt();
            if (length > 4096 * numSectors || length <= 0) {
                return false;
            }
            byte version = this.dataFile.readByte();
            if (version == 1 || version == 2) {
                return true;
            }
        }
        catch (IOException ioexception) {
            return false;
        }
        return false;
    }

    @Nullable
    public synchronized DataInputStream getChunkDataInputStream(int p_getChunkDataInputStream_1_, int p_getChunkDataInputStream_2_) {
        if (this.outOfBounds(p_getChunkDataInputStream_1_, p_getChunkDataInputStream_2_)) {
            return null;
        }
        try {
            int i = this.getOffset(p_getChunkDataInputStream_1_, p_getChunkDataInputStream_2_);
            if (i == 0) {
                return null;
            }
            int j = i >> 8;
            int k = i & 0xFF;
            if (j + k > this.sectorFree.size()) {
                return null;
            }
            this.dataFile.seek(j * 4096);
            int l = this.dataFile.readInt();
            if (l > 4096 * k) {
                return null;
            }
            if (l <= 0) {
                return null;
            }
            byte b0 = this.dataFile.readByte();
            if (b0 == 1) {
                byte[] abyte1 = new byte[l - 1];
                this.dataFile.read(abyte1);
                return new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(abyte1))));
            }
            if (b0 == 2) {
                byte[] abyte = new byte[l - 1];
                this.dataFile.read(abyte);
                return new DataInputStream(new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(abyte))));
            }
            return null;
        }
        catch (IOException var9) {
            return null;
        }
    }

    @Nullable
    public DataOutputStream getChunkDataOutputStream(int p_getChunkDataOutputStream_1_, int p_getChunkDataOutputStream_2_) {
        return this.outOfBounds(p_getChunkDataOutputStream_1_, p_getChunkDataOutputStream_2_) ? null : new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(new ChunkBuffer(p_getChunkDataOutputStream_1_, p_getChunkDataOutputStream_2_))));
    }

    protected synchronized void write(int p_write_1_, int p_write_2_, byte[] p_write_3_, int p_write_4_) {
        try {
            int i = this.getOffset(p_write_1_, p_write_2_);
            int j = i >> 8;
            int k = i & 0xFF;
            int l = (p_write_4_ + 5) / 4096 + 1;
            if (l >= 256) {
                return;
            }
            if (j != 0 && k == l) {
                this.write(j, p_write_3_, p_write_4_);
            } else {
                for (int i1 = 0; i1 < k; ++i1) {
                    this.sectorFree.set(j + i1, true);
                }
                int l1 = this.sectorFree.indexOf(true);
                int j1 = 0;
                if (l1 != -1) {
                    for (int k1 = l1; k1 < this.sectorFree.size(); ++k1) {
                        if (j1 != 0) {
                            j1 = this.sectorFree.get(k1).booleanValue() ? ++j1 : 0;
                        } else if (this.sectorFree.get(k1).booleanValue()) {
                            l1 = k1;
                            j1 = 1;
                        }
                        if (j1 >= l) break;
                    }
                }
                if (j1 >= l) {
                    j = l1;
                    this.setOffset(p_write_1_, p_write_2_, l1 << 8 | l);
                    for (int j2 = 0; j2 < l; ++j2) {
                        this.sectorFree.set(j + j2, false);
                    }
                    this.write(j, p_write_3_, p_write_4_);
                } else {
                    this.dataFile.seek(this.dataFile.length());
                    j = this.sectorFree.size();
                    for (int i2 = 0; i2 < l; ++i2) {
                        this.dataFile.write(EMPTY_SECTOR);
                        this.sectorFree.add(false);
                    }
                    this.sizeDelta += 4096 * l;
                    this.write(j, p_write_3_, p_write_4_);
                    this.setOffset(p_write_1_, p_write_2_, j << 8 | l);
                }
            }
            this.setChunkTimestamp(p_write_1_, p_write_2_, (int)(MinecraftServer.getCurrentTimeMillis() / 1000L));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private void write(int p_write_1_, byte[] p_write_2_, int p_write_3_) throws IOException {
        this.dataFile.seek(p_write_1_ * 4096);
        this.dataFile.writeInt(p_write_3_ + 1);
        this.dataFile.writeByte(2);
        this.dataFile.write(p_write_2_, 0, p_write_3_);
    }

    private boolean outOfBounds(int p_outOfBounds_1_, int p_outOfBounds_2_) {
        return p_outOfBounds_1_ < 0 || p_outOfBounds_1_ >= 32 || p_outOfBounds_2_ < 0 || p_outOfBounds_2_ >= 32;
    }

    private int getOffset(int p_getOffset_1_, int p_getOffset_2_) {
        return this.offsets[p_getOffset_1_ + p_getOffset_2_ * 32];
    }

    public boolean isChunkSaved(int p_isChunkSaved_1_, int p_isChunkSaved_2_) {
        return this.getOffset(p_isChunkSaved_1_, p_isChunkSaved_2_) != 0;
    }

    private void setOffset(int p_setOffset_1_, int p_setOffset_2_, int p_setOffset_3_) throws IOException {
        this.offsets[p_setOffset_1_ + p_setOffset_2_ * 32] = p_setOffset_3_;
        this.dataFile.seek((p_setOffset_1_ + p_setOffset_2_ * 32) * 4);
        this.dataFile.writeInt(p_setOffset_3_);
    }

    private void setChunkTimestamp(int p_setChunkTimestamp_1_, int p_setChunkTimestamp_2_, int p_setChunkTimestamp_3_) throws IOException {
        this.chunkTimestamps[p_setChunkTimestamp_1_ + p_setChunkTimestamp_2_ * 32] = p_setChunkTimestamp_3_;
        this.dataFile.seek(4096 + (p_setChunkTimestamp_1_ + p_setChunkTimestamp_2_ * 32) * 4);
        this.dataFile.writeInt(p_setChunkTimestamp_3_);
    }

    public void close() throws IOException {
        if (this.dataFile != null) {
            this.dataFile.close();
        }
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final int chunkX;
        private final int chunkZ;

        public ChunkBuffer(int p_i2000_2_, int p_i2000_3_) {
            super(8096);
            this.chunkX = p_i2000_2_;
            this.chunkZ = p_i2000_3_;
        }

        @Override
        public void close() throws IOException {
            RegionFile.this.write(this.chunkX, this.chunkZ, this.buf, this.count);
        }
    }
}

