/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Maps;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.minecraft.world.chunk.storage.RegionFile;

public class RegionFileCache {
    private static final Map<File, RegionFile> REGIONS_BY_FILE = Maps.newHashMap();

    public static synchronized RegionFile createOrLoadRegionFile(File p_createOrLoadRegionFile_0_, int p_createOrLoadRegionFile_1_, int p_createOrLoadRegionFile_2_) {
        File lvt_3_1_ = new File(p_createOrLoadRegionFile_0_, "region");
        File lvt_4_1_ = new File(lvt_3_1_, "r." + (p_createOrLoadRegionFile_1_ >> 5) + "." + (p_createOrLoadRegionFile_2_ >> 5) + ".mca");
        RegionFile lvt_5_1_ = REGIONS_BY_FILE.get(lvt_4_1_);
        if (lvt_5_1_ != null) {
            return lvt_5_1_;
        }
        if (!lvt_3_1_.exists()) {
            lvt_3_1_.mkdirs();
        }
        if (REGIONS_BY_FILE.size() >= 256) {
            RegionFileCache.clearRegionFileReferences();
        }
        RegionFile lvt_6_1_ = new RegionFile(lvt_4_1_);
        REGIONS_BY_FILE.put(lvt_4_1_, lvt_6_1_);
        return lvt_6_1_;
    }

    public static synchronized RegionFile getRegionFileIfExists(File p_getRegionFileIfExists_0_, int p_getRegionFileIfExists_1_, int p_getRegionFileIfExists_2_) {
        File lvt_3_1_ = new File(p_getRegionFileIfExists_0_, "region");
        File lvt_4_1_ = new File(lvt_3_1_, "r." + (p_getRegionFileIfExists_1_ >> 5) + "." + (p_getRegionFileIfExists_2_ >> 5) + ".mca");
        RegionFile lvt_5_1_ = REGIONS_BY_FILE.get(lvt_4_1_);
        if (lvt_5_1_ != null) {
            return lvt_5_1_;
        }
        if (!lvt_3_1_.exists() || !lvt_4_1_.exists()) {
            return null;
        }
        if (REGIONS_BY_FILE.size() >= 256) {
            RegionFileCache.clearRegionFileReferences();
        }
        RegionFile lvt_6_1_ = new RegionFile(lvt_4_1_);
        REGIONS_BY_FILE.put(lvt_4_1_, lvt_6_1_);
        return lvt_6_1_;
    }

    public static synchronized void clearRegionFileReferences() {
        for (RegionFile lvt_1_1_ : REGIONS_BY_FILE.values()) {
            try {
                if (lvt_1_1_ == null) continue;
                lvt_1_1_.close();
            }
            catch (IOException lvt_2_1_) {
                lvt_2_1_.printStackTrace();
            }
        }
        REGIONS_BY_FILE.clear();
    }

    public static DataInputStream getChunkInputStream(File p_getChunkInputStream_0_, int p_getChunkInputStream_1_, int p_getChunkInputStream_2_) {
        RegionFile lvt_3_1_ = RegionFileCache.createOrLoadRegionFile(p_getChunkInputStream_0_, p_getChunkInputStream_1_, p_getChunkInputStream_2_);
        return lvt_3_1_.getChunkDataInputStream(p_getChunkInputStream_1_ & 0x1F, p_getChunkInputStream_2_ & 0x1F);
    }

    public static DataOutputStream getChunkOutputStream(File p_getChunkOutputStream_0_, int p_getChunkOutputStream_1_, int p_getChunkOutputStream_2_) {
        RegionFile lvt_3_1_ = RegionFileCache.createOrLoadRegionFile(p_getChunkOutputStream_0_, p_getChunkOutputStream_1_, p_getChunkOutputStream_2_);
        return lvt_3_1_.getChunkDataOutputStream(p_getChunkOutputStream_1_ & 0x1F, p_getChunkOutputStream_2_ & 0x1F);
    }

    public static boolean chunkExists(File p_chunkExists_0_, int p_chunkExists_1_, int p_chunkExists_2_) {
        RegionFile lvt_3_1_ = RegionFileCache.getRegionFileIfExists(p_chunkExists_0_, p_chunkExists_1_, p_chunkExists_2_);
        if (lvt_3_1_ != null) {
            return lvt_3_1_.isChunkSaved(p_chunkExists_1_ & 0x1F, p_chunkExists_2_ & 0x1F);
        }
        return false;
    }
}

