/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.demo;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class DemoWorldManager
extends PlayerInteractionManager {
    private boolean displayedIntro;
    private boolean demoTimeExpired;
    private int demoEndedReminder;
    private int gameModeTicks;

    public DemoWorldManager(World p_i1513_1_) {
        super(p_i1513_1_);
    }

    @Override
    public void updateBlockRemoving() {
        super.updateBlockRemoving();
        ++this.gameModeTicks;
        long lvt_1_1_ = this.world.getTotalWorldTime();
        long lvt_3_1_ = lvt_1_1_ / 24000L + 1L;
        if (!this.displayedIntro && this.gameModeTicks > 20) {
            this.displayedIntro = true;
            this.player.connection.sendPacket(new SPacketChangeGameState(5, 0.0f));
        }
        boolean bl = this.demoTimeExpired = lvt_1_1_ > 120500L;
        if (this.demoTimeExpired) {
            ++this.demoEndedReminder;
        }
        if (lvt_1_1_ % 24000L == 500L) {
            if (lvt_3_1_ <= 6L) {
                this.player.sendMessage(new TextComponentTranslation("demo.day." + lvt_3_1_, new Object[0]));
            }
        } else if (lvt_3_1_ == 1L) {
            if (lvt_1_1_ == 100L) {
                this.player.connection.sendPacket(new SPacketChangeGameState(5, 101.0f));
            } else if (lvt_1_1_ == 175L) {
                this.player.connection.sendPacket(new SPacketChangeGameState(5, 102.0f));
            } else if (lvt_1_1_ == 250L) {
                this.player.connection.sendPacket(new SPacketChangeGameState(5, 103.0f));
            }
        } else if (lvt_3_1_ == 5L && lvt_1_1_ % 24000L == 22000L) {
            this.player.sendMessage(new TextComponentTranslation("demo.day.warning", new Object[0]));
        }
    }

    private void sendDemoReminder() {
        if (this.demoEndedReminder > 100) {
            this.player.sendMessage(new TextComponentTranslation("demo.reminder", new Object[0]));
            this.demoEndedReminder = 0;
        }
    }

    @Override
    public void onBlockClicked(BlockPos p_onBlockClicked_1_, EnumFacing p_onBlockClicked_2_) {
        if (this.demoTimeExpired) {
            this.sendDemoReminder();
            return;
        }
        super.onBlockClicked(p_onBlockClicked_1_, p_onBlockClicked_2_);
    }

    @Override
    public void blockRemoving(BlockPos p_blockRemoving_1_) {
        if (this.demoTimeExpired) {
            return;
        }
        super.blockRemoving(p_blockRemoving_1_);
    }

    @Override
    public boolean tryHarvestBlock(BlockPos p_tryHarvestBlock_1_) {
        if (this.demoTimeExpired) {
            return false;
        }
        return super.tryHarvestBlock(p_tryHarvestBlock_1_);
    }

    @Override
    public EnumActionResult processRightClick(EntityPlayer p_processRightClick_1_, World p_processRightClick_2_, ItemStack p_processRightClick_3_, EnumHand p_processRightClick_4_) {
        if (this.demoTimeExpired) {
            this.sendDemoReminder();
            return EnumActionResult.PASS;
        }
        return super.processRightClick(p_processRightClick_1_, p_processRightClick_2_, p_processRightClick_3_, p_processRightClick_4_);
    }

    @Override
    public EnumActionResult processRightClickBlock(EntityPlayer p_processRightClickBlock_1_, World p_processRightClickBlock_2_, ItemStack p_processRightClickBlock_3_, EnumHand p_processRightClickBlock_4_, BlockPos p_processRightClickBlock_5_, EnumFacing p_processRightClickBlock_6_, float p_processRightClickBlock_7_, float p_processRightClickBlock_8_, float p_processRightClickBlock_9_) {
        if (this.demoTimeExpired) {
            this.sendDemoReminder();
            return EnumActionResult.PASS;
        }
        return super.processRightClickBlock(p_processRightClickBlock_1_, p_processRightClickBlock_2_, p_processRightClickBlock_3_, p_processRightClickBlock_4_, p_processRightClickBlock_5_, p_processRightClickBlock_6_, p_processRightClickBlock_7_, p_processRightClickBlock_8_, p_processRightClickBlock_9_);
    }
}

