/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.end;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseList;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeEndDecorator;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.end.DragonSpawnManager;
import net.minecraft.world.gen.feature.WorldGenEndGateway;
import net.minecraft.world.gen.feature.WorldGenEndPodium;
import net.minecraft.world.gen.feature.WorldGenSpikes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonFightManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Predicate<EntityPlayerMP> VALID_PLAYER = Predicates.and(EntitySelectors.IS_ALIVE, EntitySelectors.withinRange(0.0, 128.0, 0.0, 192.0));
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(new TextComponentTranslation("entity.EnderDragon.name", new Object[0]), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).setPlayEndBossMusic(true).setCreateFog(true);
    private final WorldServer world;
    private final List<Integer> gateways = Lists.newArrayList();
    private final BlockPattern portalPattern;
    private int ticksSinceDragonSeen;
    private int aliveCrystals;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan;
    private boolean dragonKilled;
    private boolean previouslyKilled;
    private UUID dragonUniqueId;
    private boolean scanForLegacyFight = true;
    private BlockPos exitPortalLocation;
    private DragonSpawnManager respawnState;
    private int respawnStateTicks;
    private List<EntityEnderCrystal> crystals;

    public DragonFightManager(WorldServer p_i46669_1_, NBTTagCompound p_i46669_2_) {
        this.world = p_i46669_1_;
        if (p_i46669_2_.hasKey("DragonKilled", 99)) {
            if (p_i46669_2_.hasUniqueId("DragonUUID")) {
                this.dragonUniqueId = p_i46669_2_.getUniqueId("DragonUUID");
            }
            this.dragonKilled = p_i46669_2_.getBoolean("DragonKilled");
            this.previouslyKilled = p_i46669_2_.getBoolean("PreviouslyKilled");
            if (p_i46669_2_.getBoolean("IsRespawning")) {
                this.respawnState = DragonSpawnManager.START;
            }
            if (p_i46669_2_.hasKey("ExitPortalLocation", 10)) {
                this.exitPortalLocation = NBTUtil.getPosFromTag(p_i46669_2_.getCompoundTag("ExitPortalLocation"));
            }
        } else {
            this.dragonKilled = true;
            this.previouslyKilled = true;
        }
        if (p_i46669_2_.hasKey("Gateways", 9)) {
            NBTTagList lvt_3_1_ = p_i46669_2_.getTagList("Gateways", 3);
            for (int lvt_4_1_ = 0; lvt_4_1_ < lvt_3_1_.tagCount(); ++lvt_4_1_) {
                this.gateways.add(lvt_3_1_.getIntAt(lvt_4_1_));
            }
        } else {
            this.gateways.addAll((Collection<Integer>)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(this.gateways, new Random(p_i46669_1_.getSeed()));
        }
        this.portalPattern = FactoryBlockPattern.start().aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").aisle("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").aisle("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").where('#', BlockWorldState.hasState(BlockMatcher.forBlock(Blocks.BEDROCK))).build();
    }

    public NBTTagCompound getCompound() {
        NBTTagCompound lvt_1_1_ = new NBTTagCompound();
        if (this.dragonUniqueId != null) {
            lvt_1_1_.setUniqueId("DragonUUID", this.dragonUniqueId);
        }
        lvt_1_1_.setBoolean("DragonKilled", this.dragonKilled);
        lvt_1_1_.setBoolean("PreviouslyKilled", this.previouslyKilled);
        if (this.exitPortalLocation != null) {
            lvt_1_1_.setTag("ExitPortalLocation", NBTUtil.createPosTag(this.exitPortalLocation));
        }
        NBTTagList lvt_2_1_ = new NBTTagList();
        for (int lvt_4_1_ : this.gateways) {
            lvt_2_1_.appendTag(new NBTTagInt(lvt_4_1_));
        }
        lvt_1_1_.setTag("Gateways", lvt_2_1_);
        return lvt_1_1_;
    }

    public void tick() {
        this.bossInfo.setVisible(!this.dragonKilled);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updateplayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.bossInfo.getPlayers().isEmpty()) {
            if (this.scanForLegacyFight) {
                LOGGER.info("Scanning for legacy world dragon fight...");
                this.loadChunks();
                this.scanForLegacyFight = false;
                boolean lvt_1_1_ = this.hasDragonBeenKilled();
                if (lvt_1_1_) {
                    LOGGER.info("Found that the dragon has been killed in this world already.");
                    this.previouslyKilled = true;
                } else {
                    LOGGER.info("Found that the dragon has not yet been killed in this world.");
                    this.previouslyKilled = false;
                    this.generatePortal(false);
                }
                List<Entity> lvt_2_1_ = this.world.getEntities(EntityDragon.class, EntitySelectors.IS_ALIVE);
                if (lvt_2_1_.isEmpty()) {
                    this.dragonKilled = true;
                } else {
                    EntityDragon lvt_3_1_ = (EntityDragon)lvt_2_1_.get(0);
                    this.dragonUniqueId = lvt_3_1_.getUniqueID();
                    LOGGER.info("Found that there's a dragon still alive ({})", new Object[]{lvt_3_1_});
                    this.dragonKilled = false;
                    if (!lvt_1_1_) {
                        LOGGER.info("But we didn't have a portal, let's remove it.");
                        lvt_3_1_.setDead();
                        this.dragonUniqueId = null;
                    }
                }
                if (!this.previouslyKilled && this.dragonKilled) {
                    this.dragonKilled = false;
                }
            }
            if (this.respawnState != null) {
                if (this.crystals == null) {
                    this.respawnState = null;
                    this.respawnDragon();
                }
                this.respawnState.process(this.world, this, this.crystals, this.respawnStateTicks++, this.exitPortalLocation);
            }
            if (!this.dragonKilled) {
                if (this.dragonUniqueId == null || ++this.ticksSinceDragonSeen >= 1200) {
                    this.loadChunks();
                    List<Entity> lvt_1_2_ = this.world.getEntities(EntityDragon.class, EntitySelectors.IS_ALIVE);
                    if (lvt_1_2_.isEmpty()) {
                        LOGGER.debug("Haven't seen the dragon, respawning it");
                        this.spawnDragon();
                    } else {
                        LOGGER.debug("Haven't seen our dragon, but found another one to use.");
                        this.dragonUniqueId = ((EntityDragon)lvt_1_2_.get(0)).getUniqueID();
                    }
                    this.ticksSinceDragonSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100) {
                    this.findAliveCrystals();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        }
    }

    protected void setRespawnState(DragonSpawnManager p_setRespawnState_1_) {
        if (this.respawnState == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnStateTicks = 0;
        if (p_setRespawnState_1_ == DragonSpawnManager.END) {
            this.respawnState = null;
            this.dragonKilled = false;
            this.spawnDragon();
        } else {
            this.respawnState = p_setRespawnState_1_;
        }
    }

    private boolean hasDragonBeenKilled() {
        for (int lvt_1_1_ = -8; lvt_1_1_ <= 8; ++lvt_1_1_) {
            for (int lvt_2_1_ = -8; lvt_2_1_ <= 8; ++lvt_2_1_) {
                Chunk lvt_3_1_ = this.world.getChunkFromChunkCoords(lvt_1_1_, lvt_2_1_);
                for (TileEntity lvt_5_1_ : lvt_3_1_.getTileEntityMap().values()) {
                    if (!(lvt_5_1_ instanceof TileEntityEndPortal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private BlockPattern.PatternHelper findExitPortal() {
        int lvt_1_2_;
        for (int lvt_1_1_ = -8; lvt_1_1_ <= 8; ++lvt_1_1_) {
            for (int lvt_2_1_ = -8; lvt_2_1_ <= 8; ++lvt_2_1_) {
                Chunk lvt_3_1_ = this.world.getChunkFromChunkCoords(lvt_1_1_, lvt_2_1_);
                for (TileEntity lvt_5_1_ : lvt_3_1_.getTileEntityMap().values()) {
                    BlockPattern.PatternHelper lvt_6_1_;
                    if (!(lvt_5_1_ instanceof TileEntityEndPortal) || (lvt_6_1_ = this.portalPattern.match(this.world, lvt_5_1_.getPos())) == null) continue;
                    BlockPos lvt_7_1_ = lvt_6_1_.translateOffset(3, 3, 3).getPos();
                    if (this.exitPortalLocation == null && lvt_7_1_.getX() == 0 && lvt_7_1_.getZ() == 0) {
                        this.exitPortalLocation = lvt_7_1_;
                    }
                    return lvt_6_1_;
                }
            }
        }
        for (int lvt_2_2_ = lvt_1_2_ = this.world.getHeight(WorldGenEndPodium.END_PODIUM_LOCATION).getY(); lvt_2_2_ >= 0; --lvt_2_2_) {
            BlockPattern.PatternHelper lvt_3_2_ = this.portalPattern.match(this.world, new BlockPos(WorldGenEndPodium.END_PODIUM_LOCATION.getX(), lvt_2_2_, WorldGenEndPodium.END_PODIUM_LOCATION.getZ()));
            if (lvt_3_2_ == null) continue;
            if (this.exitPortalLocation == null) {
                this.exitPortalLocation = lvt_3_2_.translateOffset(3, 3, 3).getPos();
            }
            return lvt_3_2_;
        }
        return null;
    }

    private void loadChunks() {
        for (int lvt_1_1_ = -8; lvt_1_1_ <= 8; ++lvt_1_1_) {
            for (int lvt_2_1_ = -8; lvt_2_1_ <= 8; ++lvt_2_1_) {
                this.world.getChunkFromChunkCoords(lvt_1_1_, lvt_2_1_);
            }
        }
    }

    private void updateplayers() {
        HashSet lvt_1_1_ = Sets.newHashSet();
        for (EntityPlayerMP lvt_3_1_ : this.world.getPlayers(EntityPlayerMP.class, VALID_PLAYER)) {
            this.bossInfo.addPlayer(lvt_3_1_);
            lvt_1_1_.add(lvt_3_1_);
        }
        HashSet lvt_2_1_ = Sets.newHashSet(this.bossInfo.getPlayers());
        lvt_2_1_.removeAll(lvt_1_1_);
        for (EntityPlayerMP lvt_4_1_ : lvt_2_1_) {
            this.bossInfo.removePlayer(lvt_4_1_);
        }
    }

    private void findAliveCrystals() {
        this.ticksSinceCrystalsScanned = 0;
        this.aliveCrystals = 0;
        for (WorldGenSpikes.EndSpike lvt_4_1_ : BiomeEndDecorator.getSpikesForWorld(this.world)) {
            this.aliveCrystals += this.world.getEntitiesWithinAABB(EntityEnderCrystal.class, lvt_4_1_.getTopBoundingBox()).size();
        }
        LOGGER.debug("Found {} end crystals still alive", new Object[]{this.aliveCrystals});
    }

    public void processDragonDeath(EntityDragon p_processDragonDeath_1_) {
        if (p_processDragonDeath_1_.getUniqueID().equals(this.dragonUniqueId)) {
            this.bossInfo.setPercent(0.0f);
            this.bossInfo.setVisible(false);
            this.generatePortal(true);
            this.spawnNewGateway();
            if (!this.previouslyKilled) {
                this.world.setBlockState(this.world.getHeight(WorldGenEndPodium.END_PODIUM_LOCATION), Blocks.DRAGON_EGG.getDefaultState());
            }
            this.previouslyKilled = true;
            this.dragonKilled = true;
        }
    }

    private void spawnNewGateway() {
        if (this.gateways.isEmpty()) {
            return;
        }
        int lvt_1_1_ = this.gateways.remove(this.gateways.size() - 1);
        int lvt_2_1_ = (int)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)lvt_1_1_)));
        int lvt_3_1_ = (int)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)lvt_1_1_)));
        this.generateGateway(new BlockPos(lvt_2_1_, 75, lvt_3_1_));
    }

    private void generateGateway(BlockPos p_generateGateway_1_) {
        this.world.playEvent(3000, p_generateGateway_1_, 0);
        new WorldGenEndGateway().generate(this.world, new Random(), p_generateGateway_1_);
    }

    private void generatePortal(boolean p_generatePortal_1_) {
        WorldGenEndPodium lvt_2_1_ = new WorldGenEndPodium(p_generatePortal_1_);
        if (this.exitPortalLocation == null) {
            this.exitPortalLocation = this.world.getTopSolidOrLiquidBlock(WorldGenEndPodium.END_PODIUM_LOCATION).down();
            while (this.world.getBlockState(this.exitPortalLocation).getBlock() == Blocks.BEDROCK && this.exitPortalLocation.getY() > this.world.getSeaLevel()) {
                this.exitPortalLocation = this.exitPortalLocation.down();
            }
        }
        lvt_2_1_.generate(this.world, new Random(), this.exitPortalLocation);
    }

    private void spawnDragon() {
        this.world.getChunkFromBlockCoords(new BlockPos(0, 128, 0));
        EntityDragon lvt_1_1_ = new EntityDragon(this.world);
        lvt_1_1_.getPhaseManager().setPhase(PhaseList.HOLDING_PATTERN);
        lvt_1_1_.setLocationAndAngles(0.0, 128.0, 0.0, this.world.rand.nextFloat() * 360.0f, 0.0f);
        this.world.spawnEntity(lvt_1_1_);
        this.dragonUniqueId = lvt_1_1_.getUniqueID();
    }

    public void dragonUpdate(EntityDragon p_dragonUpdate_1_) {
        if (p_dragonUpdate_1_.getUniqueID().equals(this.dragonUniqueId)) {
            this.bossInfo.setPercent(p_dragonUpdate_1_.getHealth() / p_dragonUpdate_1_.getMaxHealth());
            this.ticksSinceDragonSeen = 0;
            if (p_dragonUpdate_1_.hasCustomName()) {
                this.bossInfo.setName(p_dragonUpdate_1_.getDisplayName());
            }
        }
    }

    public int getNumAliveCrystals() {
        return this.aliveCrystals;
    }

    public void onCrystalDestroyed(EntityEnderCrystal p_onCrystalDestroyed_1_, DamageSource p_onCrystalDestroyed_2_) {
        if (this.respawnState != null && this.crystals.contains(p_onCrystalDestroyed_1_)) {
            LOGGER.debug("Aborting respawn sequence");
            this.respawnState = null;
            this.respawnStateTicks = 0;
            this.resetSpikeCrystals();
            this.generatePortal(true);
        } else {
            this.findAliveCrystals();
            Entity lvt_3_1_ = this.world.getEntityFromUuid(this.dragonUniqueId);
            if (lvt_3_1_ instanceof EntityDragon) {
                ((EntityDragon)lvt_3_1_).onCrystalDestroyed(p_onCrystalDestroyed_1_, new BlockPos(p_onCrystalDestroyed_1_), p_onCrystalDestroyed_2_);
            }
        }
    }

    public boolean hasPreviouslyKilledDragon() {
        return this.previouslyKilled;
    }

    public void respawnDragon() {
        if (this.dragonKilled && this.respawnState == null) {
            BlockPos lvt_1_1_ = this.exitPortalLocation;
            if (lvt_1_1_ == null) {
                LOGGER.debug("Tried to respawn, but need to find the portal first.");
                BlockPattern.PatternHelper lvt_2_1_ = this.findExitPortal();
                if (lvt_2_1_ == null) {
                    LOGGER.debug("Couldn't find a portal, so we made one.");
                    this.generatePortal(true);
                } else {
                    LOGGER.debug("Found the exit portal & temporarily using it.");
                }
                lvt_1_1_ = this.exitPortalLocation;
            }
            ArrayList lvt_2_2_ = Lists.newArrayList();
            BlockPos lvt_3_1_ = lvt_1_1_.up(1);
            for (EnumFacing lvt_5_1_ : EnumFacing.Plane.HORIZONTAL) {
                List<EntityEnderCrystal> lvt_6_1_ = this.world.getEntitiesWithinAABB(EntityEnderCrystal.class, new AxisAlignedBB(lvt_3_1_.offset(lvt_5_1_, 2)));
                if (lvt_6_1_.isEmpty()) {
                    return;
                }
                lvt_2_2_.addAll(lvt_6_1_);
            }
            LOGGER.debug("Found all crystals, respawning dragon.");
            this.respawnDragon(lvt_2_2_);
        }
    }

    private void respawnDragon(List<EntityEnderCrystal> p_respawnDragon_1_) {
        if (this.dragonKilled && this.respawnState == null) {
            BlockPattern.PatternHelper lvt_2_1_ = this.findExitPortal();
            while (lvt_2_1_ != null) {
                for (int lvt_3_1_ = 0; lvt_3_1_ < this.portalPattern.getPalmLength(); ++lvt_3_1_) {
                    for (int lvt_4_1_ = 0; lvt_4_1_ < this.portalPattern.getThumbLength(); ++lvt_4_1_) {
                        for (int lvt_5_1_ = 0; lvt_5_1_ < this.portalPattern.getFingerLength(); ++lvt_5_1_) {
                            BlockWorldState lvt_6_1_ = lvt_2_1_.translateOffset(lvt_3_1_, lvt_4_1_, lvt_5_1_);
                            if (lvt_6_1_.getBlockState().getBlock() != Blocks.BEDROCK && lvt_6_1_.getBlockState().getBlock() != Blocks.END_PORTAL) continue;
                            this.world.setBlockState(lvt_6_1_.getPos(), Blocks.END_STONE.getDefaultState());
                        }
                    }
                }
                lvt_2_1_ = this.findExitPortal();
            }
            this.respawnState = DragonSpawnManager.START;
            this.respawnStateTicks = 0;
            this.generatePortal(false);
            this.crystals = p_respawnDragon_1_;
        }
    }

    public void resetSpikeCrystals() {
        for (WorldGenSpikes.EndSpike lvt_4_1_ : BiomeEndDecorator.getSpikesForWorld(this.world)) {
            List<EntityEnderCrystal> lvt_5_1_ = this.world.getEntitiesWithinAABB(EntityEnderCrystal.class, lvt_4_1_.getTopBoundingBox());
            for (EntityEnderCrystal lvt_7_1_ : lvt_5_1_) {
                lvt_7_1_.setEntityInvulnerable(false);
                lvt_7_1_.setBeamTarget(null);
            }
        }
    }
}

