/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.end;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeEndDecorator;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.feature.WorldGenSpikes;

public enum DragonSpawnManager {
    START{

        @Override
        public void process(WorldServer p_process_1_, DragonFightManager p_process_2_, List<EntityEnderCrystal> p_process_3_, int p_process_4_, BlockPos p_process_5_) {
            BlockPos lvt_6_1_ = new BlockPos(0, 128, 0);
            for (EntityEnderCrystal lvt_8_1_ : p_process_3_) {
                lvt_8_1_.setBeamTarget(lvt_6_1_);
            }
            p_process_2_.setRespawnState(PREPARING_TO_SUMMON_PILLARS);
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS{

        @Override
        public void process(WorldServer p_process_1_, DragonFightManager p_process_2_, List<EntityEnderCrystal> p_process_3_, int p_process_4_, BlockPos p_process_5_) {
            if (p_process_4_ < 100) {
                if (p_process_4_ == 0 || p_process_4_ == 50 || p_process_4_ == 51 || p_process_4_ == 52 || p_process_4_ >= 95) {
                    p_process_1_.playEvent(3001, new BlockPos(0, 128, 0), 0);
                }
            } else {
                p_process_2_.setRespawnState(SUMMONING_PILLARS);
            }
        }
    }
    ,
    SUMMONING_PILLARS{

        @Override
        public void process(WorldServer p_process_1_, DragonFightManager p_process_2_, List<EntityEnderCrystal> p_process_3_, int p_process_4_, BlockPos p_process_5_) {
            boolean lvt_8_1_;
            int lvt_6_1_ = 40;
            boolean lvt_7_1_ = p_process_4_ % 40 == 0;
            boolean bl = lvt_8_1_ = p_process_4_ % 40 == 39;
            if (lvt_7_1_ || lvt_8_1_) {
                int lvt_10_1_ = p_process_4_ / 40;
                WorldGenSpikes.EndSpike[] lvt_9_1_ = BiomeEndDecorator.getSpikesForWorld(p_process_1_);
                if (lvt_10_1_ < lvt_9_1_.length) {
                    WorldGenSpikes.EndSpike lvt_11_1_ = lvt_9_1_[lvt_10_1_];
                    if (lvt_7_1_) {
                        for (EntityEnderCrystal lvt_13_1_ : p_process_3_) {
                            lvt_13_1_.setBeamTarget(new BlockPos(lvt_11_1_.getCenterX(), lvt_11_1_.getHeight() + 1, lvt_11_1_.getCenterZ()));
                        }
                    } else {
                        int lvt_12_1_ = 10;
                        for (BlockPos.MutableBlockPos lvt_14_1_ : BlockPos.getAllInBoxMutable(new BlockPos(lvt_11_1_.getCenterX() - 10, lvt_11_1_.getHeight() - 10, lvt_11_1_.getCenterZ() - 10), new BlockPos(lvt_11_1_.getCenterX() + 10, lvt_11_1_.getHeight() + 10, lvt_11_1_.getCenterZ() + 10))) {
                            p_process_1_.setBlockToAir(lvt_14_1_);
                        }
                        p_process_1_.createExplosion(null, (float)lvt_11_1_.getCenterX() + 0.5f, lvt_11_1_.getHeight(), (float)lvt_11_1_.getCenterZ() + 0.5f, 5.0f, true);
                        WorldGenSpikes lvt_13_2_ = new WorldGenSpikes();
                        lvt_13_2_.setSpike(lvt_11_1_);
                        lvt_13_2_.setCrystalInvulnerable(true);
                        lvt_13_2_.setBeamTarget(new BlockPos(0, 128, 0));
                        lvt_13_2_.generate(p_process_1_, new Random(), new BlockPos(lvt_11_1_.getCenterX(), 45, lvt_11_1_.getCenterZ()));
                    }
                } else if (lvt_7_1_) {
                    p_process_2_.setRespawnState(SUMMONING_DRAGON);
                }
            }
        }
    }
    ,
    SUMMONING_DRAGON{

        @Override
        public void process(WorldServer p_process_1_, DragonFightManager p_process_2_, List<EntityEnderCrystal> p_process_3_, int p_process_4_, BlockPos p_process_5_) {
            if (p_process_4_ >= 100) {
                p_process_2_.setRespawnState(END);
                p_process_2_.resetSpikeCrystals();
                for (EntityEnderCrystal lvt_7_1_ : p_process_3_) {
                    lvt_7_1_.setBeamTarget(null);
                    p_process_1_.createExplosion(lvt_7_1_, lvt_7_1_.posX, lvt_7_1_.posY, lvt_7_1_.posZ, 6.0f, false);
                    lvt_7_1_.setDead();
                }
            } else if (p_process_4_ >= 80) {
                p_process_1_.playEvent(3001, new BlockPos(0, 128, 0), 0);
            } else if (p_process_4_ == 0) {
                for (EntityEnderCrystal lvt_7_2_ : p_process_3_) {
                    lvt_7_2_.setBeamTarget(new BlockPos(0, 128, 0));
                }
            } else if (p_process_4_ < 5) {
                p_process_1_.playEvent(3001, new BlockPos(0, 128, 0), 0);
            }
        }
    }
    ,
    END{

        @Override
        public void process(WorldServer p_process_1_, DragonFightManager p_process_2_, List<EntityEnderCrystal> p_process_3_, int p_process_4_, BlockPos p_process_5_) {
        }
    };


    public abstract void process(WorldServer var1, DragonFightManager var2, List<EntityEnderCrystal> var3, int var4, BlockPos var5);
}

