/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;

public class ChunkProviderDebug
implements IChunkGenerator {
    private static final List<IBlockState> ALL_VALID_STATES = Lists.newArrayList();
    private static final int GRID_WIDTH;
    private static final int GRID_HEIGHT;
    protected static final IBlockState AIR;
    protected static final IBlockState BARRIER;
    private final World world;

    public ChunkProviderDebug(World p_i45638_1_) {
        this.world = p_i45638_1_;
    }

    @Override
    public Chunk provideChunk(int p_provideChunk_1_, int p_provideChunk_2_) {
        ChunkPrimer lvt_3_1_ = new ChunkPrimer();
        for (int lvt_4_1_ = 0; lvt_4_1_ < 16; ++lvt_4_1_) {
            for (int lvt_5_1_ = 0; lvt_5_1_ < 16; ++lvt_5_1_) {
                int lvt_6_1_ = p_provideChunk_1_ * 16 + lvt_4_1_;
                int lvt_7_1_ = p_provideChunk_2_ * 16 + lvt_5_1_;
                lvt_3_1_.setBlockState(lvt_4_1_, 60, lvt_5_1_, BARRIER);
                IBlockState lvt_8_1_ = ChunkProviderDebug.getBlockStateFor(lvt_6_1_, lvt_7_1_);
                if (lvt_8_1_ == null) continue;
                lvt_3_1_.setBlockState(lvt_4_1_, 70, lvt_5_1_, lvt_8_1_);
            }
        }
        Chunk lvt_4_2_ = new Chunk(this.world, lvt_3_1_, p_provideChunk_1_, p_provideChunk_2_);
        lvt_4_2_.generateSkylightMap();
        Biome[] lvt_5_2_ = this.world.getBiomeProvider().getBiomes(null, p_provideChunk_1_ * 16, p_provideChunk_2_ * 16, 16, 16);
        byte[] lvt_6_2_ = lvt_4_2_.getBiomeArray();
        for (int lvt_7_2_ = 0; lvt_7_2_ < lvt_6_2_.length; ++lvt_7_2_) {
            lvt_6_2_[lvt_7_2_] = (byte)Biome.getIdForBiome(lvt_5_2_[lvt_7_2_]);
        }
        lvt_4_2_.generateSkylightMap();
        return lvt_4_2_;
    }

    public static IBlockState getBlockStateFor(int p_getBlockStateFor_0_, int p_getBlockStateFor_1_) {
        int lvt_3_1_;
        IBlockState lvt_2_1_ = AIR;
        if (p_getBlockStateFor_0_ > 0 && p_getBlockStateFor_1_ > 0 && p_getBlockStateFor_0_ % 2 != 0 && p_getBlockStateFor_1_ % 2 != 0 && (p_getBlockStateFor_0_ /= 2) <= GRID_WIDTH && (p_getBlockStateFor_1_ /= 2) <= GRID_HEIGHT && (lvt_3_1_ = MathHelper.abs(p_getBlockStateFor_0_ * GRID_WIDTH + p_getBlockStateFor_1_)) < ALL_VALID_STATES.size()) {
            lvt_2_1_ = ALL_VALID_STATES.get(lvt_3_1_);
        }
        return lvt_2_1_;
    }

    @Override
    public void populate(int p_populate_1_, int p_populate_2_) {
    }

    @Override
    public boolean generateStructures(Chunk p_generateStructures_1_, int p_generateStructures_2_, int p_generateStructures_3_) {
        return false;
    }

    @Override
    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType p_getPossibleCreatures_1_, BlockPos p_getPossibleCreatures_2_) {
        Biome lvt_3_1_ = this.world.getBiome(p_getPossibleCreatures_2_);
        return lvt_3_1_.getSpawnableList(p_getPossibleCreatures_1_);
    }

    @Override
    @Nullable
    public BlockPos getStrongholdGen(World p_getStrongholdGen_1_, String p_getStrongholdGen_2_, BlockPos p_getStrongholdGen_3_, boolean p_getStrongholdGen_4_) {
        return null;
    }

    @Override
    public void recreateStructures(Chunk p_recreateStructures_1_, int p_recreateStructures_2_, int p_recreateStructures_3_) {
    }

    static {
        AIR = Blocks.AIR.getDefaultState();
        BARRIER = Blocks.BARRIER.getDefaultState();
        for (Block lvt_1_1_ : Block.REGISTRY) {
            ALL_VALID_STATES.addAll((Collection<IBlockState>)lvt_1_1_.getBlockState().getValidStates());
        }
        GRID_WIDTH = MathHelper.ceil(MathHelper.sqrt(ALL_VALID_STATES.size()));
        GRID_HEIGHT = MathHelper.ceil((float)ALL_VALID_STATES.size() / (float)GRID_WIDTH);
    }
}

