/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraft.world.gen.feature.WorldGenEndGateway;
import net.minecraft.world.gen.feature.WorldGenEndIsland;
import net.minecraft.world.gen.structure.MapGenEndCity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderEnd
implements IChunkGenerator {
    private final Random rand;
    protected static final IBlockState END_STONE = Blocks.END_STONE.getDefaultState();
    protected static final IBlockState AIR = Blocks.AIR.getDefaultState();
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    private final World world;
    private final boolean mapFeaturesEnabled;
    private final BlockPos spawnPoint;
    private final MapGenEndCity endCityGen = new MapGenEndCity(this);
    private NoiseGeneratorSimplex islandNoise;
    private double[] buffer;
    private Biome[] biomesForGeneration;
    double[] pnr;
    double[] ar;
    double[] br;
    private final WorldGenEndIsland endIslands = new WorldGenEndIsland();
    private int chunkX = 0;
    private int chunkZ = 0;

    public ChunkProviderEnd(World p_i47241_1_, boolean p_i47241_2_, long p_i47241_3_, BlockPos p_i47241_5_) {
        this.world = p_i47241_1_;
        this.mapFeaturesEnabled = p_i47241_2_;
        this.spawnPoint = p_i47241_5_;
        this.rand = new Random(p_i47241_3_);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.islandNoise = new NoiseGeneratorSimplex(this.rand);
        InitNoiseGensEvent.ContextEnd ctx = new InitNoiseGensEvent.ContextEnd(this.lperlinNoise1, this.lperlinNoise2, this.perlinNoise1, this.noiseGen5, this.noiseGen6, this.islandNoise);
        ctx = TerrainGen.getModdedNoiseGenerators(p_i47241_1_, this.rand, ctx);
        this.lperlinNoise1 = ctx.getLPerlin1();
        this.lperlinNoise2 = ctx.getLPerlin2();
        this.perlinNoise1 = ctx.getPerlin();
        this.noiseGen5 = ctx.getDepth();
        this.noiseGen6 = ctx.getScale();
        this.islandNoise = ctx.getIsland();
    }

    public void setBlocksInChunk(int p_setBlocksInChunk_1_, int p_setBlocksInChunk_2_, ChunkPrimer p_setBlocksInChunk_3_) {
        int i = 2;
        int j = 3;
        int k = 33;
        int l = 3;
        this.buffer = this.getHeights(this.buffer, p_setBlocksInChunk_1_ * 2, 0, p_setBlocksInChunk_2_ * 2, 3, 33, 3);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d0 = 0.25;
                    double d1 = this.buffer[((i1 + 0) * 3 + j1 + 0) * 33 + k1 + 0];
                    double d2 = this.buffer[((i1 + 0) * 3 + j1 + 1) * 33 + k1 + 0];
                    double d3 = this.buffer[((i1 + 1) * 3 + j1 + 0) * 33 + k1 + 0];
                    double d4 = this.buffer[((i1 + 1) * 3 + j1 + 1) * 33 + k1 + 0];
                    double d5 = (this.buffer[((i1 + 0) * 3 + j1 + 0) * 33 + k1 + 1] - d1) * 0.25;
                    double d6 = (this.buffer[((i1 + 0) * 3 + j1 + 1) * 33 + k1 + 1] - d2) * 0.25;
                    double d7 = (this.buffer[((i1 + 1) * 3 + j1 + 0) * 33 + k1 + 1] - d3) * 0.25;
                    double d8 = (this.buffer[((i1 + 1) * 3 + j1 + 1) * 33 + k1 + 1] - d4) * 0.25;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.125;
                        double d13 = (d4 - d2) * 0.125;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.125;
                            for (int j2 = 0; j2 < 8; ++j2) {
                                IBlockState iblockstate = AIR;
                                if (d15 > 0.0) {
                                    iblockstate = END_STONE;
                                }
                                int k2 = i2 + i1 * 8;
                                int l2 = l1 + k1 * 4;
                                int i3 = j2 + j1 * 8;
                                p_setBlocksInChunk_3_.setBlockState(k2, l2, i3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void buildSurfaces(ChunkPrimer p_buildSurfaces_1_) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks(this, this.chunkX, this.chunkZ, p_buildSurfaces_1_, this.world)) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                boolean k = true;
                int l = -1;
                IBlockState iblockstate = END_STONE;
                IBlockState iblockstate1 = END_STONE;
                for (int i1 = 127; i1 >= 0; --i1) {
                    IBlockState iblockstate2 = p_buildSurfaces_1_.getBlockState(i, i1, j);
                    if (iblockstate2.getMaterial() == Material.AIR) {
                        l = -1;
                        continue;
                    }
                    if (iblockstate2.getBlock() != Blocks.STONE) continue;
                    if (l == -1) {
                        l = 1;
                        if (i1 >= 0) {
                            p_buildSurfaces_1_.setBlockState(i, i1, j, iblockstate);
                            continue;
                        }
                        p_buildSurfaces_1_.setBlockState(i, i1, j, iblockstate1);
                        continue;
                    }
                    if (l <= 0) continue;
                    --l;
                    p_buildSurfaces_1_.setBlockState(i, i1, j, iblockstate1);
                }
            }
        }
    }

    @Override
    public Chunk provideChunk(int p_provideChunk_1_, int p_provideChunk_2_) {
        this.chunkX = p_provideChunk_1_;
        this.chunkZ = p_provideChunk_2_;
        this.rand.setSeed((long)p_provideChunk_1_ * 341873128712L + (long)p_provideChunk_2_ * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.world.getBiomeProvider().getBiomes(this.biomesForGeneration, p_provideChunk_1_ * 16, p_provideChunk_2_ * 16, 16, 16);
        this.setBlocksInChunk(p_provideChunk_1_, p_provideChunk_2_, chunkprimer);
        this.buildSurfaces(chunkprimer);
        if (this.mapFeaturesEnabled) {
            this.endCityGen.generate(this.world, p_provideChunk_1_, p_provideChunk_2_, chunkprimer);
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, p_provideChunk_1_, p_provideChunk_2_);
        byte[] abyte = chunk.getBiomeArray();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.getIdForBiome(this.biomesForGeneration[i]);
        }
        chunk.generateSkylightMap();
        return chunk;
    }

    private float getIslandHeightValue(int p_getIslandHeightValue_1_, int p_getIslandHeightValue_2_, int p_getIslandHeightValue_3_, int p_getIslandHeightValue_4_) {
        float f = p_getIslandHeightValue_1_ * 2 + p_getIslandHeightValue_3_;
        float f1 = p_getIslandHeightValue_2_ * 2 + p_getIslandHeightValue_4_;
        float f2 = 100.0f - MathHelper.sqrt(f * f + f1 * f1) * 8.0f;
        if (f2 > 80.0f) {
            f2 = 80.0f;
        }
        if (f2 < -100.0f) {
            f2 = -100.0f;
        }
        for (int i = -12; i <= 12; ++i) {
            for (int j = -12; j <= 12; ++j) {
                long k = p_getIslandHeightValue_1_ + i;
                long l = p_getIslandHeightValue_2_ + j;
                if (k * k + l * l <= 4096L || !(this.islandNoise.getValue(k, l) < (double)-0.9f)) continue;
                float f3 = (MathHelper.abs(k) * 3439.0f + MathHelper.abs(l) * 147.0f) % 13.0f + 9.0f;
                f = p_getIslandHeightValue_3_ - i * 2;
                f1 = p_getIslandHeightValue_4_ - j * 2;
                float f4 = 100.0f - MathHelper.sqrt(f * f + f1 * f1) * f3;
                if (f4 > 80.0f) {
                    f4 = 80.0f;
                }
                if (f4 < -100.0f) {
                    f4 = -100.0f;
                }
                if (!(f4 > f2)) continue;
                f2 = f4;
            }
        }
        return f2;
    }

    public boolean isIslandChunk(int p_isIslandChunk_1_, int p_isIslandChunk_2_) {
        return (long)p_isIslandChunk_1_ * (long)p_isIslandChunk_1_ + (long)p_isIslandChunk_2_ * (long)p_isIslandChunk_2_ > 4096L && this.getIslandHeightValue(p_isIslandChunk_1_, p_isIslandChunk_2_, 1, 1) >= 0.0f;
    }

    private double[] getHeights(double[] p_getHeights_1_, int p_getHeights_2_, int p_getHeights_3_, int p_getHeights_4_, int p_getHeights_5_, int p_getHeights_6_, int p_getHeights_7_) {
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField(this, p_getHeights_1_, p_getHeights_2_, p_getHeights_3_, p_getHeights_4_, p_getHeights_5_, p_getHeights_6_, p_getHeights_7_);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        if (p_getHeights_1_ == null) {
            p_getHeights_1_ = new double[p_getHeights_5_ * p_getHeights_6_ * p_getHeights_7_];
        }
        double d0 = 684.412;
        double d1 = 684.412;
        this.pnr = this.perlinNoise1.generateNoiseOctaves(this.pnr, p_getHeights_2_, p_getHeights_3_, p_getHeights_4_, p_getHeights_5_, p_getHeights_6_, p_getHeights_7_, (d0 *= 2.0) / 80.0, 4.277575000000001, d0 / 80.0);
        this.ar = this.lperlinNoise1.generateNoiseOctaves(this.ar, p_getHeights_2_, p_getHeights_3_, p_getHeights_4_, p_getHeights_5_, p_getHeights_6_, p_getHeights_7_, d0, 684.412, d0);
        this.br = this.lperlinNoise2.generateNoiseOctaves(this.br, p_getHeights_2_, p_getHeights_3_, p_getHeights_4_, p_getHeights_5_, p_getHeights_6_, p_getHeights_7_, d0, 684.412, d0);
        int i = p_getHeights_2_ / 2;
        int j = p_getHeights_4_ / 2;
        int k = 0;
        for (int l = 0; l < p_getHeights_5_; ++l) {
            for (int i1 = 0; i1 < p_getHeights_7_; ++i1) {
                float f = this.getIslandHeightValue(i, j, l, i1);
                for (int j1 = 0; j1 < p_getHeights_6_; ++j1) {
                    double d2 = this.ar[k] / 512.0;
                    double d3 = this.br[k] / 512.0;
                    double d5 = (this.pnr[k] / 10.0 + 1.0) / 2.0;
                    double d4 = d5 < 0.0 ? d2 : (d5 > 1.0 ? d3 : d2 + (d3 - d2) * d5);
                    d4 -= 8.0;
                    d4 += (double)f;
                    int k1 = 2;
                    if (j1 > p_getHeights_6_ / 2 - k1) {
                        double d6 = (float)(j1 - (p_getHeights_6_ / 2 - k1)) / 64.0f;
                        d6 = MathHelper.clamp(d6, 0.0, 1.0);
                        d4 = d4 * (1.0 - d6) + -3000.0 * d6;
                    }
                    if (j1 < (k1 = 8)) {
                        double d7 = (float)(k1 - j1) / ((float)k1 - 1.0f);
                        d4 = d4 * (1.0 - d7) + -30.0 * d7;
                    }
                    p_getHeights_1_[k] = d4;
                    ++k;
                }
            }
        }
        return p_getHeights_1_;
    }

    @Override
    public void populate(int p_populate_1_, int p_populate_2_) {
        BlockFalling.fallInstantly = true;
        ForgeEventFactory.onChunkPopulate(true, this, this.world, this.rand, p_populate_1_, p_populate_2_, false);
        BlockPos blockpos = new BlockPos(p_populate_1_ * 16, 0, p_populate_2_ * 16);
        if (this.mapFeaturesEnabled) {
            this.endCityGen.generateStructure(this.world, this.rand, new ChunkPos(p_populate_1_, p_populate_2_));
        }
        this.world.getBiome(blockpos.add(16, 0, 16)).decorate(this.world, this.world.rand, blockpos);
        long i = (long)p_populate_1_ * (long)p_populate_1_ + (long)p_populate_2_ * (long)p_populate_2_;
        if (i > 4096L) {
            float f = this.getIslandHeightValue(p_populate_1_, p_populate_2_, 1, 1);
            if (f < -20.0f && this.rand.nextInt(14) == 0) {
                this.endIslands.generate(this.world, this.rand, blockpos.add(this.rand.nextInt(16) + 8, 55 + this.rand.nextInt(16), this.rand.nextInt(16) + 8));
                if (this.rand.nextInt(4) == 0) {
                    this.endIslands.generate(this.world, this.rand, blockpos.add(this.rand.nextInt(16) + 8, 55 + this.rand.nextInt(16), this.rand.nextInt(16) + 8));
                }
            }
            if (this.getIslandHeightValue(p_populate_1_, p_populate_2_, 1, 1) > 40.0f) {
                int i2;
                int l1;
                int j2;
                int j = this.rand.nextInt(5);
                for (int k = 0; k < j; ++k) {
                    int k1;
                    int i1;
                    int l = this.rand.nextInt(16) + 8;
                    int j1 = this.world.getHeight(blockpos.add(l, 0, i1 = this.rand.nextInt(16) + 8)).getY();
                    if (j1 <= 0 || !this.world.isAirBlock(blockpos.add(l, (k1 = j1 - 1) + 1, i1)) || this.world.getBlockState(blockpos.add(l, k1, i1)).getBlock() != Blocks.END_STONE) continue;
                    BlockChorusFlower.generatePlant(this.world, blockpos.add(l, k1 + 1, i1), this.rand, 8);
                }
                if (this.rand.nextInt(700) == 0 && (j2 = this.world.getHeight(blockpos.add(l1 = this.rand.nextInt(16) + 8, 0, i2 = this.rand.nextInt(16) + 8)).getY()) > 0) {
                    int k2 = j2 + 3 + this.rand.nextInt(7);
                    BlockPos blockpos1 = blockpos.add(l1, k2, i2);
                    new WorldGenEndGateway().generate(this.world, this.rand, blockpos1);
                    TileEntity tileentity = this.world.getTileEntity(blockpos1);
                    if (tileentity instanceof TileEntityEndGateway) {
                        TileEntityEndGateway tileentityendgateway = (TileEntityEndGateway)tileentity;
                        tileentityendgateway.setExactPosition(this.spawnPoint);
                    }
                }
            }
        }
        ForgeEventFactory.onChunkPopulate(false, this, this.world, this.rand, p_populate_1_, p_populate_2_, false);
        BlockFalling.fallInstantly = false;
    }

    @Override
    public boolean generateStructures(Chunk p_generateStructures_1_, int p_generateStructures_2_, int p_generateStructures_3_) {
        return false;
    }

    @Override
    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType p_getPossibleCreatures_1_, BlockPos p_getPossibleCreatures_2_) {
        return this.world.getBiome(p_getPossibleCreatures_2_).getSpawnableList(p_getPossibleCreatures_1_);
    }

    @Override
    @Nullable
    public BlockPos getStrongholdGen(World p_getStrongholdGen_1_, String p_getStrongholdGen_2_, BlockPos p_getStrongholdGen_3_, boolean p_getStrongholdGen_4_) {
        return "EndCity".equals(p_getStrongholdGen_2_) && this.endCityGen != null ? this.endCityGen.getClosestStrongholdPos(p_getStrongholdGen_1_, p_getStrongholdGen_3_, p_getStrongholdGen_4_) : null;
    }

    @Override
    public void recreateStructures(Chunk p_recreateStructures_1_, int p_recreateStructures_2_, int p_recreateStructures_3_) {
    }
}

