/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.event.ForgeEventFactory;

public class ChunkProviderFlat
implements IChunkGenerator {
    private final World world;
    private final Random random;
    private final IBlockState[] cachedBlockIDs = new IBlockState[256];
    private final FlatGeneratorInfo flatWorldGenInfo;
    private final Map<String, MapGenStructure> structureGenerators = new HashMap<String, MapGenStructure>();
    private final boolean hasDecoration;
    private final boolean hasDungeons;
    private WorldGenLakes waterLakeGenerator;
    private WorldGenLakes lavaLakeGenerator;

    public ChunkProviderFlat(World p_i2004_1_, long p_i2004_2_, boolean p_i2004_4_, String p_i2004_5_) {
        this.world = p_i2004_1_;
        this.random = new Random(p_i2004_2_);
        this.flatWorldGenInfo = FlatGeneratorInfo.createFlatGeneratorFromString(p_i2004_5_);
        if (p_i2004_4_) {
            Map<String, Map<String, String>> map = this.flatWorldGenInfo.getWorldFeatures();
            if (map.containsKey("village")) {
                Map<String, String> map1 = map.get("village");
                if (!map1.containsKey("size")) {
                    map1.put("size", "1");
                }
                this.structureGenerators.put("Village", new MapGenVillage(map1));
            }
            if (map.containsKey("biome_1")) {
                this.structureGenerators.put("Temple", new MapGenScatteredFeature(map.get("biome_1")));
            }
            if (map.containsKey("mineshaft")) {
                this.structureGenerators.put("Mineshaft", new MapGenMineshaft(map.get("mineshaft")));
            }
            if (map.containsKey("stronghold")) {
                this.structureGenerators.put("Stronghold", new MapGenStronghold(map.get("stronghold")));
            }
            if (map.containsKey("oceanmonument")) {
                this.structureGenerators.put("Monument", new StructureOceanMonument(map.get("oceanmonument")));
            }
        }
        if (this.flatWorldGenInfo.getWorldFeatures().containsKey("lake")) {
            this.waterLakeGenerator = new WorldGenLakes(Blocks.WATER);
        }
        if (this.flatWorldGenInfo.getWorldFeatures().containsKey("lava_lake")) {
            this.lavaLakeGenerator = new WorldGenLakes(Blocks.LAVA);
        }
        this.hasDungeons = this.flatWorldGenInfo.getWorldFeatures().containsKey("dungeon");
        int j = 0;
        int k = 0;
        boolean flag = true;
        for (FlatLayerInfo flatlayerinfo : this.flatWorldGenInfo.getFlatLayers()) {
            for (int i = flatlayerinfo.getMinY(); i < flatlayerinfo.getMinY() + flatlayerinfo.getLayerCount(); ++i) {
                IBlockState iblockstate = flatlayerinfo.getLayerMaterial();
                if (iblockstate.getBlock() == Blocks.AIR) continue;
                flag = false;
                this.cachedBlockIDs[i] = iblockstate;
            }
            if (flatlayerinfo.getLayerMaterial().getBlock() == Blocks.AIR) {
                k += flatlayerinfo.getLayerCount();
                continue;
            }
            j += flatlayerinfo.getLayerCount() + k;
            k = 0;
        }
        p_i2004_1_.setSeaLevel(j);
        this.hasDecoration = flag && this.flatWorldGenInfo.getBiome() != Biome.getIdForBiome(Biomes.VOID) ? false : this.flatWorldGenInfo.getWorldFeatures().containsKey("decoration");
    }

    @Override
    public Chunk provideChunk(int p_provideChunk_1_, int p_provideChunk_2_) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        for (int i = 0; i < this.cachedBlockIDs.length; ++i) {
            IBlockState iBlockState = this.cachedBlockIDs[i];
            if (iBlockState == null) continue;
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    chunkprimer.setBlockState(j, i, k, iBlockState);
                }
            }
        }
        for (MapGenBase mapGenBase : this.structureGenerators.values()) {
            mapGenBase.generate(this.world, p_provideChunk_1_, p_provideChunk_2_, chunkprimer);
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, p_provideChunk_1_, p_provideChunk_2_);
        Biome[] biomeArray = this.world.getBiomeProvider().getBiomes(null, p_provideChunk_1_ * 16, p_provideChunk_2_ * 16, 16, 16);
        byte[] abyte = chunk.getBiomeArray();
        for (int l = 0; l < abyte.length; ++l) {
            abyte[l] = (byte)Biome.getIdForBiome(biomeArray[l]);
        }
        chunk.generateSkylightMap();
        return chunk;
    }

    @Override
    public void populate(int p_populate_1_, int p_populate_2_) {
        BlockPos blockpos1;
        BlockFalling.fallInstantly = true;
        int i = p_populate_1_ * 16;
        int j = p_populate_2_ * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.getBiome(new BlockPos(i + 16, 0, j + 16));
        boolean flag = false;
        this.random.setSeed(this.world.getSeed());
        long k = this.random.nextLong() / 2L * 2L + 1L;
        long l = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)p_populate_1_ * k + (long)p_populate_2_ * l ^ this.world.getSeed());
        ChunkPos chunkpos = new ChunkPos(p_populate_1_, p_populate_2_);
        ForgeEventFactory.onChunkPopulate(true, this, this.world, this.random, p_populate_1_, p_populate_2_, flag);
        for (MapGenStructure mapgenstructure : this.structureGenerators.values()) {
            boolean flag1 = mapgenstructure.generateStructure(this.world, this.random, chunkpos);
            if (!(mapgenstructure instanceof MapGenVillage)) continue;
            flag |= flag1;
        }
        if (this.waterLakeGenerator != null && !flag && this.random.nextInt(4) == 0) {
            this.waterLakeGenerator.generate(this.world, this.random, blockpos.add(this.random.nextInt(16) + 8, this.random.nextInt(256), this.random.nextInt(16) + 8));
        }
        if (!(this.lavaLakeGenerator == null || flag || this.random.nextInt(8) != 0 || (blockpos1 = blockpos.add(this.random.nextInt(16) + 8, this.random.nextInt(this.random.nextInt(248) + 8), this.random.nextInt(16) + 8)).getY() >= this.world.getSeaLevel() && this.random.nextInt(10) != 0)) {
            this.lavaLakeGenerator.generate(this.world, this.random, blockpos1);
        }
        if (this.hasDungeons) {
            for (int i1 = 0; i1 < 8; ++i1) {
                new WorldGenDungeons().generate(this.world, this.random, blockpos.add(this.random.nextInt(16) + 8, this.random.nextInt(256), this.random.nextInt(16) + 8));
            }
        }
        if (this.hasDecoration) {
            biome.decorate(this.world, this.random, blockpos);
        }
        ForgeEventFactory.onChunkPopulate(false, this, this.world, this.random, p_populate_1_, p_populate_2_, flag);
        BlockFalling.fallInstantly = false;
    }

    @Override
    public boolean generateStructures(Chunk p_generateStructures_1_, int p_generateStructures_2_, int p_generateStructures_3_) {
        return false;
    }

    @Override
    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType p_getPossibleCreatures_1_, BlockPos p_getPossibleCreatures_2_) {
        Biome biome = this.world.getBiome(p_getPossibleCreatures_2_);
        return biome.getSpawnableList(p_getPossibleCreatures_1_);
    }

    @Override
    @Nullable
    public BlockPos getStrongholdGen(World p_getStrongholdGen_1_, String p_getStrongholdGen_2_, BlockPos p_getStrongholdGen_3_, boolean p_getStrongholdGen_4_) {
        MapGenStructure mapgenstructure = this.structureGenerators.get(p_getStrongholdGen_2_);
        return mapgenstructure != null ? mapgenstructure.getClosestStrongholdPos(p_getStrongholdGen_1_, p_getStrongholdGen_3_, p_getStrongholdGen_4_) : null;
    }

    @Override
    public void recreateStructures(Chunk p_recreateStructures_1_, int p_recreateStructures_2_, int p_recreateStructures_3_) {
        for (MapGenStructure mapgenstructure : this.structureGenerators.values()) {
            mapgenstructure.generate(this.world, p_recreateStructures_2_, p_recreateStructures_3_, null);
        }
    }
}

