/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkProviderServer
implements IChunkProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<Long> droppedChunksSet = Sets.newHashSet();
    public final IChunkGenerator chunkGenerator;
    public final IChunkLoader chunkLoader;
    public final Long2ObjectMap<Chunk> id2ChunkMap = new Long2ObjectOpenHashMap(8192);
    public final WorldServer world;
    private Set<Long> loadingChunks = Sets.newHashSet();

    public ChunkProviderServer(WorldServer p_i46838_1_, IChunkLoader p_i46838_2_, IChunkGenerator p_i46838_3_) {
        this.world = p_i46838_1_;
        this.chunkLoader = p_i46838_2_;
        this.chunkGenerator = p_i46838_3_;
    }

    public Collection<Chunk> getLoadedChunks() {
        return this.id2ChunkMap.values();
    }

    public void unload(Chunk p_unload_1_) {
        if (this.world.provider.canDropChunk(p_unload_1_.xPosition, p_unload_1_.zPosition)) {
            this.droppedChunksSet.add(ChunkPos.asLong(p_unload_1_.xPosition, p_unload_1_.zPosition));
            p_unload_1_.unloaded = true;
        }
    }

    public void unloadAllChunks() {
        for (Chunk chunk : this.id2ChunkMap.values()) {
            this.unload(chunk);
        }
    }

    @Override
    @Nullable
    public Chunk getLoadedChunk(int p_getLoadedChunk_1_, int p_getLoadedChunk_2_) {
        long i = ChunkPos.asLong(p_getLoadedChunk_1_, p_getLoadedChunk_2_);
        Chunk chunk = (Chunk)this.id2ChunkMap.get(i);
        if (chunk != null) {
            chunk.unloaded = false;
        }
        return chunk;
    }

    @Nullable
    public Chunk loadChunk(int p_loadChunk_1_, int p_loadChunk_2_) {
        return this.loadChunk(p_loadChunk_1_, p_loadChunk_2_, null);
    }

    @Nullable
    public Chunk loadChunk(int p_loadChunk_1_, int p_loadChunk_2_, Runnable p_loadChunk_3_) {
        Chunk chunk = this.getLoadedChunk(p_loadChunk_1_, p_loadChunk_2_);
        if (chunk == null) {
            long pos = ChunkPos.asLong(p_loadChunk_1_, p_loadChunk_2_);
            chunk = ForgeChunkManager.fetchDormantChunk(pos, this.world);
            if (chunk != null || !(this.chunkLoader instanceof AnvilChunkLoader)) {
                if (!this.loadingChunks.add(pos)) {
                    FMLLog.bigWarning("There is an attempt to load a chunk (%d,%d) in dimension %d that is already being loaded. This will cause weird chunk breakages.", p_loadChunk_1_, p_loadChunk_2_, this.world.provider.getDimension());
                }
                if (chunk == null) {
                    chunk = this.loadChunkFromFile(p_loadChunk_1_, p_loadChunk_2_);
                }
                if (chunk != null) {
                    this.id2ChunkMap.put(ChunkPos.asLong(p_loadChunk_1_, p_loadChunk_2_), (Object)chunk);
                    chunk.onChunkLoad();
                    chunk.populateChunk(this, this.chunkGenerator);
                }
                this.loadingChunks.remove(pos);
            } else {
                AnvilChunkLoader loader = (AnvilChunkLoader)this.chunkLoader;
                if (p_loadChunk_3_ == null) {
                    chunk = ChunkIOExecutor.syncChunkLoad(this.world, loader, this, p_loadChunk_1_, p_loadChunk_2_);
                } else if (loader.chunkExists(this.world, p_loadChunk_1_, p_loadChunk_2_)) {
                    ChunkIOExecutor.queueChunkLoad(this.world, loader, this, p_loadChunk_1_, p_loadChunk_2_, p_loadChunk_3_);
                    return null;
                }
            }
        }
        if (p_loadChunk_3_ != null) {
            p_loadChunk_3_.run();
        }
        return chunk;
    }

    @Override
    public Chunk provideChunk(int p_provideChunk_1_, int p_provideChunk_2_) {
        Chunk chunk = this.loadChunk(p_provideChunk_1_, p_provideChunk_2_);
        if (chunk == null) {
            long i = ChunkPos.asLong(p_provideChunk_1_, p_provideChunk_2_);
            try {
                chunk = this.chunkGenerator.provideChunk(p_provideChunk_1_, p_provideChunk_2_);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Exception generating new chunk");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Chunk to be generated");
                crashreportcategory.addCrashSection("Location", String.format("%d,%d", p_provideChunk_1_, p_provideChunk_2_));
                crashreportcategory.addCrashSection("Position hash", i);
                crashreportcategory.addCrashSection("Generator", this.chunkGenerator);
                throw new ReportedException(crashreport);
            }
            this.id2ChunkMap.put(i, (Object)chunk);
            chunk.onChunkLoad();
            chunk.populateChunk(this, this.chunkGenerator);
        }
        return chunk;
    }

    @Nullable
    private Chunk loadChunkFromFile(int p_loadChunkFromFile_1_, int p_loadChunkFromFile_2_) {
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.world, p_loadChunkFromFile_1_, p_loadChunkFromFile_2_);
            if (chunk != null) {
                chunk.setLastSaveTime(this.world.getTotalWorldTime());
                this.chunkGenerator.recreateStructures(chunk, p_loadChunkFromFile_1_, p_loadChunkFromFile_2_);
            }
            return chunk;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load chunk", (Throwable)exception);
            return null;
        }
    }

    private void saveChunkExtraData(Chunk p_saveChunkExtraData_1_) {
        try {
            this.chunkLoader.saveExtraChunkData(this.world, p_saveChunkExtraData_1_);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't save entities", (Throwable)exception);
        }
    }

    private void saveChunkData(Chunk p_saveChunkData_1_) {
        try {
            p_saveChunkData_1_.setLastSaveTime(this.world.getTotalWorldTime());
            this.chunkLoader.saveChunk(this.world, p_saveChunkData_1_);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save chunk", (Throwable)ioexception);
        }
        catch (MinecraftException minecraftexception) {
            LOGGER.error("Couldn't save chunk; already in use by another instance of Minecraft?", (Throwable)minecraftexception);
        }
    }

    public boolean saveChunks(boolean p_saveChunks_1_) {
        int i = 0;
        ArrayList list = Lists.newArrayList((Iterable)this.id2ChunkMap.values());
        for (int j = 0; j < list.size(); ++j) {
            Chunk chunk = (Chunk)list.get(j);
            if (p_saveChunks_1_) {
                this.saveChunkExtraData(chunk);
            }
            if (!chunk.needsSaving(p_saveChunks_1_)) continue;
            this.saveChunkData(chunk);
            chunk.setModified(false);
            if (++i != 24 || p_saveChunks_1_) continue;
            return false;
        }
        return true;
    }

    public void saveExtraData() {
        this.chunkLoader.saveExtraData();
    }

    @Override
    public boolean tick() {
        if (!this.world.disableLevelSaving) {
            if (!this.droppedChunksSet.isEmpty()) {
                for (ChunkPos forced : this.world.getPersistentChunks().keySet()) {
                    this.droppedChunksSet.remove(ChunkPos.asLong(forced.chunkXPos, forced.chunkZPos));
                }
                Iterator<Long> iterator = this.droppedChunksSet.iterator();
                int i = 0;
                while (i < 100 && iterator.hasNext()) {
                    Long olong = iterator.next();
                    Chunk chunk = (Chunk)this.id2ChunkMap.get((Object)olong);
                    if (chunk != null && chunk.unloaded) {
                        chunk.onChunkUnload();
                        this.saveChunkData(chunk);
                        this.saveChunkExtraData(chunk);
                        this.id2ChunkMap.remove((Object)olong);
                        ++i;
                        ForgeChunkManager.putDormantChunk(ChunkPos.asLong(chunk.xPosition, chunk.zPosition), chunk);
                        if (this.id2ChunkMap.size() == 0 && ForgeChunkManager.getPersistentChunksFor(this.world).size() == 0 && !this.world.provider.getDimensionType().shouldLoadSpawn()) {
                            DimensionManager.unloadWorld(this.world.provider.getDimension());
                            break;
                        }
                    }
                    iterator.remove();
                }
            }
            this.chunkLoader.chunkTick();
        }
        return false;
    }

    public boolean canSave() {
        return !this.world.disableLevelSaving;
    }

    @Override
    public String makeString() {
        return "ServerChunkCache: " + this.id2ChunkMap.size() + " Drop: " + this.droppedChunksSet.size();
    }

    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType p_getPossibleCreatures_1_, BlockPos p_getPossibleCreatures_2_) {
        return this.chunkGenerator.getPossibleCreatures(p_getPossibleCreatures_1_, p_getPossibleCreatures_2_);
    }

    @Nullable
    public BlockPos getStrongholdGen(World p_getStrongholdGen_1_, String p_getStrongholdGen_2_, BlockPos p_getStrongholdGen_3_, boolean p_getStrongholdGen_4_) {
        return this.chunkGenerator.getStrongholdGen(p_getStrongholdGen_1_, p_getStrongholdGen_2_, p_getStrongholdGen_3_, p_getStrongholdGen_4_);
    }

    public int getLoadedChunkCount() {
        return this.id2ChunkMap.size();
    }

    public boolean chunkExists(int p_chunkExists_1_, int p_chunkExists_2_) {
        return this.id2ChunkMap.containsKey(ChunkPos.asLong(p_chunkExists_1_, p_chunkExists_2_));
    }

    @Override
    public boolean isChunkGeneratedAt(int p_isChunkGeneratedAt_1_, int p_isChunkGeneratedAt_2_) {
        return this.id2ChunkMap.containsKey(ChunkPos.asLong(p_isChunkGeneratedAt_1_, p_isChunkGeneratedAt_2_)) || this.chunkLoader.isChunkGeneratedAt(p_isChunkGeneratedAt_1_, p_isChunkGeneratedAt_2_);
    }
}

