/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.init.Biomes;
import net.minecraft.util.JsonUtils;
import net.minecraft.world.biome.Biome;

public class ChunkProviderSettings {
    public final float coordinateScale;
    public final float heightScale;
    public final float upperLimitScale;
    public final float lowerLimitScale;
    public final float depthNoiseScaleX;
    public final float depthNoiseScaleZ;
    public final float depthNoiseScaleExponent;
    public final float mainNoiseScaleX;
    public final float mainNoiseScaleY;
    public final float mainNoiseScaleZ;
    public final float baseSize;
    public final float stretchY;
    public final float biomeDepthWeight;
    public final float biomeDepthOffSet;
    public final float biomeScaleWeight;
    public final float biomeScaleOffset;
    public final int seaLevel;
    public final boolean useCaves;
    public final boolean useDungeons;
    public final int dungeonChance;
    public final boolean useStrongholds;
    public final boolean useVillages;
    public final boolean useMineShafts;
    public final boolean useTemples;
    public final boolean useMonuments;
    public final boolean useMansions;
    public final boolean useRavines;
    public final boolean useWaterLakes;
    public final int waterLakeChance;
    public final boolean useLavaLakes;
    public final int lavaLakeChance;
    public final boolean useLavaOceans;
    public final int fixedBiome;
    public final int biomeSize;
    public final int riverSize;
    public final int dirtSize;
    public final int dirtCount;
    public final int dirtMinHeight;
    public final int dirtMaxHeight;
    public final int gravelSize;
    public final int gravelCount;
    public final int gravelMinHeight;
    public final int gravelMaxHeight;
    public final int graniteSize;
    public final int graniteCount;
    public final int graniteMinHeight;
    public final int graniteMaxHeight;
    public final int dioriteSize;
    public final int dioriteCount;
    public final int dioriteMinHeight;
    public final int dioriteMaxHeight;
    public final int andesiteSize;
    public final int andesiteCount;
    public final int andesiteMinHeight;
    public final int andesiteMaxHeight;
    public final int coalSize;
    public final int coalCount;
    public final int coalMinHeight;
    public final int coalMaxHeight;
    public final int ironSize;
    public final int ironCount;
    public final int ironMinHeight;
    public final int ironMaxHeight;
    public final int goldSize;
    public final int goldCount;
    public final int goldMinHeight;
    public final int goldMaxHeight;
    public final int redstoneSize;
    public final int redstoneCount;
    public final int redstoneMinHeight;
    public final int redstoneMaxHeight;
    public final int diamondSize;
    public final int diamondCount;
    public final int diamondMinHeight;
    public final int diamondMaxHeight;
    public final int lapisSize;
    public final int lapisCount;
    public final int lapisCenterHeight;
    public final int lapisSpread;

    private ChunkProviderSettings(Factory p_i45639_1_) {
        this.coordinateScale = p_i45639_1_.coordinateScale;
        this.heightScale = p_i45639_1_.heightScale;
        this.upperLimitScale = p_i45639_1_.upperLimitScale;
        this.lowerLimitScale = p_i45639_1_.lowerLimitScale;
        this.depthNoiseScaleX = p_i45639_1_.depthNoiseScaleX;
        this.depthNoiseScaleZ = p_i45639_1_.depthNoiseScaleZ;
        this.depthNoiseScaleExponent = p_i45639_1_.depthNoiseScaleExponent;
        this.mainNoiseScaleX = p_i45639_1_.mainNoiseScaleX;
        this.mainNoiseScaleY = p_i45639_1_.mainNoiseScaleY;
        this.mainNoiseScaleZ = p_i45639_1_.mainNoiseScaleZ;
        this.baseSize = p_i45639_1_.baseSize;
        this.stretchY = p_i45639_1_.stretchY;
        this.biomeDepthWeight = p_i45639_1_.biomeDepthWeight;
        this.biomeDepthOffSet = p_i45639_1_.biomeDepthOffset;
        this.biomeScaleWeight = p_i45639_1_.biomeScaleWeight;
        this.biomeScaleOffset = p_i45639_1_.biomeScaleOffset;
        this.seaLevel = p_i45639_1_.seaLevel;
        this.useCaves = p_i45639_1_.useCaves;
        this.useDungeons = p_i45639_1_.useDungeons;
        this.dungeonChance = p_i45639_1_.dungeonChance;
        this.useStrongholds = p_i45639_1_.useStrongholds;
        this.useVillages = p_i45639_1_.useVillages;
        this.useMineShafts = p_i45639_1_.useMineShafts;
        this.useTemples = p_i45639_1_.useTemples;
        this.useMonuments = p_i45639_1_.useMonuments;
        this.useMansions = p_i45639_1_.useMansions;
        this.useRavines = p_i45639_1_.useRavines;
        this.useWaterLakes = p_i45639_1_.useWaterLakes;
        this.waterLakeChance = p_i45639_1_.waterLakeChance;
        this.useLavaLakes = p_i45639_1_.useLavaLakes;
        this.lavaLakeChance = p_i45639_1_.lavaLakeChance;
        this.useLavaOceans = p_i45639_1_.useLavaOceans;
        this.fixedBiome = p_i45639_1_.fixedBiome;
        this.biomeSize = p_i45639_1_.biomeSize;
        this.riverSize = p_i45639_1_.riverSize;
        this.dirtSize = p_i45639_1_.dirtSize;
        this.dirtCount = p_i45639_1_.dirtCount;
        this.dirtMinHeight = p_i45639_1_.dirtMinHeight;
        this.dirtMaxHeight = p_i45639_1_.dirtMaxHeight;
        this.gravelSize = p_i45639_1_.gravelSize;
        this.gravelCount = p_i45639_1_.gravelCount;
        this.gravelMinHeight = p_i45639_1_.gravelMinHeight;
        this.gravelMaxHeight = p_i45639_1_.gravelMaxHeight;
        this.graniteSize = p_i45639_1_.graniteSize;
        this.graniteCount = p_i45639_1_.graniteCount;
        this.graniteMinHeight = p_i45639_1_.graniteMinHeight;
        this.graniteMaxHeight = p_i45639_1_.graniteMaxHeight;
        this.dioriteSize = p_i45639_1_.dioriteSize;
        this.dioriteCount = p_i45639_1_.dioriteCount;
        this.dioriteMinHeight = p_i45639_1_.dioriteMinHeight;
        this.dioriteMaxHeight = p_i45639_1_.dioriteMaxHeight;
        this.andesiteSize = p_i45639_1_.andesiteSize;
        this.andesiteCount = p_i45639_1_.andesiteCount;
        this.andesiteMinHeight = p_i45639_1_.andesiteMinHeight;
        this.andesiteMaxHeight = p_i45639_1_.andesiteMaxHeight;
        this.coalSize = p_i45639_1_.coalSize;
        this.coalCount = p_i45639_1_.coalCount;
        this.coalMinHeight = p_i45639_1_.coalMinHeight;
        this.coalMaxHeight = p_i45639_1_.coalMaxHeight;
        this.ironSize = p_i45639_1_.ironSize;
        this.ironCount = p_i45639_1_.ironCount;
        this.ironMinHeight = p_i45639_1_.ironMinHeight;
        this.ironMaxHeight = p_i45639_1_.ironMaxHeight;
        this.goldSize = p_i45639_1_.goldSize;
        this.goldCount = p_i45639_1_.goldCount;
        this.goldMinHeight = p_i45639_1_.goldMinHeight;
        this.goldMaxHeight = p_i45639_1_.goldMaxHeight;
        this.redstoneSize = p_i45639_1_.redstoneSize;
        this.redstoneCount = p_i45639_1_.redstoneCount;
        this.redstoneMinHeight = p_i45639_1_.redstoneMinHeight;
        this.redstoneMaxHeight = p_i45639_1_.redstoneMaxHeight;
        this.diamondSize = p_i45639_1_.diamondSize;
        this.diamondCount = p_i45639_1_.diamondCount;
        this.diamondMinHeight = p_i45639_1_.diamondMinHeight;
        this.diamondMaxHeight = p_i45639_1_.diamondMaxHeight;
        this.lapisSize = p_i45639_1_.lapisSize;
        this.lapisCount = p_i45639_1_.lapisCount;
        this.lapisCenterHeight = p_i45639_1_.lapisCenterHeight;
        this.lapisSpread = p_i45639_1_.lapisSpread;
    }

    public static class Serializer
    implements JsonDeserializer<Factory>,
    JsonSerializer<Factory> {
        public Factory deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject lvt_4_1_ = p_deserialize_1_.getAsJsonObject();
            Factory lvt_5_1_ = new Factory();
            try {
                lvt_5_1_.coordinateScale = JsonUtils.getFloat(lvt_4_1_, "coordinateScale", lvt_5_1_.coordinateScale);
                lvt_5_1_.heightScale = JsonUtils.getFloat(lvt_4_1_, "heightScale", lvt_5_1_.heightScale);
                lvt_5_1_.lowerLimitScale = JsonUtils.getFloat(lvt_4_1_, "lowerLimitScale", lvt_5_1_.lowerLimitScale);
                lvt_5_1_.upperLimitScale = JsonUtils.getFloat(lvt_4_1_, "upperLimitScale", lvt_5_1_.upperLimitScale);
                lvt_5_1_.depthNoiseScaleX = JsonUtils.getFloat(lvt_4_1_, "depthNoiseScaleX", lvt_5_1_.depthNoiseScaleX);
                lvt_5_1_.depthNoiseScaleZ = JsonUtils.getFloat(lvt_4_1_, "depthNoiseScaleZ", lvt_5_1_.depthNoiseScaleZ);
                lvt_5_1_.depthNoiseScaleExponent = JsonUtils.getFloat(lvt_4_1_, "depthNoiseScaleExponent", lvt_5_1_.depthNoiseScaleExponent);
                lvt_5_1_.mainNoiseScaleX = JsonUtils.getFloat(lvt_4_1_, "mainNoiseScaleX", lvt_5_1_.mainNoiseScaleX);
                lvt_5_1_.mainNoiseScaleY = JsonUtils.getFloat(lvt_4_1_, "mainNoiseScaleY", lvt_5_1_.mainNoiseScaleY);
                lvt_5_1_.mainNoiseScaleZ = JsonUtils.getFloat(lvt_4_1_, "mainNoiseScaleZ", lvt_5_1_.mainNoiseScaleZ);
                lvt_5_1_.baseSize = JsonUtils.getFloat(lvt_4_1_, "baseSize", lvt_5_1_.baseSize);
                lvt_5_1_.stretchY = JsonUtils.getFloat(lvt_4_1_, "stretchY", lvt_5_1_.stretchY);
                lvt_5_1_.biomeDepthWeight = JsonUtils.getFloat(lvt_4_1_, "biomeDepthWeight", lvt_5_1_.biomeDepthWeight);
                lvt_5_1_.biomeDepthOffset = JsonUtils.getFloat(lvt_4_1_, "biomeDepthOffset", lvt_5_1_.biomeDepthOffset);
                lvt_5_1_.biomeScaleWeight = JsonUtils.getFloat(lvt_4_1_, "biomeScaleWeight", lvt_5_1_.biomeScaleWeight);
                lvt_5_1_.biomeScaleOffset = JsonUtils.getFloat(lvt_4_1_, "biomeScaleOffset", lvt_5_1_.biomeScaleOffset);
                lvt_5_1_.seaLevel = JsonUtils.getInt(lvt_4_1_, "seaLevel", lvt_5_1_.seaLevel);
                lvt_5_1_.useCaves = JsonUtils.getBoolean(lvt_4_1_, "useCaves", lvt_5_1_.useCaves);
                lvt_5_1_.useDungeons = JsonUtils.getBoolean(lvt_4_1_, "useDungeons", lvt_5_1_.useDungeons);
                lvt_5_1_.dungeonChance = JsonUtils.getInt(lvt_4_1_, "dungeonChance", lvt_5_1_.dungeonChance);
                lvt_5_1_.useStrongholds = JsonUtils.getBoolean(lvt_4_1_, "useStrongholds", lvt_5_1_.useStrongholds);
                lvt_5_1_.useVillages = JsonUtils.getBoolean(lvt_4_1_, "useVillages", lvt_5_1_.useVillages);
                lvt_5_1_.useMineShafts = JsonUtils.getBoolean(lvt_4_1_, "useMineShafts", lvt_5_1_.useMineShafts);
                lvt_5_1_.useTemples = JsonUtils.getBoolean(lvt_4_1_, "useTemples", lvt_5_1_.useTemples);
                lvt_5_1_.useMonuments = JsonUtils.getBoolean(lvt_4_1_, "useMonuments", lvt_5_1_.useMonuments);
                lvt_5_1_.useMansions = JsonUtils.getBoolean(lvt_4_1_, "useMansions", lvt_5_1_.useMansions);
                lvt_5_1_.useRavines = JsonUtils.getBoolean(lvt_4_1_, "useRavines", lvt_5_1_.useRavines);
                lvt_5_1_.useWaterLakes = JsonUtils.getBoolean(lvt_4_1_, "useWaterLakes", lvt_5_1_.useWaterLakes);
                lvt_5_1_.waterLakeChance = JsonUtils.getInt(lvt_4_1_, "waterLakeChance", lvt_5_1_.waterLakeChance);
                lvt_5_1_.useLavaLakes = JsonUtils.getBoolean(lvt_4_1_, "useLavaLakes", lvt_5_1_.useLavaLakes);
                lvt_5_1_.lavaLakeChance = JsonUtils.getInt(lvt_4_1_, "lavaLakeChance", lvt_5_1_.lavaLakeChance);
                lvt_5_1_.useLavaOceans = JsonUtils.getBoolean(lvt_4_1_, "useLavaOceans", lvt_5_1_.useLavaOceans);
                lvt_5_1_.fixedBiome = JsonUtils.getInt(lvt_4_1_, "fixedBiome", lvt_5_1_.fixedBiome);
                if (lvt_5_1_.fixedBiome >= 38 || lvt_5_1_.fixedBiome < -1) {
                    lvt_5_1_.fixedBiome = -1;
                } else if (lvt_5_1_.fixedBiome >= Biome.getIdForBiome(Biomes.HELL)) {
                    lvt_5_1_.fixedBiome += 2;
                }
                lvt_5_1_.biomeSize = JsonUtils.getInt(lvt_4_1_, "biomeSize", lvt_5_1_.biomeSize);
                lvt_5_1_.riverSize = JsonUtils.getInt(lvt_4_1_, "riverSize", lvt_5_1_.riverSize);
                lvt_5_1_.dirtSize = JsonUtils.getInt(lvt_4_1_, "dirtSize", lvt_5_1_.dirtSize);
                lvt_5_1_.dirtCount = JsonUtils.getInt(lvt_4_1_, "dirtCount", lvt_5_1_.dirtCount);
                lvt_5_1_.dirtMinHeight = JsonUtils.getInt(lvt_4_1_, "dirtMinHeight", lvt_5_1_.dirtMinHeight);
                lvt_5_1_.dirtMaxHeight = JsonUtils.getInt(lvt_4_1_, "dirtMaxHeight", lvt_5_1_.dirtMaxHeight);
                lvt_5_1_.gravelSize = JsonUtils.getInt(lvt_4_1_, "gravelSize", lvt_5_1_.gravelSize);
                lvt_5_1_.gravelCount = JsonUtils.getInt(lvt_4_1_, "gravelCount", lvt_5_1_.gravelCount);
                lvt_5_1_.gravelMinHeight = JsonUtils.getInt(lvt_4_1_, "gravelMinHeight", lvt_5_1_.gravelMinHeight);
                lvt_5_1_.gravelMaxHeight = JsonUtils.getInt(lvt_4_1_, "gravelMaxHeight", lvt_5_1_.gravelMaxHeight);
                lvt_5_1_.graniteSize = JsonUtils.getInt(lvt_4_1_, "graniteSize", lvt_5_1_.graniteSize);
                lvt_5_1_.graniteCount = JsonUtils.getInt(lvt_4_1_, "graniteCount", lvt_5_1_.graniteCount);
                lvt_5_1_.graniteMinHeight = JsonUtils.getInt(lvt_4_1_, "graniteMinHeight", lvt_5_1_.graniteMinHeight);
                lvt_5_1_.graniteMaxHeight = JsonUtils.getInt(lvt_4_1_, "graniteMaxHeight", lvt_5_1_.graniteMaxHeight);
                lvt_5_1_.dioriteSize = JsonUtils.getInt(lvt_4_1_, "dioriteSize", lvt_5_1_.dioriteSize);
                lvt_5_1_.dioriteCount = JsonUtils.getInt(lvt_4_1_, "dioriteCount", lvt_5_1_.dioriteCount);
                lvt_5_1_.dioriteMinHeight = JsonUtils.getInt(lvt_4_1_, "dioriteMinHeight", lvt_5_1_.dioriteMinHeight);
                lvt_5_1_.dioriteMaxHeight = JsonUtils.getInt(lvt_4_1_, "dioriteMaxHeight", lvt_5_1_.dioriteMaxHeight);
                lvt_5_1_.andesiteSize = JsonUtils.getInt(lvt_4_1_, "andesiteSize", lvt_5_1_.andesiteSize);
                lvt_5_1_.andesiteCount = JsonUtils.getInt(lvt_4_1_, "andesiteCount", lvt_5_1_.andesiteCount);
                lvt_5_1_.andesiteMinHeight = JsonUtils.getInt(lvt_4_1_, "andesiteMinHeight", lvt_5_1_.andesiteMinHeight);
                lvt_5_1_.andesiteMaxHeight = JsonUtils.getInt(lvt_4_1_, "andesiteMaxHeight", lvt_5_1_.andesiteMaxHeight);
                lvt_5_1_.coalSize = JsonUtils.getInt(lvt_4_1_, "coalSize", lvt_5_1_.coalSize);
                lvt_5_1_.coalCount = JsonUtils.getInt(lvt_4_1_, "coalCount", lvt_5_1_.coalCount);
                lvt_5_1_.coalMinHeight = JsonUtils.getInt(lvt_4_1_, "coalMinHeight", lvt_5_1_.coalMinHeight);
                lvt_5_1_.coalMaxHeight = JsonUtils.getInt(lvt_4_1_, "coalMaxHeight", lvt_5_1_.coalMaxHeight);
                lvt_5_1_.ironSize = JsonUtils.getInt(lvt_4_1_, "ironSize", lvt_5_1_.ironSize);
                lvt_5_1_.ironCount = JsonUtils.getInt(lvt_4_1_, "ironCount", lvt_5_1_.ironCount);
                lvt_5_1_.ironMinHeight = JsonUtils.getInt(lvt_4_1_, "ironMinHeight", lvt_5_1_.ironMinHeight);
                lvt_5_1_.ironMaxHeight = JsonUtils.getInt(lvt_4_1_, "ironMaxHeight", lvt_5_1_.ironMaxHeight);
                lvt_5_1_.goldSize = JsonUtils.getInt(lvt_4_1_, "goldSize", lvt_5_1_.goldSize);
                lvt_5_1_.goldCount = JsonUtils.getInt(lvt_4_1_, "goldCount", lvt_5_1_.goldCount);
                lvt_5_1_.goldMinHeight = JsonUtils.getInt(lvt_4_1_, "goldMinHeight", lvt_5_1_.goldMinHeight);
                lvt_5_1_.goldMaxHeight = JsonUtils.getInt(lvt_4_1_, "goldMaxHeight", lvt_5_1_.goldMaxHeight);
                lvt_5_1_.redstoneSize = JsonUtils.getInt(lvt_4_1_, "redstoneSize", lvt_5_1_.redstoneSize);
                lvt_5_1_.redstoneCount = JsonUtils.getInt(lvt_4_1_, "redstoneCount", lvt_5_1_.redstoneCount);
                lvt_5_1_.redstoneMinHeight = JsonUtils.getInt(lvt_4_1_, "redstoneMinHeight", lvt_5_1_.redstoneMinHeight);
                lvt_5_1_.redstoneMaxHeight = JsonUtils.getInt(lvt_4_1_, "redstoneMaxHeight", lvt_5_1_.redstoneMaxHeight);
                lvt_5_1_.diamondSize = JsonUtils.getInt(lvt_4_1_, "diamondSize", lvt_5_1_.diamondSize);
                lvt_5_1_.diamondCount = JsonUtils.getInt(lvt_4_1_, "diamondCount", lvt_5_1_.diamondCount);
                lvt_5_1_.diamondMinHeight = JsonUtils.getInt(lvt_4_1_, "diamondMinHeight", lvt_5_1_.diamondMinHeight);
                lvt_5_1_.diamondMaxHeight = JsonUtils.getInt(lvt_4_1_, "diamondMaxHeight", lvt_5_1_.diamondMaxHeight);
                lvt_5_1_.lapisSize = JsonUtils.getInt(lvt_4_1_, "lapisSize", lvt_5_1_.lapisSize);
                lvt_5_1_.lapisCount = JsonUtils.getInt(lvt_4_1_, "lapisCount", lvt_5_1_.lapisCount);
                lvt_5_1_.lapisCenterHeight = JsonUtils.getInt(lvt_4_1_, "lapisCenterHeight", lvt_5_1_.lapisCenterHeight);
                lvt_5_1_.lapisSpread = JsonUtils.getInt(lvt_4_1_, "lapisSpread", lvt_5_1_.lapisSpread);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return lvt_5_1_;
        }

        public JsonElement serialize(Factory p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            JsonObject lvt_4_1_ = new JsonObject();
            lvt_4_1_.addProperty("coordinateScale", (Number)Float.valueOf(p_serialize_1_.coordinateScale));
            lvt_4_1_.addProperty("heightScale", (Number)Float.valueOf(p_serialize_1_.heightScale));
            lvt_4_1_.addProperty("lowerLimitScale", (Number)Float.valueOf(p_serialize_1_.lowerLimitScale));
            lvt_4_1_.addProperty("upperLimitScale", (Number)Float.valueOf(p_serialize_1_.upperLimitScale));
            lvt_4_1_.addProperty("depthNoiseScaleX", (Number)Float.valueOf(p_serialize_1_.depthNoiseScaleX));
            lvt_4_1_.addProperty("depthNoiseScaleZ", (Number)Float.valueOf(p_serialize_1_.depthNoiseScaleZ));
            lvt_4_1_.addProperty("depthNoiseScaleExponent", (Number)Float.valueOf(p_serialize_1_.depthNoiseScaleExponent));
            lvt_4_1_.addProperty("mainNoiseScaleX", (Number)Float.valueOf(p_serialize_1_.mainNoiseScaleX));
            lvt_4_1_.addProperty("mainNoiseScaleY", (Number)Float.valueOf(p_serialize_1_.mainNoiseScaleY));
            lvt_4_1_.addProperty("mainNoiseScaleZ", (Number)Float.valueOf(p_serialize_1_.mainNoiseScaleZ));
            lvt_4_1_.addProperty("baseSize", (Number)Float.valueOf(p_serialize_1_.baseSize));
            lvt_4_1_.addProperty("stretchY", (Number)Float.valueOf(p_serialize_1_.stretchY));
            lvt_4_1_.addProperty("biomeDepthWeight", (Number)Float.valueOf(p_serialize_1_.biomeDepthWeight));
            lvt_4_1_.addProperty("biomeDepthOffset", (Number)Float.valueOf(p_serialize_1_.biomeDepthOffset));
            lvt_4_1_.addProperty("biomeScaleWeight", (Number)Float.valueOf(p_serialize_1_.biomeScaleWeight));
            lvt_4_1_.addProperty("biomeScaleOffset", (Number)Float.valueOf(p_serialize_1_.biomeScaleOffset));
            lvt_4_1_.addProperty("seaLevel", (Number)p_serialize_1_.seaLevel);
            lvt_4_1_.addProperty("useCaves", Boolean.valueOf(p_serialize_1_.useCaves));
            lvt_4_1_.addProperty("useDungeons", Boolean.valueOf(p_serialize_1_.useDungeons));
            lvt_4_1_.addProperty("dungeonChance", (Number)p_serialize_1_.dungeonChance);
            lvt_4_1_.addProperty("useStrongholds", Boolean.valueOf(p_serialize_1_.useStrongholds));
            lvt_4_1_.addProperty("useVillages", Boolean.valueOf(p_serialize_1_.useVillages));
            lvt_4_1_.addProperty("useMineShafts", Boolean.valueOf(p_serialize_1_.useMineShafts));
            lvt_4_1_.addProperty("useTemples", Boolean.valueOf(p_serialize_1_.useTemples));
            lvt_4_1_.addProperty("useMonuments", Boolean.valueOf(p_serialize_1_.useMonuments));
            lvt_4_1_.addProperty("useMansions", Boolean.valueOf(p_serialize_1_.useMansions));
            lvt_4_1_.addProperty("useRavines", Boolean.valueOf(p_serialize_1_.useRavines));
            lvt_4_1_.addProperty("useWaterLakes", Boolean.valueOf(p_serialize_1_.useWaterLakes));
            lvt_4_1_.addProperty("waterLakeChance", (Number)p_serialize_1_.waterLakeChance);
            lvt_4_1_.addProperty("useLavaLakes", Boolean.valueOf(p_serialize_1_.useLavaLakes));
            lvt_4_1_.addProperty("lavaLakeChance", (Number)p_serialize_1_.lavaLakeChance);
            lvt_4_1_.addProperty("useLavaOceans", Boolean.valueOf(p_serialize_1_.useLavaOceans));
            lvt_4_1_.addProperty("fixedBiome", (Number)p_serialize_1_.fixedBiome);
            lvt_4_1_.addProperty("biomeSize", (Number)p_serialize_1_.biomeSize);
            lvt_4_1_.addProperty("riverSize", (Number)p_serialize_1_.riverSize);
            lvt_4_1_.addProperty("dirtSize", (Number)p_serialize_1_.dirtSize);
            lvt_4_1_.addProperty("dirtCount", (Number)p_serialize_1_.dirtCount);
            lvt_4_1_.addProperty("dirtMinHeight", (Number)p_serialize_1_.dirtMinHeight);
            lvt_4_1_.addProperty("dirtMaxHeight", (Number)p_serialize_1_.dirtMaxHeight);
            lvt_4_1_.addProperty("gravelSize", (Number)p_serialize_1_.gravelSize);
            lvt_4_1_.addProperty("gravelCount", (Number)p_serialize_1_.gravelCount);
            lvt_4_1_.addProperty("gravelMinHeight", (Number)p_serialize_1_.gravelMinHeight);
            lvt_4_1_.addProperty("gravelMaxHeight", (Number)p_serialize_1_.gravelMaxHeight);
            lvt_4_1_.addProperty("graniteSize", (Number)p_serialize_1_.graniteSize);
            lvt_4_1_.addProperty("graniteCount", (Number)p_serialize_1_.graniteCount);
            lvt_4_1_.addProperty("graniteMinHeight", (Number)p_serialize_1_.graniteMinHeight);
            lvt_4_1_.addProperty("graniteMaxHeight", (Number)p_serialize_1_.graniteMaxHeight);
            lvt_4_1_.addProperty("dioriteSize", (Number)p_serialize_1_.dioriteSize);
            lvt_4_1_.addProperty("dioriteCount", (Number)p_serialize_1_.dioriteCount);
            lvt_4_1_.addProperty("dioriteMinHeight", (Number)p_serialize_1_.dioriteMinHeight);
            lvt_4_1_.addProperty("dioriteMaxHeight", (Number)p_serialize_1_.dioriteMaxHeight);
            lvt_4_1_.addProperty("andesiteSize", (Number)p_serialize_1_.andesiteSize);
            lvt_4_1_.addProperty("andesiteCount", (Number)p_serialize_1_.andesiteCount);
            lvt_4_1_.addProperty("andesiteMinHeight", (Number)p_serialize_1_.andesiteMinHeight);
            lvt_4_1_.addProperty("andesiteMaxHeight", (Number)p_serialize_1_.andesiteMaxHeight);
            lvt_4_1_.addProperty("coalSize", (Number)p_serialize_1_.coalSize);
            lvt_4_1_.addProperty("coalCount", (Number)p_serialize_1_.coalCount);
            lvt_4_1_.addProperty("coalMinHeight", (Number)p_serialize_1_.coalMinHeight);
            lvt_4_1_.addProperty("coalMaxHeight", (Number)p_serialize_1_.coalMaxHeight);
            lvt_4_1_.addProperty("ironSize", (Number)p_serialize_1_.ironSize);
            lvt_4_1_.addProperty("ironCount", (Number)p_serialize_1_.ironCount);
            lvt_4_1_.addProperty("ironMinHeight", (Number)p_serialize_1_.ironMinHeight);
            lvt_4_1_.addProperty("ironMaxHeight", (Number)p_serialize_1_.ironMaxHeight);
            lvt_4_1_.addProperty("goldSize", (Number)p_serialize_1_.goldSize);
            lvt_4_1_.addProperty("goldCount", (Number)p_serialize_1_.goldCount);
            lvt_4_1_.addProperty("goldMinHeight", (Number)p_serialize_1_.goldMinHeight);
            lvt_4_1_.addProperty("goldMaxHeight", (Number)p_serialize_1_.goldMaxHeight);
            lvt_4_1_.addProperty("redstoneSize", (Number)p_serialize_1_.redstoneSize);
            lvt_4_1_.addProperty("redstoneCount", (Number)p_serialize_1_.redstoneCount);
            lvt_4_1_.addProperty("redstoneMinHeight", (Number)p_serialize_1_.redstoneMinHeight);
            lvt_4_1_.addProperty("redstoneMaxHeight", (Number)p_serialize_1_.redstoneMaxHeight);
            lvt_4_1_.addProperty("diamondSize", (Number)p_serialize_1_.diamondSize);
            lvt_4_1_.addProperty("diamondCount", (Number)p_serialize_1_.diamondCount);
            lvt_4_1_.addProperty("diamondMinHeight", (Number)p_serialize_1_.diamondMinHeight);
            lvt_4_1_.addProperty("diamondMaxHeight", (Number)p_serialize_1_.diamondMaxHeight);
            lvt_4_1_.addProperty("lapisSize", (Number)p_serialize_1_.lapisSize);
            lvt_4_1_.addProperty("lapisCount", (Number)p_serialize_1_.lapisCount);
            lvt_4_1_.addProperty("lapisCenterHeight", (Number)p_serialize_1_.lapisCenterHeight);
            lvt_4_1_.addProperty("lapisSpread", (Number)p_serialize_1_.lapisSpread);
            return lvt_4_1_;
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }

        public /* synthetic */ JsonElement serialize(Object p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            return this.serialize((Factory)p_serialize_1_, p_serialize_2_, p_serialize_3_);
        }
    }

    public static class Factory {
        @VisibleForTesting
        static final Gson JSON_ADAPTER = new GsonBuilder().registerTypeAdapter(Factory.class, (Object)new Serializer()).create();
        public float coordinateScale = 684.412f;
        public float heightScale = 684.412f;
        public float upperLimitScale = 512.0f;
        public float lowerLimitScale = 512.0f;
        public float depthNoiseScaleX = 200.0f;
        public float depthNoiseScaleZ = 200.0f;
        public float depthNoiseScaleExponent = 0.5f;
        public float mainNoiseScaleX = 80.0f;
        public float mainNoiseScaleY = 160.0f;
        public float mainNoiseScaleZ = 80.0f;
        public float baseSize = 8.5f;
        public float stretchY = 12.0f;
        public float biomeDepthWeight = 1.0f;
        public float biomeDepthOffset;
        public float biomeScaleWeight = 1.0f;
        public float biomeScaleOffset;
        public int seaLevel = 63;
        public boolean useCaves = true;
        public boolean useDungeons = true;
        public int dungeonChance = 8;
        public boolean useStrongholds = true;
        public boolean useVillages = true;
        public boolean useMineShafts = true;
        public boolean useTemples = true;
        public boolean useMonuments = true;
        public boolean useMansions = true;
        public boolean useRavines = true;
        public boolean useWaterLakes = true;
        public int waterLakeChance = 4;
        public boolean useLavaLakes = true;
        public int lavaLakeChance = 80;
        public boolean useLavaOceans;
        public int fixedBiome = -1;
        public int biomeSize = 4;
        public int riverSize = 4;
        public int dirtSize = 33;
        public int dirtCount = 10;
        public int dirtMinHeight;
        public int dirtMaxHeight = 256;
        public int gravelSize = 33;
        public int gravelCount = 8;
        public int gravelMinHeight;
        public int gravelMaxHeight = 256;
        public int graniteSize = 33;
        public int graniteCount = 10;
        public int graniteMinHeight;
        public int graniteMaxHeight = 80;
        public int dioriteSize = 33;
        public int dioriteCount = 10;
        public int dioriteMinHeight;
        public int dioriteMaxHeight = 80;
        public int andesiteSize = 33;
        public int andesiteCount = 10;
        public int andesiteMinHeight;
        public int andesiteMaxHeight = 80;
        public int coalSize = 17;
        public int coalCount = 20;
        public int coalMinHeight;
        public int coalMaxHeight = 128;
        public int ironSize = 9;
        public int ironCount = 20;
        public int ironMinHeight;
        public int ironMaxHeight = 64;
        public int goldSize = 9;
        public int goldCount = 2;
        public int goldMinHeight;
        public int goldMaxHeight = 32;
        public int redstoneSize = 8;
        public int redstoneCount = 8;
        public int redstoneMinHeight;
        public int redstoneMaxHeight = 16;
        public int diamondSize = 8;
        public int diamondCount = 1;
        public int diamondMinHeight;
        public int diamondMaxHeight = 16;
        public int lapisSize = 7;
        public int lapisCount = 1;
        public int lapisCenterHeight = 16;
        public int lapisSpread = 16;

        public static Factory jsonToFactory(String p_jsonToFactory_0_) {
            if (p_jsonToFactory_0_.isEmpty()) {
                return new Factory();
            }
            try {
                return JsonUtils.gsonDeserialize(JSON_ADAPTER, p_jsonToFactory_0_, Factory.class);
            }
            catch (Exception lvt_1_1_) {
                return new Factory();
            }
        }

        public String toString() {
            return JSON_ADAPTER.toJson((Object)this);
        }

        public Factory() {
            this.setDefaults();
        }

        public void setDefaults() {
            this.coordinateScale = 684.412f;
            this.heightScale = 684.412f;
            this.upperLimitScale = 512.0f;
            this.lowerLimitScale = 512.0f;
            this.depthNoiseScaleX = 200.0f;
            this.depthNoiseScaleZ = 200.0f;
            this.depthNoiseScaleExponent = 0.5f;
            this.mainNoiseScaleX = 80.0f;
            this.mainNoiseScaleY = 160.0f;
            this.mainNoiseScaleZ = 80.0f;
            this.baseSize = 8.5f;
            this.stretchY = 12.0f;
            this.biomeDepthWeight = 1.0f;
            this.biomeDepthOffset = 0.0f;
            this.biomeScaleWeight = 1.0f;
            this.biomeScaleOffset = 0.0f;
            this.seaLevel = 63;
            this.useCaves = true;
            this.useDungeons = true;
            this.dungeonChance = 8;
            this.useStrongholds = true;
            this.useVillages = true;
            this.useMineShafts = true;
            this.useTemples = true;
            this.useMonuments = true;
            this.useMansions = true;
            this.useRavines = true;
            this.useWaterLakes = true;
            this.waterLakeChance = 4;
            this.useLavaLakes = true;
            this.lavaLakeChance = 80;
            this.useLavaOceans = false;
            this.fixedBiome = -1;
            this.biomeSize = 4;
            this.riverSize = 4;
            this.dirtSize = 33;
            this.dirtCount = 10;
            this.dirtMinHeight = 0;
            this.dirtMaxHeight = 256;
            this.gravelSize = 33;
            this.gravelCount = 8;
            this.gravelMinHeight = 0;
            this.gravelMaxHeight = 256;
            this.graniteSize = 33;
            this.graniteCount = 10;
            this.graniteMinHeight = 0;
            this.graniteMaxHeight = 80;
            this.dioriteSize = 33;
            this.dioriteCount = 10;
            this.dioriteMinHeight = 0;
            this.dioriteMaxHeight = 80;
            this.andesiteSize = 33;
            this.andesiteCount = 10;
            this.andesiteMinHeight = 0;
            this.andesiteMaxHeight = 80;
            this.coalSize = 17;
            this.coalCount = 20;
            this.coalMinHeight = 0;
            this.coalMaxHeight = 128;
            this.ironSize = 9;
            this.ironCount = 20;
            this.ironMinHeight = 0;
            this.ironMaxHeight = 64;
            this.goldSize = 9;
            this.goldCount = 2;
            this.goldMinHeight = 0;
            this.goldMaxHeight = 32;
            this.redstoneSize = 8;
            this.redstoneCount = 8;
            this.redstoneMinHeight = 0;
            this.redstoneMaxHeight = 16;
            this.diamondSize = 8;
            this.diamondCount = 1;
            this.diamondMinHeight = 0;
            this.diamondMaxHeight = 16;
            this.lapisSize = 7;
            this.lapisCount = 1;
            this.lapisCenterHeight = 16;
            this.lapisSpread = 16;
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (p_equals_1_ == null || this.getClass() != p_equals_1_.getClass()) {
                return false;
            }
            Factory lvt_2_1_ = (Factory)p_equals_1_;
            if (this.andesiteCount != lvt_2_1_.andesiteCount) {
                return false;
            }
            if (this.andesiteMaxHeight != lvt_2_1_.andesiteMaxHeight) {
                return false;
            }
            if (this.andesiteMinHeight != lvt_2_1_.andesiteMinHeight) {
                return false;
            }
            if (this.andesiteSize != lvt_2_1_.andesiteSize) {
                return false;
            }
            if (Float.compare(lvt_2_1_.baseSize, this.baseSize) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.biomeDepthOffset, this.biomeDepthOffset) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.biomeDepthWeight, this.biomeDepthWeight) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.biomeScaleOffset, this.biomeScaleOffset) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.biomeScaleWeight, this.biomeScaleWeight) != 0) {
                return false;
            }
            if (this.biomeSize != lvt_2_1_.biomeSize) {
                return false;
            }
            if (this.coalCount != lvt_2_1_.coalCount) {
                return false;
            }
            if (this.coalMaxHeight != lvt_2_1_.coalMaxHeight) {
                return false;
            }
            if (this.coalMinHeight != lvt_2_1_.coalMinHeight) {
                return false;
            }
            if (this.coalSize != lvt_2_1_.coalSize) {
                return false;
            }
            if (Float.compare(lvt_2_1_.coordinateScale, this.coordinateScale) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.depthNoiseScaleExponent, this.depthNoiseScaleExponent) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.depthNoiseScaleX, this.depthNoiseScaleX) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.depthNoiseScaleZ, this.depthNoiseScaleZ) != 0) {
                return false;
            }
            if (this.diamondCount != lvt_2_1_.diamondCount) {
                return false;
            }
            if (this.diamondMaxHeight != lvt_2_1_.diamondMaxHeight) {
                return false;
            }
            if (this.diamondMinHeight != lvt_2_1_.diamondMinHeight) {
                return false;
            }
            if (this.diamondSize != lvt_2_1_.diamondSize) {
                return false;
            }
            if (this.dioriteCount != lvt_2_1_.dioriteCount) {
                return false;
            }
            if (this.dioriteMaxHeight != lvt_2_1_.dioriteMaxHeight) {
                return false;
            }
            if (this.dioriteMinHeight != lvt_2_1_.dioriteMinHeight) {
                return false;
            }
            if (this.dioriteSize != lvt_2_1_.dioriteSize) {
                return false;
            }
            if (this.dirtCount != lvt_2_1_.dirtCount) {
                return false;
            }
            if (this.dirtMaxHeight != lvt_2_1_.dirtMaxHeight) {
                return false;
            }
            if (this.dirtMinHeight != lvt_2_1_.dirtMinHeight) {
                return false;
            }
            if (this.dirtSize != lvt_2_1_.dirtSize) {
                return false;
            }
            if (this.dungeonChance != lvt_2_1_.dungeonChance) {
                return false;
            }
            if (this.fixedBiome != lvt_2_1_.fixedBiome) {
                return false;
            }
            if (this.goldCount != lvt_2_1_.goldCount) {
                return false;
            }
            if (this.goldMaxHeight != lvt_2_1_.goldMaxHeight) {
                return false;
            }
            if (this.goldMinHeight != lvt_2_1_.goldMinHeight) {
                return false;
            }
            if (this.goldSize != lvt_2_1_.goldSize) {
                return false;
            }
            if (this.graniteCount != lvt_2_1_.graniteCount) {
                return false;
            }
            if (this.graniteMaxHeight != lvt_2_1_.graniteMaxHeight) {
                return false;
            }
            if (this.graniteMinHeight != lvt_2_1_.graniteMinHeight) {
                return false;
            }
            if (this.graniteSize != lvt_2_1_.graniteSize) {
                return false;
            }
            if (this.gravelCount != lvt_2_1_.gravelCount) {
                return false;
            }
            if (this.gravelMaxHeight != lvt_2_1_.gravelMaxHeight) {
                return false;
            }
            if (this.gravelMinHeight != lvt_2_1_.gravelMinHeight) {
                return false;
            }
            if (this.gravelSize != lvt_2_1_.gravelSize) {
                return false;
            }
            if (Float.compare(lvt_2_1_.heightScale, this.heightScale) != 0) {
                return false;
            }
            if (this.ironCount != lvt_2_1_.ironCount) {
                return false;
            }
            if (this.ironMaxHeight != lvt_2_1_.ironMaxHeight) {
                return false;
            }
            if (this.ironMinHeight != lvt_2_1_.ironMinHeight) {
                return false;
            }
            if (this.ironSize != lvt_2_1_.ironSize) {
                return false;
            }
            if (this.lapisCenterHeight != lvt_2_1_.lapisCenterHeight) {
                return false;
            }
            if (this.lapisCount != lvt_2_1_.lapisCount) {
                return false;
            }
            if (this.lapisSize != lvt_2_1_.lapisSize) {
                return false;
            }
            if (this.lapisSpread != lvt_2_1_.lapisSpread) {
                return false;
            }
            if (this.lavaLakeChance != lvt_2_1_.lavaLakeChance) {
                return false;
            }
            if (Float.compare(lvt_2_1_.lowerLimitScale, this.lowerLimitScale) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.mainNoiseScaleX, this.mainNoiseScaleX) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.mainNoiseScaleY, this.mainNoiseScaleY) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.mainNoiseScaleZ, this.mainNoiseScaleZ) != 0) {
                return false;
            }
            if (this.redstoneCount != lvt_2_1_.redstoneCount) {
                return false;
            }
            if (this.redstoneMaxHeight != lvt_2_1_.redstoneMaxHeight) {
                return false;
            }
            if (this.redstoneMinHeight != lvt_2_1_.redstoneMinHeight) {
                return false;
            }
            if (this.redstoneSize != lvt_2_1_.redstoneSize) {
                return false;
            }
            if (this.riverSize != lvt_2_1_.riverSize) {
                return false;
            }
            if (this.seaLevel != lvt_2_1_.seaLevel) {
                return false;
            }
            if (Float.compare(lvt_2_1_.stretchY, this.stretchY) != 0) {
                return false;
            }
            if (Float.compare(lvt_2_1_.upperLimitScale, this.upperLimitScale) != 0) {
                return false;
            }
            if (this.useCaves != lvt_2_1_.useCaves) {
                return false;
            }
            if (this.useDungeons != lvt_2_1_.useDungeons) {
                return false;
            }
            if (this.useLavaLakes != lvt_2_1_.useLavaLakes) {
                return false;
            }
            if (this.useLavaOceans != lvt_2_1_.useLavaOceans) {
                return false;
            }
            if (this.useMineShafts != lvt_2_1_.useMineShafts) {
                return false;
            }
            if (this.useRavines != lvt_2_1_.useRavines) {
                return false;
            }
            if (this.useStrongholds != lvt_2_1_.useStrongholds) {
                return false;
            }
            if (this.useTemples != lvt_2_1_.useTemples) {
                return false;
            }
            if (this.useMonuments != lvt_2_1_.useMonuments) {
                return false;
            }
            if (this.useMansions != lvt_2_1_.useMansions) {
                return false;
            }
            if (this.useVillages != lvt_2_1_.useVillages) {
                return false;
            }
            if (this.useWaterLakes != lvt_2_1_.useWaterLakes) {
                return false;
            }
            return this.waterLakeChance == lvt_2_1_.waterLakeChance;
        }

        public int hashCode() {
            int lvt_1_1_ = this.coordinateScale == 0.0f ? 0 : Float.floatToIntBits(this.coordinateScale);
            lvt_1_1_ = 31 * lvt_1_1_ + (this.heightScale == 0.0f ? 0 : Float.floatToIntBits(this.heightScale));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.upperLimitScale == 0.0f ? 0 : Float.floatToIntBits(this.upperLimitScale));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.lowerLimitScale == 0.0f ? 0 : Float.floatToIntBits(this.lowerLimitScale));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.depthNoiseScaleX == 0.0f ? 0 : Float.floatToIntBits(this.depthNoiseScaleX));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.depthNoiseScaleZ == 0.0f ? 0 : Float.floatToIntBits(this.depthNoiseScaleZ));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.depthNoiseScaleExponent == 0.0f ? 0 : Float.floatToIntBits(this.depthNoiseScaleExponent));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.mainNoiseScaleX == 0.0f ? 0 : Float.floatToIntBits(this.mainNoiseScaleX));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.mainNoiseScaleY == 0.0f ? 0 : Float.floatToIntBits(this.mainNoiseScaleY));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.mainNoiseScaleZ == 0.0f ? 0 : Float.floatToIntBits(this.mainNoiseScaleZ));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.baseSize == 0.0f ? 0 : Float.floatToIntBits(this.baseSize));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.stretchY == 0.0f ? 0 : Float.floatToIntBits(this.stretchY));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.biomeDepthWeight == 0.0f ? 0 : Float.floatToIntBits(this.biomeDepthWeight));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.biomeDepthOffset == 0.0f ? 0 : Float.floatToIntBits(this.biomeDepthOffset));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.biomeScaleWeight == 0.0f ? 0 : Float.floatToIntBits(this.biomeScaleWeight));
            lvt_1_1_ = 31 * lvt_1_1_ + (this.biomeScaleOffset == 0.0f ? 0 : Float.floatToIntBits(this.biomeScaleOffset));
            lvt_1_1_ = 31 * lvt_1_1_ + this.seaLevel;
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useCaves ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useDungeons ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + this.dungeonChance;
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useStrongholds ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useVillages ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useMineShafts ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useTemples ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useMonuments ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useMansions ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useRavines ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useWaterLakes ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + this.waterLakeChance;
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useLavaLakes ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + this.lavaLakeChance;
            lvt_1_1_ = 31 * lvt_1_1_ + (this.useLavaOceans ? 1 : 0);
            lvt_1_1_ = 31 * lvt_1_1_ + this.fixedBiome;
            lvt_1_1_ = 31 * lvt_1_1_ + this.biomeSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.riverSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.dirtSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.dirtCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.dirtMinHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.dirtMaxHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.gravelSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.gravelCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.gravelMinHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.gravelMaxHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.graniteSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.graniteCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.graniteMinHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.graniteMaxHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.dioriteSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.dioriteCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.dioriteMinHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.dioriteMaxHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.andesiteSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.andesiteCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.andesiteMinHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.andesiteMaxHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.coalSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.coalCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.coalMinHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.coalMaxHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.ironSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.ironCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.ironMinHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.ironMaxHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.goldSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.goldCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.goldMinHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.goldMaxHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.redstoneSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.redstoneCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.redstoneMinHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.redstoneMaxHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.diamondSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.diamondCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.diamondMinHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.diamondMaxHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.lapisSize;
            lvt_1_1_ = 31 * lvt_1_1_ + this.lapisCount;
            lvt_1_1_ = 31 * lvt_1_1_ + this.lapisCenterHeight;
            lvt_1_1_ = 31 * lvt_1_1_ + this.lapisSpread;
            return lvt_1_1_;
        }

        public ChunkProviderSettings build() {
            return new ChunkProviderSettings(this);
        }
    }
}

