/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.FlatLayerInfo;

public class FlatGeneratorInfo {
    private final List<FlatLayerInfo> flatLayers = Lists.newArrayList();
    private final Map<String, Map<String, String>> worldFeatures = Maps.newHashMap();
    private int biomeToUse;

    public int getBiome() {
        return this.biomeToUse;
    }

    public void setBiome(int p_setBiome_1_) {
        this.biomeToUse = p_setBiome_1_;
    }

    public Map<String, Map<String, String>> getWorldFeatures() {
        return this.worldFeatures;
    }

    public List<FlatLayerInfo> getFlatLayers() {
        return this.flatLayers;
    }

    public void updateLayers() {
        int lvt_1_1_ = 0;
        for (FlatLayerInfo lvt_3_1_ : this.flatLayers) {
            lvt_3_1_.setMinY(lvt_1_1_);
            lvt_1_1_ += lvt_3_1_.getLayerCount();
        }
    }

    public String toString() {
        StringBuilder lvt_1_1_ = new StringBuilder();
        lvt_1_1_.append(3);
        lvt_1_1_.append(";");
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.flatLayers.size(); ++lvt_2_1_) {
            if (lvt_2_1_ > 0) {
                lvt_1_1_.append(",");
            }
            lvt_1_1_.append(this.flatLayers.get(lvt_2_1_));
        }
        lvt_1_1_.append(";");
        lvt_1_1_.append(this.biomeToUse);
        if (this.worldFeatures.isEmpty()) {
            lvt_1_1_.append(";");
        } else {
            lvt_1_1_.append(";");
            int lvt_2_2_ = 0;
            for (Map.Entry<String, Map<String, String>> lvt_4_1_ : this.worldFeatures.entrySet()) {
                if (lvt_2_2_++ > 0) {
                    lvt_1_1_.append(",");
                }
                lvt_1_1_.append(lvt_4_1_.getKey().toLowerCase(Locale.ROOT));
                Map<String, String> lvt_5_1_ = lvt_4_1_.getValue();
                if (lvt_5_1_.isEmpty()) continue;
                lvt_1_1_.append("(");
                int lvt_6_1_ = 0;
                for (Map.Entry<String, String> lvt_8_1_ : lvt_5_1_.entrySet()) {
                    if (lvt_6_1_++ > 0) {
                        lvt_1_1_.append(" ");
                    }
                    lvt_1_1_.append(lvt_8_1_.getKey());
                    lvt_1_1_.append("=");
                    lvt_1_1_.append(lvt_8_1_.getValue());
                }
                lvt_1_1_.append(")");
            }
        }
        return lvt_1_1_.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static FlatLayerInfo getLayerFromString(int p_getLayerFromString_0_, String p_getLayerFromString_1_, int p_getLayerFromString_2_) {
        void lvt_6_4_;
        String[] lvt_3_1_ = p_getLayerFromString_0_ >= 3 ? p_getLayerFromString_1_.split("\\*", 2) : p_getLayerFromString_1_.split("x", 2);
        int lvt_4_1_ = 1;
        int lvt_5_1_ = 0;
        if (lvt_3_1_.length == 2) {
            try {
                lvt_4_1_ = Integer.parseInt(lvt_3_1_[0]);
                if (p_getLayerFromString_2_ + lvt_4_1_ >= 256) {
                    lvt_4_1_ = 256 - p_getLayerFromString_2_;
                }
                if (lvt_4_1_ < 0) {
                    lvt_4_1_ = 0;
                }
            }
            catch (Throwable lvt_6_1_) {
                return null;
            }
        }
        try {
            Block lvt_6_3_;
            String lvt_7_1_ = lvt_3_1_[lvt_3_1_.length - 1];
            if (p_getLayerFromString_0_ < 3) {
                lvt_3_1_ = lvt_7_1_.split(":", 2);
                if (lvt_3_1_.length > 1) {
                    lvt_5_1_ = Integer.parseInt(lvt_3_1_[1]);
                }
                Block lvt_6_2_ = Block.getBlockById(Integer.parseInt(lvt_3_1_[0]));
            } else {
                lvt_3_1_ = lvt_7_1_.split(":", 3);
                Block block = lvt_6_3_ = lvt_3_1_.length > 1 ? Block.getBlockFromName(lvt_3_1_[0] + ":" + lvt_3_1_[1]) : null;
                if (lvt_6_3_ != null) {
                    lvt_5_1_ = lvt_3_1_.length > 2 ? Integer.parseInt(lvt_3_1_[2]) : 0;
                } else {
                    lvt_6_3_ = Block.getBlockFromName(lvt_3_1_[0]);
                    if (lvt_6_3_ != null) {
                        int n = lvt_5_1_ = lvt_3_1_.length > 1 ? Integer.parseInt(lvt_3_1_[1]) : 0;
                    }
                }
                if (lvt_6_3_ == null) {
                    return null;
                }
            }
            if (lvt_6_3_ == Blocks.AIR) {
                lvt_5_1_ = 0;
            }
            if (lvt_5_1_ < 0 || lvt_5_1_ > 15) {
                lvt_5_1_ = 0;
            }
        }
        catch (Throwable lvt_7_2_) {
            return null;
        }
        FlatLayerInfo lvt_7_3_ = new FlatLayerInfo(p_getLayerFromString_0_, lvt_4_1_, (Block)lvt_6_4_, lvt_5_1_);
        lvt_7_3_.setMinY(p_getLayerFromString_2_);
        return lvt_7_3_;
    }

    private static List<FlatLayerInfo> getLayersFromString(int p_getLayersFromString_0_, String p_getLayersFromString_1_) {
        if (p_getLayersFromString_1_ == null || p_getLayersFromString_1_.length() < 1) {
            return null;
        }
        ArrayList lvt_2_1_ = Lists.newArrayList();
        String[] lvt_3_1_ = p_getLayersFromString_1_.split(",");
        int lvt_4_1_ = 0;
        for (String lvt_8_1_ : lvt_3_1_) {
            FlatLayerInfo lvt_9_1_ = FlatGeneratorInfo.getLayerFromString(p_getLayersFromString_0_, lvt_8_1_, lvt_4_1_);
            if (lvt_9_1_ == null) {
                return null;
            }
            lvt_2_1_.add(lvt_9_1_);
            lvt_4_1_ += lvt_9_1_.getLayerCount();
        }
        return lvt_2_1_;
    }

    public static FlatGeneratorInfo createFlatGeneratorFromString(String p_createFlatGeneratorFromString_0_) {
        List<FlatLayerInfo> lvt_5_1_;
        int lvt_2_1_;
        if (p_createFlatGeneratorFromString_0_ == null) {
            return FlatGeneratorInfo.getDefaultFlatGenerator();
        }
        String[] lvt_1_1_ = p_createFlatGeneratorFromString_0_.split(";", -1);
        int n = lvt_2_1_ = lvt_1_1_.length == 1 ? 0 : MathHelper.getInt(lvt_1_1_[0], 0);
        if (lvt_2_1_ < 0 || lvt_2_1_ > 3) {
            return FlatGeneratorInfo.getDefaultFlatGenerator();
        }
        FlatGeneratorInfo lvt_3_1_ = new FlatGeneratorInfo();
        int lvt_4_1_ = lvt_1_1_.length == 1 ? 0 : 1;
        if ((lvt_5_1_ = FlatGeneratorInfo.getLayersFromString(lvt_2_1_, lvt_1_1_[lvt_4_1_++])) == null || lvt_5_1_.isEmpty()) {
            return FlatGeneratorInfo.getDefaultFlatGenerator();
        }
        lvt_3_1_.getFlatLayers().addAll(lvt_5_1_);
        lvt_3_1_.updateLayers();
        int lvt_6_1_ = Biome.getIdForBiome(Biomes.PLAINS);
        if (lvt_2_1_ > 0 && lvt_1_1_.length > lvt_4_1_) {
            lvt_6_1_ = MathHelper.getInt(lvt_1_1_[lvt_4_1_++], lvt_6_1_);
        }
        lvt_3_1_.setBiome(lvt_6_1_);
        if (lvt_2_1_ > 0 && lvt_1_1_.length > lvt_4_1_) {
            String[] lvt_7_1_;
            for (String lvt_11_1_ : lvt_7_1_ = lvt_1_1_[lvt_4_1_++].toLowerCase(Locale.ROOT).split(",")) {
                String[] lvt_14_1_;
                String[] lvt_12_1_ = lvt_11_1_.split("\\(", 2);
                HashMap lvt_13_1_ = Maps.newHashMap();
                if (lvt_12_1_[0].isEmpty()) continue;
                lvt_3_1_.getWorldFeatures().put(lvt_12_1_[0], lvt_13_1_);
                if (lvt_12_1_.length <= 1 || !lvt_12_1_[1].endsWith(")") || lvt_12_1_[1].length() <= 1) continue;
                for (String lvt_18_1_ : lvt_14_1_ = lvt_12_1_[1].substring(0, lvt_12_1_[1].length() - 1).split(" ")) {
                    String[] lvt_19_1_ = lvt_18_1_.split("=", 2);
                    if (lvt_19_1_.length != 2) continue;
                    lvt_13_1_.put(lvt_19_1_[0], lvt_19_1_[1]);
                }
            }
        } else {
            lvt_3_1_.getWorldFeatures().put("village", Maps.newHashMap());
        }
        return lvt_3_1_;
    }

    public static FlatGeneratorInfo getDefaultFlatGenerator() {
        FlatGeneratorInfo lvt_0_1_ = new FlatGeneratorInfo();
        lvt_0_1_.setBiome(Biome.getIdForBiome(Biomes.PLAINS));
        lvt_0_1_.getFlatLayers().add(new FlatLayerInfo(1, Blocks.BEDROCK));
        lvt_0_1_.getFlatLayers().add(new FlatLayerInfo(2, Blocks.DIRT));
        lvt_0_1_.getFlatLayers().add(new FlatLayerInfo(1, Blocks.GRASS));
        lvt_0_1_.updateLayers();
        lvt_0_1_.getWorldFeatures().put("village", Maps.newHashMap());
        return lvt_0_1_;
    }
}

