/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public class FlatLayerInfo {
    private final int version;
    private IBlockState layerMaterial;
    private int layerCount = 1;
    private int layerMinimumY;

    public FlatLayerInfo(int p_i45467_1_, Block p_i45467_2_) {
        this(3, p_i45467_1_, p_i45467_2_);
    }

    public FlatLayerInfo(int p_i45627_1_, int p_i45627_2_, Block p_i45627_3_) {
        this.version = p_i45627_1_;
        this.layerCount = p_i45627_2_;
        this.layerMaterial = p_i45627_3_.getDefaultState();
    }

    public FlatLayerInfo(int p_i45628_1_, int p_i45628_2_, Block p_i45628_3_, int p_i45628_4_) {
        this(p_i45628_1_, p_i45628_2_, p_i45628_3_);
        this.layerMaterial = p_i45628_3_.getStateFromMeta(p_i45628_4_);
    }

    public int getLayerCount() {
        return this.layerCount;
    }

    public IBlockState getLayerMaterial() {
        return this.layerMaterial;
    }

    private Block getLayerMaterialBlock() {
        return this.layerMaterial.getBlock();
    }

    private int getFillBlockMeta() {
        return this.layerMaterial.getBlock().getMetaFromState(this.layerMaterial);
    }

    public int getMinY() {
        return this.layerMinimumY;
    }

    public void setMinY(int p_setMinY_1_) {
        this.layerMinimumY = p_setMinY_1_;
    }

    public String toString() {
        String lvt_1_2_;
        if (this.version >= 3) {
            String lvt_1_1_;
            ResourceLocation lvt_2_1_ = Block.REGISTRY.getNameForObject(this.getLayerMaterialBlock());
            String string = lvt_1_1_ = lvt_2_1_ == null ? "null" : lvt_2_1_.toString();
            if (this.layerCount > 1) {
                lvt_1_1_ = this.layerCount + "*" + lvt_1_1_;
            }
        } else {
            lvt_1_2_ = Integer.toString(Block.getIdFromBlock(this.getLayerMaterialBlock()));
            if (this.layerCount > 1) {
                lvt_1_2_ = this.layerCount + "x" + lvt_1_2_;
            }
        }
        int lvt_2_2_ = this.getFillBlockMeta();
        if (lvt_2_2_ > 0) {
            lvt_1_2_ = lvt_1_2_ + ":" + lvt_2_2_;
        }
        return lvt_1_2_;
    }
}

