/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.base.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class MapGenCaves
extends MapGenBase {
    protected static final IBlockState BLK_LAVA = Blocks.LAVA.getDefaultState();
    protected static final IBlockState BLK_AIR = Blocks.AIR.getDefaultState();
    protected static final IBlockState BLK_SANDSTONE = Blocks.SANDSTONE.getDefaultState();
    protected static final IBlockState BLK_RED_SANDSTONE = Blocks.RED_SANDSTONE.getDefaultState();

    protected void addRoom(long p_addRoom_1_, int p_addRoom_3_, int p_addRoom_4_, ChunkPrimer p_addRoom_5_, double p_addRoom_6_, double p_addRoom_8_, double p_addRoom_10_) {
        this.addTunnel(p_addRoom_1_, p_addRoom_3_, p_addRoom_4_, p_addRoom_5_, p_addRoom_6_, p_addRoom_8_, p_addRoom_10_, 1.0f + this.rand.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void addTunnel(long p_addTunnel_1_, int p_addTunnel_3_, int p_addTunnel_4_, ChunkPrimer p_addTunnel_5_, double p_addTunnel_6_, double p_addTunnel_8_, double p_addTunnel_10_, float p_addTunnel_12_, float p_addTunnel_13_, float p_addTunnel_14_, int p_addTunnel_15_, int p_addTunnel_16_, double p_addTunnel_17_) {
        boolean flag;
        double d0 = p_addTunnel_3_ * 16 + 8;
        double d1 = p_addTunnel_4_ * 16 + 8;
        float f = 0.0f;
        float f1 = 0.0f;
        Random random = new Random(p_addTunnel_1_);
        if (p_addTunnel_16_ <= 0) {
            int i = this.range * 16 - 16;
            p_addTunnel_16_ = i - random.nextInt(i / 4);
        }
        boolean flag2 = false;
        if (p_addTunnel_15_ == -1) {
            p_addTunnel_15_ = p_addTunnel_16_ / 2;
            flag2 = true;
        }
        int j = random.nextInt(p_addTunnel_16_ / 2) + p_addTunnel_16_ / 4;
        boolean bl = flag = random.nextInt(6) == 0;
        while (p_addTunnel_15_ < p_addTunnel_16_) {
            double d2 = 1.5 + (double)(MathHelper.sin((float)p_addTunnel_15_ * (float)Math.PI / (float)p_addTunnel_16_) * p_addTunnel_12_);
            double d3 = d2 * p_addTunnel_17_;
            float f2 = MathHelper.cos(p_addTunnel_14_);
            float f3 = MathHelper.sin(p_addTunnel_14_);
            p_addTunnel_6_ += (double)(MathHelper.cos(p_addTunnel_13_) * f2);
            p_addTunnel_8_ += (double)f3;
            p_addTunnel_10_ += (double)(MathHelper.sin(p_addTunnel_13_) * f2);
            p_addTunnel_14_ = flag ? (p_addTunnel_14_ *= 0.92f) : (p_addTunnel_14_ *= 0.7f);
            p_addTunnel_14_ += f1 * 0.1f;
            p_addTunnel_13_ += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag2 && p_addTunnel_15_ == j && p_addTunnel_12_ > 1.0f && p_addTunnel_16_ > 0) {
                this.addTunnel(random.nextLong(), p_addTunnel_3_, p_addTunnel_4_, p_addTunnel_5_, p_addTunnel_6_, p_addTunnel_8_, p_addTunnel_10_, random.nextFloat() * 0.5f + 0.5f, p_addTunnel_13_ - 1.5707964f, p_addTunnel_14_ / 3.0f, p_addTunnel_15_, p_addTunnel_16_, 1.0);
                this.addTunnel(random.nextLong(), p_addTunnel_3_, p_addTunnel_4_, p_addTunnel_5_, p_addTunnel_6_, p_addTunnel_8_, p_addTunnel_10_, random.nextFloat() * 0.5f + 0.5f, p_addTunnel_13_ + 1.5707964f, p_addTunnel_14_ / 3.0f, p_addTunnel_15_, p_addTunnel_16_, 1.0);
                return;
            }
            if (flag2 || random.nextInt(4) != 0) {
                double d4 = p_addTunnel_6_ - d0;
                double d5 = p_addTunnel_10_ - d1;
                double d6 = p_addTunnel_16_ - p_addTunnel_15_;
                double d7 = p_addTunnel_12_ + 2.0f + 16.0f;
                if (d4 * d4 + d5 * d5 - d6 * d6 > d7 * d7) {
                    return;
                }
                if (p_addTunnel_6_ >= d0 - 16.0 - d2 * 2.0 && p_addTunnel_10_ >= d1 - 16.0 - d2 * 2.0 && p_addTunnel_6_ <= d0 + 16.0 + d2 * 2.0 && p_addTunnel_10_ <= d1 + 16.0 + d2 * 2.0) {
                    int k2 = MathHelper.floor(p_addTunnel_6_ - d2) - p_addTunnel_3_ * 16 - 1;
                    int k = MathHelper.floor(p_addTunnel_6_ + d2) - p_addTunnel_3_ * 16 + 1;
                    int l2 = MathHelper.floor(p_addTunnel_8_ - d3) - 1;
                    int l = MathHelper.floor(p_addTunnel_8_ + d3) + 1;
                    int i3 = MathHelper.floor(p_addTunnel_10_ - d2) - p_addTunnel_4_ * 16 - 1;
                    int i1 = MathHelper.floor(p_addTunnel_10_ + d2) - p_addTunnel_4_ * 16 + 1;
                    if (k2 < 0) {
                        k2 = 0;
                    }
                    if (k > 16) {
                        k = 16;
                    }
                    if (l2 < 1) {
                        l2 = 1;
                    }
                    if (l > 248) {
                        l = 248;
                    }
                    if (i3 < 0) {
                        i3 = 0;
                    }
                    if (i1 > 16) {
                        i1 = 16;
                    }
                    boolean flag3 = false;
                    for (int j1 = k2; !flag3 && j1 < k; ++j1) {
                        for (int k1 = i3; !flag3 && k1 < i1; ++k1) {
                            for (int l1 = l + 1; !flag3 && l1 >= l2 - 1; --l1) {
                                if (l1 < 0 || l1 >= 256) continue;
                                if (this.isOceanBlock(p_addTunnel_5_, j1, l1, k1, p_addTunnel_3_, p_addTunnel_4_)) {
                                    flag3 = true;
                                }
                                if (l1 == l2 - 1 || j1 == k2 || j1 == k - 1 || k1 == i3 || k1 == i1 - 1) continue;
                                l1 = l2;
                            }
                        }
                    }
                    if (!flag3) {
                        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                        for (int j3 = k2; j3 < k; ++j3) {
                            double d10 = ((double)(j3 + p_addTunnel_3_ * 16) + 0.5 - p_addTunnel_6_) / d2;
                            for (int i2 = i3; i2 < i1; ++i2) {
                                double d8 = ((double)(i2 + p_addTunnel_4_ * 16) + 0.5 - p_addTunnel_10_) / d2;
                                boolean flag1 = false;
                                if (!(d10 * d10 + d8 * d8 < 1.0)) continue;
                                for (int j2 = l; j2 > l2; --j2) {
                                    double d9 = ((double)(j2 - 1) + 0.5 - p_addTunnel_8_) / d3;
                                    if (!(d9 > -0.7) || !(d10 * d10 + d9 * d9 + d8 * d8 < 1.0)) continue;
                                    IBlockState iblockstate1 = p_addTunnel_5_.getBlockState(j3, j2, i2);
                                    IBlockState iblockstate2 = (IBlockState)Objects.firstNonNull((Object)p_addTunnel_5_.getBlockState(j3, j2 + 1, i2), (Object)BLK_AIR);
                                    if (this.isTopBlock(p_addTunnel_5_, j3, j2, i2, p_addTunnel_3_, p_addTunnel_4_)) {
                                        flag1 = true;
                                    }
                                    this.digBlock(p_addTunnel_5_, j3, j2, i2, p_addTunnel_3_, p_addTunnel_4_, flag1, iblockstate1, iblockstate2);
                                }
                            }
                        }
                        if (flag2) break;
                    }
                }
            }
            ++p_addTunnel_15_;
        }
    }

    protected boolean canReplaceBlock(IBlockState p_canReplaceBlock_1_, IBlockState p_canReplaceBlock_2_) {
        return p_canReplaceBlock_1_.getBlock() == Blocks.STONE ? true : (p_canReplaceBlock_1_.getBlock() == Blocks.DIRT ? true : (p_canReplaceBlock_1_.getBlock() == Blocks.GRASS ? true : (p_canReplaceBlock_1_.getBlock() == Blocks.HARDENED_CLAY ? true : (p_canReplaceBlock_1_.getBlock() == Blocks.STAINED_HARDENED_CLAY ? true : (p_canReplaceBlock_1_.getBlock() == Blocks.SANDSTONE ? true : (p_canReplaceBlock_1_.getBlock() == Blocks.RED_SANDSTONE ? true : (p_canReplaceBlock_1_.getBlock() == Blocks.MYCELIUM ? true : (p_canReplaceBlock_1_.getBlock() == Blocks.SNOW_LAYER ? true : (p_canReplaceBlock_1_.getBlock() == Blocks.SAND || p_canReplaceBlock_1_.getBlock() == Blocks.GRAVEL) && p_canReplaceBlock_2_.getMaterial() != Material.WATER))))))));
    }

    @Override
    protected void recursiveGenerate(World p_recursiveGenerate_1_, int p_recursiveGenerate_2_, int p_recursiveGenerate_3_, int p_recursiveGenerate_4_, int p_recursiveGenerate_5_, ChunkPrimer p_recursiveGenerate_6_) {
        int i = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(15) + 1) + 1);
        if (this.rand.nextInt(7) != 0) {
            i = 0;
        }
        for (int j = 0; j < i; ++j) {
            double d0 = p_recursiveGenerate_2_ * 16 + this.rand.nextInt(16);
            double d1 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            double d2 = p_recursiveGenerate_3_ * 16 + this.rand.nextInt(16);
            int k = 1;
            if (this.rand.nextInt(4) == 0) {
                this.addRoom(this.rand.nextLong(), p_recursiveGenerate_4_, p_recursiveGenerate_5_, p_recursiveGenerate_6_, d0, d1, d2);
                k += this.rand.nextInt(4);
            }
            for (int l = 0; l < k; ++l) {
                float f = this.rand.nextFloat() * ((float)Math.PI * 2);
                float f1 = (this.rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = this.rand.nextFloat() * 2.0f + this.rand.nextFloat();
                if (this.rand.nextInt(10) == 0) {
                    f2 *= this.rand.nextFloat() * this.rand.nextFloat() * 3.0f + 1.0f;
                }
                this.addTunnel(this.rand.nextLong(), p_recursiveGenerate_4_, p_recursiveGenerate_5_, p_recursiveGenerate_6_, d0, d1, d2, f2, f, f1, 0, 0, 1.0);
            }
        }
    }

    protected boolean isOceanBlock(ChunkPrimer p_isOceanBlock_1_, int p_isOceanBlock_2_, int p_isOceanBlock_3_, int p_isOceanBlock_4_, int p_isOceanBlock_5_, int p_isOceanBlock_6_) {
        Block block = p_isOceanBlock_1_.getBlockState(p_isOceanBlock_2_, p_isOceanBlock_3_, p_isOceanBlock_4_).getBlock();
        return block == Blocks.FLOWING_WATER || block == Blocks.WATER;
    }

    private boolean isExceptionBiome(Biome p_isExceptionBiome_1_) {
        if (p_isExceptionBiome_1_ == Biomes.BEACH) {
            return true;
        }
        return p_isExceptionBiome_1_ == Biomes.DESERT;
    }

    private boolean isTopBlock(ChunkPrimer p_isTopBlock_1_, int p_isTopBlock_2_, int p_isTopBlock_3_, int p_isTopBlock_4_, int p_isTopBlock_5_, int p_isTopBlock_6_) {
        Biome biome = this.world.getBiome(new BlockPos(p_isTopBlock_2_ + p_isTopBlock_5_ * 16, 0, p_isTopBlock_4_ + p_isTopBlock_6_ * 16));
        IBlockState state = p_isTopBlock_1_.getBlockState(p_isTopBlock_2_, p_isTopBlock_3_, p_isTopBlock_4_);
        return this.isExceptionBiome(biome) ? state.getBlock() == Blocks.GRASS : state.getBlock() == biome.topBlock;
    }

    protected void digBlock(ChunkPrimer p_digBlock_1_, int p_digBlock_2_, int p_digBlock_3_, int p_digBlock_4_, int p_digBlock_5_, int p_digBlock_6_, boolean p_digBlock_7_, IBlockState p_digBlock_8_, IBlockState p_digBlock_9_) {
        Biome biome = this.world.getBiome(new BlockPos(p_digBlock_2_ + p_digBlock_5_ * 16, 0, p_digBlock_4_ + p_digBlock_6_ * 16));
        IBlockState top = biome.topBlock;
        IBlockState filler = biome.fillerBlock;
        if (this.canReplaceBlock(p_digBlock_8_, p_digBlock_9_) || p_digBlock_8_.getBlock() == top.getBlock() || p_digBlock_8_.getBlock() == filler.getBlock()) {
            if (p_digBlock_3_ - 1 < 10) {
                p_digBlock_1_.setBlockState(p_digBlock_2_, p_digBlock_3_, p_digBlock_4_, BLK_LAVA);
            } else {
                p_digBlock_1_.setBlockState(p_digBlock_2_, p_digBlock_3_, p_digBlock_4_, BLK_AIR);
                if (p_digBlock_7_ && p_digBlock_1_.getBlockState(p_digBlock_2_, p_digBlock_3_ - 1, p_digBlock_4_).getBlock() == filler.getBlock()) {
                    p_digBlock_1_.setBlockState(p_digBlock_2_, p_digBlock_3_ - 1, p_digBlock_4_, top.getBlock().getDefaultState());
                }
            }
        }
    }
}

