/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class MapGenRavine
extends MapGenBase {
    protected static final IBlockState FLOWING_LAVA = Blocks.FLOWING_LAVA.getDefaultState();
    protected static final IBlockState AIR = Blocks.AIR.getDefaultState();
    private final float[] rs = new float[1024];

    protected void addTunnel(long p_addTunnel_1_, int p_addTunnel_3_, int p_addTunnel_4_, ChunkPrimer p_addTunnel_5_, double p_addTunnel_6_, double p_addTunnel_8_, double p_addTunnel_10_, float p_addTunnel_12_, float p_addTunnel_13_, float p_addTunnel_14_, int p_addTunnel_15_, int p_addTunnel_16_, double p_addTunnel_17_) {
        Random random = new Random(p_addTunnel_1_);
        double d0 = p_addTunnel_3_ * 16 + 8;
        double d1 = p_addTunnel_4_ * 16 + 8;
        float f = 0.0f;
        float f1 = 0.0f;
        if (p_addTunnel_16_ <= 0) {
            int i = this.range * 16 - 16;
            p_addTunnel_16_ = i - random.nextInt(i / 4);
        }
        boolean flag1 = false;
        if (p_addTunnel_15_ == -1) {
            p_addTunnel_15_ = p_addTunnel_16_ / 2;
            flag1 = true;
        }
        float f2 = 1.0f;
        for (int j = 0; j < 256; ++j) {
            if (j == 0 || random.nextInt(3) == 0) {
                f2 = 1.0f + random.nextFloat() * random.nextFloat();
            }
            this.rs[j] = f2 * f2;
        }
        while (p_addTunnel_15_ < p_addTunnel_16_) {
            double d9 = 1.5 + (double)(MathHelper.sin((float)p_addTunnel_15_ * (float)Math.PI / (float)p_addTunnel_16_) * p_addTunnel_12_);
            double d2 = d9 * p_addTunnel_17_;
            d9 *= (double)random.nextFloat() * 0.25 + 0.75;
            d2 *= (double)random.nextFloat() * 0.25 + 0.75;
            float f3 = MathHelper.cos(p_addTunnel_14_);
            float f4 = MathHelper.sin(p_addTunnel_14_);
            p_addTunnel_6_ += (double)(MathHelper.cos(p_addTunnel_13_) * f3);
            p_addTunnel_8_ += (double)f4;
            p_addTunnel_10_ += (double)(MathHelper.sin(p_addTunnel_13_) * f3);
            p_addTunnel_14_ *= 0.7f;
            p_addTunnel_14_ += f1 * 0.05f;
            p_addTunnel_13_ += f * 0.05f;
            f1 *= 0.8f;
            f *= 0.5f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (flag1 || random.nextInt(4) != 0) {
                double d3 = p_addTunnel_6_ - d0;
                double d4 = p_addTunnel_10_ - d1;
                double d5 = p_addTunnel_16_ - p_addTunnel_15_;
                double d6 = p_addTunnel_12_ + 2.0f + 16.0f;
                if (d3 * d3 + d4 * d4 - d5 * d5 > d6 * d6) {
                    return;
                }
                if (p_addTunnel_6_ >= d0 - 16.0 - d9 * 2.0 && p_addTunnel_10_ >= d1 - 16.0 - d9 * 2.0 && p_addTunnel_6_ <= d0 + 16.0 + d9 * 2.0 && p_addTunnel_10_ <= d1 + 16.0 + d9 * 2.0) {
                    int k2 = MathHelper.floor(p_addTunnel_6_ - d9) - p_addTunnel_3_ * 16 - 1;
                    int k = MathHelper.floor(p_addTunnel_6_ + d9) - p_addTunnel_3_ * 16 + 1;
                    int l2 = MathHelper.floor(p_addTunnel_8_ - d2) - 1;
                    int l = MathHelper.floor(p_addTunnel_8_ + d2) + 1;
                    int i3 = MathHelper.floor(p_addTunnel_10_ - d9) - p_addTunnel_4_ * 16 - 1;
                    int i1 = MathHelper.floor(p_addTunnel_10_ + d9) - p_addTunnel_4_ * 16 + 1;
                    if (k2 < 0) {
                        k2 = 0;
                    }
                    if (k > 16) {
                        k = 16;
                    }
                    if (l2 < 1) {
                        l2 = 1;
                    }
                    if (l > 248) {
                        l = 248;
                    }
                    if (i3 < 0) {
                        i3 = 0;
                    }
                    if (i1 > 16) {
                        i1 = 16;
                    }
                    boolean flag2 = false;
                    for (int j1 = k2; !flag2 && j1 < k; ++j1) {
                        for (int k1 = i3; !flag2 && k1 < i1; ++k1) {
                            for (int l1 = l + 1; !flag2 && l1 >= l2 - 1; --l1) {
                                if (l1 < 0 || l1 >= 256) continue;
                                if (this.isOceanBlock(p_addTunnel_5_, j1, l1, k1, p_addTunnel_3_, p_addTunnel_4_)) {
                                    flag2 = true;
                                }
                                if (l1 == l2 - 1 || j1 == k2 || j1 == k - 1 || k1 == i3 || k1 == i1 - 1) continue;
                                l1 = l2;
                            }
                        }
                    }
                    if (!flag2) {
                        for (int j3 = k2; j3 < k; ++j3) {
                            double d10 = ((double)(j3 + p_addTunnel_3_ * 16) + 0.5 - p_addTunnel_6_) / d9;
                            for (int i2 = i3; i2 < i1; ++i2) {
                                double d7 = ((double)(i2 + p_addTunnel_4_ * 16) + 0.5 - p_addTunnel_10_) / d9;
                                boolean flag = false;
                                if (!(d10 * d10 + d7 * d7 < 1.0)) continue;
                                for (int j2 = l; j2 > l2; --j2) {
                                    double d8 = ((double)(j2 - 1) + 0.5 - p_addTunnel_8_) / d2;
                                    if (!((d10 * d10 + d7 * d7) * (double)this.rs[j2 - 1] + d8 * d8 / 6.0 < 1.0)) continue;
                                    if (this.isTopBlock(p_addTunnel_5_, j3, j2, i2, p_addTunnel_3_, p_addTunnel_4_)) {
                                        flag = true;
                                    }
                                    this.digBlock(p_addTunnel_5_, j3, j2, i2, p_addTunnel_3_, p_addTunnel_4_, flag);
                                }
                            }
                        }
                        if (flag1) break;
                    }
                }
            }
            ++p_addTunnel_15_;
        }
    }

    @Override
    protected void recursiveGenerate(World p_recursiveGenerate_1_, int p_recursiveGenerate_2_, int p_recursiveGenerate_3_, int p_recursiveGenerate_4_, int p_recursiveGenerate_5_, ChunkPrimer p_recursiveGenerate_6_) {
        if (this.rand.nextInt(50) == 0) {
            double d0 = p_recursiveGenerate_2_ * 16 + this.rand.nextInt(16);
            double d1 = this.rand.nextInt(this.rand.nextInt(40) + 8) + 20;
            double d2 = p_recursiveGenerate_3_ * 16 + this.rand.nextInt(16);
            boolean i = true;
            for (int j = 0; j < 1; ++j) {
                float f = this.rand.nextFloat() * ((float)Math.PI * 2);
                float f1 = (this.rand.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = (this.rand.nextFloat() * 2.0f + this.rand.nextFloat()) * 2.0f;
                this.addTunnel(this.rand.nextLong(), p_recursiveGenerate_4_, p_recursiveGenerate_5_, p_recursiveGenerate_6_, d0, d1, d2, f2, f, f1, 0, 0, 3.0);
            }
        }
    }

    protected boolean isOceanBlock(ChunkPrimer p_isOceanBlock_1_, int p_isOceanBlock_2_, int p_isOceanBlock_3_, int p_isOceanBlock_4_, int p_isOceanBlock_5_, int p_isOceanBlock_6_) {
        Block block = p_isOceanBlock_1_.getBlockState(p_isOceanBlock_2_, p_isOceanBlock_3_, p_isOceanBlock_4_).getBlock();
        return block == Blocks.FLOWING_WATER || block == Blocks.WATER;
    }

    private boolean isExceptionBiome(Biome p_isExceptionBiome_1_) {
        if (p_isExceptionBiome_1_ == Biomes.BEACH) {
            return true;
        }
        if (p_isExceptionBiome_1_ == Biomes.DESERT) {
            return true;
        }
        if (p_isExceptionBiome_1_ == Biomes.MUSHROOM_ISLAND) {
            return true;
        }
        return p_isExceptionBiome_1_ == Biomes.MUSHROOM_ISLAND_SHORE;
    }

    private boolean isTopBlock(ChunkPrimer p_isTopBlock_1_, int p_isTopBlock_2_, int p_isTopBlock_3_, int p_isTopBlock_4_, int p_isTopBlock_5_, int p_isTopBlock_6_) {
        Biome biome = this.world.getBiome(new BlockPos(p_isTopBlock_2_ + p_isTopBlock_5_ * 16, 0, p_isTopBlock_4_ + p_isTopBlock_6_ * 16));
        IBlockState state = p_isTopBlock_1_.getBlockState(p_isTopBlock_2_, p_isTopBlock_3_, p_isTopBlock_4_);
        return this.isExceptionBiome(biome) ? state.getBlock() == Blocks.GRASS : state.getBlock() == biome.topBlock;
    }

    protected void digBlock(ChunkPrimer p_digBlock_1_, int p_digBlock_2_, int p_digBlock_3_, int p_digBlock_4_, int p_digBlock_5_, int p_digBlock_6_, boolean p_digBlock_7_) {
        IBlockState filler;
        Biome biome = this.world.getBiome(new BlockPos(p_digBlock_2_ + p_digBlock_5_ * 16, 0, p_digBlock_4_ + p_digBlock_6_ * 16));
        IBlockState state = p_digBlock_1_.getBlockState(p_digBlock_2_, p_digBlock_3_, p_digBlock_4_);
        IBlockState top = this.isExceptionBiome(biome) ? Blocks.GRASS.getDefaultState() : biome.topBlock;
        IBlockState iBlockState = filler = this.isExceptionBiome(biome) ? Blocks.DIRT.getDefaultState() : biome.fillerBlock;
        if (state.getBlock() == Blocks.STONE || state.getBlock() == top.getBlock() || state.getBlock() == filler.getBlock()) {
            if (p_digBlock_3_ - 1 < 10) {
                p_digBlock_1_.setBlockState(p_digBlock_2_, p_digBlock_3_, p_digBlock_4_, FLOWING_LAVA);
            } else {
                p_digBlock_1_.setBlockState(p_digBlock_2_, p_digBlock_3_, p_digBlock_4_, AIR);
                if (p_digBlock_7_ && p_digBlock_1_.getBlockState(p_digBlock_2_, p_digBlock_3_ - 1, p_digBlock_4_).getBlock() == filler.getBlock()) {
                    p_digBlock_1_.setBlockState(p_digBlock_2_, p_digBlock_3_ - 1, p_digBlock_4_, top.getBlock().getDefaultState());
                }
            }
        }
    }
}

