/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.Random;
import net.minecraft.world.gen.NoiseGenerator;

public class NoiseGeneratorImproved
extends NoiseGenerator {
    private final int[] permutations = new int[512];
    public double xCoord;
    public double yCoord;
    public double zCoord;
    private static final double[] GRAD_X = new double[]{1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0};
    private static final double[] GRAD_Y = new double[]{1.0, 1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0};
    private static final double[] GRAD_Z = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 0.0, 1.0, 0.0, -1.0};
    private static final double[] GRAD_2X = new double[]{1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0};
    private static final double[] GRAD_2Z = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, -1.0, -1.0, 1.0, 1.0, -1.0, -1.0, 0.0, 1.0, 0.0, -1.0};

    public NoiseGeneratorImproved() {
        this(new Random());
    }

    public NoiseGeneratorImproved(Random p_i45469_1_) {
        this.xCoord = p_i45469_1_.nextDouble() * 256.0;
        this.yCoord = p_i45469_1_.nextDouble() * 256.0;
        this.zCoord = p_i45469_1_.nextDouble() * 256.0;
        for (int lvt_2_1_ = 0; lvt_2_1_ < 256; ++lvt_2_1_) {
            this.permutations[lvt_2_1_] = lvt_2_1_;
        }
        for (int lvt_2_2_ = 0; lvt_2_2_ < 256; ++lvt_2_2_) {
            int lvt_3_1_ = p_i45469_1_.nextInt(256 - lvt_2_2_) + lvt_2_2_;
            int lvt_4_1_ = this.permutations[lvt_2_2_];
            this.permutations[lvt_2_2_] = this.permutations[lvt_3_1_];
            this.permutations[lvt_3_1_] = lvt_4_1_;
            this.permutations[lvt_2_2_ + 256] = this.permutations[lvt_2_2_];
        }
    }

    public final double lerp(double p_lerp_1_, double p_lerp_3_, double p_lerp_5_) {
        return p_lerp_3_ + p_lerp_1_ * (p_lerp_5_ - p_lerp_3_);
    }

    public final double grad2(int p_grad2_1_, double p_grad2_2_, double p_grad2_4_) {
        int lvt_6_1_ = p_grad2_1_ & 0xF;
        return GRAD_2X[lvt_6_1_] * p_grad2_2_ + GRAD_2Z[lvt_6_1_] * p_grad2_4_;
    }

    public final double grad(int p_grad_1_, double p_grad_2_, double p_grad_4_, double p_grad_6_) {
        int lvt_8_1_ = p_grad_1_ & 0xF;
        return GRAD_X[lvt_8_1_] * p_grad_2_ + GRAD_Y[lvt_8_1_] * p_grad_4_ + GRAD_Z[lvt_8_1_] * p_grad_6_;
    }

    public void populateNoiseArray(double[] p_populateNoiseArray_1_, double p_populateNoiseArray_2_, double p_populateNoiseArray_4_, double p_populateNoiseArray_6_, int p_populateNoiseArray_8_, int p_populateNoiseArray_9_, int p_populateNoiseArray_10_, double p_populateNoiseArray_11_, double p_populateNoiseArray_13_, double p_populateNoiseArray_15_, double p_populateNoiseArray_17_) {
        if (p_populateNoiseArray_9_ == 1) {
            int lvt_19_1_ = 0;
            int lvt_20_1_ = 0;
            int lvt_21_1_ = 0;
            int lvt_22_1_ = 0;
            double lvt_23_1_ = 0.0;
            double lvt_25_1_ = 0.0;
            int lvt_27_1_ = 0;
            double lvt_28_1_ = 1.0 / p_populateNoiseArray_17_;
            for (int lvt_30_1_ = 0; lvt_30_1_ < p_populateNoiseArray_8_; ++lvt_30_1_) {
                double lvt_31_1_ = p_populateNoiseArray_2_ + (double)lvt_30_1_ * p_populateNoiseArray_11_ + this.xCoord;
                int lvt_33_1_ = (int)lvt_31_1_;
                if (lvt_31_1_ < (double)lvt_33_1_) {
                    --lvt_33_1_;
                }
                int lvt_34_1_ = lvt_33_1_ & 0xFF;
                double lvt_35_1_ = (lvt_31_1_ -= (double)lvt_33_1_) * lvt_31_1_ * lvt_31_1_ * (lvt_31_1_ * (lvt_31_1_ * 6.0 - 15.0) + 10.0);
                for (int lvt_37_1_ = 0; lvt_37_1_ < p_populateNoiseArray_10_; ++lvt_37_1_) {
                    double lvt_38_1_ = p_populateNoiseArray_6_ + (double)lvt_37_1_ * p_populateNoiseArray_15_ + this.zCoord;
                    int lvt_40_1_ = (int)lvt_38_1_;
                    if (lvt_38_1_ < (double)lvt_40_1_) {
                        --lvt_40_1_;
                    }
                    int lvt_41_1_ = lvt_40_1_ & 0xFF;
                    double lvt_42_1_ = (lvt_38_1_ -= (double)lvt_40_1_) * lvt_38_1_ * lvt_38_1_ * (lvt_38_1_ * (lvt_38_1_ * 6.0 - 15.0) + 10.0);
                    lvt_19_1_ = this.permutations[lvt_34_1_] + 0;
                    lvt_20_1_ = this.permutations[lvt_19_1_] + lvt_41_1_;
                    lvt_21_1_ = this.permutations[lvt_34_1_ + 1] + 0;
                    lvt_22_1_ = this.permutations[lvt_21_1_] + lvt_41_1_;
                    lvt_23_1_ = this.lerp(lvt_35_1_, this.grad2(this.permutations[lvt_20_1_], lvt_31_1_, lvt_38_1_), this.grad(this.permutations[lvt_22_1_], lvt_31_1_ - 1.0, 0.0, lvt_38_1_));
                    lvt_25_1_ = this.lerp(lvt_35_1_, this.grad(this.permutations[lvt_20_1_ + 1], lvt_31_1_, 0.0, lvt_38_1_ - 1.0), this.grad(this.permutations[lvt_22_1_ + 1], lvt_31_1_ - 1.0, 0.0, lvt_38_1_ - 1.0));
                    double lvt_44_1_ = this.lerp(lvt_42_1_, lvt_23_1_, lvt_25_1_);
                    int n = lvt_27_1_++;
                    p_populateNoiseArray_1_[n] = p_populateNoiseArray_1_[n] + lvt_44_1_ * lvt_28_1_;
                }
            }
            return;
        }
        int lvt_19_2_ = 0;
        double lvt_20_2_ = 1.0 / p_populateNoiseArray_17_;
        int lvt_22_2_ = -1;
        int lvt_23_2_ = 0;
        int lvt_24_1_ = 0;
        int lvt_25_2_ = 0;
        int lvt_26_1_ = 0;
        int lvt_27_2_ = 0;
        int lvt_28_2_ = 0;
        double lvt_29_1_ = 0.0;
        double lvt_31_2_ = 0.0;
        double lvt_33_2_ = 0.0;
        double lvt_35_2_ = 0.0;
        for (int lvt_37_2_ = 0; lvt_37_2_ < p_populateNoiseArray_8_; ++lvt_37_2_) {
            double lvt_38_2_ = p_populateNoiseArray_2_ + (double)lvt_37_2_ * p_populateNoiseArray_11_ + this.xCoord;
            int lvt_40_2_ = (int)lvt_38_2_;
            if (lvt_38_2_ < (double)lvt_40_2_) {
                --lvt_40_2_;
            }
            int lvt_41_2_ = lvt_40_2_ & 0xFF;
            double lvt_42_2_ = (lvt_38_2_ -= (double)lvt_40_2_) * lvt_38_2_ * lvt_38_2_ * (lvt_38_2_ * (lvt_38_2_ * 6.0 - 15.0) + 10.0);
            for (int lvt_44_2_ = 0; lvt_44_2_ < p_populateNoiseArray_10_; ++lvt_44_2_) {
                double lvt_45_1_ = p_populateNoiseArray_6_ + (double)lvt_44_2_ * p_populateNoiseArray_15_ + this.zCoord;
                int lvt_47_1_ = (int)lvt_45_1_;
                if (lvt_45_1_ < (double)lvt_47_1_) {
                    --lvt_47_1_;
                }
                int lvt_48_1_ = lvt_47_1_ & 0xFF;
                double lvt_49_1_ = (lvt_45_1_ -= (double)lvt_47_1_) * lvt_45_1_ * lvt_45_1_ * (lvt_45_1_ * (lvt_45_1_ * 6.0 - 15.0) + 10.0);
                for (int lvt_51_1_ = 0; lvt_51_1_ < p_populateNoiseArray_9_; ++lvt_51_1_) {
                    double lvt_52_1_ = p_populateNoiseArray_4_ + (double)lvt_51_1_ * p_populateNoiseArray_13_ + this.yCoord;
                    int lvt_54_1_ = (int)lvt_52_1_;
                    if (lvt_52_1_ < (double)lvt_54_1_) {
                        --lvt_54_1_;
                    }
                    int lvt_55_1_ = lvt_54_1_ & 0xFF;
                    double lvt_56_1_ = (lvt_52_1_ -= (double)lvt_54_1_) * lvt_52_1_ * lvt_52_1_ * (lvt_52_1_ * (lvt_52_1_ * 6.0 - 15.0) + 10.0);
                    if (lvt_51_1_ == 0 || lvt_55_1_ != lvt_22_2_) {
                        lvt_22_2_ = lvt_55_1_;
                        lvt_23_2_ = this.permutations[lvt_41_2_] + lvt_55_1_;
                        lvt_24_1_ = this.permutations[lvt_23_2_] + lvt_48_1_;
                        lvt_25_2_ = this.permutations[lvt_23_2_ + 1] + lvt_48_1_;
                        lvt_26_1_ = this.permutations[lvt_41_2_ + 1] + lvt_55_1_;
                        lvt_27_2_ = this.permutations[lvt_26_1_] + lvt_48_1_;
                        lvt_28_2_ = this.permutations[lvt_26_1_ + 1] + lvt_48_1_;
                        lvt_29_1_ = this.lerp(lvt_42_2_, this.grad(this.permutations[lvt_24_1_], lvt_38_2_, lvt_52_1_, lvt_45_1_), this.grad(this.permutations[lvt_27_2_], lvt_38_2_ - 1.0, lvt_52_1_, lvt_45_1_));
                        lvt_31_2_ = this.lerp(lvt_42_2_, this.grad(this.permutations[lvt_25_2_], lvt_38_2_, lvt_52_1_ - 1.0, lvt_45_1_), this.grad(this.permutations[lvt_28_2_], lvt_38_2_ - 1.0, lvt_52_1_ - 1.0, lvt_45_1_));
                        lvt_33_2_ = this.lerp(lvt_42_2_, this.grad(this.permutations[lvt_24_1_ + 1], lvt_38_2_, lvt_52_1_, lvt_45_1_ - 1.0), this.grad(this.permutations[lvt_27_2_ + 1], lvt_38_2_ - 1.0, lvt_52_1_, lvt_45_1_ - 1.0));
                        lvt_35_2_ = this.lerp(lvt_42_2_, this.grad(this.permutations[lvt_25_2_ + 1], lvt_38_2_, lvt_52_1_ - 1.0, lvt_45_1_ - 1.0), this.grad(this.permutations[lvt_28_2_ + 1], lvt_38_2_ - 1.0, lvt_52_1_ - 1.0, lvt_45_1_ - 1.0));
                    }
                    double lvt_58_1_ = this.lerp(lvt_56_1_, lvt_29_1_, lvt_31_2_);
                    double lvt_60_1_ = this.lerp(lvt_56_1_, lvt_33_2_, lvt_35_2_);
                    double lvt_62_1_ = this.lerp(lvt_49_1_, lvt_58_1_, lvt_60_1_);
                    int n = lvt_19_2_++;
                    p_populateNoiseArray_1_[n] = p_populateNoiseArray_1_[n] + lvt_62_1_ * lvt_20_2_;
                }
            }
        }
    }
}

