/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.Random;

public class NoiseGeneratorSimplex {
    private static final int[][] grad3 = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}};
    public static final double SQRT_3 = Math.sqrt(3.0);
    private final int[] p = new int[512];
    public double xo;
    public double yo;
    public double zo;
    private static final double F2 = 0.5 * (SQRT_3 - 1.0);
    private static final double G2 = (3.0 - SQRT_3) / 6.0;

    public NoiseGeneratorSimplex() {
        this(new Random());
    }

    public NoiseGeneratorSimplex(Random p_i45471_1_) {
        this.xo = p_i45471_1_.nextDouble() * 256.0;
        this.yo = p_i45471_1_.nextDouble() * 256.0;
        this.zo = p_i45471_1_.nextDouble() * 256.0;
        for (int lvt_2_1_ = 0; lvt_2_1_ < 256; ++lvt_2_1_) {
            this.p[lvt_2_1_] = lvt_2_1_;
        }
        for (int lvt_2_2_ = 0; lvt_2_2_ < 256; ++lvt_2_2_) {
            int lvt_3_1_ = p_i45471_1_.nextInt(256 - lvt_2_2_) + lvt_2_2_;
            int lvt_4_1_ = this.p[lvt_2_2_];
            this.p[lvt_2_2_] = this.p[lvt_3_1_];
            this.p[lvt_3_1_] = lvt_4_1_;
            this.p[lvt_2_2_ + 256] = this.p[lvt_2_2_];
        }
    }

    private static int fastFloor(double p_fastFloor_0_) {
        return p_fastFloor_0_ > 0.0 ? (int)p_fastFloor_0_ : (int)p_fastFloor_0_ - 1;
    }

    private static double dot(int[] p_dot_0_, double p_dot_1_, double p_dot_3_) {
        return (double)p_dot_0_[0] * p_dot_1_ + (double)p_dot_0_[1] * p_dot_3_;
    }

    public double getValue(double p_getValue_1_, double p_getValue_3_) {
        double lvt_9_2_;
        double lvt_7_2_;
        double lvt_5_2_;
        int lvt_30_2_;
        int lvt_29_2_;
        double lvt_23_1_;
        double lvt_27_1_;
        double lvt_17_1_;
        int lvt_16_1_;
        double lvt_19_1_;
        double lvt_11_1_ = 0.5 * (SQRT_3 - 1.0);
        double lvt_13_1_ = (p_getValue_1_ + p_getValue_3_) * lvt_11_1_;
        int lvt_15_1_ = NoiseGeneratorSimplex.fastFloor(p_getValue_1_ + lvt_13_1_);
        double lvt_21_1_ = (double)lvt_15_1_ - (lvt_19_1_ = (double)(lvt_15_1_ + (lvt_16_1_ = NoiseGeneratorSimplex.fastFloor(p_getValue_3_ + lvt_13_1_))) * (lvt_17_1_ = (3.0 - SQRT_3) / 6.0));
        double lvt_25_1_ = p_getValue_1_ - lvt_21_1_;
        if (lvt_25_1_ > (lvt_27_1_ = p_getValue_3_ - (lvt_23_1_ = (double)lvt_16_1_ - lvt_19_1_))) {
            boolean lvt_29_1_ = true;
            boolean lvt_30_1_ = false;
        } else {
            lvt_29_2_ = 0;
            lvt_30_2_ = 1;
        }
        double lvt_31_1_ = lvt_25_1_ - (double)lvt_29_2_ + lvt_17_1_;
        double lvt_33_1_ = lvt_27_1_ - (double)lvt_30_2_ + lvt_17_1_;
        double lvt_35_1_ = lvt_25_1_ - 1.0 + 2.0 * lvt_17_1_;
        double lvt_37_1_ = lvt_27_1_ - 1.0 + 2.0 * lvt_17_1_;
        int lvt_39_1_ = lvt_15_1_ & 0xFF;
        int lvt_40_1_ = lvt_16_1_ & 0xFF;
        int lvt_41_1_ = this.p[lvt_39_1_ + this.p[lvt_40_1_]] % 12;
        int lvt_42_1_ = this.p[lvt_39_1_ + lvt_29_2_ + this.p[lvt_40_1_ + lvt_30_2_]] % 12;
        int lvt_43_1_ = this.p[lvt_39_1_ + 1 + this.p[lvt_40_1_ + 1]] % 12;
        double lvt_44_1_ = 0.5 - lvt_25_1_ * lvt_25_1_ - lvt_27_1_ * lvt_27_1_;
        if (lvt_44_1_ < 0.0) {
            double lvt_5_1_ = 0.0;
        } else {
            lvt_44_1_ *= lvt_44_1_;
            lvt_5_2_ = lvt_44_1_ * lvt_44_1_ * NoiseGeneratorSimplex.dot(grad3[lvt_41_1_], lvt_25_1_, lvt_27_1_);
        }
        double lvt_46_1_ = 0.5 - lvt_31_1_ * lvt_31_1_ - lvt_33_1_ * lvt_33_1_;
        if (lvt_46_1_ < 0.0) {
            double lvt_7_1_ = 0.0;
        } else {
            lvt_46_1_ *= lvt_46_1_;
            lvt_7_2_ = lvt_46_1_ * lvt_46_1_ * NoiseGeneratorSimplex.dot(grad3[lvt_42_1_], lvt_31_1_, lvt_33_1_);
        }
        double lvt_48_1_ = 0.5 - lvt_35_1_ * lvt_35_1_ - lvt_37_1_ * lvt_37_1_;
        if (lvt_48_1_ < 0.0) {
            double lvt_9_1_ = 0.0;
        } else {
            lvt_48_1_ *= lvt_48_1_;
            lvt_9_2_ = lvt_48_1_ * lvt_48_1_ * NoiseGeneratorSimplex.dot(grad3[lvt_43_1_], lvt_35_1_, lvt_37_1_);
        }
        return 70.0 * (lvt_5_2_ + lvt_7_2_ + lvt_9_2_);
    }

    public void add(double[] p_add_1_, double p_add_2_, double p_add_4_, int p_add_6_, int p_add_7_, double p_add_8_, double p_add_10_, double p_add_12_) {
        int lvt_14_1_ = 0;
        for (int lvt_15_1_ = 0; lvt_15_1_ < p_add_7_; ++lvt_15_1_) {
            double lvt_16_1_ = (p_add_4_ + (double)lvt_15_1_) * p_add_10_ + this.yo;
            for (int lvt_18_1_ = 0; lvt_18_1_ < p_add_6_; ++lvt_18_1_) {
                double lvt_25_2_;
                double lvt_23_2_;
                double lvt_21_2_;
                int lvt_42_2_;
                int lvt_41_2_;
                double lvt_35_1_;
                double lvt_39_1_;
                int lvt_30_1_;
                double lvt_31_1_;
                double lvt_19_1_ = (p_add_2_ + (double)lvt_18_1_) * p_add_8_ + this.xo;
                double lvt_27_1_ = (lvt_19_1_ + lvt_16_1_) * F2;
                int lvt_29_1_ = NoiseGeneratorSimplex.fastFloor(lvt_19_1_ + lvt_27_1_);
                double lvt_33_1_ = (double)lvt_29_1_ - (lvt_31_1_ = (double)(lvt_29_1_ + (lvt_30_1_ = NoiseGeneratorSimplex.fastFloor(lvt_16_1_ + lvt_27_1_))) * G2);
                double lvt_37_1_ = lvt_19_1_ - lvt_33_1_;
                if (lvt_37_1_ > (lvt_39_1_ = lvt_16_1_ - (lvt_35_1_ = (double)lvt_30_1_ - lvt_31_1_))) {
                    boolean lvt_41_1_ = true;
                    boolean lvt_42_1_ = false;
                } else {
                    lvt_41_2_ = 0;
                    lvt_42_2_ = 1;
                }
                double lvt_43_1_ = lvt_37_1_ - (double)lvt_41_2_ + G2;
                double lvt_45_1_ = lvt_39_1_ - (double)lvt_42_2_ + G2;
                double lvt_47_1_ = lvt_37_1_ - 1.0 + 2.0 * G2;
                double lvt_49_1_ = lvt_39_1_ - 1.0 + 2.0 * G2;
                int lvt_51_1_ = lvt_29_1_ & 0xFF;
                int lvt_52_1_ = lvt_30_1_ & 0xFF;
                int lvt_53_1_ = this.p[lvt_51_1_ + this.p[lvt_52_1_]] % 12;
                int lvt_54_1_ = this.p[lvt_51_1_ + lvt_41_2_ + this.p[lvt_52_1_ + lvt_42_2_]] % 12;
                int lvt_55_1_ = this.p[lvt_51_1_ + 1 + this.p[lvt_52_1_ + 1]] % 12;
                double lvt_56_1_ = 0.5 - lvt_37_1_ * lvt_37_1_ - lvt_39_1_ * lvt_39_1_;
                if (lvt_56_1_ < 0.0) {
                    double lvt_21_1_ = 0.0;
                } else {
                    lvt_56_1_ *= lvt_56_1_;
                    lvt_21_2_ = lvt_56_1_ * lvt_56_1_ * NoiseGeneratorSimplex.dot(grad3[lvt_53_1_], lvt_37_1_, lvt_39_1_);
                }
                double lvt_58_1_ = 0.5 - lvt_43_1_ * lvt_43_1_ - lvt_45_1_ * lvt_45_1_;
                if (lvt_58_1_ < 0.0) {
                    double lvt_23_1_ = 0.0;
                } else {
                    lvt_58_1_ *= lvt_58_1_;
                    lvt_23_2_ = lvt_58_1_ * lvt_58_1_ * NoiseGeneratorSimplex.dot(grad3[lvt_54_1_], lvt_43_1_, lvt_45_1_);
                }
                double lvt_60_1_ = 0.5 - lvt_47_1_ * lvt_47_1_ - lvt_49_1_ * lvt_49_1_;
                if (lvt_60_1_ < 0.0) {
                    double lvt_25_1_ = 0.0;
                } else {
                    lvt_60_1_ *= lvt_60_1_;
                    lvt_25_2_ = lvt_60_1_ * lvt_60_1_ * NoiseGeneratorSimplex.dot(grad3[lvt_55_1_], lvt_47_1_, lvt_49_1_);
                }
                int n = lvt_14_1_++;
                p_add_1_[n] = p_add_1_[n] + 70.0 * (lvt_21_2_ + lvt_23_2_ + lvt_25_2_) * p_add_12_;
            }
        }
    }
}

