/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBigMushroom
extends WorldGenerator {
    private final Block mushroomType;

    public WorldGenBigMushroom(Block p_i46449_1_) {
        super(true);
        this.mushroomType = p_i46449_1_;
    }

    public WorldGenBigMushroom() {
        super(false);
        this.mushroomType = null;
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        Block block = this.mushroomType;
        if (block == null) {
            block = p_generate_2_.nextBoolean() ? Blocks.BROWN_MUSHROOM_BLOCK : Blocks.RED_MUSHROOM_BLOCK;
        }
        int i = p_generate_2_.nextInt(3) + 4;
        if (p_generate_2_.nextInt(12) == 0) {
            i *= 2;
        }
        boolean flag = true;
        if (p_generate_3_.getY() >= 1 && p_generate_3_.getY() + i + 1 < 256) {
            for (int j = p_generate_3_.getY(); j <= p_generate_3_.getY() + 1 + i; ++j) {
                int k = 3;
                if (j <= p_generate_3_.getY() + 3) {
                    k = 0;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = p_generate_3_.getX() - k; l <= p_generate_3_.getX() + k && flag; ++l) {
                    for (int i1 = p_generate_3_.getZ() - k; i1 <= p_generate_3_.getZ() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            IBlockState state = p_generate_1_.getBlockState(blockpos$mutableblockpos.setPos(l, j, i1));
                            if (state.getBlock().isAir(state, p_generate_1_, blockpos$mutableblockpos) || state.getBlock().isLeaves(state, p_generate_1_, blockpos$mutableblockpos)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block block1 = p_generate_1_.getBlockState(p_generate_3_.down()).getBlock();
            if (block1 != Blocks.DIRT && block1 != Blocks.GRASS && block1 != Blocks.MYCELIUM) {
                return false;
            }
            int k2 = p_generate_3_.getY() + i;
            if (block == Blocks.RED_MUSHROOM_BLOCK) {
                k2 = p_generate_3_.getY() + i - 3;
            }
            for (int l2 = k2; l2 <= p_generate_3_.getY() + i; ++l2) {
                int j3 = 1;
                if (l2 < p_generate_3_.getY() + i) {
                    ++j3;
                }
                if (block == Blocks.BROWN_MUSHROOM_BLOCK) {
                    j3 = 3;
                }
                int k3 = p_generate_3_.getX() - j3;
                int l3 = p_generate_3_.getX() + j3;
                int j1 = p_generate_3_.getZ() - j3;
                int k1 = p_generate_3_.getZ() + j3;
                for (int l1 = k3; l1 <= l3; ++l1) {
                    for (int i2 = j1; i2 <= k1; ++i2) {
                        BlockPos blockpos;
                        IBlockState state;
                        int j2 = 5;
                        if (l1 == k3) {
                            --j2;
                        } else if (l1 == l3) {
                            ++j2;
                        }
                        if (i2 == j1) {
                            j2 -= 3;
                        } else if (i2 == k1) {
                            j2 += 3;
                        }
                        BlockHugeMushroom.EnumType blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.byMetadata(j2);
                        if (block == Blocks.BROWN_MUSHROOM_BLOCK || l2 < p_generate_3_.getY() + i) {
                            if ((l1 == k3 || l1 == l3) && (i2 == j1 || i2 == k1)) continue;
                            if (l1 == p_generate_3_.getX() - (j3 - 1) && i2 == j1) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.NORTH_WEST;
                            }
                            if (l1 == k3 && i2 == p_generate_3_.getZ() - (j3 - 1)) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.NORTH_WEST;
                            }
                            if (l1 == p_generate_3_.getX() + (j3 - 1) && i2 == j1) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.NORTH_EAST;
                            }
                            if (l1 == l3 && i2 == p_generate_3_.getZ() - (j3 - 1)) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.NORTH_EAST;
                            }
                            if (l1 == p_generate_3_.getX() - (j3 - 1) && i2 == k1) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.SOUTH_WEST;
                            }
                            if (l1 == k3 && i2 == p_generate_3_.getZ() + (j3 - 1)) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.SOUTH_WEST;
                            }
                            if (l1 == p_generate_3_.getX() + (j3 - 1) && i2 == k1) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.SOUTH_EAST;
                            }
                            if (l1 == l3 && i2 == p_generate_3_.getZ() + (j3 - 1)) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.SOUTH_EAST;
                            }
                        }
                        if (blockhugemushroom$enumtype == BlockHugeMushroom.EnumType.CENTER && l2 < p_generate_3_.getY() + i) {
                            blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.ALL_INSIDE;
                        }
                        if (p_generate_3_.getY() < p_generate_3_.getY() + i - 1 && blockhugemushroom$enumtype == BlockHugeMushroom.EnumType.ALL_INSIDE || !(state = p_generate_1_.getBlockState(blockpos = new BlockPos(l1, l2, i2))).getBlock().canBeReplacedByLeaves(state, p_generate_1_, blockpos)) continue;
                        this.setBlockAndNotifyAdequately(p_generate_1_, blockpos, block.getDefaultState().withProperty(BlockHugeMushroom.VARIANT, blockhugemushroom$enumtype));
                    }
                }
            }
            for (int i3 = 0; i3 < i; ++i3) {
                IBlockState iblockstate = p_generate_1_.getBlockState(p_generate_3_.up(i3));
                if (!iblockstate.getBlock().canBeReplacedByLeaves(iblockstate, p_generate_1_, p_generate_3_.up(i3))) continue;
                this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_.up(i3), block.getDefaultState().withProperty(BlockHugeMushroom.VARIANT, BlockHugeMushroom.EnumType.STEM));
            }
            return true;
        }
        return false;
    }
}

