/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenBirchTree
extends WorldGenAbstractTree {
    private static final IBlockState LOG = Blocks.LOG.getDefaultState().withProperty(BlockOldLog.VARIANT, BlockPlanks.EnumType.BIRCH);
    private static final IBlockState LEAF = Blocks.LEAVES.getDefaultState().withProperty(BlockOldLeaf.VARIANT, BlockPlanks.EnumType.BIRCH).withProperty(BlockOldLeaf.CHECK_DECAY, false);
    private final boolean useExtraRandomHeight;

    public WorldGenBirchTree(boolean p_i45449_1_, boolean p_i45449_2_) {
        super(p_i45449_1_);
        this.useExtraRandomHeight = p_i45449_2_;
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        int i = p_generate_2_.nextInt(3) + 5;
        if (this.useExtraRandomHeight) {
            i += p_generate_2_.nextInt(7);
        }
        boolean flag = true;
        if (p_generate_3_.getY() >= 1 && p_generate_3_.getY() + i + 1 <= 256) {
            for (int j = p_generate_3_.getY(); j <= p_generate_3_.getY() + 1 + i; ++j) {
                int k = 1;
                if (j == p_generate_3_.getY()) {
                    k = 0;
                }
                if (j >= p_generate_3_.getY() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = p_generate_3_.getX() - k; l <= p_generate_3_.getX() + k && flag; ++l) {
                    for (int i1 = p_generate_3_.getZ() - k; i1 <= p_generate_3_.getZ() + k && flag; ++i1) {
                        if (j >= 0 && j < p_generate_1_.getHeight()) {
                            if (this.isReplaceable(p_generate_1_, blockpos$mutableblockpos.setPos(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = p_generate_3_.down();
            IBlockState state = p_generate_1_.getBlockState(down);
            boolean isSoil = state.getBlock().canSustainPlant(state, p_generate_1_, down, EnumFacing.UP, (BlockSapling)Blocks.SAPLING);
            if (isSoil && p_generate_3_.getY() < p_generate_1_.getHeight() - i - 1) {
                state.getBlock().onPlantGrow(state, p_generate_1_, down, p_generate_3_);
                for (int i2 = p_generate_3_.getY() - 3 + i; i2 <= p_generate_3_.getY() + i; ++i2) {
                    int k2 = i2 - (p_generate_3_.getY() + i);
                    int l2 = 1 - k2 / 2;
                    for (int i3 = p_generate_3_.getX() - l2; i3 <= p_generate_3_.getX() + l2; ++i3) {
                        int j1 = i3 - p_generate_3_.getX();
                        for (int k1 = p_generate_3_.getZ() - l2; k1 <= p_generate_3_.getZ() + l2; ++k1) {
                            BlockPos blockpos;
                            IBlockState state2;
                            int l1 = k1 - p_generate_3_.getZ();
                            if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (p_generate_2_.nextInt(2) == 0 || k2 == 0) || !(state2 = p_generate_1_.getBlockState(blockpos = new BlockPos(i3, i2, k1))).getBlock().isAir(state2, p_generate_1_, blockpos) && !state2.getBlock().isAir(state2, p_generate_1_, blockpos)) continue;
                            this.setBlockAndNotifyAdequately(p_generate_1_, blockpos, LEAF);
                        }
                    }
                }
                for (int j2 = 0; j2 < i; ++j2) {
                    BlockPos upN = p_generate_3_.up(j2);
                    IBlockState state2 = p_generate_1_.getBlockState(upN);
                    if (!state2.getBlock().isAir(state2, p_generate_1_, upN) && !state2.getBlock().isLeaves(state2, p_generate_1_, upN)) continue;
                    this.setBlockAndNotifyAdequately(p_generate_1_, p_generate_3_.up(j2), LOG);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

