/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenCanopyTree
extends WorldGenAbstractTree {
    private static final IBlockState DARK_OAK_LOG = Blocks.LOG2.getDefaultState().withProperty(BlockNewLog.VARIANT, BlockPlanks.EnumType.DARK_OAK);
    private static final IBlockState DARK_OAK_LEAVES = Blocks.LEAVES2.getDefaultState().withProperty(BlockNewLeaf.VARIANT, BlockPlanks.EnumType.DARK_OAK).withProperty(BlockLeaves.CHECK_DECAY, false);

    public WorldGenCanopyTree(boolean p_i45461_1_) {
        super(p_i45461_1_);
    }

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        int i = p_generate_2_.nextInt(3) + p_generate_2_.nextInt(2) + 6;
        int j = p_generate_3_.getX();
        int k = p_generate_3_.getY();
        int l = p_generate_3_.getZ();
        if (k >= 1 && k + i + 1 < 256) {
            BlockPos blockpos = p_generate_3_.down();
            IBlockState state = p_generate_1_.getBlockState(blockpos);
            boolean isSoil = state.getBlock().canSustainPlant(state, p_generate_1_, blockpos, EnumFacing.UP, (BlockSapling)Blocks.SAPLING);
            if (!isSoil || p_generate_3_.getY() >= p_generate_1_.getHeight() - i - 1) {
                return false;
            }
            if (!this.placeTreeOfHeight(p_generate_1_, p_generate_3_, i)) {
                return false;
            }
            this.onPlantGrow(p_generate_1_, blockpos, p_generate_3_);
            this.onPlantGrow(p_generate_1_, blockpos.east(), p_generate_3_);
            this.onPlantGrow(p_generate_1_, blockpos.south(), p_generate_3_);
            this.onPlantGrow(p_generate_1_, blockpos.south().east(), p_generate_3_);
            EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.random(p_generate_2_);
            int i1 = i - p_generate_2_.nextInt(4);
            int j1 = 2 - p_generate_2_.nextInt(3);
            int k1 = j;
            int l1 = l;
            int i2 = k + i - 1;
            for (int j2 = 0; j2 < i; ++j2) {
                int k2;
                BlockPos blockpos1;
                if (j2 >= i1 && j1 > 0) {
                    k1 += enumfacing.getFrontOffsetX();
                    l1 += enumfacing.getFrontOffsetZ();
                    --j1;
                }
                if (!(state = p_generate_1_.getBlockState(blockpos1 = new BlockPos(k1, k2 = k + j2, l1))).getBlock().isAir(state, p_generate_1_, blockpos1) && !state.getBlock().isLeaves(state, p_generate_1_, blockpos1)) continue;
                this.placeLogAt(p_generate_1_, blockpos1);
                this.placeLogAt(p_generate_1_, blockpos1.east());
                this.placeLogAt(p_generate_1_, blockpos1.south());
                this.placeLogAt(p_generate_1_, blockpos1.east().south());
            }
            for (int i3 = -2; i3 <= 0; ++i3) {
                for (int l3 = -2; l3 <= 0; ++l3) {
                    int k4 = -1;
                    this.placeLeafAt(p_generate_1_, k1 + i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(p_generate_1_, 1 + k1 - i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(p_generate_1_, k1 + i3, i2 + k4, 1 + l1 - l3);
                    this.placeLeafAt(p_generate_1_, 1 + k1 - i3, i2 + k4, 1 + l1 - l3);
                    if (i3 <= -2 && l3 <= -1 || i3 == -1 && l3 == -2) continue;
                    k4 = 1;
                    this.placeLeafAt(p_generate_1_, k1 + i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(p_generate_1_, 1 + k1 - i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(p_generate_1_, k1 + i3, i2 + k4, 1 + l1 - l3);
                    this.placeLeafAt(p_generate_1_, 1 + k1 - i3, i2 + k4, 1 + l1 - l3);
                }
            }
            if (p_generate_2_.nextBoolean()) {
                this.placeLeafAt(p_generate_1_, k1, i2 + 2, l1);
                this.placeLeafAt(p_generate_1_, k1 + 1, i2 + 2, l1);
                this.placeLeafAt(p_generate_1_, k1 + 1, i2 + 2, l1 + 1);
                this.placeLeafAt(p_generate_1_, k1, i2 + 2, l1 + 1);
            }
            for (int j3 = -3; j3 <= 4; ++j3) {
                for (int i4 = -3; i4 <= 4; ++i4) {
                    if (j3 == -3 && i4 == -3 || j3 == -3 && i4 == 4 || j3 == 4 && i4 == -3 || j3 == 4 && i4 == 4 || Math.abs(j3) >= 3 && Math.abs(i4) >= 3) continue;
                    this.placeLeafAt(p_generate_1_, k1 + j3, i2, l1 + i4);
                }
            }
            for (int k3 = -1; k3 <= 2; ++k3) {
                for (int j4 = -1; j4 <= 2; ++j4) {
                    if (k3 >= 0 && k3 <= 1 && j4 >= 0 && j4 <= 1 || p_generate_2_.nextInt(3) > 0) continue;
                    int l4 = p_generate_2_.nextInt(3) + 2;
                    for (int i5 = 0; i5 < l4; ++i5) {
                        this.placeLogAt(p_generate_1_, new BlockPos(j + k3, i2 - i5 - 1, l + j4));
                    }
                    for (int j5 = -1; j5 <= 1; ++j5) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            this.placeLeafAt(p_generate_1_, k1 + k3 + j5, i2, l1 + j4 + l2);
                        }
                    }
                    for (int k5 = -2; k5 <= 2; ++k5) {
                        for (int l5 = -2; l5 <= 2; ++l5) {
                            if (Math.abs(k5) == 2 && Math.abs(l5) == 2) continue;
                            this.placeLeafAt(p_generate_1_, k1 + k3 + k5, i2 - 1, l1 + j4 + l5);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean placeTreeOfHeight(World p_placeTreeOfHeight_1_, BlockPos p_placeTreeOfHeight_2_, int p_placeTreeOfHeight_3_) {
        int i = p_placeTreeOfHeight_2_.getX();
        int j = p_placeTreeOfHeight_2_.getY();
        int k = p_placeTreeOfHeight_2_.getZ();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = 0; l <= p_placeTreeOfHeight_3_ + 1; ++l) {
            int i1 = 1;
            if (l == 0) {
                i1 = 0;
            }
            if (l >= p_placeTreeOfHeight_3_ - 1) {
                i1 = 2;
            }
            for (int j1 = -i1; j1 <= i1; ++j1) {
                for (int k1 = -i1; k1 <= i1; ++k1) {
                    if (this.isReplaceable(p_placeTreeOfHeight_1_, blockpos$mutableblockpos.setPos(i + j1, j + l, k + k1))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void placeLogAt(World p_placeLogAt_1_, BlockPos p_placeLogAt_2_) {
        if (this.canGrowInto(p_placeLogAt_1_.getBlockState(p_placeLogAt_2_).getBlock())) {
            this.setBlockAndNotifyAdequately(p_placeLogAt_1_, p_placeLogAt_2_, DARK_OAK_LOG);
        }
    }

    private void placeLeafAt(World p_placeLeafAt_1_, int p_placeLeafAt_2_, int p_placeLeafAt_3_, int p_placeLeafAt_4_) {
        BlockPos blockpos = new BlockPos(p_placeLeafAt_2_, p_placeLeafAt_3_, p_placeLeafAt_4_);
        IBlockState state = p_placeLeafAt_1_.getBlockState(blockpos);
        if (state.getBlock().isAir(state, p_placeLeafAt_1_, blockpos)) {
            this.setBlockAndNotifyAdequately(p_placeLeafAt_1_, blockpos, DARK_OAK_LEAVES);
        }
    }

    private void onPlantGrow(World p_onPlantGrow_1_, BlockPos p_onPlantGrow_2_, BlockPos p_onPlantGrow_3_) {
        IBlockState state = p_onPlantGrow_1_.getBlockState(p_onPlantGrow_2_);
        state.getBlock().onPlantGrow(state, p_onPlantGrow_1_, p_onPlantGrow_2_, p_onPlantGrow_3_);
    }
}

