/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.base.Predicates;
import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenDesertWells
extends WorldGenerator {
    private static final BlockStateMatcher IS_SAND = BlockStateMatcher.forBlock(Blocks.SAND).where(BlockSand.VARIANT, Predicates.equalTo((Object)BlockSand.EnumType.SAND));
    private final IBlockState sandSlab = Blocks.STONE_SLAB.getDefaultState().withProperty(BlockStoneSlab.VARIANT, BlockStoneSlab.EnumType.SAND).withProperty(BlockSlab.HALF, BlockSlab.EnumBlockHalf.BOTTOM);
    private final IBlockState sandstone = Blocks.SANDSTONE.getDefaultState();
    private final IBlockState water = Blocks.FLOWING_WATER.getDefaultState();

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        while (p_generate_1_.isAirBlock(p_generate_3_) && p_generate_3_.getY() > 2) {
            p_generate_3_ = p_generate_3_.down();
        }
        if (!IS_SAND.apply(p_generate_1_.getBlockState(p_generate_3_))) {
            return false;
        }
        for (int lvt_4_1_ = -2; lvt_4_1_ <= 2; ++lvt_4_1_) {
            for (int lvt_5_1_ = -2; lvt_5_1_ <= 2; ++lvt_5_1_) {
                if (!p_generate_1_.isAirBlock(p_generate_3_.add(lvt_4_1_, -1, lvt_5_1_)) || !p_generate_1_.isAirBlock(p_generate_3_.add(lvt_4_1_, -2, lvt_5_1_))) continue;
                return false;
            }
        }
        for (int lvt_4_2_ = -1; lvt_4_2_ <= 0; ++lvt_4_2_) {
            for (int lvt_5_2_ = -2; lvt_5_2_ <= 2; ++lvt_5_2_) {
                for (int lvt_6_1_ = -2; lvt_6_1_ <= 2; ++lvt_6_1_) {
                    p_generate_1_.setBlockState(p_generate_3_.add(lvt_5_2_, lvt_4_2_, lvt_6_1_), this.sandstone, 2);
                }
            }
        }
        p_generate_1_.setBlockState(p_generate_3_, this.water, 2);
        for (EnumFacing lvt_5_3_ : EnumFacing.Plane.HORIZONTAL) {
            p_generate_1_.setBlockState(p_generate_3_.offset(lvt_5_3_), this.water, 2);
        }
        for (int lvt_4_3_ = -2; lvt_4_3_ <= 2; ++lvt_4_3_) {
            for (int lvt_5_4_ = -2; lvt_5_4_ <= 2; ++lvt_5_4_) {
                if (lvt_4_3_ != -2 && lvt_4_3_ != 2 && lvt_5_4_ != -2 && lvt_5_4_ != 2) continue;
                p_generate_1_.setBlockState(p_generate_3_.add(lvt_4_3_, 1, lvt_5_4_), this.sandstone, 2);
            }
        }
        p_generate_1_.setBlockState(p_generate_3_.add(2, 1, 0), this.sandSlab, 2);
        p_generate_1_.setBlockState(p_generate_3_.add(-2, 1, 0), this.sandSlab, 2);
        p_generate_1_.setBlockState(p_generate_3_.add(0, 1, 2), this.sandSlab, 2);
        p_generate_1_.setBlockState(p_generate_3_.add(0, 1, -2), this.sandSlab, 2);
        for (int lvt_4_4_ = -1; lvt_4_4_ <= 1; ++lvt_4_4_) {
            for (int lvt_5_5_ = -1; lvt_5_5_ <= 1; ++lvt_5_5_) {
                if (lvt_4_4_ == 0 && lvt_5_5_ == 0) {
                    p_generate_1_.setBlockState(p_generate_3_.add(lvt_4_4_, 4, lvt_5_5_), this.sandstone, 2);
                    continue;
                }
                p_generate_1_.setBlockState(p_generate_3_.add(lvt_4_4_, 4, lvt_5_5_), this.sandSlab, 2);
            }
        }
        for (int lvt_4_5_ = 1; lvt_4_5_ <= 3; ++lvt_4_5_) {
            p_generate_1_.setBlockState(p_generate_3_.add(-1, lvt_4_5_, -1), this.sandstone, 2);
            p_generate_1_.setBlockState(p_generate_3_.add(-1, lvt_4_5_, 1), this.sandstone, 2);
            p_generate_1_.setBlockState(p_generate_3_.add(1, lvt_4_5_, -1), this.sandstone, 2);
            p_generate_1_.setBlockState(p_generate_3_.add(1, lvt_4_5_, 1), this.sandstone, 2);
        }
        return true;
    }
}

