/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.DungeonHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenDungeons
extends WorldGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation[] SPAWNERTYPES = new ResourceLocation[]{EntityList.getKey(EntitySkeleton.class), EntityList.getKey(EntityZombie.class), EntityList.getKey(EntityZombie.class), EntityList.getKey(EntitySpider.class)};

    @Override
    public boolean generate(World p_generate_1_, Random p_generate_2_, BlockPos p_generate_3_) {
        int i = 3;
        int j = p_generate_2_.nextInt(2) + 2;
        int k = -j - 1;
        int l = j + 1;
        int i1 = -1;
        int j1 = 4;
        int k1 = p_generate_2_.nextInt(2) + 2;
        int l1 = -k1 - 1;
        int i2 = k1 + 1;
        int j2 = 0;
        for (int k2 = k; k2 <= l; ++k2) {
            for (int l2 = -1; l2 <= 4; ++l2) {
                for (int i3 = l1; i3 <= i2; ++i3) {
                    BlockPos blockpos = p_generate_3_.add(k2, l2, i3);
                    Material material = p_generate_1_.getBlockState(blockpos).getMaterial();
                    boolean flag = material.isSolid();
                    if (l2 == -1 && !flag) {
                        return false;
                    }
                    if (l2 == 4 && !flag) {
                        return false;
                    }
                    if (k2 != k && k2 != l && i3 != l1 && i3 != i2 || l2 != 0 || !p_generate_1_.isAirBlock(blockpos) || !p_generate_1_.isAirBlock(blockpos.up())) continue;
                    ++j2;
                }
            }
        }
        if (j2 >= 1 && j2 <= 5) {
            for (int k3 = k; k3 <= l; ++k3) {
                for (int i4 = 3; i4 >= -1; --i4) {
                    for (int k4 = l1; k4 <= i2; ++k4) {
                        BlockPos blockpos1 = p_generate_3_.add(k3, i4, k4);
                        if (k3 != k && i4 != -1 && k4 != l1 && k3 != l && i4 != 4 && k4 != i2) {
                            if (p_generate_1_.getBlockState(blockpos1).getBlock() == Blocks.CHEST) continue;
                            p_generate_1_.setBlockToAir(blockpos1);
                            continue;
                        }
                        if (blockpos1.getY() >= 0 && !p_generate_1_.getBlockState(blockpos1.down()).getMaterial().isSolid()) {
                            p_generate_1_.setBlockToAir(blockpos1);
                            continue;
                        }
                        if (!p_generate_1_.getBlockState(blockpos1).getMaterial().isSolid() || p_generate_1_.getBlockState(blockpos1).getBlock() == Blocks.CHEST) continue;
                        if (i4 == -1 && p_generate_2_.nextInt(4) != 0) {
                            p_generate_1_.setBlockState(blockpos1, Blocks.MOSSY_COBBLESTONE.getDefaultState(), 2);
                            continue;
                        }
                        p_generate_1_.setBlockState(blockpos1, Blocks.COBBLESTONE.getDefaultState(), 2);
                    }
                }
            }
            block6: for (int l3 = 0; l3 < 2; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int j5;
                    int i5;
                    int l4 = p_generate_3_.getX() + p_generate_2_.nextInt(j * 2 + 1) - j;
                    BlockPos blockpos2 = new BlockPos(l4, i5 = p_generate_3_.getY(), j5 = p_generate_3_.getZ() + p_generate_2_.nextInt(k1 * 2 + 1) - k1);
                    if (!p_generate_1_.isAirBlock(blockpos2)) continue;
                    int j3 = 0;
                    for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                        if (!p_generate_1_.getBlockState(blockpos2.offset(enumfacing)).getMaterial().isSolid()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    p_generate_1_.setBlockState(blockpos2, Blocks.CHEST.correctFacing(p_generate_1_, blockpos2, Blocks.CHEST.getDefaultState()), 2);
                    TileEntity tileentity1 = p_generate_1_.getTileEntity(blockpos2);
                    if (!(tileentity1 instanceof TileEntityChest)) continue block6;
                    ((TileEntityChest)tileentity1).setLootTable(LootTableList.CHESTS_SIMPLE_DUNGEON, p_generate_2_.nextLong());
                    continue block6;
                }
            }
            p_generate_1_.setBlockState(p_generate_3_, Blocks.MOB_SPAWNER.getDefaultState(), 2);
            TileEntity tileentity = p_generate_1_.getTileEntity(p_generate_3_);
            if (tileentity instanceof TileEntityMobSpawner) {
                ((TileEntityMobSpawner)tileentity).getSpawnerBaseLogic().setEntityId(this.pickMobSpawner(p_generate_2_));
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{p_generate_3_.getX(), p_generate_3_.getY(), p_generate_3_.getZ()});
            }
            return true;
        }
        return false;
    }

    private ResourceLocation pickMobSpawner(Random p_pickMobSpawner_1_) {
        return DungeonHooks.getRandomDungeonMob(p_pickMobSpawner_1_);
    }
}

